/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.hbm_m.main.MainRegistry;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractObjPartModelLoader<T extends BakedModel>
implements IGeometryLoader<ObjPartGeometry<T>> {
    protected abstract Set<String> getPartNames(JsonObject var1);

    protected abstract T createBakedModel(HashMap<String, BakedModel> var1, ItemTransforms var2, ResourceLocation var3);

    public ObjPartGeometry<T> read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        String modelStr = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"model");
        MainRegistry.LOGGER.debug("{}: model string='{}'", (Object)this.getClass().getSimpleName(), (Object)modelStr);
        ResourceLocation model = ResourceLocation.parse((String)modelStr);
        Set<String> partNames = this.getPartNames(jsonObject);
        return new ObjPartGeometry(model, partNames, this);
    }

    public static class ObjPartGeometry<T extends BakedModel>
    implements IUnbakedGeometry<ObjPartGeometry<T>> {
        private final ResourceLocation modelLocation;
        private final Set<String> partNames;
        private final AbstractObjPartModelLoader<T> loader;

        public ObjPartGeometry(ResourceLocation modelLocation, Set<String> partNames, AbstractObjPartModelLoader<T> loader) {
            this.modelLocation = modelLocation;
            this.partNames = partNames;
            this.loader = loader;
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelName) {
            ObjModel model = this.loadObjModel();
            HashMap<String, BakedModel> bakedParts = this.bakeParts(model, context, baker, spriteGetter, overrides, modelName);
            this.ensureBasePart(model, bakedParts, context, baker, spriteGetter, overrides, modelName);
            MainRegistry.LOGGER.info("{}: Total baked parts: {}", (Object)this.loader.getClass().getSimpleName(), (Object)bakedParts.size());
            return this.loader.createBakedModel(bakedParts, context.getTransforms(), this.modelLocation);
        }

        private ObjModel loadObjModel() {
            try {
                ObjModel model = ObjLoader.INSTANCE.loadModel(new ObjModel.ModelSettings(this.modelLocation, true, false, true, true, null));
                MainRegistry.LOGGER.info("{}: Successfully loaded OBJ model: {}", (Object)this.loader.getClass().getSimpleName(), (Object)this.modelLocation);
                return model;
            }
            catch (Exception e) {
                MainRegistry.LOGGER.error("Failed to load OBJ model: " + String.valueOf(this.modelLocation), (Throwable)e);
                throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c OBJ \u043c\u043e\u0434\u0435\u043b\u044c: " + String.valueOf(this.modelLocation), e);
            }
        }

        private HashMap<String, BakedModel> bakeParts(ObjModel model, IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ResourceLocation modelName) {
            HashMap<String, BakedModel> bakedParts = new HashMap<String, BakedModel>();
            ModelState identityState = this.createIdentityState();
            for (String partName : this.partNames) {
                SinglePartBakingContext partContext = new SinglePartBakingContext(context, partName);
                BakedModel bakedPart = model.bake((IGeometryBakingContext)partContext, baker, spriteGetter, identityState, overrides, modelName);
                bakedParts.put(partName, bakedPart);
            }
            return bakedParts;
        }

        private void ensureBasePart(ObjModel model, HashMap<String, BakedModel> bakedParts, IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ResourceLocation modelName) {
            if (!bakedParts.containsKey("Base")) {
                bakedParts.put("Base", model.bake((IGeometryBakingContext)new SinglePartBakingContext(context, "Base"), baker, spriteGetter, this.createIdentityState(), overrides, modelName));
            }
        }

        private ModelState createIdentityState() {
            return new ModelState(){

                @NotNull
                public Transformation m_6189_() {
                    return Transformation.m_121093_();
                }
            };
        }
    }

    protected static class SinglePartBakingContext
    implements IGeometryBakingContext {
        private final IGeometryBakingContext parent;
        private final String visiblePart;

        public SinglePartBakingContext(IGeometryBakingContext parent, String visiblePart) {
            this.parent = parent;
            this.visiblePart = visiblePart;
        }

        public String getModelName() {
            return this.parent.getModelName();
        }

        public boolean isGui3d() {
            return this.parent.isGui3d();
        }

        public boolean useBlockLight() {
            return this.parent.useBlockLight();
        }

        public boolean useAmbientOcclusion() {
            return this.parent.useAmbientOcclusion();
        }

        public ItemTransforms getTransforms() {
            return this.parent.getTransforms();
        }

        public Material getMaterial(String name) {
            return this.parent.getMaterial(name);
        }

        public Transformation getRootTransform() {
            return this.parent.getRootTransform();
        }

        public boolean hasMaterial(String name) {
            return this.parent.hasMaterial(name);
        }

        public ResourceLocation getRenderTypeHint() {
            return this.parent.getRenderTypeHint();
        }

        public boolean isComponentVisible(String component, boolean fallback) {
            return component.equals(this.visiblePart) || component.startsWith(this.visiblePart + "/");
        }
    }
}

