/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.loader;

import com.hbm_m.main.MainRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ColladaAnimationParser {
    public static Map<String, List<AnimationChannel>> parse(InputStream daeStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(daeStream);
            HashMap<String, List<AnimationChannel>> result = new HashMap<String, List<AnimationChannel>>();
            NodeList animList = doc.getElementsByTagName("animation");
            for (int i = 0; i < animList.getLength(); ++i) {
                Element anim = (Element)animList.item(i);
                ColladaAnimationParser.parseAnimation(anim, result);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }

    private static void parseAnimation(Element anim, Map<String, List<AnimationChannel>> result) {
        HashMap<String, float[]> sources = new HashMap<String, float[]>();
        NodeList sourceList = anim.getElementsByTagName("source");
        for (int i = 0; i < sourceList.getLength(); ++i) {
            Element source = (Element)sourceList.item(i);
            String sourceId = source.getAttribute("id");
            NodeList floatArrays = source.getElementsByTagName("float_array");
            if (floatArrays.getLength() <= 0) continue;
            Element floatArray = (Element)floatArrays.item(0);
            String[] values = floatArray.getTextContent().trim().split("\\s+");
            float[] floats = new float[values.length];
            for (int j = 0; j < values.length; ++j) {
                floats[j] = Float.parseFloat(values[j]);
            }
            sources.put(sourceId, floats);
        }
        NodeList samplers = anim.getElementsByTagName("sampler");
        if (samplers.getLength() == 0) {
            return;
        }
        Element sampler = (Element)samplers.item(0);
        NodeList inputs = sampler.getElementsByTagName("input");
        String inputSource = null;
        String outputSource = null;
        for (int i = 0; i < inputs.getLength(); ++i) {
            Element input = (Element)inputs.item(i);
            String semantic = input.getAttribute("semantic");
            String source = input.getAttribute("source").substring(1);
            if ("INPUT".equals(semantic)) {
                inputSource = source;
                continue;
            }
            if (!"OUTPUT".equals(semantic)) continue;
            outputSource = source;
        }
        NodeList channels = anim.getElementsByTagName("channel");
        if (channels.getLength() == 0) {
            return;
        }
        Element channel = (Element)channels.item(0);
        String target = channel.getAttribute("target");
        String[] targetParts = target.split("/");
        String objectName = targetParts[0];
        String property = targetParts.length > 1 ? targetParts[1] : "transform";
        float[] times = (float[])sources.get(inputSource);
        float[] values = (float[])sources.get(outputSource);
        if (times != null && values != null) {
            AnimationChannel animChannel = new AnimationChannel();
            animChannel.property = property;
            animChannel.times = times;
            animChannel.values = values;
            result.computeIfAbsent(objectName, k -> new ArrayList()).add(animChannel);
            MainRegistry.LOGGER.debug("Loaded animation channel: " + objectName + " -> " + property + " (keyframes: " + times.length + ", duration: " + times[times.length - 1] + "s)");
        }
    }

    public static class AnimationChannel {
        public String property;
        public float[] times;
        public float[] values;

        public float getValue(float time) {
            if (this.times.length == 0) {
                return 0.0f;
            }
            if (time <= this.times[0]) {
                return this.values[0];
            }
            if (time >= this.times[this.times.length - 1]) {
                return this.values[this.values.length - 1];
            }
            for (int i = 0; i < this.times.length - 1; ++i) {
                if (!(time >= this.times[i]) || !(time <= this.times[i + 1])) continue;
                float alpha = (time - this.times[i]) / (this.times[i + 1] - this.times[i]);
                return this.values[i] + alpha * (this.values[i + 1] - this.values[i]);
            }
            return this.values[this.values.length - 1];
        }

        public float[] getMatrix(float time) {
            if (!this.property.equals("transform")) {
                return null;
            }
            int frameIndex = 0;
            for (int i = 0; i < this.times.length - 1; ++i) {
                if (!(time >= this.times[i]) || !(time <= this.times[i + 1])) continue;
                float alpha = (time - this.times[i]) / (this.times[i + 1] - this.times[i]);
                frameIndex = alpha < 0.5f ? i : i + 1;
                break;
            }
            if (time >= this.times[this.times.length - 1]) {
                frameIndex = this.times.length - 1;
            }
            float[] matrix = new float[16];
            int offset = frameIndex * 16;
            if (offset + 16 <= this.values.length) {
                System.arraycopy(this.values, offset, matrix, 0, 16);
            }
            return matrix;
        }

        public float[] getTranslationFromMatrix(float time) {
            float[] matrix = this.getMatrix(time);
            if (matrix == null) {
                return new float[]{0.0f, 0.0f, 0.0f};
            }
            return new float[]{matrix[12], matrix[13], matrix[14]};
        }
    }
}

