/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.hbm_m.client.model.PressBakedModel;
import com.hbm_m.main.MainRegistry;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class PressModelLoader
implements IGeometryLoader<PressGeometry> {
    public PressGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        ResourceLocation baseModel = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"base_model"));
        ResourceLocation headModel = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"head_model"));
        boolean flipV = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"flip_v", (boolean)true);
        Vector3f headTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
        float headTravel = 0.8f;
        if (jsonObject.has("head_transform")) {
            JsonObject headTransform = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"head_transform");
            headTranslation = PressModelLoader.parseTranslation(headTransform);
            if (headTransform.has("travel")) {
                headTravel = headTransform.get("travel").getAsFloat();
            }
        }
        return new PressGeometry(baseModel, headModel, flipV, headTranslation, headTravel);
    }

    private static Vector3f parseTranslation(JsonObject headTransform) {
        if (!headTransform.has("translation")) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        JsonArray array = GsonHelper.m_13933_((JsonObject)headTransform, (String)"translation");
        float x = array.size() > 0 ? array.get(0).getAsFloat() : 0.0f;
        float y = array.size() > 1 ? array.get(1).getAsFloat() : 0.0f;
        float z = array.size() > 2 ? array.get(2).getAsFloat() : 0.0f;
        return new Vector3f(x, y, z);
    }

    public static class PressGeometry
    implements IUnbakedGeometry<PressGeometry> {
        private final ResourceLocation baseModelLocation;
        private final ResourceLocation headModelLocation;
        private final boolean flipV;
        private final Vector3f headRestOffset;
        private final float headTravel;

        public PressGeometry(ResourceLocation baseModelLocation, ResourceLocation headModelLocation, boolean flipV, Vector3f headRestOffset, float headTravel) {
            this.baseModelLocation = baseModelLocation;
            this.headModelLocation = headModelLocation;
            this.flipV = flipV;
            this.headRestOffset = headRestOffset;
            this.headTravel = headTravel;
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            HashMap<String, BakedModel> bakedParts = new HashMap<String, BakedModel>();
            bakedParts.put("Base", this.bakeObjPart(this.baseModelLocation, context, baker, spriteGetter, overrides, modelLocation));
            bakedParts.put("Head", this.bakeObjPart(this.headModelLocation, context, baker, spriteGetter, overrides, modelLocation));
            ItemTransforms transforms = context.getTransforms();
            return new PressBakedModel(bakedParts, transforms, this.headRestOffset, this.headTravel);
        }

        private BakedModel bakeObjPart(ResourceLocation modelLocation, IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ResourceLocation rootModel) {
            try {
                ObjModel model = ObjLoader.INSTANCE.loadModel(new ObjModel.ModelSettings(modelLocation, this.flipV, false, true, true, null));
                return model.bake(context, baker, spriteGetter, this.identityState(), overrides, rootModel);
            }
            catch (Exception e) {
                MainRegistry.LOGGER.error("Failed to bake OBJ part for {}", (Object)modelLocation, (Object)e);
                throw new RuntimeException("Failed to bake press model part: " + String.valueOf(modelLocation), e);
            }
        }

        private ModelState identityState() {
            return new ModelState(){

                @NotNull
                public Transformation m_6189_() {
                    return Transformation.m_121093_();
                }
            };
        }
    }
}

