/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultipartBakedModel
implements BakedModel {
    protected final Map<String, BakedModel> parts;
    protected final ItemTransforms transforms;
    private TextureAtlasSprite cachedParticleIcon;

    protected AbstractMultipartBakedModel(Map<String, BakedModel> parts, ItemTransforms transforms) {
        this.parts = parts;
        this.transforms = transforms;
    }

    public BakedModel getPart(String name) {
        return this.parts.get(name);
    }

    public Map<String, BakedModel> getPartModels() {
        return Collections.unmodifiableMap(this.parts);
    }

    protected String[] getPartNamesInternal() {
        AbstractMultipartBakedModel abstractMultipartBakedModel = this;
        if (abstractMultipartBakedModel instanceof PartNamesProvider) {
            PartNamesProvider provider = (PartNamesProvider)((Object)abstractMultipartBakedModel);
            return provider.getPartNames();
        }
        return (String[])this.parts.keySet().stream().sorted().toArray(String[]::new);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        if (this.cachedParticleIcon == null) {
            BakedModel part;
            String[] iconParts;
            String[] partNames = this.getPartNamesInternal();
            for (String partName : iconParts = new String[]{"Base", "base", "frame", "Frame", "main", "Main"}) {
                BakedModel part2 = this.parts.get(partName);
                if (part2 == null) continue;
                this.cachedParticleIcon = part2.getParticleIcon(data);
                break;
            }
            if (this.cachedParticleIcon == null && partNames.length > 0 && (part = this.parts.get(partNames[0])) != null) {
                this.cachedParticleIcon = part.getParticleIcon(data);
            }
            if (this.cachedParticleIcon == null && !this.parts.isEmpty()) {
                this.cachedParticleIcon = this.parts.values().iterator().next().getParticleIcon(data);
            }
            if (this.cachedParticleIcon == null) {
                this.cachedParticleIcon = Minecraft.m_91087_().m_91304_().m_119409_().getParticleIcon(data);
            }
        }
        return this.cachedParticleIcon;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (this.shouldSkipWorldRendering(state)) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected abstract boolean shouldSkipWorldRendering(@Nullable BlockState var1);

    protected boolean shouldSkipSideRendering(@Nullable BlockState state, @Nullable Direction side) {
        return state == null && side != null;
    }

    protected BlockState getStateForPart(@Nullable BlockState state) {
        return state;
    }

    protected List<String> getItemRenderPartNames() {
        String[] allPartNames = this.getPartNamesInternal();
        String[] priorityParts = new String[]{"frame", "Frame", "doorLeft", "doorRight", "Base", "base", "main", "Main"};
        ArrayList<String> result = new ArrayList<String>();
        for (String priorityPart : priorityParts) {
            if (!this.parts.containsKey(priorityPart)) continue;
            result.add(priorityPart);
        }
        for (String partName : allPartNames) {
            if (result.contains(partName) || !this.parts.containsKey(partName)) continue;
            result.add(partName);
        }
        return result;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return this.transforms;
    }

    public void clearCaches() {
        this.cachedParticleIcon = null;
    }

    public static interface PartNamesProvider {
        public String[] getPartNames();
    }
}

