/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model;

import com.hbm_m.block.entity.DoorDecl;
import com.hbm_m.block.entity.DoorDeclRegistry;
import com.hbm_m.client.model.AbstractMultipartBakedModel;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.multiblock.DoorPartAABBRegistry;
import com.hbm_m.physics.PartAABBExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class DoorBakedModel
extends AbstractMultipartBakedModel
implements AbstractMultipartBakedModel.PartNamesProvider {
    private final String[] cachedPartNames;
    private final ResourceLocation doorId;
    private List<BakedQuad> cachedItemQuads;
    private boolean itemQuadsCached = false;

    public DoorBakedModel(Map<String, BakedModel> parts, ItemTransforms transforms, ResourceLocation doorId) {
        super(parts, transforms);
        this.doorId = doorId;
        this.cachedPartNames = parts.keySet().toArray(new String[0]);
        this.initializeDoorDecl();
        this.extractAndRegisterAABBs();
    }

    private void extractAndRegisterAABBs() {
        String doorIdStr = this.extractDoorId(this.doorId.m_135815_());
        Map<String, AABB> partAABBs = PartAABBExtractor.extractAll(this.parts);
        if (!partAABBs.isEmpty()) {
            DoorDecl decl;
            DoorPartAABBRegistry.register(doorIdStr, partAABBs);
            if (DoorDeclRegistry.contains(doorIdStr) && (decl = DoorDeclRegistry.getById(doorIdStr)) != null) {
                decl.setPartAABBs(partAABBs);
            }
            MainRegistry.LOGGER.info("DoorBakedModel: Extracted {} part AABBs for door {}", (Object)partAABBs.size(), (Object)doorIdStr);
        } else {
            MainRegistry.LOGGER.warn("DoorBakedModel: No AABBs extracted for door {}", (Object)doorIdStr);
        }
    }

    private String extractDoorId(String path) {
        String pathWithoutDir = path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
        return pathWithoutDir.endsWith(".obj") ? pathWithoutDir.substring(0, pathWithoutDir.length() - 4) : pathWithoutDir;
    }

    private void initializeDoorDecl() {
        String id;
        String fullPath = this.doorId.m_135815_();
        String pathWithoutDir = fullPath.contains("/") ? fullPath.substring(fullPath.lastIndexOf(47) + 1) : fullPath;
        String string = id = pathWithoutDir.endsWith(".obj") ? pathWithoutDir.substring(0, pathWithoutDir.length() - 4) : pathWithoutDir;
        if (DoorDeclRegistry.contains(id)) {
            DoorDecl decl = DoorDeclRegistry.getById(id);
            if (decl != null) {
                decl.setPartsFromModel(this.cachedPartNames, this.parts);
                MainRegistry.LOGGER.info("Initialized DoorDecl for {} with {} parts: {}", new Object[]{id, this.cachedPartNames.length, String.join((CharSequence)", ", this.cachedPartNames)});
            }
        } else {
            MainRegistry.LOGGER.warn("Door ID '{}' (from path '{}') not found in DoorDeclRegistry. Available doors: {}", new Object[]{id, fullPath, String.join((CharSequence)", ", DoorDeclRegistry.getAll().keySet())});
        }
    }

    @Override
    public String[] getPartNames() {
        return this.cachedPartNames;
    }

    public Map<String, BakedModel> getParts() {
        return this.parts;
    }

    @Override
    protected boolean shouldSkipWorldRendering(@Nullable BlockState state) {
        return state != null;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (this.shouldSkipWorldRendering(state)) {
            return Collections.emptyList();
        }
        if (state == null) {
            return this.getItemQuads(side, rand, modelData, renderType);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> getItemQuads(@Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (!this.itemQuadsCached) {
            this.buildItemQuads(rand, modelData, renderType);
            this.itemQuadsCached = true;
        }
        if (side != null) {
            return this.cachedItemQuads.stream().filter(quad -> quad.m_111306_() == side).toList();
        }
        return this.cachedItemQuads;
    }

    private void buildItemQuads(RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> allQuads = new ArrayList<BakedQuad>();
        List<String> itemRenderParts = this.getItemRenderPartNames();
        for (String partName : itemRenderParts) {
            BakedModel part = (BakedModel)this.parts.get(partName);
            if (part == null) continue;
            for (Direction dir : Direction.values()) {
                List partQuads = part.getQuads(null, dir, rand, modelData, renderType);
                allQuads.addAll(partQuads);
            }
            List generalQuads = part.getQuads(null, null, rand, modelData, renderType);
            allQuads.addAll(generalQuads);
        }
        this.cachedItemQuads = allQuads;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.clearItemQuadCache();
    }

    public void clearItemQuadCache() {
        this.itemQuadsCached = false;
        this.cachedItemQuads = null;
    }
}

