/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model;

import com.hbm_m.client.model.AbstractMultipartBakedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class MachineAdvancedAssemblerBakedModel
extends AbstractMultipartBakedModel
implements AbstractMultipartBakedModel.PartNamesProvider {
    private final String[] cachedPartNames;
    private List<BakedQuad> cachedItemQuads;
    private boolean itemQuadsCached = false;

    public MachineAdvancedAssemblerBakedModel(Map<String, BakedModel> parts, ItemTransforms transforms) {
        super(parts, transforms);
        this.cachedPartNames = (String[])parts.keySet().stream().sorted((a, b) -> {
            String[] priority = new String[]{"Base", "Frame", "Ring", "ArmLower1", "ArmUpper1", "Head1", "Spike1", "ArmLower2", "ArmUpper2", "Head2", "Spike2"};
            int aIndex = MachineAdvancedAssemblerBakedModel.indexOf(priority, a);
            int bIndex = MachineAdvancedAssemblerBakedModel.indexOf(priority, b);
            if (aIndex != -1 && bIndex != -1) {
                return Integer.compare(aIndex, bIndex);
            }
            if (aIndex != -1) {
                return -1;
            }
            if (bIndex != -1) {
                return 1;
            }
            return a.compareTo((String)b);
        }).toArray(String[]::new);
    }

    private static int indexOf(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String[] getPartNames() {
        return this.cachedPartNames;
    }

    @Override
    protected boolean shouldSkipWorldRendering(@Nullable BlockState state) {
        return state != null && state.m_155947_();
    }

    @Override
    public boolean m_7547_() {
        return true;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (this.shouldSkipWorldRendering(state)) {
            return Collections.emptyList();
        }
        if (state == null) {
            return this.getItemQuads(side, rand, modelData, renderType);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> getItemQuads(@Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (!this.itemQuadsCached) {
            this.buildItemQuads(rand, modelData, renderType);
            this.itemQuadsCached = true;
        }
        if (side != null) {
            return this.cachedItemQuads.stream().filter(quad -> quad.m_111306_() == side).toList();
        }
        return this.cachedItemQuads;
    }

    private void buildItemQuads(RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> allQuads = new ArrayList<BakedQuad>();
        List<String> itemRenderParts = this.getItemRenderPartNames();
        for (String partName : itemRenderParts) {
            BakedModel part = (BakedModel)this.parts.get(partName);
            if (part == null) continue;
            for (Direction dir : Direction.values()) {
                List partQuads = part.getQuads(null, dir, rand, modelData, renderType);
                allQuads.addAll(partQuads);
            }
            List generalQuads = part.getQuads(null, null, rand, modelData, renderType);
            allQuads.addAll(generalQuads);
        }
        this.cachedItemQuads = allQuads;
    }

    @Override
    protected List<String> getItemRenderPartNames() {
        String[] priorityParts;
        ArrayList<String> result = new ArrayList<String>();
        for (String priorityPart : priorityParts = new String[]{"Base", "Ring", "ArmLower1", "ArmUpper1", "Head1", "Spike1", "ArmLower2", "ArmUpper2", "Head2", "Spike2"}) {
            if (!this.parts.containsKey(priorityPart)) continue;
            result.add(priorityPart);
        }
        return result;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.clearItemQuadCache();
    }

    public void clearItemQuadCache() {
        this.itemQuadsCached = false;
        this.cachedItemQuads = null;
    }
}

