/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model;

import com.hbm_m.client.model.AbstractMultipartBakedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PressBakedModel
extends AbstractMultipartBakedModel
implements AbstractMultipartBakedModel.PartNamesProvider {
    private static final String BASE = "Base";
    private static final String HEAD = "Head";
    private final String[] partNames;
    private final Vector3f headRestOffset;
    private final float headTravelDistance;
    private List<BakedQuad> cachedItemQuads;
    private boolean itemQuadsCached = false;

    public PressBakedModel(Map<String, BakedModel> parts, ItemTransforms transforms, Vector3f headRestOffset, float headTravelDistance) {
        super(parts, transforms);
        this.partNames = parts.keySet().toArray(new String[0]);
        this.headRestOffset = headRestOffset;
        this.headTravelDistance = headTravelDistance;
    }

    public Vector3f getHeadRestOffset() {
        return new Vector3f((Vector3fc)this.headRestOffset);
    }

    public float getHeadTravelDistance() {
        return this.headTravelDistance;
    }

    @Override
    public String[] getPartNames() {
        return this.partNames;
    }

    @Override
    protected boolean shouldSkipWorldRendering(@Nullable BlockState state) {
        return state != null && state.m_155947_();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (this.shouldSkipWorldRendering(state)) {
            return Collections.emptyList();
        }
        if (state == null) {
            return this.getItemQuads(side, rand, modelData, renderType);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> getItemQuads(@Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (!this.itemQuadsCached) {
            this.cachedItemQuads = this.buildItemQuads(rand, modelData, renderType);
            this.itemQuadsCached = true;
        }
        if (side != null) {
            return this.cachedItemQuads.stream().filter(quad -> quad.m_111306_() == side).toList();
        }
        return this.cachedItemQuads;
    }

    private List<BakedQuad> buildItemQuads(RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (String partName : this.getItemRenderPartNames()) {
            BakedModel part = (BakedModel)this.parts.get(partName);
            if (part == null) continue;
            for (Direction dir : Direction.values()) {
                quads.addAll(part.getQuads(null, dir, rand, modelData, renderType));
            }
            quads.addAll(part.getQuads(null, null, rand, modelData, renderType));
        }
        return quads;
    }

    @Override
    protected List<String> getItemRenderPartNames() {
        ArrayList<String> order = new ArrayList<String>(2);
        if (this.parts.containsKey(BASE)) {
            order.add(BASE);
        }
        if (this.parts.containsKey(HEAD)) {
            order.add(HEAD);
        }
        this.parts.keySet().stream().filter(name -> !order.contains(name)).forEach(order::add);
        return order;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.cachedItemQuads = null;
        this.itemQuadsCached = false;
    }
}

