/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.block.entity.machine.MachineAdvancedAssemblerBlockEntity;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.SetAssemblerRecipeC2SPacket;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.util.TemplateTooltipUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GUIAdvancedAssemblerRecipeSelector
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/processing/gui_recipe_selector.png");
    public static final String NULL_SELECTION = "null";
    private final int xSize = 176;
    private final int ySize = 132;
    private int guiLeft;
    private int guiTop;
    private EditBox searchBox;
    private int pageIndex = 0;
    private int pageCount;
    private final List<RecipeEntry> allRecipes = new ArrayList<RecipeEntry>();
    private List<RecipeEntry> filteredRecipes = new ArrayList<RecipeEntry>();
    private final BlockPos machinePos;
    private final Screen parentScreen;
    private ItemStack lastFolderStack = ItemStack.f_41583_;
    private ResourceLocation selectedRecipe = null;

    public GUIAdvancedAssemblerRecipeSelector(BlockPos machinePos, ResourceLocation currentRecipe, Screen parentScreen) {
        super((Component)Component.m_237115_((String)"gui.hbm_m.assembler_recipe_selector"));
        this.machinePos = machinePos;
        this.parentScreen = parentScreen;
        this.selectedRecipe = currentRecipe;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        if (this.allRecipes.isEmpty()) {
            this.reloadRecipes();
        }
        this.searchBox = new EditBox(this.f_96547_, this.guiLeft + 28, this.guiTop + 111, 102, 12, (Component)Component.m_237119_());
        this.searchBox.m_94199_(32);
        this.searchBox.m_94151_(this::onSearch);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_93692_(true);
        this.m_142416_((GuiEventListener)this.searchBox);
    }

    private void resetPaging() {
        this.pageIndex = 0;
        this.pageCount = Math.max(0, (int)Math.ceil((double)(this.filteredRecipes.size() - 40) / 8.0));
    }

    private void onSearch(String query) {
        this.filteredRecipes.clear();
        if (query.isEmpty()) {
            this.filteredRecipes.addAll(this.allRecipes);
        } else {
            String lowerQuery = query.toLowerCase(Locale.ROOT);
            for (RecipeEntry entry : this.allRecipes) {
                if (!entry.icon.m_41786_().getString().toLowerCase(Locale.ROOT).contains(lowerQuery)) continue;
                this.filteredRecipes.add(entry);
            }
        }
        this.resetPaging();
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.drawGuiBackground(guiGraphics, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderRecipes(guiGraphics, mouseX, mouseY);
        this.renderTooltips(guiGraphics, mouseX, mouseY);
    }

    private void drawGuiBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.searchBox.m_93696_()) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 26, this.guiTop + 108, 0, 132, 106, 16);
        }
        if (this.isHovering(mouseX, mouseY, 152, 18, 16, 16)) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 152, this.guiTop + 18, 176, 0, 16, 16);
        }
        if (this.isHovering(mouseX, mouseY, 152, 36, 16, 16)) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 152, this.guiTop + 36, 176, 16, 16, 16);
        }
        if (this.isHovering(mouseX, mouseY, 152, 90, 16, 16)) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 152, this.guiTop + 90, 176, 32, 16, 16);
        }
        if (this.isHovering(mouseX, mouseY, 134, 108, 16, 16)) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 134, this.guiTop + 108, 176, 48, 16, 16);
        }
        if (this.isHovering(mouseX, mouseY, 8, 108, 16, 16)) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 8, this.guiTop + 108, 176, 64, 16, 16);
        }
        for (int i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.filteredRecipes.size(); ++i) {
            int ind = i - this.pageIndex * 8;
            RecipeEntry entry = this.filteredRecipes.get(i);
            if (!entry.id.equals((Object)this.selectedRecipe)) continue;
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 7 + 18 * (ind % 8), this.guiTop + 17 + 18 * (ind / 8), 192, 0, 18, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.filteredRecipes.size(); ++i) {
            int ind = i - this.pageIndex * 8;
            int col = ind % 8;
            int row = ind / 8;
            int x = this.guiLeft + 8 + 18 * col;
            int y = this.guiTop + 18 + 18 * row;
            RecipeEntry entry = this.filteredRecipes.get(i);
            guiGraphics.m_280480_(entry.icon, x, y);
        }
        if (this.selectedRecipe != null) {
            for (RecipeEntry entry : this.filteredRecipes) {
                if (!entry.id.equals((Object)this.selectedRecipe)) continue;
                guiGraphics.m_280480_(entry.icon, this.guiLeft + 152, this.guiTop + 72);
                break;
            }
        }
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.filteredRecipes.size(); ++i) {
            int ind = i - this.pageIndex * 8;
            int ix = 7 + 18 * (ind % 8);
            int iy = 17 + 18 * (ind / 8);
            if (!this.isHovering(mouseX, mouseY, ix, iy, 18, 18)) continue;
            RecipeEntry entry = this.filteredRecipes.get(i);
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add(entry.icon.m_41786_());
            if (entry.recipe != null) {
                String pool = entry.recipe.getBlueprintPool();
                if (pool != null && !pool.isEmpty()) {
                    tooltip.add((Component)Component.m_237119_());
                    tooltip.add((Component)Component.m_237115_((String)"gui.hbm_m.recipe_from_group").m_130940_(ChatFormatting.AQUA));
                    tooltip.add((Component)Component.m_237113_((String)("  " + pool)).m_130940_(ChatFormatting.GOLD));
                }
                tooltip.add((Component)Component.m_237119_());
                TemplateTooltipUtil.buildRecipeTooltip(entry.recipe, tooltip);
            }
            guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
            return;
        }
        if (this.isHovering(mouseX, mouseY, 151, 71, 18, 18) && this.selectedRecipe != null) {
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                this.f_96541_.f_91073_.m_7465_().m_44043_(this.selectedRecipe).ifPresent(recipe -> {
                    if (recipe instanceof AssemblerRecipe) {
                        AssemblerRecipe assemblerRecipe = (AssemblerRecipe)recipe;
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        ItemStack output = assemblerRecipe.m_8043_(null);
                        tooltip.add(output.m_41786_());
                        String pool = assemblerRecipe.getBlueprintPool();
                        if (pool != null && !pool.isEmpty()) {
                            tooltip.add((Component)Component.m_237119_());
                            tooltip.add((Component)Component.m_237115_((String)"gui.hbm_m.recipe_from_group").m_130940_(ChatFormatting.AQUA));
                            tooltip.add((Component)Component.m_237113_((String)("  " + pool)).m_130940_(ChatFormatting.GOLD));
                        }
                        tooltip.add((Component)Component.m_237119_());
                        TemplateTooltipUtil.buildRecipeTooltip(assemblerRecipe, tooltip);
                        guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
                    }
                });
            }
            return;
        }
        if (this.isHovering(mouseX, mouseY, 152, 90, 16, 16)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Close").m_130940_(ChatFormatting.YELLOW), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 134, 108, 16, 16)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Clear search").m_130940_(ChatFormatting.YELLOW), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 8, 108, 16, 16)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Press ENTER to toggle focus").m_130940_(ChatFormatting.ITALIC), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isHovering((int)mouseX, (int)mouseY, 152, 18, 16, 16)) {
            this.playClickSound();
            if (this.pageIndex > 0) {
                --this.pageIndex;
            }
            return true;
        }
        if (this.isHovering((int)mouseX, (int)mouseY, 152, 36, 16, 16)) {
            this.playClickSound();
            if (this.pageIndex < this.pageCount) {
                ++this.pageIndex;
            }
            return true;
        }
        if (this.isHovering((int)mouseX, (int)mouseY, 134, 108, 16, 16)) {
            this.searchBox.m_94144_("");
            this.onSearch("");
            this.searchBox.m_93692_(true);
            return true;
        }
        for (int i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.filteredRecipes.size(); ++i) {
            int ind = i - this.pageIndex * 8;
            int ix = 7 + 18 * (ind % 8);
            int iy = 17 + 18 * (ind / 8);
            if (!this.isHovering((int)mouseX, (int)mouseY, ix, iy, 18, 18)) continue;
            RecipeEntry entry = this.filteredRecipes.get(i);
            this.selectedRecipe = !entry.id.equals((Object)this.selectedRecipe) ? entry.id : null;
            this.playClickSound();
            return true;
        }
        if (this.isHovering((int)mouseX, (int)mouseY, 151, 71, 18, 18) && this.selectedRecipe != null) {
            this.selectedRecipe = null;
            this.playClickSound();
            return true;
        }
        if (this.isHovering((int)mouseX, (int)mouseY, 152, 90, 16, 16)) {
            this.applySelection();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.pageIndex > 0) {
            --this.pageIndex;
        } else if (delta < 0.0 && this.pageIndex < this.pageCount) {
            ++this.pageIndex;
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.searchBox.m_93692_(!this.searchBox.m_93696_());
            return true;
        }
        if (keyCode == 265) {
            --this.pageIndex;
        }
        if (keyCode == 264) {
            ++this.pageIndex;
        }
        if (keyCode == 266) {
            this.pageIndex -= 5;
        }
        if (keyCode == 267) {
            this.pageIndex += 5;
        }
        if (keyCode == 268) {
            this.pageIndex = 0;
        }
        if (keyCode == 269) {
            this.pageIndex = this.pageCount;
        }
        this.pageIndex = Math.max(0, Math.min(this.pageIndex, this.pageCount));
        if (keyCode == 256) {
            this.applySelection();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void applySelection() {
        ModPacketHandler.INSTANCE.sendToServer((Object)new SetAssemblerRecipeC2SPacket(this.machinePos, this.selectedRecipe));
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
        }
    }

    public void m_7379_() {
        this.applySelection();
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean isHovering(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= this.guiLeft + x && mouseX < this.guiLeft + x + width && mouseY >= this.guiTop + y && mouseY < this.guiTop + y + height;
    }

    private void playClickSound() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    public void m_86600_() {
        MachineAdvancedAssemblerBlockEntity assembler;
        ItemStack currentFolder;
        BlockEntity be;
        super.m_86600_();
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (be = this.f_96541_.f_91073_.m_7702_(this.machinePos)) instanceof MachineAdvancedAssemblerBlockEntity && !ItemStack.m_41728_((ItemStack)this.lastFolderStack, (ItemStack)(currentFolder = (assembler = (MachineAdvancedAssemblerBlockEntity)be).getBlueprintFolder()))) {
            this.lastFolderStack = currentFolder.m_41777_();
            this.reloadRecipes();
        }
    }

    private void reloadRecipes() {
        BlockEntity be;
        this.allRecipes.clear();
        this.filteredRecipes.clear();
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (be = this.f_96541_.f_91073_.m_7702_(this.machinePos)) instanceof MachineAdvancedAssemblerBlockEntity) {
            MachineAdvancedAssemblerBlockEntity assembler = (MachineAdvancedAssemblerBlockEntity)be;
            List<AssemblerRecipe> available = assembler.getAvailableRecipes();
            ArrayList<RecipeEntry> poolRecipes = new ArrayList<RecipeEntry>();
            ArrayList<RecipeEntry> baseRecipes = new ArrayList<RecipeEntry>();
            for (AssemblerRecipe recipe : available) {
                ItemStack icon = recipe.m_8043_(null);
                RecipeEntry entry = new RecipeEntry(recipe.m_6423_(), icon, recipe);
                if (recipe.getBlueprintPool() != null && !recipe.getBlueprintPool().isEmpty()) {
                    poolRecipes.add(entry);
                    continue;
                }
                baseRecipes.add(entry);
            }
            this.allRecipes.addAll(poolRecipes);
            this.allRecipes.addAll(baseRecipes);
            if (this.searchBox != null && !this.searchBox.m_94155_().isEmpty()) {
                this.onSearch(this.searchBox.m_94155_());
            } else {
                this.filteredRecipes.addAll(this.allRecipes);
            }
            this.resetPaging();
        }
    }

    private record RecipeEntry(ResourceLocation id, ItemStack icon, @Nullable AssemblerRecipe recipe) {
    }
}

