/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.menu.AnvilMenu;
import com.hbm_m.network.AnvilCraftC2SPacket;
import com.hbm_m.network.AnvilSelectRecipeC2SPacket;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.recipe.AnvilRecipe;
import com.hbm_m.recipe.AnvilRecipeManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GUIAnvil
extends AbstractContainerScreen<AnvilMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/processing/gui_anvil.png");
    private static final int DISPLAY_SLOTS = 10;
    private final List<AnvilRecipe> originRecipes = new ArrayList<AnvilRecipe>();
    private final List<AnvilRecipe> filteredRecipes = new ArrayList<AnvilRecipe>();
    private EditBox searchBox;
    private int columnOffset;
    private int maxColumnOffset;
    private int selectionIndex = -1;
    private int lastTextWidth;
    private ItemStack hoveredRecipeStack = ItemStack.f_41583_;
    private boolean followSelection = true;
    @Nullable
    private ResourceLocation cachedServerSelection;

    public GUIAnvil(AnvilMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.loadAvailableRecipes();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.searchBox = new EditBox(this.f_96547_, x + 10, y + 111, 84, 12, (Component)Component.m_237119_());
        this.searchBox.m_94199_(25);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(-1);
        this.searchBox.m_94205_(-1);
        this.searchBox.m_94151_(this::applySearch);
        String hint = Component.m_237115_((String)"gui.hbm_m.anvil.search_hint").getString();
        if ("gui.hbm_m.anvil.search_hint".equals(hint)) {
            hint = Component.m_237115_((String)"gui.hbm_m.anvil.search").getString();
        }
        this.searchBox.m_94167_(hint);
        this.searchBox.m_94144_("");
        this.m_142416_((GuiEventListener)this.searchBox);
        this.cachedServerSelection = ((AnvilMenu)this.f_97732_).blockEntity.getSelectedRecipeId().orElse(null);
        this.applySearch("");
    }

    private void loadAvailableRecipes() {
        this.originRecipes.clear();
        RegistryAccess access = this.getRegistryAccess();
        this.originRecipes.addAll(AnvilRecipeManager.getClientRecipes().stream().filter(recipe -> recipe.canCraftOn(((AnvilMenu)this.f_97732_).blockEntity.getTier())).sorted(Comparator.comparing(recipe -> recipe.m_8043_(access).m_41786_().getString().toLowerCase(Locale.ROOT))).toList());
    }

    private void applySearch(String rawQuery) {
        String query = rawQuery == null ? "" : rawQuery.trim().toLowerCase(Locale.ROOT);
        this.filteredRecipes.clear();
        if (query.isEmpty()) {
            this.filteredRecipes.addAll(this.originRecipes);
        } else {
            RegistryAccess access = this.getRegistryAccess();
            block0: for (AnvilRecipe recipe : this.originRecipes) {
                List<String> searchTerms = this.buildSearchTerms(recipe, access);
                for (String term : searchTerms) {
                    if (!term.contains(query)) continue;
                    this.filteredRecipes.add(recipe);
                    continue block0;
                }
            }
        }
        this.resetPagination();
        this.cachedServerSelection = ((AnvilMenu)this.f_97732_).blockEntity.getSelectedRecipeId().orElse(null);
        this.followSelection = true;
        this.refreshSelectionFromCache(false);
    }

    private List<String> buildSearchTerms(AnvilRecipe recipe, RegistryAccess access) {
        ArrayList<String> terms = new ArrayList<String>();
        ItemStack output = recipe.m_8043_(access);
        if (!output.m_41619_()) {
            try {
                terms.add(output.m_41786_().getString().toLowerCase(Locale.ROOT));
            }
            catch (Exception ex) {
                terms.add("error");
            }
            this.addTagSearchTerms(terms, output);
        }
        for (AnvilRecipe.ResultEntry entry : recipe.getOutputs()) {
            ItemStack stack = entry.stack();
            if (stack.m_41619_()) continue;
            try {
                terms.add(stack.m_41786_().getString().toLowerCase(Locale.ROOT));
            }
            catch (Exception ex) {
                terms.add("error");
            }
            this.addTagSearchTerms(terms, stack);
        }
        for (ItemStack input : List.of(recipe.getInputA(), recipe.getInputB())) {
            if (input.m_41619_()) continue;
            try {
                terms.add(input.m_41786_().getString().toLowerCase(Locale.ROOT));
            }
            catch (Exception ex) {
                terms.add("error");
            }
            this.addTagSearchTerms(terms, input);
        }
        for (ItemStack required : recipe.getInventoryInputs()) {
            if (required.m_41619_()) continue;
            try {
                terms.add(required.m_41786_().getString().toLowerCase(Locale.ROOT));
            }
            catch (Exception ex) {
                terms.add("error");
            }
            this.addTagSearchTerms(terms, required);
        }
        return terms;
    }

    private void resetPagination() {
        this.columnOffset = 0;
        this.selectionIndex = -1;
        this.recalculateBounds();
    }

    private void recalculateBounds() {
        int size = this.filteredRecipes.size();
        double raw = (double)(size - 10) / 2.0;
        this.maxColumnOffset = Math.max(0, (int)Math.ceil(raw));
        this.columnOffset = Mth.m_14045_((int)this.columnOffset, (int)0, (int)this.maxColumnOffset);
        if (this.selectionIndex >= size) {
            this.selectionIndex = -1;
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
            if (this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
                this.searchBox.m_94167_("");
            } else if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
                String hint = Component.m_237115_((String)"gui.hbm_m.anvil.search_hint").getString();
                if ("gui.hbm_m.anvil.search_hint".equals(hint)) {
                    hint = Component.m_237115_((String)"gui.hbm_m.anvil.search").getString();
                }
                this.searchBox.m_94167_(hint);
            }
        }
        this.syncSelectionFromServer();
        if (this.followSelection) {
            this.ensureSelectionVisible();
        }
    }

    private void syncSelectionFromServer() {
        ResourceLocation serverSelection = ((AnvilMenu)this.f_97732_).blockEntity.getSelectedRecipeId().orElse(null);
        if (!Objects.equals(serverSelection, this.cachedServerSelection)) {
            this.cachedServerSelection = serverSelection;
            this.refreshSelectionFromCache(false);
        }
    }

    private void refreshSelectionFromCache(boolean forceDefault) {
        if (this.filteredRecipes.isEmpty()) {
            this.selectionIndex = -1;
            this.followSelection = false;
            return;
        }
        if (this.cachedServerSelection == null) {
            if (forceDefault) {
                this.selectionIndex = 0;
                this.followSelection = true;
                this.notifyServerAboutSelection(this.filteredRecipes.get(0));
            } else {
                this.selectionIndex = -1;
                this.followSelection = false;
            }
            return;
        }
        int index = this.findRecipeIndex(this.cachedServerSelection);
        if (index >= 0) {
            this.selectionIndex = index;
            this.followSelection = true;
        } else if (forceDefault) {
            this.selectionIndex = 0;
            this.followSelection = true;
            this.notifyServerAboutSelection(this.filteredRecipes.get(0));
        } else {
            this.selectionIndex = -1;
            this.followSelection = false;
        }
    }

    private void ensureSelectionVisible() {
        if (this.selectionIndex < 0) {
            return;
        }
        int targetColumn = this.selectionIndex / 2;
        int columnsVisible = 5;
        int maxVisibleColumn = this.columnOffset + columnsVisible - 1;
        if (targetColumn < this.columnOffset) {
            this.columnOffset = targetColumn;
        } else if (targetColumn > maxVisibleColumn) {
            this.columnOffset = targetColumn - columnsVisible + 1;
        } else {
            return;
        }
        this.columnOffset = Mth.m_14045_((int)this.columnOffset, (int)0, (int)this.maxColumnOffset);
    }

    private int findRecipeIndex(ResourceLocation id) {
        for (int i = 0; i < this.filteredRecipes.size(); ++i) {
            if (!this.filteredRecipes.get(i).m_6423_().equals((Object)id)) continue;
            return i;
        }
        return -1;
    }

    public void focusRecipe(@Nullable AnvilRecipe target) {
        if (target == null || !this.originRecipes.contains(target)) {
            return;
        }
        this.searchBox.m_94144_("");
        this.applySearch("");
        int pos = this.filteredRecipes.indexOf(target);
        if (pos >= 0) {
            this.selectionIndex = pos;
            this.followSelection = true;
            this.ensureSelectionVisible();
            this.notifyServerAboutSelection(target);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchBox != null) {
            if (this.searchBox.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)this.searchBox);
                return true;
            }
            if (this.searchBox.m_93696_() && !this.isMouseOverSearchBox(mouseX, mouseY)) {
                this.searchBox.m_93692_(false);
            }
        }
        if (this.isOverLeftArrow(mouseX, mouseY)) {
            this.playClickSound();
            this.scrollColumns(-1);
            return true;
        }
        if (this.isOverRightArrow(mouseX, mouseY)) {
            this.playClickSound();
            this.scrollColumns(1);
            return true;
        }
        if (this.isOverCraftButton(mouseX, mouseY) && this.isCraftButtonEnabled()) {
            this.playClickSound();
            boolean craftAll = GUIAnvil.m_96638_();
            ModPacketHandler.INSTANCE.sendToServer((Object)new AnvilCraftC2SPacket(((AnvilMenu)this.f_97732_).blockEntity.m_58899_(), craftAll));
            return true;
        }
        if (this.isOverSearchButton(mouseX, mouseY)) {
            this.playClickSound();
            this.applySearch(this.searchBox.m_94155_());
            return true;
        }
        if (this.handleRecipeClick(mouseX, mouseY)) {
            this.playClickSound();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void playClickSound() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    private void scrollColumns(int delta) {
        this.columnOffset = Mth.m_14045_((int)(this.columnOffset + delta), (int)0, (int)this.maxColumnOffset);
        this.followSelection = false;
    }

    private boolean handleRecipeClick(double mouseX, double mouseY) {
        int recipeIndex;
        int startIndex = this.columnOffset * 2;
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        for (int slot = 0; slot < 10 && (recipeIndex = startIndex + slot) < this.filteredRecipes.size(); ++slot) {
            int col = slot / 2;
            int row = slot % 2;
            int overlayX = guiLeft + 16 + col * 18;
            int overlayY = guiTop + 71 + row * 18;
            if (!(mouseX >= (double)overlayX) || !(mouseX < (double)(overlayX + 18)) || !(mouseY >= (double)overlayY) || !(mouseY < (double)(overlayY + 18))) continue;
            if (this.selectionIndex == recipeIndex) {
                this.selectionIndex = -1;
                this.followSelection = false;
                this.notifyServerAboutSelection(null);
            } else {
                this.selectionIndex = recipeIndex;
                this.followSelection = true;
                this.notifyServerAboutSelection(this.filteredRecipes.get(recipeIndex));
            }
            return true;
        }
        return false;
    }

    private boolean isCraftButtonEnabled() {
        if (this.selectionIndex < 0 || this.selectionIndex >= this.filteredRecipes.size()) {
            return false;
        }
        return !this.filteredRecipes.get(this.selectionIndex).usesMachineInputs();
    }

    private void notifyServerAboutSelection(@Nullable AnvilRecipe recipe) {
        ResourceLocation id;
        this.cachedServerSelection = id = recipe != null ? recipe.m_6423_() : null;
        ((AnvilMenu)this.f_97732_).blockEntity.setSelectedRecipeId(id);
        ModPacketHandler.INSTANCE.sendToServer((Object)new AnvilSelectRecipeC2SPacket(((AnvilMenu)this.f_97732_).blockEntity.m_58899_(), id));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isOverRecipeGrid(mouseX, mouseY)) {
            if (delta > 0.0) {
                this.scrollColumns(-1);
            } else if (delta < 0.0) {
                this.scrollColumns(1);
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private boolean isOverRecipeGrid(double mouseX, double mouseY) {
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        return mouseX >= (double)(guiLeft + 16) && mouseX < (double)(guiLeft + 106) && mouseY >= (double)(guiTop + 71) && mouseY < (double)(guiTop + 107);
    }

    private boolean isOverLeftArrow(double mouseX, double mouseY) {
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        return mouseX >= (double)(guiLeft + 7) && mouseX < (double)(guiLeft + 16) && mouseY >= (double)(guiTop + 71) && mouseY < (double)(guiTop + 107);
    }

    private boolean isOverRightArrow(double mouseX, double mouseY) {
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        return mouseX >= (double)(guiLeft + 106) && mouseX < (double)(guiLeft + 115) && mouseY >= (double)(guiTop + 71) && mouseY < (double)(guiTop + 107);
    }

    private boolean isOverCraftButton(double mouseX, double mouseY) {
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        return mouseX >= (double)(guiLeft + 52) && mouseX < (double)(guiLeft + 70) && mouseY >= (double)(guiTop + 53) && mouseY < (double)(guiTop + 71);
    }

    private boolean isOverSearchButton(double mouseX, double mouseY) {
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        return mouseX >= (double)(guiLeft + 97) && mouseX < (double)(guiLeft + 115) && mouseY >= (double)(guiTop + 107) && mouseY < (double)(guiTop + 125);
    }

    private boolean isMouseOverSearchBox(double mouseX, double mouseY) {
        if (this.searchBox == null) {
            return false;
        }
        int x = this.searchBox.m_252754_();
        int y = this.searchBox.m_252907_();
        int width = this.searchBox.m_5711_();
        int height = this.searchBox.m_93694_();
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.hoveredRecipeStack = ItemStack.f_41583_;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, guiLeft, guiTop, 0, 0, this.f_97726_, this.f_97727_);
        this.renderSearchFieldBackground(guiGraphics, guiLeft, guiTop);
        this.drawButtonHighlights(guiGraphics, guiLeft, guiTop, mouseX, mouseY);
        this.renderRecipeGrid(guiGraphics, guiLeft, guiTop, mouseX, mouseY);
        this.renderSidePanel(guiGraphics, guiLeft, guiTop);
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableComponent titleText = Component.m_237110_((String)"container.hbm_m.anvil", (Object[])new Object[]{((AnvilMenu)this.f_97732_).blockEntity.getTier().getDisplayName()});
        int titleWidth = this.f_96547_.m_92852_((FormattedText)titleText);
        int x = 61 - titleWidth / 2;
        int y = 8;
        guiGraphics.m_280614_(this.f_96547_, (Component)titleText, x, y, 0x404040, false);
        MutableComponent inventoryLabel = Component.m_237115_((String)"container.inventory");
        guiGraphics.m_280614_(this.f_96547_, (Component)inventoryLabel, 8, this.f_97727_ - 96 + 2, 0x404040, false);
        this.renderRecipeDetailsText(guiGraphics);
    }

    private void drawButtonHighlights(GuiGraphics guiGraphics, int guiLeft, int guiTop, int mouseX, int mouseY) {
        if (this.isOverLeftArrow(mouseX, mouseY) && this.columnOffset > 0) {
            guiGraphics.m_280218_(TEXTURE, guiLeft + 7, guiTop + 71, 176, 186, 9, 36);
        }
        if (this.isOverRightArrow(mouseX, mouseY) && this.columnOffset < this.maxColumnOffset) {
            guiGraphics.m_280218_(TEXTURE, guiLeft + 106, guiTop + 71, 185, 186, 9, 36);
        }
        if (this.isOverCraftButton(mouseX, mouseY) && this.isCraftButtonEnabled()) {
            guiGraphics.m_280218_(TEXTURE, guiLeft + 52, guiTop + 53, 176, 150, 18, 18);
        }
        if (this.isOverSearchButton(mouseX, mouseY)) {
            guiGraphics.m_280218_(TEXTURE, guiLeft + 97, guiTop + 107, 176, 168, 18, 18);
        }
    }

    private void renderSearchFieldBackground(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        if (this.searchBox == null) {
            return;
        }
        if (this.searchBox.m_93696_()) {
            guiGraphics.m_280218_(TEXTURE, guiLeft + 8, guiTop + 108, 168, 222, 88, 16);
        }
    }

    private void renderRecipeGrid(GuiGraphics guiGraphics, int guiLeft, int guiTop, int mouseX, int mouseY) {
        int recipeIndex;
        int startIndex = this.columnOffset * 2;
        for (int slot = 0; slot < 10 && (recipeIndex = startIndex + slot) < this.filteredRecipes.size(); ++slot) {
            ItemStack displayStack;
            int col = slot / 2;
            int row = slot % 2;
            int itemX = guiLeft + 17 + col * 18;
            int itemY = guiTop + 72 + row * 18;
            int overlayX = itemX - 1;
            int overlayY = itemY - 1;
            AnvilRecipe recipe = this.filteredRecipes.get(recipeIndex);
            if (recipe.isRecycling()) {
                displayStack = recipe.getRecyclingInputStack();
                if (displayStack.m_41619_()) {
                    displayStack = recipe.getDisplayStack();
                }
            } else {
                displayStack = recipe.getDisplayStack();
            }
            guiGraphics.m_280480_(displayStack, itemX, itemY);
            guiGraphics.m_280370_(this.f_96547_, displayStack, itemX, itemY);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            int overlayU = 18 + 18 * recipe.getOverlay().ordinal();
            guiGraphics.m_280218_(TEXTURE, overlayX, overlayY, overlayU, 222, 18, 18);
            if (recipeIndex == this.selectionIndex) {
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
                guiGraphics.m_280218_(TEXTURE, overlayX, overlayY, 0, 222, 18, 18);
            }
            guiGraphics.m_280168_().m_85849_();
            if (mouseX < overlayX || mouseX >= overlayX + 18 || mouseY < overlayY || mouseY >= overlayY + 18) continue;
            this.hoveredRecipeStack = displayStack;
        }
    }

    private void renderSidePanel(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        int slide = Mth.m_14045_((int)(this.lastTextWidth - 42), (int)0, (int)1000);
        int mul = 1;
        while (slide >= 51 * mul) {
            guiGraphics.m_280218_(TEXTURE, guiLeft + 125 + 51 * mul, guiTop + 17, 125, 17, 54, 108);
            ++mul;
        }
        guiGraphics.m_280218_(TEXTURE, guiLeft + 125 + slide, guiTop + 17, 125, 17, 54, 108);
    }

    private void renderRecipeDetailsText(GuiGraphics guiGraphics) {
        float scale;
        List<Component> lines = this.buildRecipeDetails();
        int longest = 0;
        if (!lines.isEmpty()) {
            for (Component line : lines) {
                longest = Math.max(longest, this.f_96547_.m_92852_((FormattedText)line));
            }
            scale = 0.5f;
            this.lastTextWidth = (int)((float)longest * scale);
        } else {
            this.lastTextWidth = 0;
        }
        if (lines.isEmpty()) {
            return;
        }
        scale = 0.5f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280168_().m_252880_(130.0f / scale, 25.0f / scale, 0.0f);
        int yOffset = 0;
        for (Component line : lines) {
            guiGraphics.m_280614_(this.f_96547_, line, 0, yOffset, 0xFFFFFF, false);
            yOffset += 9;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private List<Component> buildRecipeDetails() {
        if (this.selectionIndex < 0 || this.selectionIndex >= this.filteredRecipes.size() || this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return List.of();
        }
        AnvilRecipe recipe = this.filteredRecipes.get(this.selectionIndex);
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237115_((String)"gui.hbm_m.anvil.inputs").m_130940_(ChatFormatting.YELLOW));
        ArrayList<ItemStack> machineInputs = new ArrayList<ItemStack>();
        if (!recipe.getInputA().m_41619_()) {
            machineInputs.add(recipe.getInputA());
        }
        if (!recipe.getInputB().m_41619_()) {
            machineInputs.add(recipe.getInputB());
        }
        if (!machineInputs.isEmpty()) {
            this.appendIngredientLines(lines, machineInputs, IngredientSource.MACHINE);
        }
        if (!recipe.getInventoryInputs().isEmpty()) {
            this.appendIngredientLines(lines, recipe.getInventoryInputs(), IngredientSource.PLAYER);
        }
        lines.add((Component)Component.m_237119_());
        lines.add((Component)Component.m_237115_((String)"gui.hbm_m.anvil.outputs").m_130940_(ChatFormatting.YELLOW));
        for (AnvilRecipe.ResultEntry entry : recipe.getOutputs()) {
            ItemStack stack = entry.stack();
            float chance = entry.chance();
            String chanceText = chance < 1.0f ? " (" + (int)(chance * 100.0f) + "%)" : "";
            lines.add((Component)Component.m_237113_((String)("> " + stack.m_41613_() + "x " + stack.m_41786_().getString() + chanceText)));
        }
        return lines;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.hoveredRecipeStack = ItemStack.f_41583_;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (!this.hoveredRecipeStack.m_41619_()) {
            guiGraphics.m_280153_(this.f_96547_, this.hoveredRecipeStack, mouseX, mouseY);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            this.applySearch(this.searchBox.m_94155_());
            return true;
        }
        if (keyCode == 47 && this.searchBox != null && !this.searchBox.m_93696_()) {
            this.searchBox.m_93692_(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_5534_(codePoint, modifiers)) {
            this.applySearch(this.searchBox.m_94155_());
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private int getPlayerItemCount(ItemStack stack) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return 0;
        }
        int count = 0;
        Inventory inventory = this.f_96541_.f_91074_.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack invStack = inventory.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)invStack, (ItemStack)stack)) continue;
            count += invStack.m_41613_();
        }
        return count;
    }

    private void appendIngredientLines(List<Component> lines, List<ItemStack> stacks, IngredientSource source) {
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            int owned = source == IngredientSource.MACHINE ? this.getMachineItemCount(stack) : this.getPlayerItemCount(stack);
            boolean hasEnough = owned >= stack.m_41613_();
            MutableComponent line = Component.m_237113_((String)("> " + stack.m_41613_() + "x " + stack.m_41786_().getString()));
            line = line.m_6881_().m_130940_(hasEnough ? ChatFormatting.WHITE : ChatFormatting.RED);
            lines.add((Component)line);
        }
    }

    private void addTagSearchTerms(List<String> terms, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        try {
            stack.m_41720_().m_204114_().m_203616_().forEach(tagKey -> {
                ResourceLocation id = tagKey.f_203868_();
                if (!"forge".equals(id.m_135827_())) {
                    return;
                }
                String full = id.toString().toLowerCase(Locale.ROOT);
                String path = id.m_135815_().toLowerCase(Locale.ROOT);
                terms.add(full);
                terms.add(path);
                for (String part : path.split("[/_]")) {
                    if (part.isEmpty()) continue;
                    terms.add(part);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getMachineItemCount(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        ItemStackHandler handler = ((AnvilMenu)this.f_97732_).blockEntity.getItemHandler();
        int count = 0;
        int slotLimit = Math.min(handler.getSlots(), 2);
        for (int slot = 0; slot < slotLimit; ++slot) {
            ItemStack slotStack = handler.getStackInSlot(slot);
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack)) continue;
            count += slotStack.m_41613_();
        }
        return count;
    }

    private RegistryAccess getRegistryAccess() {
        return this.f_96541_ != null && this.f_96541_.f_91073_ != null ? this.f_96541_.f_91073_.m_9598_() : RegistryAccess.f_243945_;
    }

    public void m_7861_() {
        super.m_7861_();
    }

    private static enum IngredientSource {
        MACHINE,
        PLAYER;

    }
}

