/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.armormod.menu.ArmorTableMenu;
import com.hbm_m.armormod.menu.IHasTooltip;
import com.hbm_m.util.mixin.IMixinSlot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GUIArmorTable
extends AbstractContainerScreen<ArmorTableMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/machine/gui_armor_modifier.png");
    private static final int SIDE_PANEL_WIDTH = 22;
    private static final int SIDE_PANEL_HEIGHT = 80;
    private static final int SIDE_PANEL_U = 176;
    private static final int SIDE_PANEL_V = 96;
    private static final int SIDE_PANEL_OFFSET_X = -22;
    private static final int SIDE_PANEL_OFFSET_Y = 31;
    private static final int SLOT_START_X = -17;
    private static final int SLOT_START_Y = 36;

    public GUIArmorTable(ArmorTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = this.f_97727_ - 96;
        for (Slot slot : ((ArmorTableMenu)this.f_97732_).f_38839_) {
            if (!this.isArmorSlot(slot)) continue;
            int armorIndex = slot.f_40219_ - 46;
            int newX = -17;
            int newY = 36 + armorIndex * 18;
            ((IMixinSlot)slot).setPos(newX, newY);
        }
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderSlotBackgrounds(GuiGraphics guiGraphics) {
        for (Slot slot : ((ArmorTableMenu)this.f_97732_).f_38839_) {
            ResourceLocation spriteLocation;
            if (!this.isArmorSlot(slot) || slot.m_6657_() || (spriteLocation = this.getArmorSlotBackground(slot.f_40219_)) == null) continue;
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteLocation);
            guiGraphics.m_280159_(this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 0, 16, 16, sprite);
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280218_(TEXTURE, x + -22, y + 31, 176, 96, 22, 80);
        this.renderSlotBackgrounds(guiGraphics);
        this.drawCompatibilityIndicators(guiGraphics);
    }

    private void drawCompatibilityIndicators(GuiGraphics guiGraphics) {
        ItemStack carried = ((ArmorTableMenu)this.f_97732_).m_142621_();
        if (carried.m_41619_()) {
            return;
        }
        for (int i = 1; i <= 9; ++i) {
            Slot slot = ((ArmorTableMenu)this.f_97732_).m_38853_(i);
            if (slot.m_5857_(carried)) {
                guiGraphics.m_280509_(this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, this.f_97735_ + slot.f_40220_ + 16, this.f_97736_ + slot.f_40221_ + 16, -2147418368);
                continue;
            }
            guiGraphics.m_280509_(this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, this.f_97735_ + slot.f_40220_ + 16, this.f_97736_ + slot.f_40221_ + 16, -2130771968);
        }
    }

    protected void m_280072_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Slot slot;
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.f_97734_ != null && !this.f_97734_.m_6657_() && (slot = this.f_97734_) instanceof IHasTooltip) {
            IHasTooltip slotWithTooltip = (IHasTooltip)slot;
            guiGraphics.m_280557_(this.f_96547_, slotWithTooltip.getEmptyTooltip(), mouseX, mouseY);
        }
    }

    @Nullable
    private ResourceLocation getArmorSlotBackground(int slotIndex) {
        int armorIndex = slotIndex - 46;
        return switch (armorIndex) {
            case 0 -> InventoryMenu.f_39693_;
            case 1 -> InventoryMenu.f_39694_;
            case 2 -> InventoryMenu.f_39695_;
            case 3 -> InventoryMenu.f_39696_;
            default -> null;
        };
    }

    private boolean isArmorSlot(Slot slot) {
        int armorSlotStartIndex = 46;
        return slot.f_40219_ >= armorSlotStartIndex && slot.f_40219_ < armorSlotStartIndex + 4;
    }
}

