/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.client.overlay.GUIAdvancedAssemblerRecipeSelector;
import com.hbm_m.item.ModItems;
import com.hbm_m.menu.MachineAdvancedAssemblerMenu;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.util.EnergyFormatter;
import com.hbm_m.util.TemplateTooltipUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GUIMachineAdvancedAssembler
extends AbstractContainerScreen<MachineAdvancedAssemblerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/processing/gui_assembler.png");

    public GUIMachineAdvancedAssembler(MachineAdvancedAssemblerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 256;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        boolean canProcess;
        int maxProgress;
        int progress;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        long energyStored = ((MachineAdvancedAssemblerMenu)this.f_97732_).getEnergyLong();
        long maxEnergy = ((MachineAdvancedAssemblerMenu)this.f_97732_).getMaxEnergyLong();
        if (maxEnergy > 0L) {
            int energyBarHeight = (int)(energyStored * 61L / maxEnergy);
            if (energyBarHeight > 61) {
                energyBarHeight = 61;
            }
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 152, this.f_97736_ + 79 - energyBarHeight, 176, 61 - energyBarHeight, 16, energyBarHeight);
        }
        if ((progress = ((MachineAdvancedAssemblerMenu)this.f_97732_).getProgress()) > 0 && (maxProgress = ((MachineAdvancedAssemblerMenu)this.f_97732_).getMaxProgress()) > 0) {
            int progressWidth = (int)Math.ceil(70.0 * (double)progress / (double)maxProgress);
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 62, this.f_97736_ + 126, 176, 61, progressWidth, 16);
        }
        ResourceLocation selectedRecipeId = ((MachineAdvancedAssemblerMenu)this.f_97732_).getBlockEntity().getSelectedRecipeId();
        AssemblerRecipe recipe = null;
        if (selectedRecipeId != null && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            recipe = this.f_96541_.f_91073_.m_7465_().m_44043_(selectedRecipeId).filter(r -> r instanceof AssemblerRecipe).map(r -> (AssemblerRecipe)r).orElse(null);
        }
        boolean hasRecipe = recipe != null;
        boolean bl = canProcess = hasRecipe && energyStored >= 100L;
        if (((MachineAdvancedAssemblerMenu)this.f_97732_).isCrafting()) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 51, this.f_97736_ + 121, 195, 0, 3, 6);
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 56, this.f_97736_ + 121, 195, 0, 3, 6);
        } else if (hasRecipe) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 51, this.f_97736_ + 121, 192, 0, 3, 6);
            if (canProcess) {
                guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 56, this.f_97736_ + 121, 192, 0, 3, 6);
            }
        }
        this.renderGhostItems(guiGraphics);
    }

    private void renderGhostItems(GuiGraphics guiGraphics) {
        NonNullList<ItemStack> ghostItems = ((MachineAdvancedAssemblerMenu)this.f_97732_).getBlockEntity().getGhostItems();
        if (ghostItems.isEmpty()) {
            return;
        }
        LinkedHashMap<ItemStack, Integer> groupedItems = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack stack : ghostItems) {
            if (stack.m_41619_()) continue;
            ItemStack found = null;
            for (ItemStack key : groupedItems.keySet()) {
                if (!ItemStack.m_150942_((ItemStack)key, (ItemStack)stack)) continue;
                found = key;
                break;
            }
            if (found != null) {
                groupedItems.put(found, (Integer)groupedItems.get(found) + stack.m_41613_());
                continue;
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            groupedItems.put(copy, stack.m_41613_());
        }
        int inputSlotsStart = 4;
        int inputSlotsCount = 12;
        int slotOffset = 0;
        for (Map.Entry entry : groupedItems.entrySet()) {
            if (slotOffset >= inputSlotsCount) break;
            ItemStack ghostStack = ((ItemStack)entry.getKey()).m_41777_();
            ghostStack.m_41764_(((Integer)entry.getValue()).intValue());
            int slotIndex = inputSlotsStart + slotOffset;
            if (slotIndex >= ((MachineAdvancedAssemblerMenu)this.f_97732_).f_38839_.size()) break;
            Slot slot = (Slot)((MachineAdvancedAssemblerMenu)this.f_97732_).f_38839_.get(slotIndex);
            if (!slot.m_6657_()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                int x = this.f_97735_ + slot.f_40220_;
                int y = this.f_97736_ + slot.f_40221_;
                guiGraphics.m_280480_(ghostStack, x, y);
                if (ghostStack.m_41613_() > 1) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.m_280370_(this.f_96547_, ghostStack, x, y);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.m_280168_().m_85849_();
            }
            ++slotOffset;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        super.m_280072_(guiGraphics, pMouseX, pMouseY);
        if (this.isMouseOver(pMouseX, pMouseY, 152, 18, 16, 61)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            long energy = ((MachineAdvancedAssemblerMenu)this.f_97732_).getEnergyLong();
            long maxEnergy = ((MachineAdvancedAssemblerMenu)this.f_97732_).getMaxEnergyLong();
            String energyStr = EnergyFormatter.format(energy);
            String maxEnergyStr = EnergyFormatter.format(maxEnergy);
            tooltip.add(Component.m_237113_((String)(energyStr + " / " + maxEnergyStr + " HE")).m_130940_(ChatFormatting.GREEN));
            guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pMouseX, pMouseY);
        }
        if (this.isMouseOver(pMouseX, pMouseY, 7, 125, 18, 18)) {
            ResourceLocation selectedRecipeId = ((MachineAdvancedAssemblerMenu)this.f_97732_).getBlockEntity().getSelectedRecipeId();
            if (selectedRecipeId != null && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                this.f_96541_.f_91073_.m_7465_().m_44043_(selectedRecipeId).ifPresent(recipe -> {
                    if (recipe instanceof AssemblerRecipe) {
                        AssemblerRecipe assemblerRecipe = (AssemblerRecipe)recipe;
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        ItemStack output = assemblerRecipe.m_8043_(null);
                        tooltip.add(output.m_41786_());
                        TemplateTooltipUtil.buildRecipeTooltip(assemblerRecipe, tooltip);
                        guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pMouseX, pMouseY);
                    }
                });
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.recipe.setRecipe").m_130940_(ChatFormatting.YELLOW), pMouseX, pMouseY);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOver((int)mouseX, (int)mouseY, 7, 125, 18, 18)) {
            this.openRecipeSelector();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void openRecipeSelector() {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        ResourceLocation currentRecipe = ((MachineAdvancedAssemblerMenu)this.f_97732_).getBlockEntity().getSelectedRecipeId();
        this.f_96541_.m_91152_((Screen)new GUIAdvancedAssemblerRecipeSelector(((MachineAdvancedAssemblerMenu)this.f_97732_).getBlockEntity().m_58899_(), currentRecipe, (Screen)this));
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String name = this.f_96539_.getString();
        guiGraphics.m_280056_(this.f_96547_, name, 70 - this.f_96547_.m_92895_(name) / 2, 6, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this) {
            ResourceLocation selectedRecipeId = ((MachineAdvancedAssemblerMenu)this.f_97732_).getBlockEntity().getSelectedRecipeId();
            if (selectedRecipeId != null && this.f_96541_.f_91073_ != null) {
                this.f_96541_.f_91073_.m_7465_().m_44043_(selectedRecipeId).ifPresent(recipe -> {
                    if (recipe instanceof AssemblerRecipe) {
                        AssemblerRecipe assemblerRecipe = (AssemblerRecipe)recipe;
                        ItemStack icon = assemblerRecipe.m_8043_(null);
                        guiGraphics.m_280480_(icon, 8, 126);
                    }
                });
            } else {
                ItemStack folderIcon = new ItemStack((ItemLike)ModItems.TEMPLATE_FOLDER.get());
                guiGraphics.m_280480_(folderIcon, 8, 126);
            }
        }
    }

    private boolean isMouseOver(int pMouseX, int pMouseY, int pX, int pY, int pWidth, int pHeight) {
        return pMouseX >= this.f_97735_ + pX && pMouseX < this.f_97735_ + pX + pWidth && pMouseY >= this.f_97736_ + pY && pMouseY < this.f_97736_ + pY + pHeight;
    }
}

