/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.client.overlay.GuiInfoScreen;
import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.menu.MachineAssemblerMenu;
import com.hbm_m.util.EnergyFormatter;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GUIMachineAssembler
extends GuiInfoScreen<MachineAssemblerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/gui_assembler.png");
    private static final int TEMPLATE_SLOT_GUI_INDEX = 40;

    public GUIMachineAssembler(MachineAssemblerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
        this.f_97729_ = 6;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(@Nonnull GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_;
        int y = this.f_97736_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int energyBarHeight = 52;
        int energy = ((MachineAssemblerMenu)this.f_97732_).getEnergyScaled(energyBarHeight);
        guiGraphics.m_280218_(TEXTURE, x + 116, y + 70 - energy, 176, 52 - energy, 16, energy);
        if (((MachineAssemblerMenu)this.f_97732_).isCrafting()) {
            int progressWidth = 83;
            guiGraphics.m_280218_(TEXTURE, x + 45, y + 82, 2, 222, ((MachineAssemblerMenu)this.f_97732_).getProgressScaled(progressWidth), 32);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.drawInfoPanels(guiGraphics);
        this.renderGhostItems(guiGraphics);
    }

    private void drawInfoPanels(GuiGraphics guiGraphics) {
        this.drawInfoPanel(guiGraphics, -16, 16, GuiInfoScreen.PanelType.LARGE_GRAY_STAR);
        ItemStack templateStack = ((MachineAssemblerMenu)this.f_97732_).m_38853_(40).m_7993_();
        if (templateStack.m_41619_() || !(templateStack.m_41720_() instanceof ItemAssemblyTemplate)) {
            this.drawInfoPanel(guiGraphics, -16, 36, GuiInfoScreen.PanelType.LARGE_RED_EXCLAMATION);
        }
    }

    private void renderGhostItems(GuiGraphics guiGraphics) {
        NonNullList<ItemStack> ghostItems = ((MachineAssemblerMenu)this.f_97732_).getBlockEntity().getGhostItems();
        if (ghostItems.isEmpty()) {
            return;
        }
        LinkedHashMap<ItemStack, Integer> groupedItems = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack stack : ghostItems) {
            if (stack.m_41619_()) continue;
            ItemStack found = null;
            for (ItemStack key : groupedItems.keySet()) {
                if (!ItemStack.m_150942_((ItemStack)key, (ItemStack)stack)) continue;
                found = key;
                break;
            }
            if (found != null) {
                groupedItems.put(found, (Integer)groupedItems.get(found) + stack.m_41613_());
                continue;
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            groupedItems.put(copy, stack.m_41613_());
        }
        int inputSlotsStart = 42;
        int inputSlotsCount = 12;
        int slotOffset = 0;
        for (Map.Entry entry : groupedItems.entrySet()) {
            if (slotOffset >= inputSlotsCount) break;
            ItemStack ghostStack = ((ItemStack)entry.getKey()).m_41777_();
            ghostStack.m_41764_(((Integer)entry.getValue()).intValue());
            int slotIndex = inputSlotsStart + slotOffset;
            if (slotIndex >= ((MachineAssemblerMenu)this.f_97732_).f_38839_.size()) break;
            Slot slot = (Slot)((MachineAssemblerMenu)this.f_97732_).f_38839_.get(slotIndex);
            if (!slot.m_6657_()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                int x = this.f_97735_ + slot.f_40220_;
                int y = this.f_97736_ + slot.f_40221_;
                guiGraphics.m_280480_(ghostStack, x, y);
                if (ghostStack.m_41613_() > 1) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.m_280370_(this.f_96547_, ghostStack, x, y);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.m_280168_().m_85849_();
            }
            ++slotOffset;
        }
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(@Nonnull GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        this.renderEnergyTooltip(pGuiGraphics, pX, pY);
        this.renderInfoPanelTooltips(pGuiGraphics, pX, pY);
    }

    private void renderEnergyTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        int energyBarX = this.f_97735_ + 116;
        int energyBarY = this.f_97736_ + 18;
        int energyBarWidth = 16;
        int energyBarHeight = 52;
        if (pX >= energyBarX && pX < energyBarX + energyBarWidth && pY >= energyBarY && pY < energyBarY + energyBarHeight) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            long energy = ((MachineAssemblerMenu)this.f_97732_).getEnergyLong();
            long maxEnergy = ((MachineAssemblerMenu)this.f_97732_).getMaxEnergyLong();
            String energyStr = EnergyFormatter.format(energy);
            String maxEnergyStr = EnergyFormatter.format(maxEnergy);
            tooltip.add(Component.m_237113_((String)(energyStr + " / " + maxEnergyStr + " HE")));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
    }

    private void renderInfoPanelTooltips(GuiGraphics pGuiGraphics, int pX, int pY) {
        ItemStack templateStack;
        if (this.isPointInRect(-16, 16, 16, 16, pX, pY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"desc.gui.template"));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
        if (((templateStack = ((MachineAssemblerMenu)this.f_97732_).m_38853_(40).m_7993_()).m_41619_() || !(templateStack.m_41720_() instanceof ItemAssemblyTemplate)) && this.isPointInRect(-16, 36, 16, 16, pX, pY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"desc.gui.assembler.warning").m_130940_(ChatFormatting.RED));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
    }
}

