/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.menu.MachinePressMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class GUIMachinePress
extends AbstractContainerScreen<MachinePressMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/gui_press.png");
    private static final int LIGHT_U = 176;
    private static final int LIGHT_V = 0;
    private static final int LIGHT_WIDTH = 14;
    private static final int LIGHT_HEIGHT = 14;
    private static final int ARROW_U = 194;
    private static final int ARROW_V = 0;
    private static final int ARROW_WIDTH = 19;
    private static final int ARROW_MAX_HEIGHT = 17;
    private static final int GAUGE_WIDTH = 18;
    private static final int GAUGE_HEIGHT = 18;

    public GUIMachinePress(MachinePressMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 6;
        this.f_97729_ = 6;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderLight(guiGraphics, x, y);
        this.renderGaugeNeedle(guiGraphics, x, y);
        this.renderPressArrow(guiGraphics, x, y);
    }

    private void renderLight(GuiGraphics guiGraphics, int x, int y) {
        int burnTime = ((MachinePressMenu)this.f_97732_).getBurnTime();
        if (burnTime >= 20) {
            guiGraphics.m_280218_(TEXTURE, x + 27, y + 36, 176, 0, 14, 14);
        }
    }

    private void renderGaugeNeedle(GuiGraphics guiGraphics, int x, int y) {
        int speed = ((MachinePressMenu)this.f_97732_).getSpeed();
        int maxSpeed = ((MachinePressMenu)this.f_97732_).getMaxSpeed();
        double progress = maxSpeed > 0 ? (double)speed / (double)maxSpeed : 0.0;
        progress = Mth.m_14008_((double)progress, (double)0.0, (double)1.0);
        float centerX = (float)(x + 25) + 9.0f;
        float centerY = (float)(y + 16) + 9.0f;
        double tipLength = 5.5;
        double backLength = 1.5;
        double backSide = 0.8;
        int color = 0x7F0000;
        int colorOuter = 0;
        float angle = (float)Math.toRadians(45.0 + progress * 270.0);
        Vector3f tip = new Vector3f(0.0f, (float)tipLength, 0.0f);
        Vector3f left = new Vector3f((float)backSide, (float)(-backLength), 0.0f);
        Vector3f right = new Vector3f((float)(-backSide), (float)(-backLength), 0.0f);
        this.rotateAroundZ(tip, angle);
        this.rotateAroundZ(left, angle);
        this.rotateAroundZ(right, angle);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        double mult = 1.3;
        buffer.m_252986_(matrix, centerX + (float)((double)tip.x * mult), centerY + (float)((double)tip.y * mult), 0.0f).m_6122_(colorOuter >> 16 & 0xFF, colorOuter >> 8 & 0xFF, colorOuter & 0xFF, 255).m_5752_();
        buffer.m_252986_(matrix, centerX + (float)((double)left.x * mult), centerY + (float)((double)left.y * mult), 0.0f).m_6122_(colorOuter >> 16 & 0xFF, colorOuter >> 8 & 0xFF, colorOuter & 0xFF, 255).m_5752_();
        buffer.m_252986_(matrix, centerX + (float)((double)right.x * mult), centerY + (float)((double)right.y * mult), 0.0f).m_6122_(colorOuter >> 16 & 0xFF, colorOuter >> 8 & 0xFF, colorOuter & 0xFF, 255).m_5752_();
        buffer.m_252986_(matrix, centerX + tip.x, centerY + tip.y, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).m_5752_();
        buffer.m_252986_(matrix, centerX + left.x, centerY + left.y, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).m_5752_();
        buffer.m_252986_(matrix, centerX + right.x, centerY + right.y, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    private void rotateAroundZ(Vector3f vec, float angle) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        float newX = vec.x * cos - vec.y * sin;
        float newY = vec.x * sin + vec.y * cos;
        vec.x = newX;
        vec.y = newY;
    }

    private void renderPressArrow(GuiGraphics guiGraphics, int x, int y) {
        int arrowHeight;
        int press = ((MachinePressMenu)this.f_97732_).getPress();
        int maxPress = ((MachinePressMenu)this.f_97732_).getMaxPress();
        if (press > 0 && maxPress > 0 && (arrowHeight = press * 17 / maxPress) > 0) {
            guiGraphics.m_280163_(TEXTURE, x + 79, y + 35, 194.0f, 0.0f, 19, arrowHeight, 256, 256);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.isHovering(25, 16, 18, 18, mouseX, mouseY)) {
            int speed = ((MachinePressMenu)this.f_97732_).getSpeed();
            int maxSpeed = ((MachinePressMenu)this.f_97732_).getMaxSpeed();
            int speedPercent = maxSpeed != 0 ? speed * 100 / maxSpeed : 0;
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)(speedPercent + "%")), mouseX, mouseY);
        }
        if (this.isHovering(25, 34, 18, 18, mouseX, mouseY)) {
            int burnTime = ((MachinePressMenu)this.f_97732_).getBurnTime();
            if (burnTime > 0) {
                int operationsLeft = burnTime / 200;
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)(operationsLeft + " operations left")), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"No fuel"), mouseX, mouseY);
            }
        }
    }

    private boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        return (mouseX -= guiLeft) >= x && mouseX < x + width && (mouseY -= guiTop) >= y && mouseY < y + height;
    }
}

