/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.block.entity.machine.MachineShredderBlockEntity;
import com.hbm_m.client.overlay.GuiInfoScreen;
import com.hbm_m.menu.MachineShredderMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class GUIMachineShredder
extends GuiInfoScreen<MachineShredderMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/gui_shredder.png");
    private static final int PROGRESS_X = 63;
    private static final int PROGRESS_Y = 89;
    private static final int PROGRESS_WIDTH = 34;
    private static final int PROGRESS_HEIGHT = 18;
    private static final int PROGRESS_TEXTURE_X = 176;
    private static final int PROGRESS_TEXTURE_Y = 54;
    private static final int ENERGY_BAR_X = 8;
    private static final int ENERGY_BAR_BASE_Y = 106;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 88;
    private static final int ENERGY_TEXTURE_X = 176;
    private static final int ENERGY_TEXTURE_BASE_Y = 160;
    private static final int BLADE_LEFT_X = 43;
    private static final int BLADE_LEFT_Y = 71;
    private static final int BLADE_RIGHT_X = 79;
    private static final int BLADE_RIGHT_Y = 71;
    private static final int BLADE_WIDTH = 18;
    private static final int BLADE_HEIGHT = 18;
    private static final int BLADE_TEXTURE_X_LEFT = 176;
    private static final int BLADE_TEXTURE_X_RIGHT = 194;
    private static final int BLADE_TEXTURE_Y_GOOD = 0;
    private static final int BLADE_TEXTURE_Y_WORN = 18;
    private static final int BLADE_TEXTURE_Y_BROKEN = 36;
    private static final int ERROR_PANEL_X = -16;
    private static final int ERROR_PANEL_Y = 36;
    private static final int ERROR_PANEL_WIDTH = 16;
    private static final int ERROR_PANEL_HEIGHT = 16;

    public GUIMachineShredder(MachineShredderMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 233;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyBar(guiGraphics, x, y);
        this.renderProgressArrow(guiGraphics, x, y);
        this.renderBlades(guiGraphics, x, y);
        this.renderErrorPanel(guiGraphics);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        int progressScaled = ((MachineShredderMenu)this.f_97732_).getScaledProgress(34);
        if (progressScaled > 0) {
            guiGraphics.m_280218_(TEXTURE, x + 63, y + 89, 176, 54, progressScaled + 1, 18);
        }
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int energyScaled;
        long power = ((MachineShredderMenu)this.f_97732_).getEnergyLong();
        long maxPower = ((MachineShredderMenu)this.f_97732_).getMaxEnergyLong();
        if (power > 0L && maxPower > 0L && (energyScaled = (int)(power * 88L / maxPower)) > 0) {
            guiGraphics.m_280218_(TEXTURE, x + 8, y + 106 - energyScaled, 176, 160 - energyScaled, 16, energyScaled);
        }
    }

    private void renderBlades(GuiGraphics guiGraphics, int x, int y) {
        int gearRight;
        MachineShredderBlockEntity blockEntity = ((MachineShredderMenu)this.f_97732_).getBlockEntity();
        int gearLeft = blockEntity.getGearLeft();
        if (gearLeft != 0) {
            int textureY = switch (gearLeft) {
                case 1 -> 0;
                case 2 -> 18;
                case 3 -> 36;
                default -> 0;
            };
            guiGraphics.m_280218_(TEXTURE, x + 43, y + 71, 176, textureY, 18, 18);
        }
        if ((gearRight = blockEntity.getGearRight()) != 0) {
            int textureY = switch (gearRight) {
                case 1 -> 0;
                case 2 -> 18;
                case 3 -> 36;
                default -> 0;
            };
            guiGraphics.m_280218_(TEXTURE, x + 79, y + 71, 194, textureY, 18, 18);
        }
    }

    private void renderErrorPanel(GuiGraphics guiGraphics) {
        if (this.shouldShowBladeWarning()) {
            this.drawInfoPanel(guiGraphics, -16, 36, GuiInfoScreen.PanelType.LARGE_RED_EXCLAMATION);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderCustomTooltips(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    private void renderCustomTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MachineShredderBlockEntity blockEntity = ((MachineShredderMenu)this.f_97732_).getBlockEntity();
        this.drawElectricityInfo(guiGraphics, mouseX, mouseY, 8, 18, 16, 88, ((MachineShredderMenu)this.f_97732_).getEnergyLong(), ((MachineShredderMenu)this.f_97732_).getMaxEnergyLong());
        if (this.shouldShowBladeWarning()) {
            this.drawCustomInfoStat(guiGraphics, mouseX, mouseY, -16, 36, 16, 16, mouseX, mouseY, new Component[]{Component.m_237115_((String)"gui.hbm_m.shredder.blade_warning.title"), Component.m_237115_((String)"gui.hbm_m.shredder.blade_warning.desc")});
        }
    }

    private boolean shouldShowBladeWarning() {
        MachineShredderBlockEntity blockEntity = ((MachineShredderMenu)this.f_97732_).getBlockEntity();
        int gearLeft = blockEntity.getGearLeft();
        int gearRight = blockEntity.getGearRight();
        return gearLeft == 0 || gearLeft == 3 || gearRight == 0 || gearRight == 3;
    }
}

