/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.menu.MachineWoodBurnerMenu;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.ToggleWoodBurnerPacket;
import com.hbm_m.util.EnergyFormatter;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GUIMachineWoodBurner
extends AbstractContainerScreen<MachineWoodBurnerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/generators/gui_wood_burner_alt.png");

    public GUIMachineWoodBurner(MachineWoodBurnerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 200;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97736_ -= 20;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97729_ = 6;
        this.f_97728_ = 17;
        this.f_97731_ = this.f_97727_ - 110;
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0xFFFFFF, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics gui, float partialTick, int mouseX, int mouseY) {
        int energyHeight;
        int burnHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = this.f_97735_;
        int y = this.f_97736_;
        gui.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (((MachineWoodBurnerMenu)this.f_97732_).isLit()) {
            gui.m_280218_(TEXTURE, x + 46, y + 37, 206, 72, 30, 14);
        }
        if ((burnHeight = ((MachineWoodBurnerMenu)this.f_97732_).getBurnTimeScaled(52)) > 0) {
            gui.m_280218_(TEXTURE, x + 17, y + 18 + 52 - burnHeight, 192, 52 - burnHeight, 4, burnHeight);
        }
        if ((energyHeight = ((MachineWoodBurnerMenu)this.f_97732_).getEnergyScaled(34)) > 0) {
            gui.m_280218_(TEXTURE, x + 143, y + 18 + 34 - energyHeight, 176, 34 - energyHeight, 16, energyHeight);
        }
        if (!((MachineWoodBurnerMenu)this.f_97732_).isEnabled()) {
            gui.m_280218_(TEXTURE, x + 53, y + 17, 196, 0, 16, 16);
        }
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, delta);
        this.m_280072_(gui, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics gui, int mouseX, int mouseY) {
        ArrayList<MutableComponent> tooltip;
        super.m_280072_(gui, mouseX, mouseY);
        if (this.isMouseOver(mouseX, mouseY, 143, 18, 16, 34)) {
            tooltip = new ArrayList<MutableComponent>();
            long energy = ((MachineWoodBurnerMenu)this.f_97732_).getEnergyLong();
            long maxEnergy = ((MachineWoodBurnerMenu)this.f_97732_).getMaxEnergyLong();
            String energyStr = EnergyFormatter.format(energy);
            String maxEnergyStr = EnergyFormatter.format(maxEnergy);
            tooltip.add(Component.m_237113_((String)(energyStr + " / " + maxEnergyStr + " HE")).m_130940_(ChatFormatting.GREEN));
            if (((MachineWoodBurnerMenu)this.f_97732_).isLit()) {
                tooltip.add(Component.m_237113_((String)"+50 HE/t").m_130940_(ChatFormatting.YELLOW));
            }
            gui.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.isMouseOver(mouseX, mouseY, 17, 18, 4, 52)) {
            tooltip = new ArrayList();
            int burnTime = ((MachineWoodBurnerMenu)this.f_97732_).getBurnTime();
            int maxBurnTime = ((MachineWoodBurnerMenu)this.f_97732_).getMaxBurnTime();
            if (maxBurnTime > 0) {
                int seconds = burnTime / 20;
                tooltip.add(Component.m_237113_((String)("Burn Time: " + seconds + "s")).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add(Component.m_237113_((String)"No Fuel").m_130940_(ChatFormatting.RED));
            }
            gui.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.isMouseOver(mouseX, mouseY, 53, 17, 16, 16)) {
            String status = ((MachineWoodBurnerMenu)this.f_97732_).isEnabled() ? "Enabled" : "Disabled";
            ChatFormatting color = ((MachineWoodBurnerMenu)this.f_97732_).isEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED;
            gui.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)status).m_130940_(color), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY, 53, 17, 16, 16)) {
            ModPacketHandler.INSTANCE.sendToServer((Object)new ToggleWoodBurnerPacket(((MachineWoodBurnerMenu)this.f_97732_).blockEntity.m_58899_()));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)(this.f_97735_ + x) && mouseX <= (double)(this.f_97735_ + x + sizeX) && mouseY >= (double)(this.f_97736_ + y) && mouseY <= (double)(this.f_97736_ + y + sizeY);
    }
}

