/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.item.tools.MultiDetonatorItem;
import com.hbm_m.network.ClearPointPacket;
import com.hbm_m.network.DetonateAllPacket;
import com.hbm_m.network.ModNetwork;
import com.hbm_m.network.SetActivePointPacket;
import com.hbm_m.network.SyncPointPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class GUIMultiDetonator
extends Screen {
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int COORDS_TEXT_WIDTH = 100;
    private static final int NAME_INPUT_WIDTH = 120;
    private static final int NAME_INPUT_HEIGHT = 18;
    private static final int SPACING = 10;
    private ItemStack detonatorStack;
    private MultiDetonatorItem detonatorItem;
    private int selectedPoint = 0;
    private EditBox[] nameInputs;
    private Button[] pointButtons;
    private Button detonateAllButton;
    private int pointsCount;

    public GUIMultiDetonator(ItemStack stack) {
        super((Component)Component.m_237113_((String)"Multi-Detonator"));
        this.detonatorStack = stack;
        this.detonatorItem = (MultiDetonatorItem)stack.m_41720_();
        this.selectedPoint = this.detonatorItem.getActivePoint(stack);
        this.pointsCount = this.detonatorItem.getMaxPoints();
        this.nameInputs = new EditBox[this.pointsCount];
        this.pointButtons = new Button[this.pointsCount];
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int centerX = this.f_96543_ / 2;
        int startY = 30;
        int yOffset = 0;
        for (int i = 0; i < this.pointsCount; ++i) {
            int pointIndex = i;
            int buttonY = startY + yOffset;
            Button pointButton = Button.m_253074_((Component)Component.m_237113_((String)("Point " + (i + 1))), btn -> this.selectPoint(pointIndex)).m_252794_(centerX - 75, buttonY).m_253046_(150, 20).m_253136_();
            if (i == this.selectedPoint) {
                pointButton.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)pointButton);
            this.pointButtons[i] = pointButton;
            EditBox nameInput = new EditBox(this.f_96547_, centerX - 60, buttonY + 20 + 5, 120, 18, (Component)Component.m_237113_((String)"Name"));
            MultiDetonatorItem.PointData pointData = this.detonatorItem.getPointData(this.detonatorStack, i);
            Object currentName = "";
            int currentX = 0;
            int currentY = 0;
            int currentZ = 0;
            boolean hasTarget = false;
            if (pointData != null && !pointData.name.isEmpty()) {
                currentName = pointData.name;
                currentX = pointData.x;
                currentY = pointData.y;
                currentZ = pointData.z;
                hasTarget = pointData.hasTarget;
            } else {
                currentName = "Point " + (i + 1);
            }
            nameInput.m_94144_((String)currentName);
            nameInput.m_94199_(16);
            int finalI = i;
            Object finalCurrentName = currentName;
            int finalX = currentX;
            int finalY = currentY;
            int finalZ = currentZ;
            boolean finalHasTarget = hasTarget;
            nameInput.m_94151_(name -> {
                if (!name.isEmpty()) {
                    this.detonatorItem.setPointName(this.detonatorStack, finalI, (String)name);
                    ModNetwork.CHANNEL.sendToServer((Object)new SyncPointPacket(finalI, (String)name, finalX, finalY, finalZ, finalHasTarget));
                }
            });
            this.m_142416_((GuiEventListener)nameInput);
            this.nameInputs[i] = nameInput;
            Button clearButton = Button.m_253074_((Component)Component.m_237113_((String)"Clear"), btn -> this.clearPoint(pointIndex)).m_252794_(centerX + 60 + 5, buttonY + 20 + 5).m_253046_(50, 18).m_253136_();
            this.m_142416_((GuiEventListener)clearButton);
            yOffset += 48;
        }
        this.detonateAllButton = Button.m_253074_((Component)Component.m_237113_((String)"Detonate All"), btn -> this.detonateAllPoints()).m_252794_(centerX - 55, this.f_96544_ - 51).m_253046_(110, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.detonateAllButton);
    }

    private void selectPoint(int pointIndex) {
        this.selectedPoint = pointIndex;
        this.detonatorItem.setActivePoint(this.detonatorStack, pointIndex);
        ModNetwork.CHANNEL.sendToServer((Object)new SetActivePointPacket(pointIndex));
        this.m_7856_();
    }

    private void clearPoint(int pointIndex) {
        this.detonatorItem.clearPoint(this.detonatorStack, pointIndex);
        ModNetwork.CHANNEL.sendToServer((Object)new ClearPointPacket(pointIndex));
        this.m_7856_();
    }

    private void detonateAllPoints() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = this.detonatorStack;
        if (stack.m_41619_() || !(stack.m_41720_() instanceof MultiDetonatorItem)) {
            return;
        }
        if (ModNetwork.CHANNEL == null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u0421\u0435\u0442\u0435\u0432\u043e\u0439 \u043a\u0430\u043d\u0430\u043b \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d!").m_130940_(ChatFormatting.RED), true);
            return;
        }
        ModNetwork.CHANNEL.sendToServer((Object)new DetonateAllPacket());
        this.f_96541_.m_91152_(null);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int centerX = this.f_96543_ / 2;
        int startY = 30;
        int yOffset = 0;
        guiGraphics.m_280056_(this.f_96547_, "Multi-Detonator", centerX - 37, 10, 0xFFFFFF, false);
        for (int i = 0; i < this.pointsCount; ++i) {
            int textY = startY + yOffset + 2;
            MultiDetonatorItem.PointData pointData = this.detonatorItem.getPointData(this.detonatorStack, i);
            String coordText = "----";
            int textColor = 0xFF0000;
            if (pointData != null && pointData.hasTarget) {
                coordText = String.format("X:%d Y:%d Z:%d", pointData.x, pointData.y, pointData.z);
                textColor = 43520;
            }
            guiGraphics.m_280056_(this.f_96547_, coordText, centerX + 75 + 20, textY, textColor, false);
            yOffset += 48;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (EditBox input : this.nameInputs) {
            if (!input.m_93696_() || !input.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        for (EditBox input : this.nameInputs) {
            if (!input.m_93696_() || !input.m_5534_(codePoint, modifiers)) continue;
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_86600_() {
        super.m_86600_();
        for (EditBox input : this.nameInputs) {
            input.m_94120_();
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }
}

