/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.item.ModItems;
import com.hbm_m.network.GiveTemplateC2SPacket;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.util.TemplateCraftingCosts;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class GUITemplateFolder
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/gui_planner.png");
    private final int imageWidth = 176;
    private final int imageHeight = 229;
    private int leftPos;
    private int topPos;
    private EditBox searchBox;
    private int currentPage = 0;
    private final List<ItemStack> allRecipes = new ArrayList<ItemStack>();
    private List<ItemStack> filteredRecipes = new ArrayList<ItemStack>();

    public GUITemplateFolder(ItemStack folderStack) {
        super((Component)Component.m_237115_((String)folderStack.m_41778_()));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        if (this.allRecipes.isEmpty()) {
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_STONE_PLATE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_STONE_WIRE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_STONE_CIRCUIT.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_IRON_PLATE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_IRON_WIRE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_IRON_CIRCUIT.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_IRON_9.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_IRON_44.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_IRON_50.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_IRON_357.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_STEEL_PLATE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_STEEL_WIRE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_STEEL_CIRCUIT.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_TITANIUM_PLATE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_TITANIUM_WIRE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_TITANIUM_CIRCUIT.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_OBSIDIAN_PLATE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_OBSIDIAN_WIRE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_OBSIDIAN_CIRCUIT.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_DESH_PLATE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_DESH_WIRE.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_DESH_CIRCUIT.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_DESH_9.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_DESH_44.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_DESH_50.get()));
                this.allRecipes.add(new ItemStack((ItemLike)ModItems.STAMP_DESH_357.get()));
                List recipes = this.f_96541_.f_91073_.m_7465_().m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE);
                for (AssemblerRecipe recipe : recipes) {
                    this.allRecipes.add(recipe.m_8043_(null));
                }
            }
            this.filteredRecipes.clear();
            this.filteredRecipes.addAll(this.allRecipes);
        }
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 62, this.topPos + 213, 48, 12, (Component)Component.m_237119_());
        this.searchBox.m_94199_(50);
        this.searchBox.m_94151_(this::onSearch);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_93692_(true);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.updateNavButtons();
    }

    private void updateNavButtons() {
        this.m_169413_();
        this.m_142416_((GuiEventListener)this.searchBox);
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$updateNavButtons$0(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((GUITemplateFolder)this)).m_252987_((int)(this.leftPos + 7), (int)(this.topPos + 107), (int)18, (int)18).m_253136_())).f_93623_ = this.currentPage > 0;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$updateNavButtons$1(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((GUITemplateFolder)this)).m_252987_((int)(this.leftPos + 151), (int)(this.topPos + 107), (int)18, (int)18).m_253136_())).f_93623_ = this.currentPage < this.getPageCount() - 1;
    }

    private void changePage(int delta) {
        this.currentPage += delta;
        this.updateNavButtons();
    }

    private void onSearch(String query) {
        this.filteredRecipes.clear();
        if (query.isEmpty()) {
            this.filteredRecipes.addAll(this.allRecipes);
        } else {
            String lowerQuery = query.toLowerCase(Locale.ROOT);
            for (ItemStack stack : this.allRecipes) {
                if (!stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains(lowerQuery)) continue;
                this.filteredRecipes.add(stack);
            }
        }
        this.currentPage = 0;
        this.updateNavButtons();
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.searchBox.m_93696_()) {
            guiGraphics.m_280218_(TEXTURE, this.leftPos + 45, this.topPos + 211, 176, 54, 72, 12);
        }
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderRecipes(guiGraphics, pMouseX, pMouseY);
        String pageText = this.currentPage + 1 + "/" + this.getPageCount();
        guiGraphics.m_280488_(this.f_96547_, pageText, this.leftPos + this.imageWidth / 2 - this.f_96547_.m_92895_(pageText) / 2, this.topPos + 10, 0xFFFFFF);
    }

    private void renderRecipes(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int recipeIndex;
        int recipesPerPage = 35;
        int startIndex = this.currentPage * recipesPerPage;
        for (int i = 0; i < recipesPerPage && (recipeIndex = startIndex + i) < this.filteredRecipes.size(); ++i) {
            int row = i / 5;
            int col = i % 5;
            int x = this.leftPos + 25 + col * 27;
            int y = this.topPos + 26 + row * 27;
            ItemStack outputStack = this.filteredRecipes.get(recipeIndex);
            boolean hovered = mouseX >= x && mouseX < x + 18 && mouseY >= y && mouseY < y + 18;
            guiGraphics.m_280218_(TEXTURE, x, y, hovered ? 194 : 176, 0, 18, 18);
            guiGraphics.m_280203_(outputStack, x + 1, y + 1);
            if (!hovered) continue;
            if (this.isStamp(outputStack)) {
                NonNullList<Ingredient> cost;
                ArrayList<Object> tooltip = new ArrayList<Object>();
                tooltip.add(outputStack.m_41786_());
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && !this.f_96541_.f_91074_.m_7500_() && (cost = TemplateCraftingCosts.getCostForStamp(outputStack)) != null && !cost.isEmpty()) {
                    for (Ingredient ingredient : cost) {
                        ItemStack[] items = ingredient.m_43908_();
                        if (items.length <= 0) continue;
                        tooltip.add(Component.m_237115_((String)"tooltip.hbm_m.requires").m_130946_(": ").m_7220_(items[0].m_41786_()).m_130938_(style -> style.m_178520_(0xAAAAAA)));
                        break;
                    }
                }
                guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
                continue;
            }
            guiGraphics.m_280153_(this.f_96547_, outputStack, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int recipeIndex;
        int recipesPerPage = 35;
        int startIndex = this.currentPage * recipesPerPage;
        for (int i = 0; i < recipesPerPage && (recipeIndex = startIndex + i) < this.filteredRecipes.size(); ++i) {
            int row = i / 5;
            int col = i % 5;
            int x = this.leftPos + 25 + col * 27;
            int y = this.topPos + 26 + row * 27;
            if (!(pMouseX >= (double)x) || !(pMouseX < (double)(x + 18)) || !(pMouseY >= (double)y) || !(pMouseY < (double)(y + 18))) continue;
            ModPacketHandler.INSTANCE.sendToServer((Object)new GiveTemplateC2SPacket(this.filteredRecipes.get(recipeIndex)));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (pDelta > 0.0 && this.currentPage > 0) {
            this.changePage(-1);
        } else if (pDelta < 0.0 && this.currentPage < this.getPageCount() - 1) {
            this.changePage(1);
        }
        return true;
    }

    private int getPageCount() {
        return Math.max(1, (int)Math.ceil((double)this.filteredRecipes.size() / 35.0));
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean isStamp(ItemStack stack) {
        return TemplateCraftingCosts.isStamp(stack);
    }

    private /* synthetic */ void lambda$updateNavButtons$1(Button b) {
        this.changePage(1);
    }

    private /* synthetic */ void lambda$updateNavButtons$0(Button b) {
        this.changePage(-1);
    }
}

