/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.util.EnergyFormatter;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public abstract class GuiInfoScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation GUI_UTILITY = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/gui_utility.png");

    protected GuiInfoScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void drawElectricityInfo(GuiGraphics guiGraphics, int mouseX, int mouseY, int relX, int relY, int width, int height, long power, long maxPower) {
        if (this.isPointInRect(relX, relY, width, height, mouseX, mouseY)) {
            MutableComponent tooltip = Component.m_237110_((String)"gui.hbm_m.energy", (Object[])new Object[]{EnergyFormatter.format(power), EnergyFormatter.format(maxPower)});
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
        }
    }

    protected void drawCustomInfoStat(GuiGraphics guiGraphics, int mouseX, int mouseY, int relX, int relY, int width, int height, int tooltipX, int tooltipY, Component ... text) {
        if (text == null || text.length == 0) {
            return;
        }
        if (this.isPointInRect(relX, relY, width, height, mouseX, mouseY)) {
            guiGraphics.m_280666_(this.f_96547_, Arrays.asList(text), tooltipX, tooltipY);
        }
    }

    protected void drawInfoPanel(GuiGraphics guiGraphics, int relX, int relY, PanelType panelType) {
        if (panelType == null) {
            return;
        }
        int x = this.f_97735_ + relX;
        int y = this.f_97736_ + relY;
        RenderSystem.enableDepthTest();
        guiGraphics.m_280218_(GUI_UTILITY, x, y, panelType.u, panelType.v, panelType.width, panelType.height);
    }

    protected void drawItemStack(ItemStack stack, GuiGraphics guiGraphics, int relX, int relY, String label) {
        if (stack.m_41619_()) {
            return;
        }
        int x = this.f_97735_ + relX;
        int y = this.f_97736_ + relY;
        guiGraphics.m_280480_(stack, x, y);
        guiGraphics.m_280302_(this.f_96547_, stack, x, y, label);
    }

    protected boolean isPointInRect(int relX, int relY, int width, int height, int mouseX, int mouseY) {
        int x = mouseX - this.f_97735_;
        int y = mouseY - this.f_97736_;
        return x >= relX && x < relX + width && y >= relY && y < relY + height;
    }

    protected void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    protected static enum PanelType {
        SMALL_BLUE_INFO(0, 0, 8, 8),
        SMALL_GREEN_INFO(0, 8, 8, 8),
        LARGE_BLUE_INFO(8, 0, 16, 16),
        LARGE_GREEN_INFO(24, 0, 16, 16),
        SMALL_RED_EXCLAMATION(0, 16, 8, 8),
        SMALL_YELLOW_EXCLAMATION(0, 24, 8, 8),
        LARGE_RED_EXCLAMATION(8, 16, 16, 16),
        LARGE_YELLOW_EXCLAMATION(24, 16, 16, 16),
        SMALL_BLUE_STAR(0, 32, 8, 8),
        SMALL_GRAY_STAR(0, 40, 8, 8),
        LARGE_BLUE_STAR(8, 32, 16, 16),
        LARGE_GRAY_STAR(24, 32, 16, 16);

        private final int u;
        private final int v;
        private final int width;
        private final int height;

        private PanelType(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }
    }
}

