/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.config.ModClothConfig;
import com.hbm_m.item.tools.ItemGeigerCounter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class OverlayGeiger {
    public static float clientPlayerRadiation = 0.0f;
    public static float clientTotalEnvironmentRadiation = 0.0f;
    private static long lastInventoryCheckTime = 0L;
    private static boolean hasGeigerCached = false;
    private static final long INVENTORY_CHECK_INTERVAL = 1000L;
    private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/misc/overlay_misc.png");
    public static final IGuiOverlay GEIGER_HUD_OVERLAY = OverlayGeiger::onRenderOverlay;

    public static void onRenderOverlay(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastInventoryCheckTime > 1000L) {
            lastInventoryCheckTime = currentTime;
            hasGeigerCached = player != null ? OverlayGeiger.checkForGeiger(player) : false;
        }
        if (!hasGeigerCached || player == null || mc.f_91066_.f_92062_) {
            return;
        }
        float environmentRad = clientTotalEnvironmentRadiation;
        float playerRadForBar = clientPlayerRadiation;
        float maxPlayerRadForBar = ModClothConfig.get().maxPlayerRad;
        if (maxPlayerRadForBar <= 0.0f) {
            maxPlayerRadForBar = 1.0f;
        }
        int barLength = (int)(74.0f * Math.min(playerRadForBar / maxPlayerRadForBar, 1.0f));
        int posX = 3;
        int posY = screenHeight - 20;
        guiGraphics.m_280218_(OVERLAY, posX, posY, 0, 0, 94, 18);
        if (barLength > 0) {
            guiGraphics.m_280218_(OVERLAY, posX + 1, posY + 1, 1, 19, barLength, 16);
        }
        if (!player.m_7500_() && !player.m_5833_()) {
            if (environmentRad >= 25.0f) {
                guiGraphics.m_280218_(OVERLAY, posX + 94 + 2, posY, 36, 36, 18, 18);
            } else if (environmentRad >= 10.0f) {
                guiGraphics.m_280218_(OVERLAY, posX + 94 + 2, posY, 18, 36, 18, 18);
            } else if ((double)environmentRad >= 2.5) {
                guiGraphics.m_280218_(OVERLAY, posX + 94 + 2, posY, 0, 36, 18, 18);
            }
            if (environmentRad > 1000.0f) {
                guiGraphics.m_280430_(mc.f_91062_, (Component)Component.m_237113_((String)">1000 RAD/s"), posX, posY - 10, 0xFF0000);
            } else if (environmentRad >= 1.0f) {
                guiGraphics.m_280430_(mc.f_91062_, (Component)Component.m_237113_((String)(Math.round(environmentRad) + " RAD/s")), posX, posY - 10, 0xFFFF00);
            } else if (environmentRad > 0.0f) {
                guiGraphics.m_280430_(mc.f_91062_, (Component)Component.m_237113_((String)"<1 RAD/s"), posX, posY - 10, 65280);
            }
        }
    }

    private static boolean checkForGeiger(LocalPlayer player) {
        if (player.m_21205_().m_41720_() instanceof ItemGeigerCounter || player.m_21206_().m_41720_() instanceof ItemGeigerCounter) {
            return true;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof ItemGeigerCounter)) continue;
            return true;
        }
        return false;
    }
}

