/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.client.render.ModShaders;
import com.hbm_m.client.render.OcclusionCullingHelper;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractGpuVboRenderer {
    protected int vaoId = -1;
    protected int vboId = -1;
    protected int eboId = -1;
    protected int indexCount = 0;
    protected boolean initialized = false;

    protected abstract VboData buildVboData();

    private boolean shouldRenderWithCulling(BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        if (blockEntity == null || blockEntity.m_58904_() == null) {
            return false;
        }
        AABB renderBounds = blockEntity.getRenderBoundingBox();
        return OcclusionCullingHelper.shouldRender(blockPos, blockEntity.m_58904_(), renderBounds);
    }

    protected void initVbo() {
        if (this.initialized) {
            return;
        }
        int previousVao = GL11.glGetInteger((int)34229);
        int previousArrayBuffer = GL11.glGetInteger((int)34964);
        int previousElementArrayBuffer = GL11.glGetInteger((int)34965);
        VboData data = null;
        try {
            this.vaoId = GL30.glGenVertexArrays();
            this.vboId = GL15.glGenBuffers();
            data = this.buildVboData();
            if (data == null) {
                MainRegistry.LOGGER.warn("VboData is null, cannot initialize VBO");
                throw new IllegalStateException("VboData is null");
            }
            this.indexCount = data.indices != null ? data.indices.remaining() : 0;
            GL30.glBindVertexArray((int)this.vaoId);
            GL15.glBindBuffer((int)34962, (int)this.vboId);
            GL15.glBufferData((int)34962, (ByteBuffer)data.byteBuffer, (int)35044);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)32, (long)12L);
            GL20.glEnableVertexAttribArray((int)2);
            GL20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)32, (long)24L);
            if (data.indices != null && data.indices.remaining() > 0) {
                this.eboId = GL15.glGenBuffers();
                GL15.glBindBuffer((int)34963, (int)this.eboId);
                GL15.glBufferData((int)34963, (IntBuffer)data.indices, (int)35044);
            }
            GL30.glBindVertexArray((int)0);
            MemoryUtil.memFree((Buffer)data.byteBuffer);
            if (data.indices != null) {
                MemoryUtil.memFree((Buffer)data.indices);
            }
            this.initialized = true;
        }
        catch (Exception e) {
            if (data != null) {
                if (data.byteBuffer != null) {
                    MemoryUtil.memFree((Buffer)data.byteBuffer);
                }
                if (data.indices != null) {
                    MemoryUtil.memFree((Buffer)data.indices);
                }
            }
            if (this.vaoId != -1) {
                GL30.glDeleteVertexArrays((int)this.vaoId);
                this.vaoId = -1;
            }
            if (this.vboId != -1) {
                GL15.glDeleteBuffers((int)this.vboId);
                this.vboId = -1;
            }
            if (this.eboId != -1) {
                GL15.glDeleteBuffers((int)this.eboId);
                this.eboId = -1;
            }
            throw e;
        }
        finally {
            GL15.glBindBuffer((int)34962, (int)previousArrayBuffer);
            GL30.glBindVertexArray((int)previousVao);
            if (previousVao == 0) {
                GL15.glBindBuffer((int)34963, (int)previousElementArrayBuffer);
            }
        }
    }

    private void applyTextureFilterBasedOnDistance(BlockPos blockPos) {
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double dx = (double)blockPos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double dy = (double)blockPos.m_123342_() + 0.5 - cameraPos.f_82480_;
        double dz = (double)blockPos.m_123343_() + 0.5 - cameraPos.f_82481_;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        int thresholdChunks = ModClothConfig.get().modelUpdateDistance;
        double thresholdBlocks = (double)thresholdChunks * 16.0;
        GL13.glActiveTexture((int)33984);
        if (distance > thresholdBlocks) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    public void render(PoseStack poseStack, int packedLight, BlockPos blockPos) {
        this.render(poseStack, packedLight, blockPos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(PoseStack poseStack, int packedLight, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        if (!this.shouldRenderWithCulling(blockPos, blockEntity)) {
            return;
        }
        if (!this.initialized) {
            try {
                this.initVbo();
            }
            catch (Exception e) {
                MainRegistry.LOGGER.error("Failed to initialize VBO", (Throwable)e);
                this.vaoId = -1;
                this.vboId = -1;
                this.eboId = -1;
                return;
            }
        }
        if (!this.initialized || this.vaoId <= 0 || this.vboId <= 0) {
            return;
        }
        if (this.eboId <= 0 || this.indexCount <= 0) {
            return;
        }
        ShaderInstance shader = ModShaders.getBlockLitShader();
        if (shader == null) {
            return;
        }
        int previousVao = GL11.glGetInteger((int)34229);
        int previousArrayBuffer = GL11.glGetInteger((int)34964);
        int previousCullFace = GL11.glGetInteger((int)2884);
        GL13.glActiveTexture((int)33984);
        int previousMinFilter = GL11.glGetTexParameteri((int)3553, (int)10241);
        int previousMagFilter = GL11.glGetTexParameteri((int)3553, (int)10240);
        try {
            Uniform fogColorUniform;
            Uniform fogEndUniform;
            Uniform fogStartUniform;
            Uniform useInstancingUniform;
            RenderSystem.setShader(() -> shader);
            if (shader.f_173308_ != null) {
                shader.f_173308_.m_5679_(poseStack.m_85850_().m_252922_());
            }
            if (shader.f_173309_ != null) {
                shader.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
            }
            float brightness = this.calculateBrightness(packedLight);
            Uniform brightnessUniform = shader.m_173348_("Brightness");
            if (brightnessUniform != null) {
                brightnessUniform.m_5985_(brightness);
            }
            if ((useInstancingUniform = shader.m_173348_("UseInstancing")) != null) {
                useInstancingUniform.m_142617_(0);
            }
            if ((fogStartUniform = shader.m_173348_("FogStart")) != null) {
                fogStartUniform.m_5985_(RenderSystem.getShaderFogStart());
            }
            if ((fogEndUniform = shader.m_173348_("FogEnd")) != null) {
                fogEndUniform.m_5985_(RenderSystem.getShaderFogEnd());
            }
            if ((fogColorUniform = shader.m_173348_("FogColor")) != null) {
                float[] fogColor = RenderSystem.getShaderFogColor();
                fogColorUniform.m_5805_(fogColor[0], fogColor[1], fogColor[2], fogColor[3]);
            }
            shader.m_173363_();
            TextureBinder.bindForModelIfNeeded(shader);
            this.applyTextureFilterBasedOnDistance(blockPos);
            Uniform sampler0 = shader.m_173348_("Sampler0");
            if (sampler0 != null) {
                sampler0.m_142617_(0);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
            RenderSystem.depthMask((boolean)true);
            GL11.glDisable((int)2884);
            GL30.glBindVertexArray((int)this.vaoId);
            GL11.glDrawElements((int)4, (int)this.indexCount, (int)5125, (long)0L);
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error during VBO render", (Throwable)e);
        }
        finally {
            GL30.glBindVertexArray((int)0);
            GL15.glBindBuffer((int)34962, (int)previousArrayBuffer);
            GL30.glBindVertexArray((int)previousVao);
            if (previousCullFace == 1) {
                GL11.glEnable((int)2884);
            }
            RenderSystem.setShader(() -> null);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            GL13.glActiveTexture((int)33984);
            GL11.glTexParameteri((int)3553, (int)10241, (int)previousMinFilter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)previousMagFilter);
        }
    }

    private float calculateBrightness(int packedLight) {
        int blockLight = LightTexture.m_109883_((int)packedLight);
        int skyLight = LightTexture.m_109894_((int)packedLight);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return Math.max(0.05f, (float)Math.max(blockLight, skyLight) / 15.0f);
        }
        float skyDarken = level.m_104805_(1.0f);
        float skyBrightness = 0.05f + skyDarken * 0.95f;
        float effectiveSkyLight = (float)skyLight * skyBrightness;
        float maxLight = Math.max((float)blockLight, effectiveSkyLight);
        float brightness = 0.05f + maxLight / 15.0f * 0.95f;
        return brightness;
    }

    public void cleanup() {
        if (!this.initialized) {
            return;
        }
        int vaoToDelete = this.vaoId;
        int vboToDelete = this.vboId;
        int eboToDelete = this.eboId;
        this.vaoId = -1;
        this.vboId = -1;
        this.eboId = -1;
        this.initialized = false;
        RenderSystem.recordRenderCall(() -> {
            try {
                if (vboToDelete != -1) {
                    GL15.glDeleteBuffers((int)vboToDelete);
                }
                if (eboToDelete != -1) {
                    GL15.glDeleteBuffers((int)eboToDelete);
                }
                if (vaoToDelete != -1) {
                    GL30.glDeleteVertexArrays((int)vaoToDelete);
                }
            }
            catch (Exception e) {
                MainRegistry.LOGGER.error("Error during VBO cleanup", (Throwable)e);
            }
        });
    }

    public static class VboData {
        public final ByteBuffer byteBuffer;
        public final IntBuffer indices;

        public VboData(ByteBuffer byteBuffer, IntBuffer indices) {
            this.byteBuffer = byteBuffer;
            this.indices = indices;
        }
    }

    static final class TextureBinder {
        TextureBinder() {
        }

        static void bindForModelIfNeeded(ShaderInstance shader) {
            Minecraft minecraft = Minecraft.m_91087_();
            TextureManager textureManager = minecraft.m_91097_();
            GL13.glActiveTexture((int)33984);
            AbstractTexture blockAtlas = textureManager.m_118506_(TextureAtlas.f_118259_);
            int textureId = blockAtlas.m_117963_();
            GL11.glBindTexture((int)3553, (int)textureId);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }
}

