/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.client.render.LegacyAnimator;
import com.hbm_m.client.render.shader.ImmediateFallbackRenderer;
import com.hbm_m.client.render.shader.RenderPathManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractPartBasedRenderer<T extends BlockEntity, M extends BakedModel>
implements BlockEntityRenderer<T> {
    private Matrix4f currentModelViewMatrix = new Matrix4f();
    private boolean gpuStateSetup = false;
    private static final RenderType RT_SOLID = RenderType.m_110451_();

    protected abstract M getModelType(BakedModel var1);

    protected abstract Direction getFacing(T var1);

    protected abstract void renderParts(T var1, M var2, LegacyAnimator var3, float var4, int var5, int var6, PoseStack var7, MultiBufferSource var8);

    public Matrix4f getCurrentModelViewMatrix() {
        return new Matrix4f((Matrix4fc)this.currentModelViewMatrix);
    }

    public void m_6922_(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BakedModel rawModel;
        M model;
        this.currentModelViewMatrix = poseStack.m_85850_().m_252922_();
        if (!this.isInViewFrustum(blockEntity)) {
            return;
        }
        if (!this.gpuStateSetup) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RT_SOLID.m_110185_();
            this.gpuStateSetup = true;
        }
        if ((model = this.getModelType(rawModel = Minecraft.m_91087_().m_91289_().m_110910_(blockEntity.m_58900_()))) == null) {
            return;
        }
        LegacyAnimator animator = LegacyAnimator.create(poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.m_85836_();
        animator.setupBlockTransform(this.getFacing(blockEntity));
        this.renderParts(blockEntity, model, animator, partialTick, packedLight, packedOverlay, poseStack, bufferSource);
        poseStack.m_85849_();
        if (this.gpuStateSetup) {
            RT_SOLID.m_110188_();
            Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
            this.gpuStateSetup = false;
        }
        if (RenderPathManager.shouldUseFallback()) {
            ImmediateFallbackRenderer.endBatch();
        }
    }

    protected final Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    protected boolean isInViewFrustum(T blockEntity) {
        return true;
    }
}

