/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.block.entity.DoorBlockEntity;
import com.hbm_m.block.entity.DoorDecl;
import com.hbm_m.client.model.DoorBakedModel;
import com.hbm_m.client.render.AbstractGpuVboRenderer;
import com.hbm_m.client.render.AbstractPartBasedRenderer;
import com.hbm_m.client.render.DoorVboRenderer;
import com.hbm_m.client.render.GlobalMeshCache;
import com.hbm_m.client.render.InstancedStaticPartRenderer;
import com.hbm_m.client.render.LegacyAnimator;
import com.hbm_m.client.render.ObjModelVboBuilder;
import com.hbm_m.client.render.OcclusionCullingHelper;
import com.hbm_m.client.render.shader.ImmediateFallbackRenderer;
import com.hbm_m.client.render.shader.RenderPathManager;
import com.hbm_m.main.MainRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DoorRenderer
extends AbstractPartBasedRenderer<DoorBlockEntity, DoorBakedModel> {
    private static final ConcurrentHashMap<String, ImmediateFallbackRenderer> fallbackRenderers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, InstancedStaticPartRenderer> instancedFrameCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Boolean> frameInitializationFlags = new ConcurrentHashMap();
    private final float[] translation = new float[3];
    private final float[] origin = new float[3];
    private final float[] rotation = new float[3];

    public DoorRenderer(BlockEntityRendererProvider.Context context) {
    }

    private synchronized void initializeFrameInstancerForType(DoorBakedModel model, String doorType, String framePartName) {
        String frameKey = "frame_" + doorType;
        if (frameInitializationFlags.getOrDefault(frameKey, false).booleanValue()) {
            return;
        }
        try {
            BakedModel frameModel = model.getPart(framePartName);
            if (frameModel != null) {
                AbstractGpuVboRenderer.VboData frameData = ObjModelVboBuilder.buildSinglePart(frameModel);
                if (frameData != null) {
                    InstancedStaticPartRenderer frameRenderer = new InstancedStaticPartRenderer(frameData);
                    instancedFrameCache.put(frameKey, frameRenderer);
                    MainRegistry.LOGGER.debug("Initialized frame renderer for {} part '{}' ", (Object)doorType, (Object)framePartName);
                } else {
                    MainRegistry.LOGGER.warn("Frame model for {} / part '{}' has no geometry", (Object)doorType, (Object)framePartName);
                }
            } else {
                MainRegistry.LOGGER.warn("Frame part '{}' not found in model for door type: {}", (Object)framePartName, (Object)doorType);
            }
            frameInitializationFlags.put(frameKey, true);
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Failed to initialize door frame instanced renderer for type: " + doorType, (Throwable)e);
            frameInitializationFlags.put(frameKey, false);
        }
    }

    @Override
    protected DoorBakedModel getModelType(BakedModel rawModel) {
        DoorBakedModel model;
        return rawModel instanceof DoorBakedModel ? (model = (DoorBakedModel)rawModel) : null;
    }

    @Override
    protected Direction getFacing(DoorBlockEntity blockEntity) {
        return blockEntity.getFacing();
    }

    @Override
    protected void renderParts(DoorBlockEntity be, DoorBakedModel model, LegacyAnimator animator, float partialTick, int packedLight, int packedOverlay, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (!be.isController()) {
            return;
        }
        DoorDecl doorDecl = be.getDoorDecl();
        if (doorDecl == null) {
            return;
        }
        BlockPos blockPos = be.m_58899_();
        Minecraft minecraft = Minecraft.m_91087_();
        AABB renderBounds = be.getRenderBoundingBox();
        if (!OcclusionCullingHelper.shouldRender(blockPos, (Level)minecraft.f_91073_, renderBounds)) {
            return;
        }
        float openTicks = be.getOpenProgress(partialTick) * (float)doorDecl.getOpenTime();
        boolean isOpen = be.isOpen();
        doorDecl.doOffsetTransform(animator);
        boolean isShadowPass = DoorRenderer.isShadowPassActive();
        if (isShadowPass || RenderPathManager.shouldUseFallback()) {
            this.renderWithFallback(be, model, doorDecl, openTicks, isOpen, poseStack, packedLight);
        } else {
            this.renderWithVBO(be, model, doorDecl, openTicks, isOpen, poseStack, packedLight, blockPos);
        }
    }

    private void renderWithVBO(DoorBlockEntity be, DoorBakedModel model, DoorDecl doorDecl, float openTicks, boolean isOpen, PoseStack poseStack, int packedLight, BlockPos blockPos) {
        try {
            String doorType = this.getDoorTypeKey(doorDecl);
            String frameKey = "frame_" + doorType;
            String[] partNames = model.getPartNames();
            String staticFramePart = this.detectFramePart(partNames);
            if (staticFramePart != null) {
                InstancedStaticPartRenderer frameRenderer;
                if (!frameInitializationFlags.getOrDefault(frameKey, false).booleanValue()) {
                    this.initializeFrameInstancerForType(model, doorType, staticFramePart);
                }
                if ((frameRenderer = instancedFrameCache.get(frameKey)) != null) {
                    poseStack.m_85836_();
                    frameRenderer.render(poseStack, packedLight, blockPos, be);
                    poseStack.m_85849_();
                }
            }
            for (String partName : partNames) {
                if (staticFramePart != null && staticFramePart.equals(partName)) continue;
                this.renderHierarchyVbo(partName, false, be, model, doorDecl, openTicks, poseStack, packedLight, blockPos);
            }
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error in VBO door render", (Throwable)e);
            this.renderWithFallback(be, model, doorDecl, openTicks, isOpen, poseStack, packedLight);
        }
    }

    private void renderHierarchyVbo(String partName, boolean child, DoorBlockEntity be, DoorBakedModel model, DoorDecl doorDecl, float openTicks, PoseStack poseStack, int packedLight, BlockPos blockPos) {
        if (!doorDecl.doesRender(partName, child)) {
            return;
        }
        poseStack.m_85836_();
        this.doPartTransform(poseStack, doorDecl, partName, openTicks, child);
        if (!"frame".equals(partName) && !"Base".equals(partName)) {
            BakedModel partModel = model.getPart(partName);
            if (partModel != null) {
                try {
                    DoorVboRenderer partRenderer = DoorVboRenderer.getOrCreate(model, partName, this.getDoorTypeKey(doorDecl));
                    partRenderer.renderPart(poseStack, packedLight, blockPos, be, doorDecl, openTicks, child);
                }
                catch (IllegalStateException e) {
                    MainRegistry.LOGGER.debug("No mesh for part {}, skipping render: {}", (Object)partName, (Object)e.getMessage());
                }
            } else {
                MainRegistry.LOGGER.trace("Part {} has no mesh, acting as container only", (Object)partName);
            }
        }
        for (String c : doorDecl.getChildren(partName)) {
            this.renderHierarchyVbo(c, true, be, model, doorDecl, openTicks, poseStack, packedLight, blockPos);
        }
        poseStack.m_85849_();
    }

    private String getDoorTypeKey(DoorDecl doorDecl) {
        if (doorDecl == DoorDecl.LARGE_VEHICLE_DOOR) {
            return "large_vehicle_door";
        }
        if (doorDecl == DoorDecl.ROUND_AIRLOCK_DOOR) {
            return "round_airlock_door";
        }
        if (doorDecl == DoorDecl.TRANSITION_SEAL) {
            return "transition_seal";
        }
        if (doorDecl == DoorDecl.FIRE_DOOR) {
            return "fire_door";
        }
        if (doorDecl == DoorDecl.SLIDE_DOOR) {
            return "sliding_blast_door";
        }
        if (doorDecl == DoorDecl.SLIDING_SEAL_DOOR) {
            return "sliding_seal_door";
        }
        if (doorDecl == DoorDecl.SECURE_ACCESS_DOOR) {
            return "secure_access_door";
        }
        if (doorDecl == DoorDecl.QE_SLIDING) {
            return "qe_sliding_door";
        }
        if (doorDecl == DoorDecl.QE_CONTAINMENT) {
            return "qe_containment_door";
        }
        if (doorDecl == DoorDecl.WATER_DOOR) {
            return "water_door";
        }
        if (doorDecl == DoorDecl.SILO_HATCH) {
            return "silo_hatch";
        }
        if (doorDecl == DoorDecl.SILO_HATCH_LARGE) {
            return "silo_hatch_large";
        }
        throw new IllegalStateException("Unknown door type: " + doorDecl.getClass().getName());
    }

    private String detectFramePart(String[] partNames) {
        for (String p : partNames) {
            if (!"frame".equals(p)) continue;
            return "frame";
        }
        for (String p : partNames) {
            if (!"Frame".equals(p)) continue;
            return "Frame";
        }
        for (String p : partNames) {
            if (!"DoorFrame".equals(p)) continue;
            return "DoorFrame";
        }
        return null;
    }

    private void renderWithFallback(DoorBlockEntity be, DoorBakedModel model, DoorDecl doorDecl, float openTicks, boolean isOpen, PoseStack poseStack, int packedLight) {
        BakedModel frameModel;
        String[] partNames = model.getPartNames();
        BlockPos blockPos = be.m_58899_();
        Level level = be.m_58904_();
        String staticFramePart = this.detectFramePart(partNames);
        if (staticFramePart != null && (frameModel = model.getPart(staticFramePart)) != null) {
            poseStack.m_85836_();
            this.renderFallbackPart(staticFramePart, frameModel, poseStack, packedLight, blockPos, level, be);
            poseStack.m_85849_();
        }
        for (String partName : partNames) {
            if (staticFramePart != null && staticFramePart.equals(partName)) continue;
            this.renderHierarchyFallback(partName, false, be, model, doorDecl, openTicks, poseStack, packedLight);
        }
        ImmediateFallbackRenderer.endBatch();
    }

    private void renderHierarchyFallback(String partName, boolean child, DoorBlockEntity be, DoorBakedModel model, DoorDecl doorDecl, float openTicks, PoseStack poseStack, int packedLight) {
        if (!doorDecl.doesRender(partName, child)) {
            return;
        }
        poseStack.m_85836_();
        this.doPartTransform(poseStack, doorDecl, partName, openTicks, child);
        BakedModel partModel = model.getPart(partName);
        if (partModel != null) {
            this.renderFallbackPart(partName, partModel, poseStack, packedLight, be.m_58899_(), be.m_58904_(), be);
        }
        for (String c : doorDecl.getChildren(partName)) {
            this.renderHierarchyFallback(c, true, be, model, doorDecl, openTicks, poseStack, packedLight);
        }
        poseStack.m_85849_();
    }

    private void doPartTransform(PoseStack poseStack, DoorDecl doorDecl, String partName, float openTicks, boolean child) {
        doorDecl.getTranslation(partName, openTicks, child, this.translation);
        doorDecl.getOrigin(partName, this.origin);
        doorDecl.getRotation(partName, openTicks, this.rotation);
        poseStack.m_252880_(this.origin[0], this.origin[1], this.origin[2]);
        if (this.rotation[0] != 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rotation[0]));
        }
        if (this.rotation[1] != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotation[1]));
        }
        if (this.rotation[2] != 0.0f) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(this.rotation[2]));
        }
        poseStack.m_252880_(-this.origin[0] + this.translation[0], -this.origin[1] + this.translation[1], -this.origin[2] + this.translation[2]);
    }

    private void renderFallbackPart(String partName, BakedModel partModel, PoseStack poseStack, int packedLight, BlockPos blockPos, Level level, BlockEntity blockEntity) {
        if (partModel == null) {
            return;
        }
        try {
            String doorType = this.getDoorTypeKey(((DoorBlockEntity)blockEntity).getDoorDecl());
            ImmediateFallbackRenderer renderer = fallbackRenderers.computeIfAbsent("door_" + doorType + "_" + partName, k -> new ImmediateFallbackRenderer(partModel));
            renderer.render(poseStack, packedLight, null, blockPos, level, blockEntity);
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error rendering fallback door part {}: {}", (Object)partName, (Object)e.getMessage());
            String doorType = this.getDoorTypeKey(((DoorBlockEntity)blockEntity).getDoorDecl());
            fallbackRenderers.remove("door_" + doorType + "_" + partName);
        }
    }

    public boolean shouldRender(DoorBlockEntity blockEntity, Vec3 cameraPos) {
        if (DoorRenderer.isShadowPassActive()) {
            return blockEntity.m_58899_().m_123331_((Vec3i)new BlockPos((int)cameraPos.f_82479_, (int)cameraPos.f_82480_, (int)cameraPos.f_82481_)) <= DoorRenderer.getShadowRenderDistance() * DoorRenderer.getShadowRenderDistance();
        }
        return super.m_142756_((BlockEntity)blockEntity, cameraPos);
    }

    public boolean shouldRenderOffScreen(DoorBlockEntity be) {
        return true;
    }

    private static double getShadowRenderDistance() {
        try {
            Class<?> shadowRenderingClass = Class.forName("net.irisshaders.iris.shadows.ShadowRenderingState");
            Method method = shadowRenderingClass.getDeclaredMethod("getRenderDistance", new Class[0]);
            method.setAccessible(true);
            Integer distance = (Integer)method.invoke(null, new Object[0]);
            return distance != null ? (double)distance.intValue() : 128.0;
        }
        catch (Exception e) {
            return 128.0;
        }
    }

    private static boolean isShadowPassActive() {
        try {
            Class<?> shadowRenderingClass = Class.forName("net.irisshaders.iris.shadows.ShadowRenderingState");
            Method method = shadowRenderingClass.getDeclaredMethod("areShadowsCurrentlyBeingRendered", new Class[0]);
            method.setAccessible(true);
            Boolean result = (Boolean)method.invoke(null, new Object[0]);
            return result != null && result != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void flushInstancedBatches() {
        for (InstancedStaticPartRenderer renderer : instancedFrameCache.values()) {
            if (renderer == null) continue;
            renderer.flush();
        }
    }

    public int m_142163_() {
        return 128;
    }

    public void onResourceManagerReload() {
        DoorRenderer.clearAllCaches();
    }

    public static void clearAllCaches() {
        for (InstancedStaticPartRenderer renderer : instancedFrameCache.values()) {
            if (renderer == null) continue;
            renderer.cleanup();
        }
        instancedFrameCache.clear();
        frameInitializationFlags.clear();
        DoorVboRenderer.clearCache();
        fallbackRenderers.clear();
        ImmediateFallbackRenderer.clearGlobalCache();
        ImmediateFallbackRenderer.endFrame();
        GlobalMeshCache.clearAll();
        MainRegistry.LOGGER.debug("Door renderer caches cleared");
    }
}

