/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.block.entity.DoorDecl;
import com.hbm_m.client.model.DoorBakedModel;
import com.hbm_m.client.render.AbstractGpuVboRenderer;
import com.hbm_m.client.render.ObjModelVboBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DoorVboRenderer
extends AbstractGpuVboRenderer {
    private final DoorBakedModel model;
    private final String partName;
    private final String cacheKey;
    private static final ConcurrentHashMap<String, DoorVboRenderer> partRenderers = new ConcurrentHashMap();
    private static final ThreadLocal<float[]> translationBuffer = ThreadLocal.withInitial(() -> new float[3]);
    private static final ThreadLocal<float[]> originBuffer = ThreadLocal.withInitial(() -> new float[3]);
    private static final ThreadLocal<float[]> rotationBuffer = ThreadLocal.withInitial(() -> new float[3]);

    private DoorVboRenderer(DoorBakedModel model, String partName) {
        this.model = model;
        this.partName = partName;
        this.cacheKey = "door_" + partName;
    }

    public static DoorVboRenderer getOrCreate(DoorBakedModel model, String partName, String doorType) {
        if ("frame".equals(partName)) {
            throw new IllegalArgumentException("Frame part should use InstancedStaticPartRenderer, not DoorVboRenderer!");
        }
        if ("Base".equals(partName)) {
            throw new IllegalArgumentException("Base part is empty and should not be rendered!");
        }
        String key = "door_" + doorType + "_" + partName + "_" + System.identityHashCode(model);
        return partRenderers.computeIfAbsent(key, k -> new DoorVboRenderer(model, partName));
    }

    public static DoorVboRenderer getOrCreate(DoorBakedModel model, String partName) {
        String doorType = "unknown_" + System.identityHashCode(model);
        return DoorVboRenderer.getOrCreate(model, partName, doorType);
    }

    @Override
    protected AbstractGpuVboRenderer.VboData buildVboData() {
        BakedModel partModel = this.model.getPart(this.partName);
        if (partModel == null) {
            throw new IllegalStateException("Part model not found: " + this.partName);
        }
        AbstractGpuVboRenderer.VboData vboData = ObjModelVboBuilder.buildSinglePart(partModel);
        if (vboData == null) {
            throw new IllegalStateException("No geometry found in part: " + this.partName);
        }
        return vboData;
    }

    public void renderPart(PoseStack poseStack, int packedLight, BlockPos blockPos, @Nullable BlockEntity blockEntity, DoorDecl doorDecl, float openTicks, boolean child) {
        if (!doorDecl.doesRender(this.partName, child)) {
            return;
        }
        super.render(poseStack, packedLight, blockPos, blockEntity);
    }

    public static void clearCache() {
        partRenderers.values().forEach(DoorVboRenderer::cleanup);
        partRenderers.clear();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        translationBuffer.remove();
        originBuffer.remove();
        rotationBuffer.remove();
    }
}

