/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.client.render.AbstractGpuVboRenderer;
import com.hbm_m.client.render.ObjModelVboBuilder;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class GlobalMeshCache {
    private static final int MAX_CACHE_SIZE = 256;
    private static final ConcurrentHashMap<String, WeakReference<AbstractGpuVboRenderer>> PART_RENDERERS = new ConcurrentHashMap();
    private static final Map<String, List<BakedQuad>> COMPILED_QUADS = new ConcurrentHashMap<String, List<BakedQuad>>();
    private static final Map<String, VertexBuffer> GPU_BUFFERS = new ConcurrentHashMap<String, VertexBuffer>();
    private static final RandomSource RANDOM_SOURCE = RandomSource.m_216335_((long)0L);

    public static List<BakedQuad> getOrCompile(String cacheKey, BakedModel modelPart) {
        if (COMPILED_QUADS.size() > 256) {
            GlobalMeshCache.clearOldestQuads();
        }
        return COMPILED_QUADS.computeIfAbsent(cacheKey, k -> GlobalMeshCache.compileMesh(modelPart));
    }

    public static List<BakedQuad> getOrCompile(Class<?> modelClass, String partName, BakedModel modelPart) {
        String cacheKey = modelClass.getSimpleName() + ":" + partName;
        return GlobalMeshCache.getOrCompile(cacheKey, modelPart);
    }

    public static VertexBuffer getOrCreateGPUBuffer(String cacheKey, BakedModel modelPart) {
        if (GPU_BUFFERS.size() > 256) {
            GlobalMeshCache.clearOldestBuffers();
        }
        return GPU_BUFFERS.computeIfAbsent(cacheKey, k -> {
            List<BakedQuad> quads = GlobalMeshCache.getOrCompile(cacheKey, modelPart);
            return GlobalMeshCache.uploadToGPU(quads);
        });
    }

    public static AbstractGpuVboRenderer getOrCreateRenderer(String partKey, BakedModel model) {
        if (PART_RENDERERS.size() > 256) {
            GlobalMeshCache.cleanupDeadRenderers();
        }
        return (AbstractGpuVboRenderer)PART_RENDERERS.compute(partKey, (key, existingRef) -> {
            AbstractGpuVboRenderer renderer;
            AbstractGpuVboRenderer abstractGpuVboRenderer = renderer = existingRef != null ? (AbstractGpuVboRenderer)existingRef.get() : null;
            if (renderer == null) {
                renderer = GlobalMeshCache.createRendererForPart(model);
                return new WeakReference<AbstractGpuVboRenderer>(renderer);
            }
            return existingRef;
        }).get();
    }

    public static List<BakedQuad> getOrCompile(String entityType, String partName, BakedModel modelPart) {
        String cacheKey = entityType + ":" + partName;
        return GlobalMeshCache.getOrCompile(cacheKey, modelPart);
    }

    public static VertexBuffer getOrCreateGPUBuffer(String entityType, String partName, BakedModel modelPart) {
        String cacheKey = entityType + ":" + partName;
        return GlobalMeshCache.getOrCreateGPUBuffer(cacheKey, modelPart);
    }

    public static AbstractGpuVboRenderer getOrCreateRenderer(String entityType, String partName, BakedModel model) {
        String partKey = entityType + ":" + partName;
        return GlobalMeshCache.getOrCreateRenderer(partKey, model);
    }

    private static List<BakedQuad> compileMesh(BakedModel modelPart) {
        if (modelPart == null) {
            return Collections.emptyList();
        }
        ArrayList quads = new ArrayList();
        quads.addAll(modelPart.getQuads(null, null, RANDOM_SOURCE, ModelData.EMPTY, null));
        for (Direction direction : Direction.values()) {
            quads.addAll(modelPart.getQuads(null, direction, RANDOM_SOURCE, ModelData.EMPTY, null));
        }
        return Collections.unmodifiableList(quads);
    }

    private static void clearOldestQuads() {
        if (COMPILED_QUADS.isEmpty()) {
            return;
        }
        int toRemove = Math.max(1, COMPILED_QUADS.size() / 4);
        Iterator<String> it = COMPILED_QUADS.keySet().iterator();
        for (int i = 0; i < toRemove && it.hasNext(); ++i) {
            String key = it.next();
            it.remove();
            VertexBuffer vb = GPU_BUFFERS.remove(key);
            if (vb == null) continue;
            vb.close();
        }
    }

    private static void clearOldestBuffers() {
        if (GPU_BUFFERS.isEmpty()) {
            return;
        }
        int toRemove = Math.max(1, GPU_BUFFERS.size() / 4);
        Iterator<Map.Entry<String, VertexBuffer>> it = GPU_BUFFERS.entrySet().iterator();
        for (int i = 0; i < toRemove && it.hasNext(); ++i) {
            Map.Entry<String, VertexBuffer> entry = it.next();
            VertexBuffer vb = entry.getValue();
            if (vb != null) {
                vb.close();
            }
            it.remove();
        }
    }

    private static VertexBuffer uploadToGPU(List<BakedQuad> quads) {
        if (quads.isEmpty()) {
            return null;
        }
        BufferBuilder builder = new BufferBuilder(quads.size() * 32);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        PoseStack.Pose neutralPose = new PoseStack().m_85850_();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        int neutralLight = 0;
        for (BakedQuad quad : quads) {
            builder.putBulkData(neutralPose, quad, r, g, b, a, neutralLight, OverlayTexture.f_118083_, false);
        }
        BufferBuilder.RenderedBuffer renderedBuffer = builder.m_231175_();
        VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vbo.m_85921_();
        vbo.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
        return vbo;
    }

    private static void cleanupDeadRenderers() {
        PART_RENDERERS.entrySet().removeIf(entry -> {
            AbstractGpuVboRenderer renderer = (AbstractGpuVboRenderer)((WeakReference)entry.getValue()).get();
            return renderer == null;
        });
    }

    private static AbstractGpuVboRenderer createRendererForPart(final BakedModel model) {
        return new AbstractGpuVboRenderer(){
            private AbstractGpuVboRenderer.VboData cachedData;

            @Override
            protected AbstractGpuVboRenderer.VboData buildVboData() {
                if (this.cachedData == null) {
                    this.cachedData = ObjModelVboBuilder.buildSinglePart(model);
                }
                return this.cachedData;
            }
        };
    }

    public static void clear() {
        COMPILED_QUADS.clear();
        GPU_BUFFERS.values().forEach(vb -> {
            if (vb != null) {
                vb.close();
            }
        });
        GPU_BUFFERS.clear();
    }

    public static void clearAll() {
        for (WeakReference<AbstractGpuVboRenderer> ref : PART_RENDERERS.values()) {
            AbstractGpuVboRenderer renderer = (AbstractGpuVboRenderer)ref.get();
            if (renderer == null) continue;
            renderer.cleanup();
        }
        PART_RENDERERS.clear();
        GlobalMeshCache.clear();
    }

    public static int getCachedQuadsCount() {
        return COMPILED_QUADS.size();
    }

    public static int getCachedBuffersCount() {
        return GPU_BUFFERS.size();
    }

    public static int getCachedRenderersCount() {
        return PART_RENDERERS.size();
    }

    public static void logCacheStats() {
        System.out.println("GlobalMeshCache stats:");
        System.out.println("  Compiled quads: " + GlobalMeshCache.getCachedQuadsCount());
        System.out.println("  GPU buffers: " + GlobalMeshCache.getCachedBuffersCount());
        System.out.println("  Renderers: " + GlobalMeshCache.getCachedRenderersCount());
    }
}

