/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.client.render.AbstractGpuVboRenderer;
import com.hbm_m.client.render.ModShaders;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL33;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class InstancedStaticPartRenderer
extends AbstractGpuVboRenderer {
    private static final int MAX_INSTANCES = 1024;
    private final List<Matrix4f> nearInstanceTransforms = new ArrayList<Matrix4f>();
    private final List<Integer> nearInstanceLights = new ArrayList<Integer>();
    private final List<Matrix4f> farInstanceTransforms = new ArrayList<Matrix4f>();
    private final List<Integer> farInstanceLights = new ArrayList<Integer>();
    private int instanceVboId = -1;
    private FloatBuffer instanceBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstancedStaticPartRenderer(AbstractGpuVboRenderer.VboData data) {
        if (data == null) {
            MainRegistry.LOGGER.error("InstancedStaticPartRenderer received null VboData!");
            this.initialized = false;
            return;
        }
        int previousVao = GL11.glGetInteger((int)34229);
        int previousArrayBuffer = GL11.glGetInteger((int)34964);
        try {
            this.vaoId = GL30.glGenVertexArrays();
            this.vboId = GL15.glGenBuffers();
            if (this.vaoId == 0 || this.vboId == 0) {
                throw new IllegalStateException("Failed to generate VAO/VBO!");
            }
            this.indexCount = data.indices != null ? data.indices.remaining() : 0;
            GL30.glBindVertexArray((int)this.vaoId);
            GL15.glBindBuffer((int)34962, (int)this.vboId);
            GL15.glBufferData((int)34962, (ByteBuffer)data.byteBuffer, (int)35044);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)32, (long)12L);
            GL20.glEnableVertexAttribArray((int)2);
            GL20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)32, (long)24L);
            if (data.indices != null && data.indices.remaining() > 0) {
                this.eboId = GL15.glGenBuffers();
                if (this.eboId == 0) {
                    throw new IllegalStateException("Failed to generate EBO!");
                }
                GL15.glBindBuffer((int)34963, (int)this.eboId);
                GL15.glBufferData((int)34963, (IntBuffer)data.indices, (int)35044);
            }
            this.instanceVboId = GL15.glGenBuffers();
            if (this.instanceVboId == 0) {
                throw new IllegalStateException("Failed to generate instance VBO!");
            }
            GL15.glBindBuffer((int)34962, (int)this.instanceVboId);
            GL15.glBufferData((int)34962, (long)69632L, (int)35040);
            int stride = 68;
            for (int i = 0; i < 4; ++i) {
                int loc = 3 + i;
                GL20.glEnableVertexAttribArray((int)loc);
                GL20.glVertexAttribPointer((int)loc, (int)4, (int)5126, (boolean)false, (int)stride, (long)((long)i * 16L));
                GL33.glVertexAttribDivisor((int)loc, (int)1);
            }
            GL20.glEnableVertexAttribArray((int)7);
            GL20.glVertexAttribPointer((int)7, (int)1, (int)5126, (boolean)false, (int)stride, (long)64L);
            GL33.glVertexAttribDivisor((int)7, (int)1);
            GL30.glBindVertexArray((int)0);
            this.instanceBuffer = MemoryUtil.memAllocFloat((int)17408);
            MemoryUtil.memFree((Buffer)data.byteBuffer);
            if (data.indices != null) {
                MemoryUtil.memFree((Buffer)data.indices);
            }
            this.initialized = true;
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Failed to initialize InstancedStaticPartRenderer", (Throwable)e);
            if (this.instanceBuffer != null) {
                MemoryUtil.memFree((Buffer)this.instanceBuffer);
                this.instanceBuffer = null;
            }
            if (this.instanceVboId != -1) {
                GL15.glDeleteBuffers((int)this.instanceVboId);
                this.instanceVboId = -1;
            }
            if (this.eboId != -1) {
                GL15.glDeleteBuffers((int)this.eboId);
                this.eboId = -1;
            }
            if (this.vboId != -1) {
                GL15.glDeleteBuffers((int)this.vboId);
                this.vboId = -1;
            }
            if (this.vaoId != -1) {
                GL30.glDeleteVertexArrays((int)this.vaoId);
                this.vaoId = -1;
            }
            this.initialized = false;
        }
        finally {
            GL15.glBindBuffer((int)34962, (int)previousArrayBuffer);
            GL30.glBindVertexArray((int)previousVao);
        }
    }

    public void addInstance(PoseStack poseStack, int packedLight, BlockPos blockPos) {
        this.addInstance(poseStack, packedLight, blockPos, null);
    }

    public void addInstance(PoseStack poseStack, int packedLight, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double dx = (double)blockPos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double dy = (double)blockPos.m_123342_() + 0.5 - cameraPos.f_82480_;
        double dz = (double)blockPos.m_123343_() + 0.5 - cameraPos.f_82481_;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        int thresholdChunks = ModClothConfig.get().modelUpdateDistance;
        double thresholdBlocks = (double)thresholdChunks * 16.0;
        Matrix4f transform = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        if (distance > thresholdBlocks) {
            if (this.farInstanceTransforms.size() >= 1024) {
                this.flushFarBatch();
            }
            this.farInstanceTransforms.add(transform);
            this.farInstanceLights.add(packedLight);
        } else {
            if (this.nearInstanceTransforms.size() >= 1024) {
                this.flushNearBatch();
            }
            this.nearInstanceTransforms.add(transform);
            this.nearInstanceLights.add(packedLight);
        }
    }

    public void flush() {
        this.flushNearBatch();
        this.flushFarBatch();
    }

    private void flushNearBatch() {
        if (this.nearInstanceTransforms.isEmpty() || !this.initialized || this.vaoId == -1 || this.eboId == -1) {
            this.nearInstanceTransforms.clear();
            this.nearInstanceLights.clear();
            return;
        }
        this.flushBatchWithFilter(this.nearInstanceTransforms, this.nearInstanceLights, false);
        this.nearInstanceTransforms.clear();
        this.nearInstanceLights.clear();
    }

    private void flushFarBatch() {
        if (this.farInstanceTransforms.isEmpty() || !this.initialized || this.vaoId == -1 || this.eboId == -1) {
            this.farInstanceTransforms.clear();
            this.farInstanceLights.clear();
            return;
        }
        this.flushBatchWithFilter(this.farInstanceTransforms, this.farInstanceLights, true);
        this.farInstanceTransforms.clear();
        this.farInstanceLights.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBatchWithFilter(List<Matrix4f> transforms, List<Integer> lights, boolean useLinearFilter) {
        ShaderInstance shader = ModShaders.getBlockLitShader();
        if (shader == null) {
            return;
        }
        int previousVao = GL11.glGetInteger((int)34229);
        int previousArrayBuffer = GL11.glGetInteger((int)34964);
        int previousCullFace = GL11.glGetInteger((int)2884);
        try {
            Uniform sampler2;
            Uniform fogColorUniform;
            Uniform fogEndUniform;
            Uniform fogStartUniform;
            Uniform useInstancingUniform;
            this.instanceBuffer.clear();
            for (int i = 0; i < transforms.size(); ++i) {
                Matrix4f mat = transforms.get(i);
                int light = lights.get(i);
                mat.get(this.instanceBuffer);
                this.instanceBuffer.position(this.instanceBuffer.position() + 16);
                float brightness = this.calculateBrightness(light);
                this.instanceBuffer.put(brightness);
            }
            this.instanceBuffer.flip();
            GL30.glBindVertexArray((int)this.vaoId);
            GL15.glBindBuffer((int)34962, (int)this.instanceVboId);
            GL15.glBufferSubData((int)34962, (long)0L, (FloatBuffer)this.instanceBuffer);
            RenderSystem.setShader(() -> shader);
            if (shader.f_173309_ != null) {
                shader.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
            }
            if ((useInstancingUniform = shader.m_173348_("UseInstancing")) != null) {
                useInstancingUniform.m_142617_(1);
            }
            if ((fogStartUniform = shader.m_173348_("FogStart")) != null) {
                fogStartUniform.m_5985_(RenderSystem.getShaderFogStart());
            }
            if ((fogEndUniform = shader.m_173348_("FogEnd")) != null) {
                fogEndUniform.m_5985_(RenderSystem.getShaderFogEnd());
            }
            if ((fogColorUniform = shader.m_173348_("FogColor")) != null) {
                float[] fogColor = RenderSystem.getShaderFogColor();
                fogColorUniform.m_5805_(fogColor[0], fogColor[1], fogColor[2], fogColor[3]);
            }
            shader.m_173363_();
            AbstractGpuVboRenderer.TextureBinder.bindForModelIfNeeded(shader);
            Uniform sampler0 = shader.m_173348_("Sampler0");
            if (sampler0 != null) {
                sampler0.m_142617_(0);
            }
            if ((sampler2 = shader.m_173348_("Sampler2")) != null) {
                sampler2.m_142617_(2);
            }
            GL13.glActiveTexture((int)33984);
            if (useLinearFilter) {
                GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            } else {
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)513);
            RenderSystem.depthMask((boolean)true);
            GL11.glEnable((int)32823);
            GL11.glPolygonOffset((float)1.0f, (float)1.0f);
            GL11.glDisable((int)2884);
            if (this.indexCount > 0) {
                GL31.glDrawElementsInstanced((int)4, (int)this.indexCount, (int)5125, (long)0L, (int)transforms.size());
            }
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error during instanced flush", (Throwable)e);
        }
        finally {
            GL15.glBindBuffer((int)34962, (int)previousArrayBuffer);
            GL30.glBindVertexArray((int)previousVao);
            GL11.glDisable((int)32823);
            GL11.glEnable((int)2884);
            if (previousCullFace == 1) {
                GL11.glEnable((int)2884);
            }
        }
    }

    private float calculateBrightness(int packedLight) {
        int blockLight = LightTexture.m_109883_((int)packedLight);
        int skyLight = LightTexture.m_109894_((int)packedLight);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return Math.max(0.05f, (float)Math.max(blockLight, skyLight) / 15.0f);
        }
        float skyDarken = level.m_104805_(1.0f);
        float skyBrightness = 0.05f + skyDarken * 0.95f;
        float effectiveSkyLight = (float)skyLight * skyBrightness;
        float maxLight = Math.max((float)blockLight, effectiveSkyLight);
        float brightness = 0.05f + maxLight / 15.0f * 0.95f;
        return brightness;
    }

    @Override
    protected AbstractGpuVboRenderer.VboData buildVboData() {
        return null;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.instanceVboId != -1) {
            GL15.glDeleteBuffers((int)this.instanceVboId);
            this.instanceVboId = -1;
        }
        if (this.instanceBuffer != null) {
            MemoryUtil.memFree((Buffer)this.instanceBuffer);
            this.instanceBuffer = null;
        }
    }
}

