/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.client.render.GlobalMeshCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class LegacyAnimator {
    protected final PoseStack poseStack;
    final VertexConsumer buffer;
    private final int packedLight;
    private final int packedOverlay;

    public LegacyAnimator(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        this.poseStack = poseStack;
        this.buffer = buffer;
        this.packedLight = packedLight;
        this.packedOverlay = packedOverlay;
    }

    public static LegacyAnimator create(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        return new LegacyAnimator(poseStack, buffer, packedLight, packedOverlay);
    }

    public void push() {
        this.poseStack.m_85836_();
    }

    public void pop() {
        this.poseStack.m_85849_();
    }

    public void translate(double x, double y, double z) {
        this.poseStack.m_85837_(x, y, z);
    }

    public void rotate(float degrees, float x, float y, float z) {
        if (degrees == 0.0f) {
            return;
        }
        if (x != 0.0f) {
            this.poseStack.m_252781_(Axis.f_252529_.m_252977_(degrees));
        }
        if (y != 0.0f) {
            this.poseStack.m_252781_(Axis.f_252436_.m_252977_(degrees));
        }
        if (z != 0.0f) {
            this.poseStack.m_252781_(Axis.f_252403_.m_252977_(degrees));
        }
    }

    public void setupBlockTransform(Direction facing) {
        this.translate(0.5, 0.0, 0.5);
        this.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        float facingRotation = switch (facing) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
        this.rotate(facingRotation, 0.0f, 1.0f, 0.0f);
    }

    public void renderQuads(List<BakedQuad> quads) {
        if (quads == null || quads.isEmpty()) {
            return;
        }
        PoseStack.Pose pose = this.poseStack.m_85850_();
        for (BakedQuad quad : quads) {
            this.buffer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, this.packedLight, this.packedOverlay, false);
        }
    }

    @Deprecated
    public void renderPart(BakedModel modelPart) {
        if (modelPart == null) {
            return;
        }
        String tempKey = "Temp:" + System.identityHashCode(modelPart);
        List<BakedQuad> quads = GlobalMeshCache.getOrCompile(tempKey, modelPart);
        this.renderQuads(quads);
    }

    public Matrix4f currentMatrix() {
        return new Matrix4f((Matrix4fc)this.poseStack.m_85850_().m_252922_());
    }
}

