/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.block.entity.machine.MachineAdvancedAssemblerBlockEntity;
import com.hbm_m.block.machine.MachineAdvancedAssemblerBlock;
import com.hbm_m.client.model.MachineAdvancedAssemblerBakedModel;
import com.hbm_m.client.render.AbstractGpuVboRenderer;
import com.hbm_m.client.render.AbstractPartBasedRenderer;
import com.hbm_m.client.render.InstancedStaticPartRenderer;
import com.hbm_m.client.render.LegacyAnimator;
import com.hbm_m.client.render.MachineAdvancedAssemblerVboRenderer;
import com.hbm_m.client.render.ObjModelVboBuilder;
import com.hbm_m.client.render.OcclusionCullingHelper;
import com.hbm_m.client.render.shader.ImmediateFallbackRenderer;
import com.hbm_m.client.render.shader.RenderPathManager;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.recipe.AssemblerRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class MachineAdvancedAssemblerRenderer
extends AbstractPartBasedRenderer<MachineAdvancedAssemblerBlockEntity, MachineAdvancedAssemblerBakedModel> {
    private MachineAdvancedAssemblerVboRenderer gpu;
    private MachineAdvancedAssemblerBakedModel cachedModel;
    private static volatile InstancedStaticPartRenderer instancedBase;
    private static volatile InstancedStaticPartRenderer instancedFrame;
    private static volatile boolean instancersInitialized;
    private static final ConcurrentHashMap<String, ImmediateFallbackRenderer> fallbackRenderers;

    public MachineAdvancedAssemblerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    private static synchronized void initializeInstancedRenderersSync(MachineAdvancedAssemblerBakedModel model) {
        if (instancersInitialized) {
            return;
        }
        try {
            BakedModel baseModel = model.getPart("Base");
            InstancedStaticPartRenderer tempBase = null;
            if (baseModel != null) {
                AbstractGpuVboRenderer.VboData baseData = ObjModelVboBuilder.buildSinglePart(baseModel);
                tempBase = new InstancedStaticPartRenderer(baseData);
            }
            BakedModel frameModel = model.getPart("Frame");
            InstancedStaticPartRenderer tempFrame = null;
            if (frameModel != null) {
                AbstractGpuVboRenderer.VboData frameData = ObjModelVboBuilder.buildSinglePart(frameModel);
                tempFrame = new InstancedStaticPartRenderer(frameData);
            }
            instancedBase = tempBase;
            instancedFrame = tempFrame;
            instancersInitialized = true;
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Failed to initialize instanced renderers", (Throwable)e);
            instancedBase = null;
            instancedFrame = null;
        }
    }

    private void initializeInstancedRenderers(MachineAdvancedAssemblerBakedModel model) {
        if (!instancersInitialized) {
            MachineAdvancedAssemblerRenderer.initializeInstancedRenderersSync(model);
        }
    }

    @Override
    protected MachineAdvancedAssemblerBakedModel getModelType(BakedModel rawModel) {
        MachineAdvancedAssemblerBakedModel m;
        return rawModel instanceof MachineAdvancedAssemblerBakedModel ? (m = (MachineAdvancedAssemblerBakedModel)rawModel) : null;
    }

    @Override
    protected Direction getFacing(MachineAdvancedAssemblerBlockEntity be) {
        return (Direction)be.m_58900_().m_61143_((Property)MachineAdvancedAssemblerBlock.FACING);
    }

    @Override
    protected void renderParts(MachineAdvancedAssemblerBlockEntity be, MachineAdvancedAssemblerBakedModel model, LegacyAnimator animator, float partialTick, int packedLight, int packedOverlay, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockPos blockPos = be.m_58899_();
        int blockLight = LightTexture.m_109883_((int)packedLight);
        int skyLight = LightTexture.m_109894_((int)packedLight);
        int dynamicLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        Minecraft minecraft = Minecraft.m_91087_();
        AABB renderBounds = be.getRenderBoundingBox();
        if (!OcclusionCullingHelper.shouldRender(blockPos, (Level)minecraft.f_91073_, renderBounds)) {
            return;
        }
        boolean useFallback = RenderPathManager.shouldUseFallback();
        if (useFallback) {
            this.renderWithFallback(be, model, partialTick, poseStack, dynamicLight);
        } else {
            this.renderWithVBO(be, model, partialTick, poseStack, dynamicLight, blockPos);
        }
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSrc = (MultiBufferSource.BufferSource)bufferSource;
            bufferSrc.m_109911_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderWithFallback(MachineAdvancedAssemblerBlockEntity be, MachineAdvancedAssemblerBakedModel model, float partialTick, PoseStack poseStack, int packedLight) {
        try {
            boolean shouldUpdateAnimation;
            BlockPos blockPos = be.m_58899_();
            this.renderFallbackPart("Base", model.getPart("Base"), poseStack, packedLight, null, blockPos, be.m_58904_(), be);
            if (be.frame) {
                this.renderFallbackPart("Frame", model.getPart("Frame"), poseStack, packedLight, null, blockPos, be.m_58904_(), be);
            }
            boolean bl = shouldUpdateAnimation = !this.shouldSkipAnimationUpdate(be.m_58899_());
            if (shouldUpdateAnimation) {
                this.renderAnimatedFallback(be, model, partialTick, poseStack, packedLight, blockPos);
            }
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error in fallback render", (Throwable)e);
        }
        finally {
            ImmediateFallbackRenderer.endBatch();
        }
    }

    private void renderAnimatedFallback(MachineAdvancedAssemblerBlockEntity be, MachineAdvancedAssemblerBakedModel model, float partialTick, PoseStack poseStack, int packedLight, BlockPos blockPos) {
        float ring = Mth.m_14179_((float)partialTick, (float)be.prevRingAngle, (float)be.ringAngle);
        Matrix4f ringMat = new Matrix4f().rotateY((float)Math.toRadians(ring));
        this.renderFallbackPart("Ring", model.getPart("Ring"), poseStack, packedLight, ringMat, blockPos, be.m_58904_(), be);
        this.renderArmFallback(be.arms[0], false, model, partialTick, poseStack, packedLight, ringMat, blockPos, be);
        this.renderArmFallback(be.arms[1], true, model, partialTick, poseStack, packedLight, ringMat, blockPos, be);
    }

    private void renderFallbackPart(String partName, BakedModel partModel, PoseStack poseStack, int packedLight, @Nullable Matrix4f additionalTransform, BlockPos blockPos, Level level, MachineAdvancedAssemblerBlockEntity blockEntity) {
        if (partModel == null) {
            return;
        }
        try {
            poseStack.m_85836_();
            if (additionalTransform != null) {
                poseStack.m_85850_().m_252922_().mul((Matrix4fc)additionalTransform);
            }
            ImmediateFallbackRenderer renderer = fallbackRenderers.computeIfAbsent(partName, k -> new ImmediateFallbackRenderer(partModel));
            renderer.render(poseStack, packedLight, null, blockPos, level, blockEntity);
            poseStack.m_85849_();
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error rendering fallback part {}: {}", (Object)partName, (Object)e.getMessage());
            fallbackRenderers.remove(partName);
        }
    }

    private void renderArmFallback(MachineAdvancedAssemblerBlockEntity.AssemblerArm arm, boolean inverted, MachineAdvancedAssemblerBakedModel model, float partialTick, PoseStack poseStack, int packedLight, Matrix4f baseTransform, BlockPos blockPos, MachineAdvancedAssemblerBlockEntity blockEntity) {
        float a0 = Mth.m_14179_((float)partialTick, (float)arm.prevAngles[0], (float)arm.angles[0]);
        float a1 = Mth.m_14179_((float)partialTick, (float)arm.prevAngles[1], (float)arm.angles[1]);
        float a2 = Mth.m_14179_((float)partialTick, (float)arm.prevAngles[2], (float)arm.angles[2]);
        float a3 = Mth.m_14179_((float)partialTick, (float)arm.prevAngles[3], (float)arm.angles[3]);
        float angleSign = inverted ? -1.0f : 1.0f;
        float zBase = inverted ? -0.9375f : 0.9375f;
        String lowerName = inverted ? "ArmLower2" : "ArmLower1";
        String upperName = inverted ? "ArmUpper2" : "ArmUpper1";
        String headName = inverted ? "Head2" : "Head1";
        String spikeName = inverted ? "Spike2" : "Spike1";
        Matrix4f lowerMat = new Matrix4f((Matrix4fc)baseTransform).translate(0.0f, 1.625f, zBase).rotateX((float)Math.toRadians(angleSign * a0)).translate(0.0f, -1.625f, -zBase);
        this.renderFallbackPart(lowerName, model.getPart(lowerName), poseStack, packedLight, lowerMat, blockPos, blockEntity.m_58904_(), blockEntity);
        Matrix4f upperMat = new Matrix4f((Matrix4fc)lowerMat).translate(0.0f, 2.375f, zBase).rotateX((float)Math.toRadians(angleSign * a1)).translate(0.0f, -2.375f, -zBase);
        this.renderFallbackPart(upperName, model.getPart(upperName), poseStack, packedLight, upperMat, blockPos, blockEntity.m_58904_(), blockEntity);
        Matrix4f headMat = new Matrix4f((Matrix4fc)upperMat).translate(0.0f, 2.375f, zBase * 0.4667f).rotateX((float)Math.toRadians(angleSign * a2)).translate(0.0f, -2.375f, -zBase * 0.4667f);
        this.renderFallbackPart(headName, model.getPart(headName), poseStack, packedLight, headMat, blockPos, blockEntity.m_58904_(), blockEntity);
        Matrix4f spikeMat = new Matrix4f((Matrix4fc)headMat).translate(0.0f, a3, 0.0f);
        this.renderFallbackPart(spikeName, model.getPart(spikeName), poseStack, packedLight, spikeMat, blockPos, blockEntity.m_58904_(), blockEntity);
    }

    public void render(MachineAdvancedAssemblerBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.m_6922_(be, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderRecipeIconDirect(be, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderWithVBO(MachineAdvancedAssemblerBlockEntity be, MachineAdvancedAssemblerBakedModel model, float partialTick, PoseStack poseStack, int dynamicLight, BlockPos blockPos) {
        boolean shouldUpdateAnimation;
        if (!instancersInitialized) {
            this.initializeInstancedRenderers(model);
        }
        if (this.cachedModel != model || this.gpu == null) {
            this.cachedModel = model;
            this.gpu = new MachineAdvancedAssemblerVboRenderer(model);
        }
        boolean bl = shouldUpdateAnimation = !this.shouldSkipAnimationUpdate(blockPos);
        if (instancedBase != null) {
            instancedBase.addInstance(poseStack, dynamicLight, blockPos, be);
        } else {
            this.gpu.renderStaticBase(poseStack, dynamicLight, blockPos, be);
        }
        if (be.frame) {
            if (instancedFrame != null) {
                instancedFrame.addInstance(poseStack, dynamicLight, blockPos, be);
            } else {
                this.gpu.renderStaticFrame(poseStack, dynamicLight, blockPos, be);
            }
        }
        if (shouldUpdateAnimation) {
            this.renderAnimated(be, partialTick, poseStack, dynamicLight, blockPos);
        }
    }

    private boolean shouldSkipAnimationUpdate(BlockPos blockPos) {
        int thresholdChunks;
        double thresholdBlocks;
        double thresholdSquared;
        double dz;
        double dy;
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double dx = (double)blockPos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double distanceSquared = dx * dx + (dy = (double)blockPos.m_123342_() + 0.5 - cameraPos.f_82480_) * dy + (dz = (double)blockPos.m_123343_() + 0.5 - cameraPos.f_82481_) * dz;
        return distanceSquared > (thresholdSquared = (thresholdBlocks = (double)(thresholdChunks = ModClothConfig.get().modelUpdateDistance) * 16.0) * thresholdBlocks);
    }

    public static void flushInstancedBatches() {
        if (instancedBase != null) {
            instancedBase.flush();
        }
        if (instancedFrame != null) {
            instancedFrame.flush();
        }
    }

    private void renderAnimated(MachineAdvancedAssemblerBlockEntity be, float pt, PoseStack pose, int blockLight, BlockPos blockPos) {
        float ring = Mth.m_14179_((float)pt, (float)be.prevRingAngle, (float)be.ringAngle);
        Matrix4f ringMat = new Matrix4f().rotateY((float)Math.toRadians(ring));
        this.gpu.renderAnimatedPart(pose, blockLight, "Ring", ringMat, blockPos, be);
        this.renderArm(be.arms[0], false, pt, pose, blockLight, ringMat, blockPos, be);
        this.renderArm(be.arms[1], true, pt, pose, blockLight, ringMat, blockPos, be);
    }

    private void renderArm(MachineAdvancedAssemblerBlockEntity.AssemblerArm arm, boolean inverted, float pt, PoseStack pose, int blockLight, Matrix4f baseTransform, BlockPos blockPos, MachineAdvancedAssemblerBlockEntity be) {
        float a0 = Mth.m_14179_((float)pt, (float)arm.prevAngles[0], (float)arm.angles[0]);
        float a1 = Mth.m_14179_((float)pt, (float)arm.prevAngles[1], (float)arm.angles[1]);
        float a2 = Mth.m_14179_((float)pt, (float)arm.prevAngles[2], (float)arm.angles[2]);
        float a3 = Mth.m_14179_((float)pt, (float)arm.prevAngles[3], (float)arm.angles[3]);
        float angleSign = inverted ? -1.0f : 1.0f;
        float zBase = inverted ? -0.9375f : 0.9375f;
        String lowerName = inverted ? "ArmLower2" : "ArmLower1";
        String upperName = inverted ? "ArmUpper2" : "ArmUpper1";
        String headName = inverted ? "Head2" : "Head1";
        String spikeName = inverted ? "Spike2" : "Spike1";
        Matrix4f lowerMat = new Matrix4f((Matrix4fc)baseTransform).translate(0.0f, 1.625f, zBase).rotateX((float)Math.toRadians(angleSign * a0)).translate(0.0f, -1.625f, -zBase);
        this.gpu.renderAnimatedPart(pose, blockLight, lowerName, lowerMat, blockPos, be);
        Matrix4f upperMat = new Matrix4f((Matrix4fc)lowerMat).translate(0.0f, 2.375f, zBase).rotateX((float)Math.toRadians(angleSign * a1)).translate(0.0f, -2.375f, -zBase);
        this.gpu.renderAnimatedPart(pose, blockLight, upperName, upperMat, blockPos, be);
        Matrix4f headMat = new Matrix4f((Matrix4fc)upperMat).translate(0.0f, 2.375f, zBase * 0.4667f).rotateX((float)Math.toRadians(angleSign * a2)).translate(0.0f, -2.375f, -zBase * 0.4667f);
        this.gpu.renderAnimatedPart(pose, blockLight, headName, headMat, blockPos, be);
        Matrix4f spikeMat = new Matrix4f((Matrix4fc)headMat).translate(0.0f, a3, 0.0f);
        this.gpu.renderAnimatedPart(pose, blockLight, spikeName, spikeMat, blockPos, be);
    }

    private void renderRecipeIconDirect(MachineAdvancedAssemblerBlockEntity be, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        AssemblerRecipe recipe;
        ResourceLocation selectedRecipeId = be.getSelectedRecipeId();
        if (selectedRecipeId == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        AssemblerRecipe assemblerRecipe = recipe = be.m_58904_() == null ? null : (AssemblerRecipe)be.m_58904_().m_7465_().m_44043_(selectedRecipeId).filter(r -> r instanceof AssemblerRecipe).map(r -> (AssemblerRecipe)r).orElse(null);
        if (recipe == null) {
            return;
        }
        ItemStack icon = recipe.m_8043_(null);
        if (icon.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_85837_(0.0, 1.0625, 0.0);
        Item item = icon.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            BakedModel blockModel = mc.m_91289_().m_110910_(bi.m_40614_().m_49966_());
            if (blockModel.m_7539_()) {
                poseStack.m_85837_(0.0, -0.0625, 0.0);
            } else {
                poseStack.m_85837_(0.0, -0.125, 0.0);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            }
        } else {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_85837_(-0.5, -0.5, -0.03);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        mc.m_91291_().m_269128_(icon, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, be.m_58904_(), 0);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(MachineAdvancedAssemblerBlockEntity be) {
        return true;
    }

    public int m_142163_() {
        return 128;
    }

    public void onResourceManagerReload() {
        if (instancedBase != null) {
            instancedBase.cleanup();
            instancedBase = null;
        }
        if (instancedFrame != null) {
            instancedFrame.cleanup();
            instancedFrame = null;
        }
        instancersInitialized = false;
        fallbackRenderers.clear();
        MachineAdvancedAssemblerVboRenderer.clearGlobalCache();
        this.gpu = null;
        this.cachedModel = null;
        MainRegistry.LOGGER.debug("Assembler renderer resources reloaded");
    }

    static {
        instancersInitialized = false;
        fallbackRenderers = new ConcurrentHashMap();
    }
}

