/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.client.model.MachineAdvancedAssemblerBakedModel;
import com.hbm_m.client.render.GlobalMeshCache;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class MachineAdvancedAssemblerVboRenderer {
    private static final String BASE = "Base";
    private static final String FRAME = "Frame";
    private final MachineAdvancedAssemblerBakedModel model;

    public MachineAdvancedAssemblerVboRenderer(MachineAdvancedAssemblerBakedModel model) {
        this.model = model;
    }

    public void renderStaticBase(PoseStack poseStack, int packedLight, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        BakedModel part = this.model.getPart(BASE);
        if (part != null) {
            GlobalMeshCache.getOrCreateRenderer("assembler_Base", part).render(poseStack, packedLight, blockPos, blockEntity);
        }
    }

    public void renderStaticFrame(PoseStack poseStack, int packedLight, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        BakedModel part = this.model.getPart(FRAME);
        if (part != null) {
            GlobalMeshCache.getOrCreateRenderer("assembler_Frame", part).render(poseStack, packedLight, blockPos, blockEntity);
        }
    }

    public void renderAnimatedPart(PoseStack poseStack, int packedLight, String partName, Matrix4f transform, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        BakedModel part = this.model.getPart(partName);
        if (part != null) {
            poseStack.m_85836_();
            if (transform != null) {
                poseStack.m_85850_().m_252922_().mul((Matrix4fc)transform);
            }
            GlobalMeshCache.getOrCreateRenderer("assembler_" + partName, part).render(poseStack, packedLight, blockPos, blockEntity);
            poseStack.m_85849_();
        }
    }

    public void renderPart(PoseStack poseStack, int packedLight, String partName, Matrix4f transform, BlockPos blockPos) {
        this.renderAnimatedPart(poseStack, packedLight, partName, transform, blockPos, null);
    }

    public static void clearGlobalCache() {
        GlobalMeshCache.clearAll();
    }
}

