/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.block.entity.machine.MachinePressBlockEntity;
import com.hbm_m.block.machine.MachinePressBlock;
import com.hbm_m.client.model.PressBakedModel;
import com.hbm_m.client.render.AbstractGpuVboRenderer;
import com.hbm_m.client.render.AbstractPartBasedRenderer;
import com.hbm_m.client.render.InstancedStaticPartRenderer;
import com.hbm_m.client.render.LegacyAnimator;
import com.hbm_m.client.render.MachinePressVboRenderer;
import com.hbm_m.client.render.ObjModelVboBuilder;
import com.hbm_m.client.render.OcclusionCullingHelper;
import com.hbm_m.client.render.shader.ImmediateFallbackRenderer;
import com.hbm_m.client.render.shader.RenderPathManager;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class MachinePressRenderer
extends AbstractPartBasedRenderer<MachinePressBlockEntity, PressBakedModel> {
    private static final String BASE_PART = "Base";
    private static final String HEAD_PART = "Head";
    private static final float PIXEL = 0.0625f;
    private static final float HEAD_SCALE = 0.983f;
    private static final float WORKPIECE_HEIGHT = 1.1875f;
    private static final float WORKPIECE_SCALE = 0.55f;
    private static final float STAMP_SCALE = 0.65f;
    private MachinePressVboRenderer gpuRenderer;
    private PressBakedModel cachedModel;
    private static volatile InstancedStaticPartRenderer instancedBase;
    private static volatile boolean instancerInitialized;
    private static final ConcurrentHashMap<String, ImmediateFallbackRenderer> FALLBACK_RENDERERS;

    public MachinePressRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    @Override
    protected PressBakedModel getModelType(BakedModel rawModel) {
        PressBakedModel pressModel;
        return rawModel instanceof PressBakedModel ? (pressModel = (PressBakedModel)rawModel) : null;
    }

    @Override
    protected Direction getFacing(MachinePressBlockEntity blockEntity) {
        return (Direction)blockEntity.m_58900_().m_61143_((Property)MachinePressBlock.FACING);
    }

    @Override
    protected void renderParts(MachinePressBlockEntity blockEntity, PressBakedModel model, LegacyAnimator animator, float partialTick, int packedLight, int packedOverlay, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockPos blockPos = blockEntity.m_58899_();
        AABB bounds = blockEntity.getRenderBoundingBox();
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || !OcclusionCullingHelper.shouldRender(blockPos, (Level)minecraft.f_91073_, bounds)) {
            return;
        }
        int blockLight = LightTexture.m_109883_((int)packedLight);
        int skyLight = LightTexture.m_109894_((int)packedLight);
        int dynamicLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        Matrix4f headTransform = RenderPathManager.shouldUseFallback() ? this.renderWithFallback(blockEntity, model, poseStack, dynamicLight, partialTick, blockPos) : this.renderWithVbo(blockEntity, model, poseStack, dynamicLight, partialTick, blockPos);
        this.renderStampItem(blockEntity, poseStack, bufferSource, dynamicLight, packedOverlay, headTransform);
        this.renderWorkpiece(blockEntity, model, poseStack, bufferSource, dynamicLight, packedOverlay);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSrc = (MultiBufferSource.BufferSource)bufferSource;
            bufferSrc.m_109911_();
        }
    }

    private Matrix4f renderWithVbo(MachinePressBlockEntity blockEntity, PressBakedModel model, PoseStack poseStack, int packedLight, float partialTick, BlockPos blockPos) {
        if (!instancerInitialized) {
            MachinePressRenderer.initializeInstancedBase(model);
        }
        if (this.cachedModel != model || this.gpuRenderer == null) {
            this.cachedModel = model;
            this.gpuRenderer = new MachinePressVboRenderer(model);
        }
        if (instancedBase != null) {
            instancedBase.addInstance(poseStack, packedLight, blockPos, blockEntity);
        } else {
            this.gpuRenderer.renderStaticBase(poseStack, packedLight, blockPos, blockEntity);
        }
        boolean freezeAnimation = this.shouldSkipAnimationUpdate(blockPos);
        Matrix4f headTransform = this.buildHeadTransform(model, blockEntity, partialTick, freezeAnimation);
        this.gpuRenderer.renderAnimatedHead(poseStack, packedLight, headTransform, blockPos, blockEntity);
        return headTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Matrix4f renderWithFallback(MachinePressBlockEntity blockEntity, PressBakedModel model, PoseStack poseStack, int packedLight, float partialTick, BlockPos blockPos) {
        Matrix4f headMatrix = null;
        try {
            this.renderFallbackPart(BASE_PART, model.getPart(BASE_PART), poseStack, packedLight, blockEntity);
            boolean freezeAnimation = this.shouldSkipAnimationUpdate(blockPos);
            headMatrix = this.buildHeadTransform(model, blockEntity, partialTick, freezeAnimation);
            this.renderFallbackPart(HEAD_PART, model.getPart(HEAD_PART), poseStack, packedLight, blockEntity, headMatrix);
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Failed to render press fallback path", (Throwable)e);
        }
        finally {
            ImmediateFallbackRenderer.endBatch();
        }
        return headMatrix;
    }

    private void renderFallbackPart(String partName, BakedModel partModel, PoseStack poseStack, int packedLight, MachinePressBlockEntity blockEntity) {
        this.renderFallbackPart(partName, partModel, poseStack, packedLight, blockEntity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFallbackPart(String partName, BakedModel partModel, PoseStack poseStack, int packedLight, MachinePressBlockEntity blockEntity, Matrix4f additionalTransform) {
        if (partModel == null || blockEntity.m_58904_() == null) {
            return;
        }
        poseStack.m_85836_();
        if (additionalTransform != null) {
            poseStack.m_85850_().m_252922_().mul((Matrix4fc)additionalTransform);
        }
        try {
            ImmediateFallbackRenderer renderer = FALLBACK_RENDERERS.computeIfAbsent(partName, key -> new ImmediateFallbackRenderer(partModel));
            renderer.render(poseStack, packedLight, null, blockEntity.m_58899_(), blockEntity.m_58904_(), blockEntity);
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error rendering press fallback part {}", (Object)partName, (Object)e);
            FALLBACK_RENDERERS.remove(partName);
        }
        finally {
            poseStack.m_85849_();
        }
    }

    private Matrix4f buildHeadTransform(PressBakedModel model, MachinePressBlockEntity blockEntity, float partialTick, boolean freezeAnimation) {
        Vector3f rest = model.getHeadRestOffset();
        float travel = model.getHeadTravelDistance();
        float progress = freezeAnimation ? 0.0f : blockEntity.getPressAnimationProgress(partialTick);
        float effectiveTravel = Math.max(0.0f, travel - 0.0625f);
        float offsetY = rest.y() - progress * effectiveTravel;
        return new Matrix4f().translate(rest.x(), offsetY, rest.z()).scale(0.983f, 0.983f, 0.983f);
    }

    private boolean shouldSkipAnimationUpdate(BlockPos blockPos) {
        int thresholdChunks;
        double thresholdBlocks;
        double thresholdSquared;
        double dz;
        double dy;
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double dx = (double)blockPos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double distanceSquared = dx * dx + (dy = (double)blockPos.m_123342_() + 0.5 - cameraPos.f_82480_) * dy + (dz = (double)blockPos.m_123343_() + 0.5 - cameraPos.f_82481_) * dz;
        return distanceSquared > (thresholdSquared = (thresholdBlocks = (double)(thresholdChunks = ModClothConfig.get().modelUpdateDistance) * 16.0) * thresholdBlocks);
    }

    private void renderWorkpiece(MachinePressBlockEntity blockEntity, PressBakedModel model, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.getMaterialStack();
        if (stack.m_41619_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.32f, 1.1875f, 0.32f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_85836_();
        poseStack.m_85841_(0.55f, 0.55f, 0.55f);
        poseStack.m_252880_(-0.5f, -0.5f, 0.32f);
        mc.m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), (int)blockEntity.m_58899_().m_121878_());
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void renderStampItem(MachinePressBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Matrix4f headTransform) {
        ItemStack stamp = blockEntity.getStampStack();
        if (stamp.m_41619_() || headTransform == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Vector3f headPos = new Vector3f();
        headTransform.getTranslation(headPos);
        poseStack.m_85836_();
        poseStack.m_252880_(0.32f, headPos.y() + 0.98f, 0.32f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_85836_();
        poseStack.m_85841_(0.65f, 0.65f, 0.65f);
        poseStack.m_252880_(-0.5f, -0.5f, 0.0f);
        mc.m_91291_().m_269128_(stamp, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), (int)blockEntity.m_58899_().m_121878_());
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static synchronized void initializeInstancedBase(PressBakedModel model) {
        if (instancerInitialized) {
            return;
        }
        try {
            AbstractGpuVboRenderer.VboData data;
            BakedModel baseModel = model.getPart(BASE_PART);
            if (baseModel != null && (data = ObjModelVboBuilder.buildSinglePart(baseModel)) != null) {
                instancedBase = new InstancedStaticPartRenderer(data);
            }
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Failed to initialize press instanced renderer", (Throwable)e);
            instancedBase = null;
        }
        finally {
            instancerInitialized = true;
        }
    }

    public static void flushInstancedBatches() {
        if (instancedBase != null) {
            instancedBase.flush();
        }
    }

    public static void clearCaches() {
        if (instancedBase != null) {
            instancedBase.cleanup();
            instancedBase = null;
        }
        instancerInitialized = false;
        FALLBACK_RENDERERS.clear();
    }

    static {
        instancerInitialized = false;
        FALLBACK_RENDERERS = new ConcurrentHashMap();
    }
}

