/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.client.render.AbstractGpuVboRenderer;
import com.hbm_m.main.MainRegistry;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class ObjModelVboBuilder {
    public static AbstractGpuVboRenderer.VboData buildSinglePart(BakedModel modelPart) {
        Object raw;
        ArrayList quads = new ArrayList();
        quads.addAll(modelPart.getQuads(null, null, RandomSource.m_216335_((long)42L), ModelData.EMPTY, RenderType.m_110451_()));
        for (Direction direction : Direction.values()) {
            quads.addAll(modelPart.getQuads(null, direction, RandomSource.m_216335_((long)42L), ModelData.EMPTY, RenderType.m_110451_()));
        }
        if (quads.isEmpty()) {
            MainRegistry.LOGGER.warn("No quads found in model part, returning null VboData");
            return null;
        }
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int indexOffset = 0;
        MainRegistry.LOGGER.debug("=== Building VBO for model, quad count: {} ===", (Object)quads.size());
        for (BakedQuad quad : quads) {
            raw = quad.m_111303_();
            for (int i = 0; i < 4; ++i) {
                int base = i * 8;
                float x = Float.intBitsToFloat((int)raw[base + 0]);
                float y = Float.intBitsToFloat((int)raw[base + 1]);
                float z = Float.intBitsToFloat((int)raw[base + 2]);
                float u = Float.intBitsToFloat((int)raw[base + 4]);
                float v = Float.intBitsToFloat((int)raw[base + 5]);
                Object normalPacked = raw[base + 6];
                float nx = (float)((byte)(normalPacked & 0xFF)) / 127.0f;
                float ny = (float)((byte)(normalPacked >> 8 & 0xFF)) / 127.0f;
                float nz = (float)((byte)(normalPacked >> 16 & 0xFF)) / 127.0f;
                float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
                if (len > 0.001f) {
                    nx /= len;
                    ny /= len;
                    nz /= len;
                }
                if (indexOffset == 0 && i == 0) {
                    MainRegistry.LOGGER.debug("VBO layout: pos({},{},{}), norm({},{},{}), uv({},{})", new Object[]{Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), Float.valueOf(nx), Float.valueOf(ny), Float.valueOf(nz), Float.valueOf(u), Float.valueOf(v)});
                }
                vertices.add(Float.valueOf(x));
                vertices.add(Float.valueOf(y));
                vertices.add(Float.valueOf(z));
                vertices.add(Float.valueOf(nx));
                vertices.add(Float.valueOf(ny));
                vertices.add(Float.valueOf(nz));
                vertices.add(Float.valueOf(u));
                vertices.add(Float.valueOf(v));
            }
            indices.add(indexOffset + 0);
            indices.add(indexOffset + 1);
            indices.add(indexOffset + 2);
            indices.add(indexOffset + 2);
            indices.add(indexOffset + 3);
            indices.add(indexOffset + 0);
            indexOffset += 4;
        }
        ByteBuffer vb = null;
        IntBuffer ib = null;
        try {
            vb = MemoryUtil.memAlloc((int)(vertices.size() * 4));
            raw = vertices.iterator();
            while (raw.hasNext()) {
                float f = ((Float)raw.next()).floatValue();
                vb.putFloat(f);
            }
            vb.flip();
            ib = MemoryUtil.memAllocInt((int)indices.size());
            raw = indices.iterator();
            while (raw.hasNext()) {
                int idx = (Integer)raw.next();
                ib.put(idx);
            }
            ib.flip();
            MainRegistry.LOGGER.debug("VBO allocated: {} vertices, {} indices", (Object)(vertices.size() / 8), (Object)indices.size());
            return new AbstractGpuVboRenderer.VboData(vb, ib);
        }
        catch (OutOfMemoryError e) {
            MainRegistry.LOGGER.error("Out of memory while building VBO! Vertices: {}, Indices: {}", new Object[]{vertices.size(), indices.size(), e});
            if (vb != null) {
                MemoryUtil.memFree((Buffer)vb);
            }
            if (ib != null) {
                MemoryUtil.memFree((Buffer)ib);
            }
            throw e;
        }
    }
}

