/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render;

import com.hbm_m.config.ModClothConfig;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class OcclusionCullingHelper {
    private static final ConcurrentHashMap<BlockPos, CachedResult> occlusionCache = new ConcurrentHashMap();
    private static long currentFrame = 0L;
    private static final double NEAR_DISTANCE = 24.0;
    private static final double MID_DISTANCE = 48.0;
    @Nullable
    private static TagKey<Block> transparentBlocksTag = null;

    private OcclusionCullingHelper() {
    }

    public static void setTransparentBlocksTag(TagKey<Block> tag) {
        transparentBlocksTag = tag;
    }

    public static boolean shouldRender(BlockPos pos, Level level, AABB renderBounds) {
        if (level == null || pos == null || renderBounds == null) {
            return false;
        }
        if (!ModClothConfig.get().enableOcclusionCulling) {
            return true;
        }
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        Vec3 center = renderBounds.m_82399_();
        double dx = center.f_82479_ - cameraPos.f_82479_;
        double dy = center.f_82480_ - cameraPos.f_82480_;
        double dz = center.f_82481_ - cameraPos.f_82481_;
        double distanceSq = dx * dx + dy * dy + dz * dz;
        double distance = Math.sqrt(distanceSq);
        CachedResult cached = occlusionCache.get(pos);
        if (cached != null && cached.isValid(currentFrame, distance)) {
            return cached.visible;
        }
        boolean visible = !OcclusionCullingHelper.isOccludedFast(pos, level, renderBounds, cameraPos, distance, distanceSq);
        occlusionCache.put(pos, new CachedResult(visible, currentFrame, distance));
        return visible;
    }

    private static boolean isOccludedFast(BlockPos centerPos, Level level, AABB bounds, Vec3 cameraPos, double distance, double distanceSq) {
        Vec3 corner2;
        Vec3 corner1;
        if (distance < 4.0) {
            return false;
        }
        if (distance > 192.0) {
            return false;
        }
        double nearSq = 576.0;
        double midSq = 2304.0;
        int numPoints = distanceSq < nearSq ? 3 : (distanceSq < midSq ? 2 : 1);
        if (!OcclusionCullingHelper.isPointOccludedFast(cameraPos, bounds.m_82399_(), level, bounds, distance)) {
            return false;
        }
        if (numPoints >= 2 && !OcclusionCullingHelper.isPointOccludedFast(cameraPos, corner1 = new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), level, bounds, distance)) {
            return false;
        }
        return numPoints < 3 || OcclusionCullingHelper.isPointOccludedFast(cameraPos, corner2 = new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), level, bounds, distance);
    }

    private static boolean isPointOccludedFast(Vec3 cameraPos, Vec3 targetPoint, Level level, AABB structureBounds, double distance) {
        double dx = targetPoint.f_82479_ - cameraPos.f_82479_;
        double dy = targetPoint.f_82480_ - cameraPos.f_82480_;
        double dz = targetPoint.f_82481_ - cameraPos.f_82481_;
        double rayDistance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (rayDistance < 2.0) {
            return false;
        }
        dx /= rayDistance;
        dy /= rayDistance;
        dz /= rayDistance;
        double stepSize = distance < 24.0 ? 1.0 : (distance < 48.0 ? 1.5 : 2.0);
        int steps = (int)Math.ceil(rayDistance / stepSize);
        steps = Math.min(steps, 16);
        for (int i = 1; i < steps; ++i) {
            BlockState blockState;
            double t = (double)i / (double)steps * rayDistance;
            BlockPos checkPos = BlockPos.m_274561_((double)(cameraPos.f_82479_ + dx * t), (double)(cameraPos.f_82480_ + dy * t), (double)(cameraPos.f_82481_ + dz * t));
            if (structureBounds.m_82393_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 0.5, (double)checkPos.m_123343_() + 0.5) || (blockState = level.m_8055_(checkPos)).m_60795_() || !OcclusionCullingHelper.isOccludingBlockFast(blockState, level, checkPos)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOccludingBlockFast(BlockState blockState, Level level, BlockPos pos) {
        if (transparentBlocksTag != null && blockState.m_204336_(transparentBlocksTag)) {
            return false;
        }
        return blockState.m_60804_((BlockGetter)level, pos);
    }

    public static void onFrameStart() {
        if (++currentFrame % 60L == 0L) {
            occlusionCache.entrySet().removeIf(entry -> currentFrame - ((CachedResult)entry.getValue()).frame > 20L);
        }
    }

    public static void clearCache() {
        occlusionCache.clear();
    }

    private static class CachedResult {
        final boolean visible;
        final long frame;
        final double distance;

        CachedResult(boolean visible, long frame, double distance) {
            this.visible = visible;
            this.frame = frame;
            this.distance = distance;
        }

        boolean isValid(long currentFrame, double currentDistance) {
            int ttl = this.distance < 24.0 ? 2 : (this.distance < 48.0 ? 5 : 10);
            return currentFrame - this.frame < (long)ttl;
        }
    }
}

