/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render.shader;

import com.hbm_m.client.render.OcclusionCullingHelper;
import com.hbm_m.main.MainRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class ImmediateFallbackRenderer {
    private final BakedModel model;
    private final List<OptimizedQuad> optimizedQuads;
    private final int quadCount;
    private final int modelHash;
    private static final ThreadLocal<Boolean> RENDERING_SHADOWS = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<BatchRenderer> THREAD_BATCH = ThreadLocal.withInitial(BatchRenderer::new);
    private static final ThreadLocal<RandomSource> RANDOM_CACHE = ThreadLocal.withInitial(() -> {
        RandomSource random = RandomSource.m_216327_();
        random.m_188584_(42L);
        return random;
    });
    private static final ConcurrentHashMap<Integer, List<OptimizedQuad>> QUAD_CACHE = new ConcurrentHashMap();

    private static boolean isShadowPass() {
        return ImmediateFallbackRenderer.detectOculusShadowPass() || RENDERING_SHADOWS.get() != false;
    }

    public static void onShaderReload() {
        RENDERING_SHADOWS.set(false);
        ImmediateFallbackRenderer.clearGlobalCache();
        MainRegistry.LOGGER.info("ImmediateFallbackRenderer: Shader reload detected, caches cleared");
    }

    private static boolean detectOculusShadowPass() {
        try {
            Class<?> shadowRendererClass = Class.forName("net.irisshaders.iris.shadows.ShadowRenderer");
            Field activeField = shadowRendererClass.getDeclaredField("ACTIVE");
            activeField.setAccessible(true);
            Boolean isActive = (Boolean)activeField.get(null);
            boolean currentlyActive = isActive != null && isActive != false;
            return currentlyActive;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void updateShadowState() {
        ImmediateFallbackRenderer.detectOculusShadowPass();
    }

    public static void setShadowMode(boolean shadowMode) {
        RENDERING_SHADOWS.set(shadowMode);
    }

    public ImmediateFallbackRenderer(BakedModel model) {
        this.model = model;
        this.modelHash = model != null ? model.hashCode() : 0;
        this.optimizedQuads = model != null ? QUAD_CACHE.computeIfAbsent(this.modelHash, hash -> ImmediateFallbackRenderer.buildOptimizedQuads(model)) : new ArrayList<OptimizedQuad>();
        this.quadCount = this.optimizedQuads.size();
    }

    private static List<OptimizedQuad> buildOptimizedQuads(BakedModel model) {
        ArrayList<OptimizedQuad> quads = new ArrayList<OptimizedQuad>();
        RandomSource random = RANDOM_CACHE.get();
        try {
            random.m_188584_(42L);
            List generalQuads = model.getQuads(null, null, random, ModelData.EMPTY, null);
            for (BakedQuad quad : generalQuads) {
                quads.add(new OptimizedQuad(quad));
            }
            for (Direction direction : Direction.values()) {
                random.m_188584_(42L);
                List directionQuads = model.getQuads(null, direction, random, ModelData.EMPTY, null);
                for (BakedQuad quad : directionQuads) {
                    quads.add(new OptimizedQuad(quad));
                }
            }
            quads.sort((a, b) -> Integer.compare(a.estimatedCost, b.estimatedCost));
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error building optimized quads", (Throwable)e);
        }
        return quads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(PoseStack poseStack, int packedLight, @Nullable Matrix4f additionalTransform, @Nullable BlockPos blockPos, @Nullable Level level, @Nullable BlockEntity blockEntity) {
        if (this.model == null || this.quadCount == 0 || this.optimizedQuads.isEmpty()) {
            return;
        }
        AABB renderBounds = null;
        if (blockPos != null && level != null && blockEntity != null && !OcclusionCullingHelper.shouldRender(blockPos, level, renderBounds = blockEntity.getRenderBoundingBox())) {
            return;
        }
        poseStack.m_85836_();
        try {
            if (additionalTransform != null) {
                poseStack.m_85850_().m_252922_().mul((Matrix4fc)additionalTransform);
            }
            BatchRenderer batchRenderer = THREAD_BATCH.get();
            batchRenderer.addTask(this.optimizedQuads, poseStack.m_85850_(), packedLight, blockPos, renderBounds);
        }
        finally {
            poseStack.m_85849_();
        }
    }

    public void render(PoseStack poseStack, int packedLight) {
        this.render(poseStack, packedLight, null, null, null, null);
    }

    public void render(PoseStack poseStack, int packedLight, @Nullable Matrix4f additionalTransform) {
        this.render(poseStack, packedLight, additionalTransform, null, null, null);
    }

    public static void endBatch() {
        BatchRenderer batchRenderer = THREAD_BATCH.get();
        batchRenderer.flushBatch();
    }

    public static void endFrame() {
        BatchRenderer batchRenderer = THREAD_BATCH.get();
        batchRenderer.flushBatch();
        RENDERING_SHADOWS.set(false);
    }

    public static void forceReset() {
        BatchRenderer batchRenderer = THREAD_BATCH.get();
        batchRenderer.safeResetTesselator();
        batchRenderer.pendingTasks.clear();
        RENDERING_SHADOWS.set(false);
    }

    public static void ensureBatchClosed() {
        ImmediateFallbackRenderer.endBatch();
    }

    public static void clearGlobalCache() {
        QUAD_CACHE.clear();
        ImmediateFallbackRenderer.THREAD_BATCH.get().pendingTasks.clear();
        RENDERING_SHADOWS.set(false);
    }

    private static long getCurrentFrameId() {
        return System.nanoTime() / 16666666L;
    }

    public static boolean beginBatch() {
        return false;
    }

    public static boolean isBatchActive() {
        BatchRenderer batchRenderer = THREAD_BATCH.get();
        return !batchRenderer.pendingTasks.isEmpty();
    }

    public static int getBatchedQuadCount() {
        BatchRenderer batchRenderer = THREAD_BATCH.get();
        return batchRenderer.pendingTasks.stream().mapToInt(task -> task.quads.size()).sum();
    }

    public int getQuadCount() {
        return this.quadCount;
    }

    public int getModelHash() {
        return this.modelHash;
    }

    public static void printCacheStats() {
        BatchRenderer batchRenderer = THREAD_BATCH.get();
        MainRegistry.LOGGER.info("ImmediateFallbackRenderer stats: {} models cached, {} pending tasks, shadow mode: {}", new Object[]{QUAD_CACHE.size(), batchRenderer.pendingTasks.size(), ImmediateFallbackRenderer.isShadowPass()});
    }

    public static void beginShadowPass() {
        ImmediateFallbackRenderer.setShadowMode(true);
        MainRegistry.LOGGER.debug("ImmediateFallbackRenderer: Shadow pass started");
    }

    public static void endShadowPass() {
        ImmediateFallbackRenderer.endBatch();
        ImmediateFallbackRenderer.setShadowMode(false);
        MainRegistry.LOGGER.debug("ImmediateFallbackRenderer: Shadow pass ended");
    }

    public static boolean isShadowPassActive() {
        return ImmediateFallbackRenderer.isShadowPass();
    }

    private static class OptimizedQuad {
        final BakedQuad quad;
        final int[] vertexData;
        final int estimatedCost;

        OptimizedQuad(BakedQuad quad) {
            this.quad = quad;
            this.vertexData = quad.m_111303_();
            this.estimatedCost = this.vertexData.length / 8;
        }
    }

    private static class BatchRenderer {
        private final List<RenderTask> pendingTasks = new ArrayList<RenderTask>(64);

        private BatchRenderer() {
        }

        void addTask(List<OptimizedQuad> quads, PoseStack.Pose pose, int packedLight, BlockPos blockPos, AABB bounds) {
            this.pendingTasks.add(new RenderTask(quads, pose, packedLight, blockPos, bounds));
            if (this.pendingTasks.size() >= 16) {
                this.flushBatch();
            }
        }

        void flushBatch() {
            if (this.pendingTasks.isEmpty()) {
                return;
            }
            try {
                ImmediateFallbackRenderer.updateShadowState();
                if (ImmediateFallbackRenderer.isShadowPass()) {
                    this.setupShadowRenderState();
                } else {
                    this.setupOculusCompatibleRenderState();
                }
                this.renderBatchedTasks();
            }
            catch (Exception e) {
                MainRegistry.LOGGER.warn("Batch render error: {}", (Object)e.getMessage());
                this.safeResetTesselator();
            }
            finally {
                this.restoreRenderState();
                this.pendingTasks.clear();
            }
        }

        private void renderBatchedTasks() {
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            if (buffer.m_85732_()) {
                try {
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                }
                catch (Exception e) {
                    buffer.m_85730_();
                }
            }
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            int totalQuads = 0;
            for (RenderTask task : this.pendingTasks) {
                if (this.shouldSkipTask(task)) continue;
                for (OptimizedQuad quad : task.quads) {
                    buffer.putBulkData(task.pose, quad.quad, 1.0f, 1.0f, 1.0f, 1.0f, task.packedLight, OverlayTexture.f_118083_, true);
                    ++totalQuads;
                }
            }
            if (totalQuads > 0) {
                BufferBuilder.RenderedBuffer builtBuffer = buffer.m_231175_();
                if (builtBuffer.m_231198_().f_85734_() > 0) {
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builtBuffer);
                }
            } else {
                buffer.m_85730_();
            }
        }

        private boolean shouldSkipTask(RenderTask task) {
            return false;
        }

        private void setupShadowRenderState() {
            RenderSystem.setShader(GameRenderer::m_172640_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableCull();
            RenderSystem.activeTexture((int)33984);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }

        private void setupOculusCompatibleRenderState() {
            RenderSystem.setShader(GameRenderer::m_172649_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableCull();
            RenderSystem.activeTexture((int)33984);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }

        private void restoreRenderState() {
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthFunc((int)513);
        }

        private void safeResetTesselator() {
            try {
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                if (buffer.m_85732_()) {
                    buffer.m_85730_();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static class RenderTask {
            final List<OptimizedQuad> quads;
            final PoseStack.Pose pose;
            final int packedLight;

            RenderTask(List<OptimizedQuad> quads, PoseStack.Pose pose, int packedLight, BlockPos blockPos, AABB bounds) {
                this.quads = quads;
                this.pose = pose;
                this.packedLight = packedLight;
            }
        }
    }
}

