/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render.shader;

import com.hbm_m.client.render.GlobalMeshCache;
import com.hbm_m.client.render.shader.ImmediateFallbackRenderer;
import com.hbm_m.client.render.shader.ShaderCompatibilityDetector;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.multiblock.DoorPartAABBRegistry;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderPathManager {
    private static final AtomicReference<RenderPath> currentPath = new AtomicReference<RenderPath>(RenderPath.VBO_OPTIMIZED);
    private static volatile boolean hasNotifiedUser = false;
    private static volatile boolean lastKnownShaderState = false;
    private static volatile long lastCheckTime = 0L;
    private static final long CHECK_INTERVAL_MS = 1000L;
    private static volatile boolean manualOverride = false;
    private static volatile RenderPath manualPath = null;

    public static void updateRenderPath() {
        RenderPath oldPath;
        RenderPath newPath;
        boolean shaderActive;
        lastKnownShaderState = shaderActive = ShaderCompatibilityDetector.isExternalShaderActive();
        lastCheckTime = System.currentTimeMillis();
        if (manualOverride) {
            newPath = manualPath;
            if (shaderActive) {
                manualOverride = false;
                manualPath = null;
                newPath = RenderPath.IMMEDIATE_FALLBACK;
                MainRegistry.LOGGER.info("Shader activated, overriding manual path selection");
            }
        } else {
            RenderPath renderPath = newPath = shaderActive ? RenderPath.IMMEDIATE_FALLBACK : RenderPath.VBO_OPTIMIZED;
        }
        if ((oldPath = currentPath.getAndSet(newPath)) != newPath) {
            RenderPathManager.notifyPathChange(newPath);
            MainRegistry.LOGGER.info("Render path changed: {} -> {}", (Object)oldPath, (Object)newPath);
            RenderPathManager.clearCaches();
            ImmediateFallbackRenderer.onShaderReload();
        }
    }

    public static void checkAndUpdate() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCheckTime < 1000L) {
            return;
        }
        boolean currentShaderState = ShaderCompatibilityDetector.isExternalShaderActive();
        if (currentShaderState != lastKnownShaderState) {
            MainRegistry.LOGGER.info("Shader state changed dynamically: {} -> {}", (Object)lastKnownShaderState, (Object)currentShaderState);
            RenderPathManager.updateRenderPath();
        } else {
            lastCheckTime = currentTime;
        }
    }

    public static RenderPath getCurrentPath() {
        return currentPath.get();
    }

    public static boolean shouldUseFallback() {
        return currentPath.get() == RenderPath.IMMEDIATE_FALLBACK;
    }

    public static void forceSetPath(RenderPath path) {
        RenderPath oldPath = currentPath.getAndSet(path);
        manualOverride = true;
        manualPath = path;
        if (oldPath != path) {
            MainRegistry.LOGGER.warn("Render path forcibly changed: {} -> {}", (Object)oldPath, (Object)path);
            RenderPathManager.clearCaches();
            Minecraft.m_91087_().execute(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7a[HBM] \u00a77Render path: " + String.valueOf((Object)path))), true);
                }
            });
        }
    }

    private static void notifyPathChange(RenderPath newPath) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return;
        }
        minecraft.execute(() -> {
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            String message = newPath == RenderPath.IMMEDIATE_FALLBACK ? "\u00a7e[HBM] \u00a77Shader detected. Switching to compatible renderer..." : "\u00a7a[HBM] \u00a77Shader disabled. Returning to optimized renderer.";
            player.m_5661_((Component)Component.m_237113_((String)message), false);
        });
    }

    private static void clearCaches() {
        try {
            GlobalMeshCache.clearAll();
            DoorPartAABBRegistry.clear();
            MainRegistry.LOGGER.info("Caches cleared after render path change");
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error clearing caches", (Throwable)e);
        }
    }

    public static void reset() {
        currentPath.set(RenderPath.VBO_OPTIMIZED);
        hasNotifiedUser = false;
        lastKnownShaderState = false;
        lastCheckTime = 0L;
        manualOverride = false;
        manualPath = null;
        RenderPathManager.clearCaches();
        MainRegistry.LOGGER.info("RenderPathManager reset to VBO_OPTIMIZED");
    }

    public static boolean isManualOverride() {
        return manualOverride;
    }

    public static void clearManualOverride() {
        manualOverride = false;
        manualPath = null;
        MainRegistry.LOGGER.info("Manual override cleared");
        RenderPathManager.updateRenderPath();
    }

    public static enum RenderPath {
        VBO_OPTIMIZED,
        IMMEDIATE_FALLBACK;

    }
}

