/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.render.shader;

import com.hbm_m.main.MainRegistry;
import java.lang.reflect.Method;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class ShaderCompatibilityDetector {
    public static boolean isExternalShaderActive() {
        return ShaderCompatibilityDetector.checkOculusShader() || ShaderCompatibilityDetector.checkIrisShader();
    }

    private static boolean checkOculusShader() {
        if (!ModList.get().isLoaded("oculus")) {
            return false;
        }
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method getInstanceMethod = irisApiClass.getMethod("getInstance", new Class[0]);
            Object apiInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method isShaderPackInUseMethod = irisApiClass.getMethod("isShaderPackInUse", new Class[0]);
            Boolean inUse = (Boolean)isShaderPackInUseMethod.invoke(apiInstance, new Object[0]);
            if (inUse != null && inUse.booleanValue()) {
                MainRegistry.LOGGER.info("Oculus shader pack detected as active");
                return true;
            }
        }
        catch (Exception e) {
            MainRegistry.LOGGER.debug("Oculus shader detection failed: {}", (Object)e.getMessage());
        }
        return false;
    }

    private static boolean checkIrisShader() {
        if (!ModList.get().isLoaded("iris")) {
            return false;
        }
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method getInstanceMethod = irisApiClass.getMethod("getInstance", new Class[0]);
            Object apiInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method isShaderPackInUseMethod = irisApiClass.getMethod("isShaderPackInUse", new Class[0]);
            Boolean inUse = (Boolean)isShaderPackInUseMethod.invoke(apiInstance, new Object[0]);
            if (inUse != null && inUse.booleanValue()) {
                MainRegistry.LOGGER.info("Iris shader pack detected as active");
                return true;
            }
        }
        catch (Exception e) {
            MainRegistry.LOGGER.debug("Iris shader detection failed: {}", (Object)e.getMessage());
        }
        return false;
    }
}

