/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm_m.block.AnvilTier;
import com.hbm_m.recipe.AnvilRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class AnvilRecipeBuilder
implements RecipeBuilder {
    private final ItemStack inputA;
    private final ItemStack inputB;
    private boolean consumeA = true;
    private boolean consumeB = true;
    private final ItemStack primaryOutput;
    private final List<ItemStack> inventoryInputs = new ArrayList<ItemStack>();
    private final List<OutputEntry> outputs = new ArrayList<OutputEntry>();
    private final AnvilTier tier;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String blueprintPool;
    @Nullable
    private AnvilTier upperTier;
    private AnvilRecipe.OverlayType overlay = AnvilRecipe.OverlayType.NONE;

    private AnvilRecipeBuilder(ItemStack inputA, ItemStack inputB, ItemStack output, AnvilTier tier) {
        this.inputA = inputA;
        this.inputB = inputB;
        this.primaryOutput = output.m_41777_();
        this.outputs.add(new OutputEntry(this.primaryOutput.m_41777_(), 1.0f));
        this.tier = tier;
    }

    public AnvilRecipeBuilder keepInputA() {
        this.consumeA = false;
        return this;
    }

    public AnvilRecipeBuilder keepInputB() {
        this.consumeB = false;
        return this;
    }

    public static AnvilRecipeBuilder anvilRecipe(ItemStack inputA, ItemStack inputB, ItemStack output, AnvilTier tier) {
        return new AnvilRecipeBuilder(inputA, inputB, output, tier);
    }

    public AnvilRecipeBuilder addRequirement(ItemStack stack) {
        return this.addInventoryRequirement(stack);
    }

    public AnvilRecipeBuilder addInventoryRequirement(ItemStack stack) {
        this.inventoryInputs.add(stack.m_41777_());
        return this;
    }

    public AnvilRecipeBuilder withBlueprintPool(String pool) {
        this.blueprintPool = pool;
        return this;
    }

    public AnvilRecipeBuilder withTierUpper(AnvilTier tier) {
        this.upperTier = tier;
        return this;
    }

    public AnvilRecipeBuilder withOverlay(AnvilRecipe.OverlayType overlay) {
        this.overlay = overlay;
        return this;
    }

    public AnvilRecipeBuilder addOutput(ItemStack stack) {
        return this.addOutput(stack, 1.0f);
    }

    public AnvilRecipeBuilder addOutput(ItemStack stack, float chance) {
        this.outputs.add(new OutputEntry(stack.m_41777_(), Mth.m_14036_((float)chance, (float)0.0f, (float)1.0f)));
        return this;
    }

    public AnvilRecipeBuilder clearOutputs() {
        this.outputs.clear();
        return this;
    }

    public AnvilRecipeBuilder unlockedBy(@Nonnull String criterionName, @Nonnull CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public AnvilRecipeBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.primaryOutput.m_41720_();
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull ResourceLocation recipeId) {
        consumer.accept(new Result(recipeId, this));
    }

    private static JsonObject stackToJson(ItemStack stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            obj.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            obj.addProperty("nbt", stack.m_41783_().toString());
        }
        return obj;
    }

    private record OutputEntry(ItemStack stack, float chance) {
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final AnvilRecipeBuilder builder;

        private Result(ResourceLocation id, AnvilRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            if (!this.builder.inputA.m_41619_()) {
                json.add("input_a", (JsonElement)AnvilRecipeBuilder.stackToJson(this.builder.inputA));
            }
            if (!this.builder.inputB.m_41619_()) {
                json.add("input_b", (JsonElement)AnvilRecipeBuilder.stackToJson(this.builder.inputB));
            }
            if (!this.builder.consumeA) {
                json.addProperty("consume_a", Boolean.valueOf(false));
            }
            if (!this.builder.consumeB) {
                json.addProperty("consume_b", Boolean.valueOf(false));
            }
            if (!this.builder.inventoryInputs.isEmpty()) {
                JsonArray array = new JsonArray();
                this.builder.inventoryInputs.forEach(stack -> array.add((JsonElement)AnvilRecipeBuilder.stackToJson(stack)));
                json.add("required_items", (JsonElement)array);
            }
            if (this.builder.outputs.isEmpty()) {
                throw new IllegalStateException("Anvil recipe " + String.valueOf(this.id) + " has no outputs");
            }
            JsonArray outputsArray = new JsonArray();
            this.builder.outputs.forEach(entry -> {
                JsonObject entryJson = AnvilRecipeBuilder.stackToJson(entry.stack());
                if (entry.chance() < 1.0f) {
                    entryJson.addProperty("chance", (Number)Float.valueOf(entry.chance()));
                }
                outputsArray.add((JsonElement)entryJson);
            });
            json.add("outputs", (JsonElement)outputsArray);
            json.addProperty("tier", this.builder.tier.name().toLowerCase(Locale.ROOT));
            if (this.builder.upperTier != null) {
                json.addProperty("tier_upper", this.builder.upperTier.name().toLowerCase(Locale.ROOT));
            }
            if (this.builder.blueprintPool != null) {
                json.addProperty("blueprint_pool", this.builder.blueprintPool);
            }
            if (this.builder.overlay != AnvilRecipe.OverlayType.NONE) {
                json.addProperty("overlay", this.builder.overlay.name().toLowerCase(Locale.ROOT));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return AnvilRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

