/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.hbm_m.block.AnvilTier;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.datagen.AnvilRecipeBuilder;
import com.hbm_m.item.ModIngots;
import com.hbm_m.item.ModItems;
import com.hbm_m.recipe.AnvilRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public final class AnvilRecipeGenerator {
    private AnvilRecipeGenerator() {
    }

    public static void generate(Consumer<FinishedRecipe> writer) {
        AnvilRecipeGenerator.registerTieredRecipes(writer);
    }

    private static void registerTieredRecipes(Consumer<FinishedRecipe> writer) {
        AnvilRecipeGenerator.registerCombineRecipes(writer);
        AnvilRecipeGenerator.registerCraftRecipes(writer);
        AnvilRecipeGenerator.registerDisassemblyRecipes(writer);
    }

    private static void registerCombineRecipes(Consumer<FinishedRecipe> writer) {
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "silicon", AnvilRecipeGenerator.stack(ModItems.CINNABAR.get(), 1), AnvilRecipeGenerator.stack(ModItems.BORAX.get(), 1), AnvilRecipeGenerator.stack(ModItems.BILLET_SILICON.get(), 3), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_steel", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.STEEL).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_STEEL.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_desh", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.DESH).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_DESH.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_ferrouranium", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.FERROURANIUM).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_FERROURANIUM.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_saturnite", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.SATURNITE).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_SATURNITE.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_bismuth_bronze", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.BISMUTH_BRONZE).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_BISMUTH_BRONZE.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_arsenic_bronze", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.ARSENIC_BRONZE).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_ARSENIC_BRONZE.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_schrabidate", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.SCHRABIDATE).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_SCHRABIDATE.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_dineutronium", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.DINEUTRONIUM).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_DNT.get(), 1), AnvilTier.IRON);
        AnvilRecipeGenerator.registerCombineRecipe(writer, "iron", "anvil_osmiridium", AnvilRecipeGenerator.stack(ModBlocks.ANVIL_IRON.get(), 1), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.OSMIRIDIUM).get(), 10), AnvilRecipeGenerator.stack(ModBlocks.ANVIL_OSMIRIDIUM.get(), 1), AnvilTier.IRON);
    }

    private static void registerCraftRecipes(Consumer<FinishedRecipe> writer) {
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "steel", "1coil_copper_torus", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModItems.COIL_COPPER_TORUS), AnvilRecipeGenerator.stack(ModItems.COIL_COPPER, 2));
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "steel", "2coil_gold_torus", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModItems.COIL_GOLD_TORUS), AnvilRecipeGenerator.stack(ModItems.COIL_GOLD, 2));
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "steel", "3coil_alloy_torus", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModItems.COIL_ADVANCED_ALLOY_TORUS), AnvilRecipeGenerator.stack(ModItems.COIL_ADVANCED_ALLOY, 2));
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "steel", "4coil_tungsten_torus", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModItems.COIL_MAGNETIZED_TUNGSTEN_TORUS), AnvilRecipeGenerator.stack(ModItems.COIL_MAGNETIZED_TUNGSTEN, 2));
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "steel", "5silicon", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModItems.SILICON_CIRCUIT), AnvilRecipeGenerator.stack(ModItems.BILLET_SILICON, 1));
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "steel", "6motor", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModItems.MOTOR), AnvilRecipeGenerator.stack(ModItems.COIL_COPPER, 1), AnvilRecipeGenerator.stack(ModItems.PLATE_IRON, 2), AnvilRecipeGenerator.stack(ModItems.COIL_COPPER_TORUS, 1));
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "iron", "7blast_furnace", AnvilTier.IRON, AnvilRecipeGenerator.stack(ModBlocks.BLAST_FURNACE), AnvilRecipeGenerator.stack(ModItems.PLATE_COPPER, 4), AnvilRecipeGenerator.stack(Items.f_42018_, 4), AnvilRecipeGenerator.stack(ModItems.FIREBRICK, 4));
        AnvilRecipeGenerator.registerInventoryRecipe(writer, "steel", "8advanced_assemble_machine", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.ADVANCED_ASSEMBLY_MACHINE), AnvilRecipeGenerator.stack(ModItems.PLATE_COPPER, 4), AnvilRecipeGenerator.stack(ModItems.getIngot(ModIngots.STEEL).get(), 8), AnvilRecipeGenerator.stack(ModItems.MOTOR, 2), AnvilRecipeGenerator.stack(ModItems.VACUUM_TUBE, 4));
    }

    private static void registerDisassemblyRecipes(Consumer<FinishedRecipe> writer) {
        AnvilRecipeGenerator.registerDisassemblyRecipe(writer, "steel", "crt_breakdown1", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.CRT_BROKEN), AnvilRecipeGenerator.stack(ModItems.PLATE_STEEL, 4), builder -> builder.addOutput(AnvilRecipeGenerator.stack(ModItems.PLATE_LEAD), 1.0f).addOutput(AnvilRecipeGenerator.stack(ModItems.CAPACITOR_BOARD), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.PCB), 1.0f).addOutput(AnvilRecipeGenerator.stack(ModItems.ANALOG_CIRCUIT), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.CAPACITOR_BOARD), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.MICROCHIP), 0.5f));
        AnvilRecipeGenerator.registerDisassemblyRecipe(writer, "steel", "crt_breakdown2", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.CRT_BSOD), AnvilRecipeGenerator.stack(ModItems.PLATE_STEEL, 4), builder -> builder.addOutput(AnvilRecipeGenerator.stack(ModItems.PLATE_LEAD), 1.0f).addOutput(AnvilRecipeGenerator.stack(ModItems.CAPACITOR_BOARD), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.PCB), 1.0f).addOutput(AnvilRecipeGenerator.stack(ModItems.ANALOG_CIRCUIT), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.CAPACITOR_BOARD), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.MICROCHIP), 0.5f));
        AnvilRecipeGenerator.registerDisassemblyRecipe(writer, "steel", "crt_breakdown3", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.CRT_CLEAN), AnvilRecipeGenerator.stack(ModItems.PLATE_STEEL, 4), builder -> builder.addOutput(AnvilRecipeGenerator.stack(ModItems.PLATE_LEAD), 1.0f).addOutput(AnvilRecipeGenerator.stack(ModItems.CAPACITOR_BOARD), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.PCB), 1.0f).addOutput(AnvilRecipeGenerator.stack(ModItems.ANALOG_CIRCUIT), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.CAPACITOR_BOARD), 0.4f).addOutput(AnvilRecipeGenerator.stack(ModItems.MICROCHIP), 0.5f));
        AnvilRecipeGenerator.registerDisassemblyRecipe(writer, "steel", "tape_breakdown", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.TAPE_RECORDER), AnvilRecipeGenerator.stack(ModItems.PLATE_STEEL, 4), builder -> builder.addOutput(AnvilRecipeGenerator.stack(ModItems.PLATE_LEAD), 1.0f).addOutput(AnvilRecipeGenerator.stack(ModItems.WIRE_RED_COPPER), 0.5f).addOutput(AnvilRecipeGenerator.stack(ModItems.VACUUM_TUBE), 0.5f).addOutput(AnvilRecipeGenerator.stack(ModItems.MICROCHIP), 0.1f));
        AnvilRecipeGenerator.registerDisassemblyRecipe(writer, "steel", "cabinet_breakdown", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.FILE_CABINET), AnvilRecipeGenerator.stack(ModItems.PLATE_STEEL, 4), builder -> builder.addOutput(AnvilRecipeGenerator.stack(ModItems.DUST), 1.0f));
        AnvilRecipeGenerator.registerDisassemblyRecipe(writer, "steel", "toaster_breakdown", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.TOASTER), AnvilRecipeGenerator.stack(ModItems.PLATE_STEEL, 2), builder -> builder.addOutput(AnvilRecipeGenerator.stack(ModItems.MAN_CORE), 0.001f));
        AnvilRecipeGenerator.registerDisassemblyRecipe(writer, "steel", "freaky_breakdown", AnvilTier.STEEL, AnvilRecipeGenerator.stack(ModBlocks.FREAKY_ALIEN_BLOCK), AnvilRecipeGenerator.stack(ModItems.CANNED_JIZZ, 1), builder -> builder.addOutput(AnvilRecipeGenerator.stack(ModItems.CANNED_ASBESTOS), 0.5f));
    }

    private static void registerCombineRecipe(Consumer<FinishedRecipe> writer, String tierFolder, String name, ItemStack inputA, ItemStack inputB, ItemStack output, AnvilTier tier) {
        AnvilRecipeGenerator.registerCombineRecipe(writer, tierFolder, name, inputA, inputB, output, tier, builder -> {});
    }

    private static void registerCombineRecipe(Consumer<FinishedRecipe> writer, String tierFolder, String name, ItemStack inputA, ItemStack inputB, ItemStack output, AnvilTier tier, Consumer<AnvilRecipeBuilder> settings) {
        AnvilRecipeBuilder builder = AnvilRecipeBuilder.anvilRecipe(inputA, inputB, output, tier).withOverlay(AnvilRecipe.OverlayType.SMITHING);
        settings.accept(builder);
        builder.m_126140_(writer, AnvilRecipeGenerator.anvilId(tierFolder, "combine", name));
    }

    private static void registerInventoryRecipe(Consumer<FinishedRecipe> writer, String tierFolder, String name, AnvilTier tier, ItemStack output, ItemStack ... requirements) {
        AnvilRecipeBuilder builder = AnvilRecipeBuilder.anvilRecipe(ItemStack.f_41583_, ItemStack.f_41583_, output, tier).withOverlay(AnvilRecipe.OverlayType.CONSTRUCTION);
        for (ItemStack stack : requirements) {
            builder.addInventoryRequirement(stack);
        }
        builder.m_126140_(writer, AnvilRecipeGenerator.anvilId(tierFolder, "craft", name));
    }

    private static void registerDisassemblyRecipe(Consumer<FinishedRecipe> writer, String tierFolder, String name, AnvilTier tier, ItemStack dismantled, ItemStack primaryOutput, Consumer<AnvilRecipeBuilder> outputs) {
        AnvilRecipeBuilder builder = AnvilRecipeBuilder.anvilRecipe(ItemStack.f_41583_, ItemStack.f_41583_, primaryOutput, tier).withOverlay(AnvilRecipe.OverlayType.RECYCLING).addInventoryRequirement(dismantled).clearOutputs().addOutput(primaryOutput, 1.0f);
        outputs.accept(builder);
        builder.m_126140_(writer, AnvilRecipeGenerator.anvilId(tierFolder, "disassemble", name));
    }

    private static ResourceLocation anvilId(String tierFolder, String category, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)("anvil/" + tierFolder + "/" + category + "_" + name));
    }

    private static ItemStack stack(Object obj, int count) {
        if (obj instanceof RegistryObject) {
            Object val = ((RegistryObject)obj).get();
            if (val instanceof Item) {
                return new ItemStack((ItemLike)((Item)val), count);
            }
            if (val instanceof Block) {
                return new ItemStack((ItemLike)((Block)val).m_5456_(), count);
            }
        } else {
            if (obj instanceof Item) {
                return new ItemStack((ItemLike)((Item)obj), count);
            }
            if (obj instanceof Block) {
                return new ItemStack((ItemLike)((Block)obj).m_5456_(), count);
            }
        }
        throw new IllegalArgumentException("Unsupported object for stack: " + String.valueOf(obj));
    }

    private static ItemStack stack(Object obj) {
        return AnvilRecipeGenerator.stack(obj, 1);
    }
}

