/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.datagen.AssemblerRecipeBuilder;
import com.hbm_m.item.ModIngots;
import com.hbm_m.item.ModItems;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class AssemblerRecipeGenerator {
    private AssemblerRecipeGenerator() {
    }

    public static void generate(Consumer<FinishedRecipe> writer) {
        AssemblerRecipeGenerator.registerMainRecipes(writer);
        AssemblerRecipeGenerator.registerElectronics(writer);
        AssemblerRecipeGenerator.registerPlateRecipes(writer);
    }

    private static void registerMainRecipes(Consumer<FinishedRecipe> writer) {
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModBlocks.SHREDDER.get(), 1), 80, 150).addIngredient((Item)ModItems.MOTOR.get(), 2).addIngredient((Item)ModItems.PLATE_STEEL.get(), 8).addIngredient((Item)ModItems.PLATE_COPPER.get(), 4).m_176500_(writer, "shredder");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.MAN_CORE.get(), 1), 160, 250).addIngredient((Item)ModItems.BILLET_PLUTONIUM.get(), 16).addIngredient((Item)ModItems.getIngot(ModIngots.BERYLLIUM).get(), 4).m_176500_(writer, "man_core");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.GRENADE_NUC.get(), 3), 160, 250).addIngredient((Item)ModItems.BILLET_PLUTONIUM.get(), 1).addIngredient((Item)ModItems.WIRE_RED_COPPER.get(), 6).addIngredient((Item)ModItems.PLATE_STEEL.get(), 3).addIngredient((Item)ModItems.PLATE_TITANIUM.get(), 3).m_176500_(writer, "grenade_nuc");
    }

    private static void registerElectronics(Consumer<FinishedRecipe> writer) {
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.ANALOG_CIRCUIT.get(), 1), 80, 150).addIngredient((Item)ModItems.CAPACITOR.get(), 2).addIngredient((Item)ModItems.VACUUM_TUBE.get(), 3).addIngredient((Item)ModItems.WIRE_CARBON.get(), 4).addIngredient((Item)ModItems.PCB.get(), 4).m_176500_(writer, "analog_circuit");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.INTEGRATED_CIRCUIT.get(), 1), 80, 150).addIngredient((Item)ModItems.WIRE_CARBON.get(), 4).addIngredient((Item)ModItems.CAPACITOR.get(), 2).addIngredient((Item)ModItems.MICROCHIP.get(), 4).addIngredient((Item)ModItems.PCB.get(), 4).m_176500_(writer, "integrated_circuit");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.CAPACITOR_BOARD.get(), 1), 80, 150).addIngredient((Item)ModItems.CAPACITOR.get(), 3).addIngredient((Item)ModItems.WIRE_CARBON.get(), 3).addIngredient((Item)ModItems.PCB.get(), 1).m_176500_(writer, "capacitor_board");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.ADVANCED_CIRCUIT.get(), 1), 120, 250).addIngredient((Item)ModItems.WIRE_CARBON.get(), 8).addIngredient((Item)ModItems.CAPACITOR.get(), 4).addIngredient((Item)ModItems.MICROCHIP.get(), 32).addIngredient((Item)ModItems.PCB.get(), 8).m_176500_(writer, "advanced_circuit");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.CONTROLLER.get(), 1), 120, 250).addIngredient((Item)ModItems.WIRE_CARBON.get(), 16).addIngredient((Item)ModItems.CAPACITOR.get(), 64).addIngredient((Item)ModItems.MICROCHIP.get(), 32).addIngredient((Item)ModItems.CONTROLLER_CHASSIS.get(), 1).addIngredient((Item)ModItems.ADVANCED_CIRCUIT.get(), 1).addIngredient((Item)ModItems.PCB.get(), 16).m_176500_(writer, "controller");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModBlocks.MACHINE_BATTERY.get(), 1), 80, 150).addIngredient((Item)ModItems.PLATE_STEEL.get(), 12).addIngredient((Item)ModItems.SULFUR.get(), 12).addIngredient((Item)ModItems.getPowder(ModIngots.LEAD).get(), 12).m_176500_(writer, "battery");
    }

    private static void registerPlateRecipes(Consumer<FinishedRecipe> writer) {
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_IRON.get(), 2), 60, 100).addIngredient(Items.f_42416_, 3).withBlueprintPool("plates").m_176500_(writer, "plate_iron_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_GOLD.get(), 2), 60, 100).addIngredient(Items.f_42417_, 3).withBlueprintPool("plates").m_176500_(writer, "plate_gold_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_STEEL.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.STEEL).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_steel_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_SATURNITE.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.SATURNITE).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_saturnite_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_SCHRABIDIUM.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.SCHRABIDIUM).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_schrabidium_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_TITANIUM.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.TITANIUM).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_titanium_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_GUNMETAL.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.GUNMETAL).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_gunmetal_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_GUNSTEEL.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.GUNSTEEL).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_gunsteel_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_LEAD.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.LEAD).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_lead_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_COPPER.get(), 2), 60, 100).addIngredient(Items.f_151052_, 3).withBlueprintPool("plates").m_176500_(writer, "plate_copper_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_ADVANCED_ALLOY.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.ADVANCED_ALLOY).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_advanced_alloy_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_ALUMINUM.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.ALUMINUM).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_aluminum_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_BISMUTH.get(), 2), 60, 100).addIngredient((Item)ModItems.getIngot(ModIngots.BISMUTH).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_bismuth_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_COMBINE_STEEL.get(), 2), 80, 150).addIngredient((Item)ModItems.getIngot(ModIngots.COMBINE_STEEL).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_combine_steel_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_DURA_STEEL.get(), 2), 80, 150).addIngredient((Item)ModItems.getIngot(ModIngots.DURA_STEEL).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_dura_steel_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_DALEKANIUM.get(), 2), 100, 200).addIngredient((Item)ModItems.getIngot(ModIngots.DIGAMMA).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_dalekanium_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_DESH.get(), 2), 100, 200).addIngredient((Item)ModItems.getIngot(ModIngots.DESH).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_desh_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_DINEUTRONIUM.get(), 1), 200, 500).addIngredient((Item)ModItems.getIngot(ModIngots.DINEUTRONIUM).get(), 2).withBlueprintPool("plates").m_176500_(writer, "plate_dineutronium_from_ingots");
        AssemblerRecipeBuilder.assemblerRecipe(new ItemStack((ItemLike)ModItems.PLATE_EUPHEMIUM.get(), 2), 120, 250).addIngredient((Item)ModItems.getIngot(ModIngots.EUPHEMIUM).get(), 3).withBlueprintPool("plates").m_176500_(writer, "plate_euphemium_from_ingots");
    }
}

