/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm_m.recipe.BlastFurnaceRecipe;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceRecipeBuilder
implements RecipeBuilder {
    private final Ingredient inputA;
    private final Ingredient inputB;
    private final ItemStack output;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    private BlastFurnaceRecipeBuilder(ItemStack output, Ingredient inputA, Ingredient inputB) {
        this.inputA = inputA;
        this.inputB = inputB;
        this.output = output;
    }

    public static BlastFurnaceRecipeBuilder blastFurnaceRecipe(ItemStack output, Ingredient inputA, Ingredient inputB) {
        return new BlastFurnaceRecipeBuilder(output, inputA, inputB);
    }

    public static BlastFurnaceRecipeBuilder blastFurnaceRecipe(ItemStack output, ItemLike inputA, ItemLike inputB) {
        return BlastFurnaceRecipeBuilder.blastFurnaceRecipe(output, Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputB}));
    }

    public RecipeBuilder m_126132_(@Nonnull String criterionName, @Nonnull CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(criterionName, trigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.output.m_41720_();
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull ResourceLocation recipeId) {
        consumer.accept(new Result(recipeId, this));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final BlastFurnaceRecipeBuilder builder;

        private Result(ResourceLocation id, BlastFurnaceRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            JsonArray ingredients = new JsonArray();
            ingredients.add(this.builder.inputA.m_43942_());
            ingredients.add(this.builder.inputB.m_43942_());
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject outputObject = new JsonObject();
            outputObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.builder.output.m_41720_()).toString());
            if (this.builder.output.m_41613_() > 1) {
                outputObject.addProperty("count", (Number)this.builder.output.m_41613_());
            }
            json.add("output", (JsonElement)outputObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return BlastFurnaceRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

