/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.damagesource.ModDamageTypes;
import com.hbm_m.datagen.ModBlockStateProvider;
import com.hbm_m.datagen.ModBlockTagProvider;
import com.hbm_m.datagen.ModDamageTypeTagProvider;
import com.hbm_m.datagen.ModItemModelProvider;
import com.hbm_m.datagen.ModItemTagProvider;
import com.hbm_m.datagen.ModLanguageProvider;
import com.hbm_m.datagen.ModLootTableProvider;
import com.hbm_m.datagen.ModRecipeProvider;
import com.hbm_m.worldgen.ModWorldGen;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="hbm_m", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModBlockTagProvider blockTagProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), existingFileHelper));
        DatapackBuiltinEntriesProvider datapackProvider = new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, DataGenerators.getRegistrySetBuilder(), Set.of("hbm_m"));
        CompletableFuture newLookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagProvider(packOutput, newLookupProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "ru_ru"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "en_us"));
    }

    public static RegistrySetBuilder getRegistrySetBuilder() {
        return new RegistrySetBuilder().m_254916_(Registries.f_268580_, context -> {
            for (Field field : ModDamageTypes.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ResourceKey.class)) continue;
                try {
                    ResourceKey key = (ResourceKey)field.get(null);
                    context.m_255272_(key, (Object)new DamageType(key.m_135782_().m_135815_(), 0.1f));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Could not access DamageType key field: " + field.getName(), e);
                }
            }
        }).m_254916_(Registries.f_256911_, context -> {
            TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.f_144266_);
            List<OreConfiguration.TargetBlockState> targets = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.URANIUM_ORE.get()).m_49966_()));
            context.m_255272_(ModWorldGen.URANIUM_ORE_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(targets, 1)));
        }).m_254916_(Registries.f_256988_, context -> {
            HolderGetter configuredFeature = context.m_255420_(Registries.f_256911_);
            context.m_255272_(ModWorldGen.URANIUM_ORE_PLACED_KEY, (Object)new PlacedFeature((Holder)configuredFeature.m_255043_(ModWorldGen.URANIUM_ORE_CONFIGURED_KEY), DataGenerators.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)1), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-60), (VerticalAnchor)VerticalAnchor.m_158922_((int)-62)))));
        }).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"add_uranium_ore")), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(ModWorldGen.URANIUM_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES)));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }
}

