/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.item.ModIngots;
import com.hbm_m.item.ModItems;
import com.hbm_m.item.ModPowders;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "hbm_m", existingFileHelper);
    }

    protected void registerModels() {
        for (ModIngots modIngots : ModIngots.values()) {
            RegistryObject<Item> ingotObject = ModItems.getIngot(modIngots);
            if (ingotObject == null || !ingotObject.isPresent()) continue;
            this.ingotItem(ingotObject);
        }
        for (Enum enum_ : ModPowders.values()) {
            RegistryObject<Item> powderObject = ModItems.getPowders((ModPowders)enum_);
            if (powderObject == null || !powderObject.isPresent()) continue;
            this.powdersItem(powderObject);
        }
        for (Enum enum_ : ModIngots.values()) {
            RegistryObject<Item> powder = ModItems.getPowder((ModIngots)enum_);
            if (powder != null && powder.isPresent() && this.powderTextureExists(((ModIngots)enum_).getName())) {
                this.powdersItem(powder);
            }
            ModItems.getTinyPowder((ModIngots)enum_).ifPresent(arg_0 -> this.lambda$registerModels$0((ModIngots)enum_, arg_0));
        }
        if (ModItems.DUST != null && ModItems.DUST.isPresent()) {
            this.powderTexture(ModItems.DUST, "powders/dust");
        }
        if (ModItems.DUST_TINY != null && ModItems.DUST_TINY.isPresent()) {
            this.powderTexture(ModItems.DUST_TINY, "powders/tiny/dust_tiny");
        }
        this.withExistingParent("large_vehicle_door", this.modLoc("block/large_vehicle_door"));
        this.withExistingParent("round_airlock_door", this.modLoc("block/round_airlock_door"));
        this.withExistingParent("transition_seal", this.modLoc("block/transition_seal"));
        this.withExistingParent("silo_hatch", this.modLoc("block/silo_hatch"));
        this.withExistingParent("silo_hatch_large", this.modLoc("block/silo_hatch_large"));
        this.withExistingParent("qe_containment_door", this.modLoc("block/qe_containment_door"));
        this.withExistingParent("water_door", this.modLoc("block/water_door"));
        this.withExistingParent("fire_door", this.modLoc("block/fire_door"));
        this.withExistingParent("sliding_blast_door", this.modLoc("block/sliding_blast_door"));
        this.withExistingParent("sliding_seal_door", this.modLoc("block/sliding_seal_door"));
        this.withExistingParent("secure_access_door", this.modLoc("block/secure_access_door"));
        this.withExistingParent("qe_sliding_door", this.modLoc("block/qe_sliding_door"));
        ((ItemModelBuilder)this.withExistingParent(ModBlocks.METAL_DOOR.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + ModBlocks.METAL_DOOR.getId().m_135815_()));
        ((ItemModelBuilder)this.withExistingParent(ModBlocks.DOOR_BUNKER.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + ModBlocks.DOOR_BUNKER.getId().m_135815_()));
        ((ItemModelBuilder)this.withExistingParent(ModBlocks.DOOR_OFFICE.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + ModBlocks.DOOR_OFFICE.getId().m_135815_()));
        this.simpleItem(ModItems.BILLET_PLUTONIUM);
        this.simpleItem(ModItems.BALL_TNT);
        this.simpleItem(ModItems.DEFUSER);
        this.simpleItem(ModItems.SCREWDRIVER);
        this.simpleItem(ModItems.CROWBAR);
        this.simpleItem(ModItems.OIL_DETECTOR);
        this.simpleItem(ModItems.MULTI_DETONATOR);
        this.simpleItem(ModItems.DETONATOR);
        this.simpleItem(ModItems.SCRAP);
        this.simpleItem(ModItems.CRT_DISPLAY);
        this.simpleItem(ModItems.MAN_CORE);
        this.simpleItem(ModItems.BLADE_STEEL);
        this.simpleItem(ModItems.BLADE_TITANIUM);
        this.simpleItem(ModItems.BLADE_ALLOY);
        this.simpleItem(ModItems.BLADE_TEST);
        this.simpleItem(ModItems.ALLOY_SWORD);
        this.simpleItem(ModItems.GEIGER_COUNTER);
        this.simpleItem(ModItems.DOSIMETER);
        this.simpleItem(ModItems.HEART_PIECE);
        this.simpleItem(ModItems.HEART_CONTAINER);
        this.simpleItem(ModItems.HEART_BOOSTER);
        this.simpleItem(ModItems.HEART_FAB);
        this.simpleItem(ModItems.BLACK_DIAMOND);
        this.simpleItem(ModItems.GHIORSIUM_CLADDING);
        this.simpleItem(ModItems.DESH_CLADDING);
        this.simpleItem(ModItems.LEAD_CLADDING);
        this.simpleItem(ModItems.RUBBER_CLADDING);
        this.simpleItem(ModItems.PAINT_CLADDING);
        this.simpleItem(ModItems.RADAWAY);
        this.simpleItem(ModItems.CREATIVE_BATTERY);
        this.simpleItem(ModItems.TEMPLATE_FOLDER);
        this.simpleItem(ModItems.STRAWBERRY);
        this.simpleItem(ModItems.LIMESTONE);
        this.simpleItem(ModItems.MALACHITE_CHUNK);
        this.simpleItem(ModItems.CANNED_ASBESTOS);
        this.simpleItem(ModItems.CANNED_ASS);
        this.simpleItem(ModItems.CANNED_BARK);
        this.simpleItem(ModItems.CANNED_BEEF);
        this.simpleItem(ModItems.CANNED_BHOLE);
        this.simpleItem(ModItems.CANNED_CHEESE);
        this.simpleItem(ModItems.CANNED_CHINESE);
        this.simpleItem(ModItems.CANNED_DIESEL);
        this.simpleItem(ModItems.CANNED_FIST);
        this.simpleItem(ModItems.CANNED_FRIED);
        this.simpleItem(ModItems.CANNED_HOTDOGS);
        this.simpleItem(ModItems.CANNED_JIZZ);
        this.simpleItem(ModItems.CANNED_KEROSENE);
        this.simpleItem(ModItems.CANNED_LEFTOVERS);
        this.simpleItem(ModItems.CANNED_MILK);
        this.simpleItem(ModItems.CANNED_MYSTERY);
        this.simpleItem(ModItems.CANNED_NAPALM);
        this.simpleItem(ModItems.CANNED_OIL);
        this.simpleItem(ModItems.CANNED_PASHTET);
        this.simpleItem(ModItems.CANNED_PIZZA);
        this.simpleItem(ModItems.CANNED_RECURSION);
        this.simpleItem(ModItems.CANNED_SPAM);
        this.simpleItem(ModItems.CANNED_STEW);
        this.simpleItem(ModItems.CANNED_TOMATO);
        this.simpleItem(ModItems.CANNED_TUNA);
        this.simpleItem(ModItems.CANNED_TUBE);
        this.simpleItem(ModItems.CANNED_YOGURT);
        this.simpleItem(ModItems.BOLT_STEEL);
        this.simpleItem(ModItems.CAN_BEPIS);
        this.simpleItem(ModItems.CAN_BREEN);
        this.simpleItem(ModItems.CAN_CREATURE);
        this.simpleItem(ModItems.CAN_EMPTY);
        this.simpleItem(ModItems.CAN_KEY);
        this.simpleItem(ModItems.CAN_LUNA);
        this.simpleItem(ModItems.CAN_MRSUGAR);
        this.simpleItem(ModItems.CAN_MUG);
        this.simpleItem(ModItems.CAN_OVERCHARGE);
        this.simpleItem(ModItems.CAN_REDBOMB);
        this.simpleItem(ModItems.CAN_SMART);
        this.simpleItem(ModItems.GRENADE_NUC);
        this.simpleItem(ModItems.GRENADE_IF_HE);
        this.simpleItem(ModItems.GRENADE_IF_FIRE);
        this.simpleItem(ModItems.GRENADE_IF_SLIME);
        this.simpleItem(ModItems.GRENADE_IF);
        this.simpleItem(ModItems.BOLT_STEEL);
        this.simpleItem(ModItems.COIL_MAGNETIZED_TUNGSTEN_TORUS);
        this.simpleItem(ModItems.COIL_MAGNETIZED_TUNGSTEN);
        this.simpleItem(ModItems.COIL_COPPER_TORUS);
        this.simpleItem(ModItems.COIL_COPPER);
        this.simpleItem(ModItems.COIL_GOLD_TORUS);
        this.simpleItem(ModItems.COIL_GOLD);
        this.simpleItem(ModItems.COIL_ADVANCED_ALLOY_TORUS);
        this.simpleItem(ModItems.COIL_ADVANCED_ALLOY);
        this.simpleItem(ModItems.MOTOR_BISMUTH);
        this.simpleItem(ModItems.MOTOR_DESH);
        this.simpleItem(ModItems.MOTOR);
        this.simpleItem(ModItems.BATTERY_SCHRABIDIUM);
        this.simpleItem(ModItems.BATTERY_POTATO);
        this.simpleItem(ModItems.BATTERY);
        this.simpleItem(ModItems.BATTERY_RED_CELL);
        this.simpleItem(ModItems.BATTERY_RED_CELL_6);
        this.simpleItem(ModItems.BATTERY_RED_CELL_24);
        this.simpleItem(ModItems.BATTERY_ADVANCED);
        this.simpleItem(ModItems.BATTERY_ADVANCED_CELL);
        this.simpleItem(ModItems.BATTERY_ADVANCED_CELL_4);
        this.simpleItem(ModItems.BATTERY_ADVANCED_CELL_12);
        this.simpleItem(ModItems.BATTERY_LITHIUM);
        this.simpleItem(ModItems.BATTERY_LITHIUM_CELL);
        this.simpleItem(ModItems.BATTERY_LITHIUM_CELL_3);
        this.simpleItem(ModItems.BATTERY_LITHIUM_CELL_6);
        this.simpleItem(ModItems.BATTERY_SCHRABIDIUM_CELL);
        this.simpleItem(ModItems.BATTERY_SCHRABIDIUM_CELL_2);
        this.simpleItem(ModItems.BATTERY_SCHRABIDIUM_CELL_4);
        this.simpleItem(ModItems.BATTERY_SPARK);
        this.simpleItem(ModItems.BATTERY_TRIXITE);
        this.simpleItem(ModItems.BATTERY_SPARK_CELL_6);
        this.simpleItem(ModItems.BATTERY_SPARK_CELL_25);
        this.simpleItem(ModItems.BATTERY_SPARK_CELL_100);
        this.simpleItem(ModItems.BATTERY_SPARK_CELL_1000);
        this.simpleItem(ModItems.BATTERY_SPARK_CELL_2500);
        this.simpleItem(ModItems.BATTERY_SPARK_CELL_10000);
        this.simpleItem(ModItems.BATTERY_SPARK_CELL_POWER);
        this.simpleItem(ModItems.DEPTH_ORES_SCANNER);
        this.simpleItem(ModItems.ZIRCONIUM_SHARP);
        this.simpleItem(ModItems.BORAX);
        this.simpleItem(ModItems.CAPACITOR_BOARD);
        this.simpleItem(ModItems.CAPACITOR_TANTALUM);
        this.simpleItem(ModItems.BISMOID_CIRCUIT);
        this.simpleItem(ModItems.BISMOID_CHIP);
        this.simpleItem(ModItems.SILICON_CIRCUIT);
        this.simpleItem(ModItems.CONTROLLER_ADVANCED);
        this.simpleItem(ModItems.CONTROLLER);
        this.simpleItem(ModItems.CONTROLLER_CHASSIS);
        this.simpleItem(ModItems.QUANTUM_COMPUTER);
        this.simpleItem(ModItems.QUANTUM_CIRCUIT);
        this.simpleItem(ModItems.QUANTUM_CHIP);
        this.simpleItem(ModItems.INTEGRATED_CIRCUIT);
        this.simpleItem(ModItems.ADVANCED_CIRCUIT);
        this.simpleItem(ModItems.ANALOG_CIRCUIT);
        this.simpleItem(ModItems.VACUUM_TUBE);
        this.simpleItem(ModItems.CAPACITOR);
        this.simpleItem(ModItems.PCB);
        this.simpleItem(ModItems.ATOMIC_CLOCK);
        this.simpleItem(ModItems.MICROCHIP);
        this.simpleItem(ModItems.BATTLE_GEARS);
        this.simpleItem(ModItems.BATTLE_SENSOR);
        this.simpleItem(ModItems.BATTLE_CASING);
        this.simpleItem(ModItems.BATTLE_COUNTER);
        this.simpleItem(ModItems.BATTLE_MODULE);
        this.simpleItem(ModItems.METAL_ROD);
        this.simpleItem(ModItems.PLATE_IRON);
        this.simpleItem(ModItems.PLATE_STEEL);
        this.simpleItem(ModItems.PLATE_GOLD);
        this.simpleItem(ModItems.PLATE_GUNMETAL);
        this.simpleItem(ModItems.PLATE_TITANIUM);
        this.simpleItem(ModItems.PLATE_GUNSTEEL);
        this.simpleItem(ModItems.PLATE_KEVLAR);
        this.simpleItem(ModItems.PLATE_LEAD);
        this.simpleItem(ModItems.PLATE_MIXED);
        this.simpleItem(ModItems.PLATE_PAA);
        this.simpleItem(ModItems.INSULATOR);
        this.simpleItem(ModItems.PLATE_SATURNITE);
        this.simpleItem(ModItems.PLATE_SCHRABIDIUM);
        this.simpleItem(ModItems.PLATE_ADVANCED_ALLOY);
        this.simpleItem(ModItems.PLATE_ALUMINUM);
        this.simpleItem(ModItems.PLATE_COPPER);
        this.simpleItem(ModItems.PLATE_BISMUTH);
        this.simpleItem(ModItems.PLATE_ARMOR_AJR);
        this.simpleItem(ModItems.PLATE_ARMOR_DNT);
        this.simpleItem(ModItems.PLATE_ARMOR_DNT_RUSTED);
        this.simpleItem(ModItems.PLATE_ARMOR_FAU);
        this.simpleItem(ModItems.PLATE_ARMOR_HEV);
        this.simpleItem(ModItems.PLATE_ARMOR_LUNAR);
        this.simpleItem(ModItems.PLATE_ARMOR_TITANIUM);
        this.simpleItem(ModItems.PLATE_CAST);
        this.simpleItem(ModItems.PLATE_CAST_ALT);
        this.simpleItem(ModItems.PLATE_CAST_BISMUTH);
        this.simpleItem(ModItems.PLATE_CAST_DARK);
        this.simpleItem(ModItems.PLATE_COMBINE_STEEL);
        this.simpleItem(ModItems.PLATE_DURA_STEEL);
        this.simpleItem(ModItems.PLATE_DALEKANIUM);
        this.simpleItem(ModItems.PLATE_DESH);
        this.simpleItem(ModItems.PLATE_DINEUTRONIUM);
        this.simpleItem(ModItems.PLATE_EUPHEMIUM);
        this.simpleItem(ModItems.PLATE_FUEL_MOX);
        this.simpleItem(ModItems.PLATE_FUEL_PU238BE);
        this.simpleItem(ModItems.PLATE_FUEL_PU239);
        this.simpleItem(ModItems.PLATE_FUEL_RA226BE);
        this.simpleItem(ModItems.PLATE_FUEL_SA326);
        this.simpleItem(ModItems.PLATE_FUEL_U233);
        this.simpleItem(ModItems.PLATE_FUEL_U235);
        this.simpleItem(ModItems.STAMP_STONE_FLAT);
        this.simpleItem(ModItems.STAMP_STONE_PLATE);
        this.simpleItem(ModItems.STAMP_STONE_WIRE);
        this.simpleItem(ModItems.STAMP_STONE_CIRCUIT);
        this.simpleItem(ModItems.STAMP_IRON_FLAT);
        this.simpleItem(ModItems.STAMP_IRON_PLATE);
        this.simpleItem(ModItems.STAMP_IRON_WIRE);
        this.simpleItem(ModItems.STAMP_IRON_CIRCUIT);
        this.simpleItem(ModItems.STAMP_IRON_9);
        this.simpleItem(ModItems.STAMP_IRON_44);
        this.simpleItem(ModItems.STAMP_IRON_50);
        this.simpleItem(ModItems.STAMP_IRON_357);
        this.simpleItem(ModItems.STAMP_STEEL_FLAT);
        this.simpleItem(ModItems.STAMP_STEEL_PLATE);
        this.simpleItem(ModItems.STAMP_STEEL_WIRE);
        this.simpleItem(ModItems.STAMP_STEEL_CIRCUIT);
        this.simpleItem(ModItems.STAMP_TITANIUM_FLAT);
        this.simpleItem(ModItems.STAMP_TITANIUM_PLATE);
        this.simpleItem(ModItems.STAMP_TITANIUM_WIRE);
        this.simpleItem(ModItems.STAMP_TITANIUM_FLAT);
        this.simpleItem(ModItems.STAMP_TITANIUM_PLATE);
        this.simpleItem(ModItems.STAMP_TITANIUM_WIRE);
        this.simpleItem(ModItems.STAMP_TITANIUM_CIRCUIT);
        this.simpleItem(ModItems.STAMP_OBSIDIAN_FLAT);
        this.simpleItem(ModItems.STAMP_OBSIDIAN_PLATE);
        this.simpleItem(ModItems.STAMP_OBSIDIAN_WIRE);
        this.simpleItem(ModItems.STAMP_OBSIDIAN_CIRCUIT);
        this.simpleItem(ModItems.STAMP_DESH_FLAT);
        this.simpleItem(ModItems.STAMP_DESH_PLATE);
        this.simpleItem(ModItems.STAMP_DESH_WIRE);
        this.simpleItem(ModItems.STAMP_DESH_CIRCUIT);
        this.simpleItem(ModItems.STAMP_DESH_9);
        this.simpleItem(ModItems.STAMP_DESH_44);
        this.simpleItem(ModItems.STAMP_DESH_50);
        this.simpleItem(ModItems.STAMP_DESH_357);
        this.simpleItem(ModItems.POWDER_COAL);
        this.simpleItem(ModItems.POWDER_COAL_SMALL);
        this.simpleItem(ModItems.COIL_TUNGSTEN);
        this.simpleItem(ModItems.NUGGET_SILICON);
        this.simpleItem(ModItems.BILLET_SILICON);
        this.simpleItem(ModItems.WIRE_RED_COPPER);
        this.simpleItem(ModItems.WIRE_COPPER);
        this.simpleItem(ModItems.WIRE_TUNGSTEN);
        this.simpleItem(ModItems.WIRE_ALUMINIUM);
        this.simpleItem(ModItems.WIRE_FINE);
        this.simpleItem(ModItems.WIRE_SCHRABIDIUM);
        this.simpleItem(ModItems.WIRE_ADVANCED_ALLOY);
        this.simpleItem(ModItems.WIRE_GOLD);
        this.simpleItem(ModItems.WIRE_MAGNETIZED_TUNGSTEN);
        this.simpleItem(ModItems.WIRE_CARBON);
        this.trimmedArmorItem(ModItems.ALLOY_HELMET);
        this.trimmedArmorItem(ModItems.ALLOY_CHESTPLATE);
        this.trimmedArmorItem(ModItems.ALLOY_LEGGINGS);
        this.trimmedArmorItem(ModItems.ALLOY_BOOTS);
        this.trimmedArmorItem(ModItems.TITANIUM_HELMET);
        this.trimmedArmorItem(ModItems.TITANIUM_CHESTPLATE);
        this.trimmedArmorItem(ModItems.TITANIUM_LEGGINGS);
        this.trimmedArmorItem(ModItems.TITANIUM_BOOTS);
        this.trimmedArmorItem(ModItems.SECURITY_HELMET);
        this.trimmedArmorItem(ModItems.SECURITY_CHESTPLATE);
        this.trimmedArmorItem(ModItems.SECURITY_LEGGINGS);
        this.trimmedArmorItem(ModItems.SECURITY_BOOTS);
        this.trimmedArmorItem(ModItems.ASBESTOS_HELMET);
        this.trimmedArmorItem(ModItems.ASBESTOS_CHESTPLATE);
        this.trimmedArmorItem(ModItems.ASBESTOS_LEGGINGS);
        this.trimmedArmorItem(ModItems.ASBESTOS_BOOTS);
        this.trimmedArmorItem(ModItems.AJR_HELMET);
        this.trimmedArmorItem(ModItems.AJR_CHESTPLATE);
        this.trimmedArmorItem(ModItems.AJR_LEGGINGS);
        this.trimmedArmorItem(ModItems.AJR_BOOTS);
        this.trimmedArmorItem(ModItems.STEEL_HELMET);
        this.trimmedArmorItem(ModItems.STEEL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.STEEL_LEGGINGS);
        this.trimmedArmorItem(ModItems.STEEL_BOOTS);
        this.trimmedArmorItem(ModItems.PAA_HELMET);
        this.trimmedArmorItem(ModItems.PAA_CHESTPLATE);
        this.trimmedArmorItem(ModItems.PAA_LEGGINGS);
        this.trimmedArmorItem(ModItems.PAA_BOOTS);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_HELMET);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_CHESTPLATE);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_LEGGINGS);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_BOOTS);
        this.trimmedArmorItem(ModItems.HAZMAT_HELMET);
        this.trimmedArmorItem(ModItems.HAZMAT_CHESTPLATE);
        this.trimmedArmorItem(ModItems.HAZMAT_LEGGINGS);
        this.trimmedArmorItem(ModItems.HAZMAT_BOOTS);
        this.trimmedArmorItem(ModItems.STARMETAL_HELMET);
        this.trimmedArmorItem(ModItems.STARMETAL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.STARMETAL_LEGGINGS);
        this.trimmedArmorItem(ModItems.STARMETAL_BOOTS);
        this.trimmedArmorItem(ModItems.COBALT_HELMET);
        this.trimmedArmorItem(ModItems.COBALT_CHESTPLATE);
        this.trimmedArmorItem(ModItems.COBALT_LEGGINGS);
        this.trimmedArmorItem(ModItems.COBALT_BOOTS);
        this.evenSimplerBlockItem(ModBlocks.REINFORCED_STONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.REINFORCED_STONE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.CONCRETE_HAZARD_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.CONCRETE_HAZARD_SLAB);
        this.simpleBlockItem(ModBlocks.DOOR_BUNKER);
        this.simpleBlockItem(ModBlocks.DOOR_OFFICE);
        this.simpleBlockItem(ModBlocks.METAL_DOOR);
        this.simpleItem(ModItems.GRENADEHE);
        this.simpleItem(ModItems.GRENADEFIRE);
        ModBlocks.getAnvilBlocks().forEach(this::blockItemFromBlockModel);
    }

    private void simpleItem(RegistryObject<Item> itemObject) {
        String name = itemObject.getId().m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", this.modLoc("item/" + name));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)("item/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder blockItemFromBlockModel(RegistryObject<Block> block) {
        return (ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), this.modLoc("block/" + block.getId().m_135815_()));
    }

    private void ingotItem(RegistryObject<Item> itemObject) {
        String registrationName = itemObject.getId().m_135815_();
        String baseName = registrationName.replace("_ingot", "");
        String textureFileName = "ingot_" + baseName;
        ((ItemModelBuilder)this.withExistingParent(registrationName, "item/generated")).texture("layer0", this.modLoc("item/ingot/" + textureFileName));
    }

    private void powdersItem(RegistryObject<Item> itemObject) {
        String registrationName = itemObject.getId().m_135815_();
        String baseName = registrationName.replace("_powder", "");
        String textureFileName = "powder_" + baseName;
        ((ItemModelBuilder)this.withExistingParent(registrationName, "item/generated")).texture("layer0", this.modLoc("item/powders/" + textureFileName));
    }

    private void tinyPowderItem(RegistryObject<Item> itemObject) {
        String registrationName = itemObject.getId().m_135815_();
        String baseName = registrationName.replace("_powder_tiny", "");
        String textureFileName = "powder_" + baseName + "_tiny";
        ((ItemModelBuilder)this.withExistingParent(registrationName, "item/generated")).texture("layer0", this.modLoc("item/powders/tiny/" + textureFileName));
    }

    private void powderTexture(RegistryObject<Item> itemObject, String texturePath) {
        ((ItemModelBuilder)this.withExistingParent(itemObject.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + texturePath));
    }

    private boolean powderTextureExists(String baseName) {
        ResourceLocation texture = this.modLoc("textures/item/powders/powder_" + baseName + ".png");
        return this.existingFileHelper.exists(texture, PackType.CLIENT_RESOURCES);
    }

    private boolean powderTinyTextureExists(String baseName) {
        ResourceLocation texture = this.modLoc("textures/item/powders/tiny/powder_" + baseName + "_tiny.png");
        return this.existingFileHelper.exists(texture, PackType.CLIENT_RESOURCES);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "hbm_m";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + String.valueOf(armorItem);
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)("item/" + itemRegistryObject.getId().m_135815_())));
            });
        }
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("hbm_m:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    private /* synthetic */ void lambda$registerModels$0(ModIngots ingot, RegistryObject tiny) {
        if (tiny != null && tiny.isPresent() && this.powderTinyTextureExists(ingot.getName())) {
            this.tinyPowderItem((RegistryObject<Item>)tiny);
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

