/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.item.ModIngots;
import com.hbm_m.item.ModItems;
import com.hbm_m.item.ModPowders;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;

public class ModLanguageProvider
extends LanguageProvider {
    private final String locale;

    public ModLanguageProvider(PackOutput output, String locale) {
        super(output, "hbm_m", locale);
        this.locale = locale;
    }

    private void addIngotPowderTranslations(Set<ResourceLocation> translatedPowders) {
        for (ModIngots ingot : ModIngots.values()) {
            RegistryObject<Item> powder;
            if (ModItems.getPowder(ingot) != null && !translatedPowders.contains((powder = ModItems.getPowder(ingot)).getId())) {
                this.add((Item)powder.get(), this.buildPowderName(ingot, false));
            }
            ModItems.getTinyPowder(ingot).ifPresent(tiny -> this.add((Item)tiny.get(), this.buildPowderName(ingot, true)));
        }
        if ("ru_ru".equals(this.locale)) {
            this.add((Item)ModItems.DUST.get(), "\u041f\u044b\u043b\u044c");
            this.add((Item)ModItems.DUST_TINY.get(), "\u041c\u0430\u043b\u0430\u044f \u043a\u0443\u0447\u043a\u0430 \u043f\u044b\u043b\u0438");
        } else {
            this.add((Item)ModItems.DUST.get(), "Dust");
            this.add((Item)ModItems.DUST_TINY.get(), "Tiny Dust");
        }
    }

    private String buildPowderName(ModIngots ingot, boolean tiny) {
        String base = ingot.getTranslation(this.locale);
        if (base == null || base.isBlank()) {
            base = this.formatName(ingot.getName());
        }
        Object result = base;
        if ("ru_ru".equals(this.locale)) {
            Object replaced = ((String)result).replace("\u0421\u043b\u0438\u0442\u043e\u043a", "\u041f\u043e\u0440\u043e\u0448\u043e\u043a").replace("\u0441\u043b\u0438\u0442\u043e\u043a", "\u043f\u043e\u0440\u043e\u0448\u043e\u043a");
            if (((String)replaced).equals(result)) {
                replaced = "\u041f\u043e\u0440\u043e\u0448\u043e\u043a " + (String)result;
            }
            result = ((String)replaced).trim();
            if (tiny) {
                result = "\u041c\u0430\u043b\u0430\u044f \u043a\u0443\u0447\u043a\u0430 " + (String)result;
            }
        } else {
            Object replaced = ((String)result).replace("Ingot", "Powder").replace("ingot", "powder");
            if (((String)replaced).equals(result)) {
                replaced = (String)result + " Powder";
            }
            result = ((String)replaced).trim();
            if (tiny) {
                result = "Tiny " + (String)result;
            }
        }
        return result;
    }

    private String formatName(String name) {
        return Arrays.stream(name.replace('.', '_').split("_")).filter(part -> !part.isEmpty()).map(part -> Character.toUpperCase(part.charAt(0)) + part.substring(1)).collect(Collectors.joining(" "));
    }

    private void addIngotBlockTranslations(Set<ResourceLocation> translatedBlocks) {
        for (ModIngots ingot : ModIngots.values()) {
            RegistryObject<Block> block;
            if (!ModBlocks.ENABLED_INGOT_BLOCKS.contains(ingot.getName()) || (block = ModBlocks.getIngotBlock(ingot)) == null || translatedBlocks.contains(block.getId())) continue;
            this.add((Block)block.get(), this.buildBlockName(ingot));
        }
    }

    private String buildBlockName(ModIngots ingot) {
        String base = ingot.getTranslation(this.locale);
        if (base == null || base.isBlank()) {
            base = this.formatName(ingot.getName());
        }
        if ("ru_ru".equals(this.locale)) {
            Object replaced = base.replace("\u0421\u043b\u0438\u0442\u043e\u043a", "\u0411\u043b\u043e\u043a").replace("\u0441\u043b\u0438\u0442\u043e\u043a", "\u0431\u043b\u043e\u043a");
            if (((String)replaced).equals(base)) {
                replaced = "\u0411\u043b\u043e\u043a " + base;
            }
            return ((String)replaced).trim();
        }
        Object replaced = base.replace("Ingot", "Block").replace("ingot", "block");
        if (((String)replaced).equals(base)) {
            replaced = base + " Block";
        }
        return ((String)replaced).trim();
    }

    protected void addTranslations() {
        for (ModIngots ingot : ModIngots.values()) {
            String translation;
            RegistryObject<Item> registryObject = ModItems.getIngot(ingot);
            if (registryObject == null || !registryObject.isPresent() || (translation = ingot.getTranslation(this.locale)) == null) continue;
            this.add((Item)registryObject.get(), translation);
        }
        HashSet<ResourceLocation> translatedPowders = new HashSet<ResourceLocation>();
        for (ModPowders modPowders : ModPowders.values()) {
            String translation;
            RegistryObject<Item> powderItem = ModItems.getPowders(modPowders);
            if (powderItem == null || !powderItem.isPresent() || (translation = modPowders.getTranslation(this.locale)) == null) continue;
            this.add((Item)powderItem.get(), translation);
            translatedPowders.add(powderItem.getId());
        }
        for (Enum enum_ : ModIngots.values()) {
            RegistryObject<Item> powder = ModItems.getPowder((ModIngots)enum_);
            if (powder != null && powder.isPresent() && !translatedPowders.contains(powder.getId())) {
                this.add((Item)powder.get(), this.buildPowderName((ModIngots)enum_, false));
            }
            ModItems.getTinyPowder((ModIngots)enum_).ifPresent(arg_0 -> this.lambda$addTranslations$3((ModIngots)enum_, arg_0));
        }
        switch (this.locale) {
            case "ru_ru": {
                this.add("itemGroup.hbm_m.ntm_resources_tab", "\u0421\u043b\u0438\u0442\u043a\u0438 \u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u044b NTM");
                this.add("itemGroup.hbm_m.ntm_fuel_tab", "\u0422\u043e\u043f\u043b\u0438\u0432\u043e \u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u043e\u0432 NTM");
                this.add("itemGroup.hbm_m.ntm_templates_tab", "\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0438 \u0448\u0442\u0430\u043c\u043f\u044b NTM");
                this.add("itemGroup.hbm_m.ntm_ores_tab", "\u0420\u0443\u0434\u044b \u0438 \u0431\u043b\u043e\u043a\u0438 NTM");
                this.add("itemGroup.hbm_m.ntm_building_tab", "\u0421\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438 NTM");
                this.add("itemGroup.hbm_m.ntm_machines_tab", "\u041c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u044b \u0438 \u0441\u0442\u0430\u043d\u043a\u0438 NTM");
                this.add("itemGroup.hbm_m.ntm_instruments_tab", "\u0411\u0440\u043e\u043d\u044f \u0438 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u044b NTM");
                this.add("itemGroup.hbm_m.ntm_spareparts_tab", "\u0417\u0430\u043f\u0447\u0430\u0441\u0442\u0438 NTM");
                this.add("itemGroup.hbm_m.ntm_bombs_tab", "\u0411\u043e\u043c\u0431\u044b NTM");
                this.add("itemGroup.hbm_m.ntm_missiles_tab", "\u0420\u0430\u043a\u0435\u0442\u044b \u0438 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u0438 NTM");
                this.add("itemGroup.hbm_m.ntm_weapons_tab", "\u041e\u0440\u0443\u0436\u0438\u0435 \u0438 \u0442\u0443\u0440\u0435\u043b\u0438 NTM");
                this.add("itemGroup.hbm_m.ntm_consumables_tab", "\u0420\u0430\u0441\u0445\u043e\u0434\u043d\u0438\u043a\u0438 \u0438 \u0441\u043d\u0430\u0440\u044f\u0436\u0435\u043d\u0438\u0435 NTM");
                this.add("item.hbm_m.alloy_sword", "\u041c\u0435\u0447 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.alloy_pickaxe", "\u041a\u0438\u0440\u043a\u0430 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.alloy_axe", "\u0422\u043e\u043f\u043e\u0440 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.alloy_hoe", "\u041c\u043e\u0442\u044b\u0433\u0430 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.alloy_shovel", "\u041b\u043e\u043f\u0430\u0442\u0430 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.steel_sword", "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u043c\u0435\u0447");
                this.add("item.hbm_m.steel_pickaxe", "\u0421\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u0438\u0440\u043a\u0430");
                this.add("item.hbm_m.steel_axe", "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0442\u043e\u043f\u043e\u0440");
                this.add("item.hbm_m.steel_hoe", "\u0421\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u043e\u0442\u044b\u0433\u0430");
                this.add("item.hbm_m.steel_shovel", "\u0421\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043b\u043e\u043f\u0430\u0442\u0430");
                this.add("item.hbm_m.titanium_sword", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u043c\u0435\u0447");
                this.add("item.hbm_m.titanium_pickaxe", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0438\u0440\u043a\u0430");
                this.add("item.hbm_m.titanium_axe", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u0442\u043e\u043f\u043e\u0440");
                this.add("item.hbm_m.titanium_hoe", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u043c\u043e\u0442\u044b\u0433\u0430");
                this.add("item.hbm_m.titanium_shovel", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u043b\u043e\u043f\u0430\u0442\u0430");
                this.add("item.hbm_m.starmetal_sword", "\u041c\u0435\u0447 \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.starmetal_pickaxe", "\u041a\u0438\u0440\u043a\u0430 \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.starmetal_axe", "\u0422\u043e\u043f\u043e\u0440 \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.starmetal_hoe", "\u041c\u043e\u0442\u044b\u0433\u0430 \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.starmetal_shovel", "\u041b\u043e\u043f\u0430\u0442\u0430 \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("gui.hbm_m.energy", "\u042d\u043d\u0435\u0440\u0433\u0438\u044f: %s/%s HE");
                this.add("gui.hbm_m.shredder.blade_warning.title", "\u041d\u0435\u0442 \u043b\u0435\u0437\u0432\u0438\u0439!");
                this.add("gui.hbm_m.shredder.blade_warning.desc", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u043e\u0442\u0440\u0435\u043c\u043e\u043d\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u043b\u0435\u0437\u0432\u0438\u044f \u0448\u0440\u0435\u0434\u0434\u0435\u0440\u0430.");
                this.add("item.hbm_m.alloy_helmet", "\u0428\u043b\u0435\u043c \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.alloy_chestplate", "\u041d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.alloy_leggings", "\u041f\u043e\u043d\u043e\u0436\u0438 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.alloy_boots", "\u0411\u043e\u0442\u0438\u043d\u043a\u0438 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add("item.hbm_m.cobalt_helmet", "\u041a\u043e\u0431\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0439 \u0448\u043b\u0435\u043c");
                this.add("item.hbm_m.cobalt_chestplate", "\u041a\u043e\u0431\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0439 \u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a");
                this.add("item.hbm_m.cobalt_leggings", "\u041a\u043e\u0431\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0435 \u043f\u043e\u043d\u043e\u0436\u0438");
                this.add("item.hbm_m.cobalt_boots", "\u041a\u043e\u0431\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0435 \u0431\u043e\u0442\u0438\u043d\u043a\u0438");
                this.add("item.hbm_m.titanium_helmet", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u043b\u0435\u043c");
                this.add("item.hbm_m.titanium_chestplate", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a");
                this.add("item.hbm_m.titanium_leggings", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0435 \u043f\u043e\u043d\u043e\u0436\u0438");
                this.add("item.hbm_m.titanium_boots", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0435 \u0431\u043e\u0442\u0438\u043d\u043a\u0438");
                this.add("item.hbm_m.security_helmet", "\u0428\u043b\u0435\u043c \u043e\u0445\u0440\u0430\u043d\u043d\u0438\u043a\u0430");
                this.add("item.hbm_m.security_chestplate", "\u041d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a \u043e\u0445\u0440\u0430\u043d\u043d\u0438\u043a\u0430");
                this.add("item.hbm_m.security_leggings", "\u041f\u043e\u043d\u043e\u0436\u0438 \u043e\u0445\u0440\u0430\u043d\u043d\u0438\u043a\u0430");
                this.add("item.hbm_m.security_boots", "\u0411\u043e\u0442\u0438\u043d\u043a\u0438 \u043e\u0445\u0440\u0430\u043d\u043d\u0438\u043a\u0430");
                this.add("item.hbm_m.ajr_helmet", "\u0428\u043b\u0435\u043c \u0421\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0420\u0435\u0439\u043d\u0434\u0436\u0435\u0440\u043e\u0432");
                this.add("item.hbm_m.ajr_chestplate", "\u041d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a \u0421\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0420\u0435\u0439\u043d\u0434\u0436\u0435\u0440\u043e\u0432");
                this.add("item.hbm_m.ajr_leggings", "\u041f\u043e\u043d\u043e\u0436\u0438 \u0421\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0420\u0435\u0439\u043d\u0434\u0436\u0435\u0440\u043e\u0432");
                this.add("item.hbm_m.ajr_boots", "\u0411\u043e\u0442\u0438\u043d\u043a\u0438 \u0421\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0420\u0435\u0439\u043d\u0434\u0436\u0435\u0440\u043e\u0432");
                this.add("item.hbm_m.steel_helmet", "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0448\u043b\u0435\u043c");
                this.add("item.hbm_m.steel_chestplate", "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a");
                this.add("item.hbm_m.steel_leggings", "\u0421\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043d\u043e\u0436\u0438");
                this.add("item.hbm_m.steel_boots", "\u0421\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0431\u043e\u0442\u0438\u043d\u043a\u0438");
                this.add("item.hbm_m.asbestos_helmet", "\u041e\u0433\u043d\u0435\u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0439 \u0448\u043b\u0435\u043c");
                this.add("item.hbm_m.asbestos_chestplate", "\u041e\u0433\u043d\u0435\u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0439 \u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a");
                this.add("item.hbm_m.asbestos_leggings", "\u041e\u0433\u043d\u0435\u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0435 \u043f\u043e\u043d\u043e\u0436\u0438");
                this.add("item.hbm_m.asbestos_boots", "\u041e\u0433\u043d\u0435\u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0435 \u0431\u043e\u0442\u0438\u043d\u043a\u0438");
                this.add("item.hbm_m.hazmat_helmet", "\u0417\u0430\u0449\u0438\u0442\u043d\u044b\u0439 \u0448\u043b\u0435\u043c");
                this.add("item.hbm_m.hazmat_chestplate", "\u0417\u0430\u0449\u0438\u0442\u043d\u044b\u0439 \u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a");
                this.add("item.hbm_m.hazmat_leggings", "\u0417\u0430\u0449\u0438\u0442\u043d\u044b\u0435 \u043f\u043e\u043d\u043e\u0436\u0438");
                this.add("item.hbm_m.hazmat_boots", "\u0417\u0430\u0449\u0438\u0442\u043d\u044b\u0435 \u0431\u043e\u0442\u0438\u043d\u043a\u0438");
                this.add("item.hbm_m.liquidator_helmet", "\u0428\u043b\u0435\u043c \u043a\u043e\u0441\u0442\u044e\u043c\u0430 \u041b\u0438\u043a\u0432\u0438\u0434\u0430\u0442\u043e\u0440\u0430");
                this.add("item.hbm_m.liquidator_chestplate", "\u041d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a \u043a\u043e\u0441\u0442\u044e\u043c\u0430 \u041b\u0438\u043a\u0432\u0438\u0434\u0430\u0442\u043e\u0440\u0430");
                this.add("item.hbm_m.liquidator_leggings", "\u041f\u043e\u043d\u043e\u0436\u0438 \u043a\u043e\u0441\u0442\u044e\u043c\u0430 \u041b\u0438\u043a\u0432\u0438\u0434\u0430\u0442\u043e\u0440\u0430");
                this.add("item.hbm_m.liquidator_boots", "\u0411\u043e\u0442\u0438\u043d\u043a\u0438 \u043a\u043e\u0441\u0442\u044e\u043c\u0430 \u041b\u0438\u043a\u0432\u0438\u0434\u0430\u0442\u043e\u0440\u0430");
                this.add("item.hbm_m.paa_helmet", "\u0411\u043e\u0435\u0432\u043e\u0439 \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0439 \u0448\u043b\u0435\u043c PaA");
                this.add("item.hbm_m.paa_chestplate", "\u0417\u0430\u0449\u0438\u0449\u0430\u044e\u0449\u0430\u044f \u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 \u0438\u0437 PaA");
                this.add("item.hbm_m.paa_leggings", "\u0423\u043a\u0440\u0435\u043f\u043b\u0451\u043d\u043d\u044b\u0435 \u043f\u043e\u043d\u043e\u0436\u0438 \u0438\u0437 PaA");
                this.add("item.hbm_m.paa_boots", "''\u0421\u0442\u0430\u0440\u044b\u0435 \u0434\u043e\u0431\u0440\u044b\u0435 \u0431\u043e\u0442\u0438\u043d\u043a\u0438'' \u0438\u0437 PaA");
                this.add("item.hbm_m.starmetal_helmet", "\u0428\u043b\u0435\u043c \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.starmetal_chestplate", "\u041d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.starmetal_leggings", "\u041f\u043e\u043d\u043e\u0436\u0438 \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.starmetal_boots", "\u0411\u043e\u0442\u0438\u043d\u043a\u0438 \u0438\u0437 \u0437\u0432\u0451\u0437\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0430\u043b\u043b\u0430");
                this.add("item.hbm_m.geiger_counter", "\u0421\u0447\u0435\u0442\u0447\u0438\u043a \u0413\u0435\u0439\u0433\u0435\u0440\u0430");
                this.add("item.hbm_m.dosimeter", "\u0414\u043e\u0437\u0438\u043c\u0435\u0442\u0440");
                this.add("item.hbm_m.battery_creative", "\u0411\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0431\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0430");
                this.add("tooltip.hbm_m.creative_battery_desc", "\u041f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u043d\u0435\u0440\u0433\u0438\u0438");
                this.add("tooltip.hbm_m.creative_battery_flavor", "\u0411\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0441\u0442\u044c \u2014 \u043d\u0435 \u043f\u0440\u0435\u0434\u0435\u043b!!");
                this.add((Item)ModItems.COIL_TUNGSTEN.get(), "\u041d\u0430\u0433\u0440\u0435\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
                this.add((Item)ModItems.BATTERY_POTATO.get(), "\u041a\u0430\u0440\u0442\u043e\u0444\u0435\u043b\u044c\u043d\u0430\u044f \u0431\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.BATTERY.get(), "\u0411\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.BATTERY_RED_CELL.get(), "\u041a\u0440\u0430\u0441\u043d\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.BATTERY_RED_CELL_6.get(), "\u041a\u0440\u0430\u0441\u043d\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x6");
                this.add((Item)ModItems.BATTERY_RED_CELL_24.get(), "\u041a\u0440\u0430\u0441\u043d\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x24");
                this.add((Item)ModItems.BATTERY_ADVANCED.get(), "\u041f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u0430\u044f \u0431\u0430\u0442\u0430\u0440\u0435\u044f");
                this.add((Item)ModItems.BATTERY_ADVANCED_CELL.get(), "\u041f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.BATTERY_ADVANCED_CELL_4.get(), "\u041f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x4");
                this.add((Item)ModItems.BATTERY_ADVANCED_CELL_12.get(), "\u041f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x12");
                this.add((Item)ModItems.BATTERY_LITHIUM.get(), "\u041b\u0438\u0442\u0438\u0435\u0432\u0430\u044f \u0431\u0430\u0442\u0430\u0440\u0435\u044f");
                this.add((Item)ModItems.BATTERY_LITHIUM_CELL.get(), "\u041b\u0438\u0442\u0438\u0435\u0432\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.BATTERY_LITHIUM_CELL_3.get(), "\u041b\u0438\u0442\u0438\u0435\u0432\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x3");
                this.add((Item)ModItems.BATTERY_LITHIUM_CELL_6.get(), "\u041b\u0438\u0442\u0438\u0435\u0432\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x6");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM_CELL.get(), "\u0428\u0440\u0430\u0431\u0438\u0434\u0438\u0435\u0432\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM_CELL_2.get(), "\u0428\u0440\u0430\u0431\u0438\u0434\u0438\u0435\u0432\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x2");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM_CELL_4.get(), "\u0428\u0440\u0430\u0431\u0438\u0434\u0438\u0435\u0432\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430 x4");
                this.add((Item)ModItems.BATTERY_SPARK.get(), "\u0421\u043f\u0430\u0440\u043a \u0431\u0430\u0442\u0430\u0440\u0435\u044f");
                this.add((Item)ModItems.BATTERY_TRIXITE.get(), "\u041d\u0435\u0444\u0440\u0438\u0442\u043e\u0432\u044b\u0439 \u0441\u0442\u0435\u0440\u0436\u0435\u043d\u044c \u0441\u043f\u0430\u0440\u043a \u0431\u0430\u0442\u0430\u0440\u0435\u0439 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_6.get(), "\u0421\u043f\u0430\u0440\u043a \u044d\u043d\u0435\u0440\u0433\u043e\u044f\u0447\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_25.get(), "\u0421\u043f\u0430\u0440\u043a \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u043a\u043a\u0443\u043c\u0443\u043b\u044f\u0442\u043e\u0440");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_100.get(), "\u0421\u043f\u0430\u0440\u043a \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u0438");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_1000.get(), "\u0421\u043f\u0430\u0440\u043a \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043c\u0430\u0441\u0441-\u044d\u043d\u0435\u0440\u0433\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043f\u0443\u0441\u0442\u043e\u0442\u0430");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_2500.get(), "\u0421\u043f\u0430\u0440\u043a \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043c\u043e\u0440\u0435 \u0414\u0438\u0440\u0430\u043a\u0430");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_10000.get(), "\u0423\u0441\u0442\u043e\u0439\u0447\u0438\u0432\u044b\u0439 \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u043e-\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0441\u043f\u0430\u0440\u043a \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_POWER.get(), "\u0410\u0431\u0441\u0443\u0440\u0434\u043d\u044b\u0439 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043f\u0430\u0440\u043a \u0431\u043b\u043e\u043a \u043d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u0438");
                this.add((Item)ModItems.WIRE_RED_COPPER.get(), "\u041f\u0440\u043e\u0432\u043e\u0434 \u0438\u0437 \u043a\u0440\u0430\u0441\u043d\u043e\u0439 \u043c\u0435\u0434\u0438");
                this.add((Item)ModItems.WIRE_COPPER.get(), "\u041c\u0435\u0434\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u043e\u0434");
                this.add((Item)ModItems.WIRE_ALUMINIUM.get(), "\u0410\u043b\u044e\u043c\u0438\u043d\u0438\u0435\u0432\u044b\u0439 \u043f\u0440\u043e\u0432\u043e\u0434");
                this.add((Item)ModItems.WIRE_GOLD.get(), "\u0417\u043e\u043b\u043e\u0442\u043e\u0439 \u043f\u0440\u043e\u0432\u043e\u0434");
                this.add((Item)ModItems.WIRE_TUNGSTEN.get(), "\u0412\u043e\u043b\u044c\u0444\u0440\u0430\u043c\u043e\u0432\u044b\u0439 \u043f\u0440\u043e\u0432\u043e\u0434");
                this.add((Item)ModItems.WIRE_MAGNETIZED_TUNGSTEN.get(), "\u041f\u0440\u043e\u0432\u043e\u0434 \u0438\u0437 \u043d\u0430\u043c\u0430\u0433\u043d\u0438\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u043e\u043b\u044c\u0444\u0440\u0430\u043c\u0430");
                this.add((Item)ModItems.WIRE_FINE.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u043e\u0434");
                this.add((Item)ModItems.WIRE_CARBON.get(), "\u041f\u0440\u043e\u0432\u043e\u0434 \u0438\u0437 \u0441\u0432\u0438\u043d\u0446\u0430");
                this.add((Item)ModItems.WIRE_SCHRABIDIUM.get(), "\u0428\u0440\u0430\u0431\u0438\u0434\u0438\u0435\u0432\u044b\u0439 \u043f\u0440\u043e\u0432\u043e\u0434");
                this.add((Item)ModItems.WIRE_ADVANCED_ALLOY.get(), "\u041f\u0440\u043e\u0432\u043e\u0434 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM.get(), "\u0428\u0440\u0430\u0431\u0438\u0434\u0438\u0435\u0432\u0430\u044f \u0431\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0430");
                this.add((Item)ModItems.STAMP_STONE_FLAT.get(), "\u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u043a\u0430\u043c\u0435\u043d\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f");
                this.add((Item)ModItems.STAMP_STONE_PLATE.get(), "\u041a\u0430\u043c\u0435\u043d\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u044b");
                this.add((Item)ModItems.STAMP_STONE_WIRE.get(), "\u041a\u0430\u043c\u0435\u043d\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u0440\u043e\u0432\u043e\u0434\u0430");
                this.add((Item)ModItems.STAMP_STONE_CIRCUIT.get(), "\u041a\u0430\u043c\u0435\u043d\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u0447\u0438\u043f\u0430");
                this.add((Item)ModItems.STAMP_IRON_FLAT.get(), "\u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u0436\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f");
                this.add((Item)ModItems.STAMP_IRON_PLATE.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u044b");
                this.add((Item)ModItems.STAMP_IRON_WIRE.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u0440\u043e\u0432\u043e\u0434\u0430");
                this.add((Item)ModItems.STAMP_IRON_CIRCUIT.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u0447\u0438\u043f\u0430");
                this.add((Item)ModItems.STAMP_STEEL_FLAT.get(), "\u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u0441\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0448\u0442\u0430\u043c\u043f");
                this.add((Item)ModItems.STAMP_STEEL_PLATE.get(), "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u044b");
                this.add((Item)ModItems.STAMP_STEEL_WIRE.get(), "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u0440\u043e\u0432\u043e\u0434\u0430");
                this.add((Item)ModItems.STAMP_STEEL_CIRCUIT.get(), "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0448\u0442\u0430\u043c\u043f \u0447\u0438\u043f\u0430");
                this.add((Item)ModItems.STAMP_TITANIUM_FLAT.get(), "\u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u0442\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f");
                this.add((Item)ModItems.STAMP_TITANIUM_PLATE.get(), "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u044b");
                this.add((Item)ModItems.STAMP_TITANIUM_WIRE.get(), "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u0440\u043e\u0432\u043e\u0434\u0430");
                this.add((Item)ModItems.STAMP_TITANIUM_CIRCUIT.get(), "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u0447\u0438\u043f\u0430");
                this.add((Item)ModItems.STAMP_OBSIDIAN_FLAT.get(), "\u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u043e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f");
                this.add((Item)ModItems.STAMP_OBSIDIAN_PLATE.get(), "\u041e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u044b");
                this.add((Item)ModItems.STAMP_OBSIDIAN_WIRE.get(), "\u041e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u043f\u0440\u043e\u0432\u043e\u0434\u0430");
                this.add((Item)ModItems.STAMP_OBSIDIAN_CIRCUIT.get(), "\u041e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u043e\u0432\u044b\u0439 \u0448\u0442\u0430\u043c\u043f \u0447\u0438\u043f\u0430");
                this.add((Item)ModItems.STAMP_DESH_FLAT.get(), "\u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u0434\u0435\u0448 \u0448\u0442\u0430\u043c\u043f");
                this.add((Item)ModItems.STAMP_DESH_PLATE.get(), "\u0414\u0435\u0448 \u0448\u0442\u0430\u043c\u043f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u044b");
                this.add((Item)ModItems.STAMP_DESH_WIRE.get(), "\u0414\u0435\u0448 \u0448\u0442\u0430\u043c\u043f \u043f\u0440\u043e\u0432\u043e\u0434\u0430");
                this.add((Item)ModItems.STAMP_DESH_CIRCUIT.get(), "\u0414\u0435\u0448 \u0448\u0442\u0430\u043c\u043f \u0447\u0438\u043f\u0430");
                this.add((Item)ModItems.STAMP_DESH_9.get(), "\u0414\u0435\u0448 \u0448\u0442\u0430\u043c\u043f 9\u043c\u043c");
                this.add((Item)ModItems.STAMP_DESH_44.get(), "\u0414\u0435\u0448 \u0448\u0442\u0430\u043c\u043f .44 Magnum");
                this.add((Item)ModItems.STAMP_DESH_50.get(), "\u0414\u0435\u0448 \u0448\u0442\u0430\u043c\u043f .50 BMG");
                this.add((Item)ModItems.STAMP_DESH_357.get(), "\u0414\u0435\u0448 \u0448\u0442\u0430\u043c\u043f .357 Magnum");
                this.add((Item)ModItems.STAMP_IRON_357.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f .357 Magnum");
                this.add((Item)ModItems.STAMP_IRON_44.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f .44 Magnum");
                this.add((Item)ModItems.STAMP_IRON_50.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f .50 BMG");
                this.add((Item)ModItems.STAMP_IRON_9.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0448\u0442\u0430\u043c\u043f 9\u043c\u043c");
                this.add("item.hbm_m.heart_piece", "\u0427\u0430\u0441\u0442\u0438\u0447\u043a\u0430 \u0441\u0435\u0440\u0434\u0446\u0430");
                this.add((Item)ModItems.HEART_CONTAINER.get(), "\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440 \u0434\u043b\u044f \u0441\u0435\u0440\u0434\u0446\u0430");
                this.add((Item)ModItems.HEART_BOOSTER.get(), "\u0423\u0441\u0438\u043b\u0438\u0442\u0435\u043b\u044c \u0441\u0435\u0440\u0434\u0446\u0430");
                this.add((Item)ModItems.HEART_FAB.get(), "\u0424\u0430\u0431-\u0441\u0435\u0440\u0434\u0446\u0435");
                this.add((Item)ModItems.BLACK_DIAMOND.get(), "\u0427\u0435\u0440\u043d\u044b\u0439 \u0430\u043b\u043c\u0430\u0437");
                this.add((Block)ModBlocks.SMOKE_BOMB.get(), "\u0421\u0435\u043c\u0442\u0435\u043a\u0441");
                this.add((Item)ModItems.TEMPLATE_FOLDER.get(), "\u041f\u0430\u043f\u043a\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u043c\u0430\u0448\u0438\u043d");
                this.add((Item)ModItems.ASSEMBLY_TEMPLATE.get(), "\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0431\u043e\u0440\u043e\u0447\u043d\u043e\u0439 \u043c\u0430\u0448\u0438\u043d\u044b: %s");
                this.add("tooltip.hbm_m.template_broken", "\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u043b\u043e\u043c\u0430\u043d!");
                this.add("tooltip.hbm_m.created_with_template_folder", "\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u041f\u0430\u043f\u043a\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u043c\u0430\u0448\u0438\u043d");
                this.add("tooltip.hbm_m.output", "\u0412\u044b\u0445\u043e\u0434: ");
                this.add("tooltip.hbm_m.input", "\u0412\u0445\u043e\u0434: ");
                this.add("tooltip.hbm_m.production_time", "\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0441\u0442\u0432\u0430: ");
                this.add("tooltip.hbm_m.seconds", "\u0441\u0435\u043a\u0443\u043d\u0434");
                this.add("tooltip.hbm_m.energy_consumption", "\u041f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435 \u044d\u043d\u0435\u0440\u0433\u0438\u0438:");
                this.add("tooltip.hbm_m.tags", "\u0422\u0435\u0433\u0438 (OreDict):");
                this.add("item.hbm_m.template_folder.desc", "\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u043c\u0430\u0448\u0438\u043d: \u0411\u0443\u043c\u0430\u0433\u0430 + \u041a\u0440\u0430\u0441\u0438\u0442\u0435\u043b\u044c$\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440: \u0416\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 + \u041a\u0440\u0430\u0441\u0438\u0442\u0435\u043b\u044c$\u0428\u0442\u0430\u043c\u043f \u0434\u043b\u044f \u043f\u0440\u0435\u0441\u0441\u0430: \u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u0448\u0442\u0430\u043c\u043f$\u0422\u0440\u0435\u043a \u0441\u0438\u0440\u0435\u043d\u044b: \u0418\u0437\u043e\u043b\u044f\u0442\u043e\u0440 + \u0421\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add("desc.gui.template", "\u0412\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0441\u0431\u043e\u0440\u043e\u0447\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d");
                this.add("desc.gui.assembler.warning", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d!");
                this.add("tooltip.hbm_m.gigadet.line1", "\u0411\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d \u043f\u043e \u043f\u0440\u0438\u043a\u043e\u043b\u0443");
                this.add("tooltip.hbm_m.nuclear_charge.line1", "\u042f\u0434\u0435\u0440\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435 \u0432\u044b\u0441\u043e\u043a\u043e\u0439 \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u0438!");
                this.add("tooltip.hbm_m.nuclear_charge.line2", "\u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442, \u044d\u0442\u043e \u0441\u0430\u043c\u044b\u0439");
                this.add("tooltip.hbm_m.nuclear_charge.line3", "\u0440\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u043b\u043e\u043a \u0432 \u043d\u0430\u0448\u0435\u043c \u043c\u043e\u0434\u0435");
                this.add("tooltip.hbm_m.nuclear_charge.line4", "\u0415\u0441\u043b\u0438 \u043a\u0440\u0430\u0442\u0435\u0440 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u043b\u0441\u044f \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e");
                this.add("tooltip.hbm_m.nuclear_charge.line5", "\u0438\u043b\u0438 \u0431\u0435\u0437 \u0431\u0438\u043e\u043c\u043e\u0432, \u0442\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u043c\u0438\u0440");
                this.add("tooltip.hbm_m.detminer.line1", "\u041d\u0435 \u043d\u0430\u043d\u043e\u0441\u0438\u0442 \u0443\u0440\u043e\u043d \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044f\u043c \u0438 \u0438\u0433\u0440\u043e\u043a\u0430\u043c");
                this.add("tooltip.hbm_m.detminer.line4", "\u041f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0434\u043e\u0431\u044b\u0432\u0430\u0442\u044c \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0435 \u0440\u0443\u0434\u044b \u0438 \u043a\u0430\u043c\u0435\u043d\u044c");
                this.add("tooltip.hbm_m.dudnuke.line1", "\u042f\u0434\u0435\u0440\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435 \u0432\u044b\u0441\u043e\u043a\u043e\u0439 \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u0438!");
                this.add("tooltip.hbm_m.dudnuke.line4", "\u0415\u0441\u043b\u0438 \u043a\u0440\u0430\u0442\u0435\u0440 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u043b\u0441\u044f \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e");
                this.add("tooltip.hbm_m.dudnuke.line5", "\u0438\u043b\u0438 \u0431\u0435\u0437 \u0431\u0438\u043e\u043c\u043e\u0432, \u0442\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u043c\u0438\u0440");
                this.add("tooltip.hbm_m.dudnuke.line6", "\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0431\u0435\u0437\u0432\u0440\u0435\u0436\u0435\u043d\u0430");
                this.add("tooltip.hbm_m.dudsalted.line1", "\u042f\u0434\u0435\u0440\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435 \u0432\u044b\u0441\u043e\u043a\u043e\u0439 \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u0438!");
                this.add("tooltip.hbm_m.dudsalted.line4", "\u0415\u0441\u043b\u0438 \u043a\u0440\u0430\u0442\u0435\u0440 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u043b\u0441\u044f \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e");
                this.add("tooltip.hbm_m.dudsalted.line5", "\u0438\u043b\u0438 \u0431\u0435\u0437 \u0431\u0438\u043e\u043c\u043e\u0432, \u0442\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u043c\u0438\u0440");
                this.add("tooltip.hbm_m.dudsalted.line6", "\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0431\u0435\u0437\u0432\u0440\u0435\u0436\u0435\u043d\u0430");
                this.add("tooltip.hbm_m.dudfugas.line1", "\u0424\u0443\u0433\u0430\u0441\u043d\u0430\u044f \u0431\u043e\u043c\u0431\u0430 \u0432\u044b\u0441\u043e\u043a\u043e\u0439 \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u0438!");
                this.add("tooltip.hbm_m.dudfugas.line6", "\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0431\u0435\u0437\u0432\u0440\u0435\u0436\u0435\u043d\u0430");
                this.add("tooltip.hbm_m.defuser.line1", "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u0434\u043b\u044f \u043e\u0431\u0435\u0437\u0432\u0440\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043c\u0438\u043d \u0438 \u0431\u043e\u043c\u0431");
                this.add("tooltip.hbm_m.crowbar.line1", "\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0434\u043b\u044f \u0432\u0441\u043a\u0440\u044b\u0442\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u043e\u0432");
                this.add("tooltip.hbm_m.crowbar.line2", "\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u0442 \u044f\u0449\u0438\u043a\u0438 \u043f\u043e \u043d\u0430\u0436\u0430\u0442\u0438\u044e \u041f\u041a\u041c");
                this.add("tooltip.hbm_m.mine_nuke.line1", "\u042f\u0434\u0435\u0440\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435!");
                this.add("tooltip.hbm_m.mine_nuke.line2", "\u0420\u0430\u0434\u0438\u0443\u0441 \u043f\u043e\u0440\u0430\u0436\u0435\u043d\u0438\u044f: 35 \u043c\u0435\u0442\u0440\u043e\u0432");
                this.add("tooltip.hbm_m.mine_nuke.line3", "\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0431\u0435\u0437\u0432\u0440\u0435\u0436\u0435\u043d\u0430");
                this.add("tooltip.hbm_m.mine.line1", "\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0431\u0435\u0437\u0432\u0440\u0435\u0436\u0435\u043d\u0430");
                this.add("tooltip.hbm_m.detonator.target", "\u0426\u0435\u043b\u044c: ");
                this.add("tooltip.hbm_m.detonator.no_target", "\u041d\u0435\u0442 \u0446\u0435\u043b\u0438");
                this.add("tooltip.hbm_m.detonator.right_click", "\u041f\u041a\u041c - \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                this.add("tooltip.hbm_m.detonator.shift_right_click", "Shift+\u041f\u041a\u041c - \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
                this.add("tooltip.hbm_m.depth_ores_scanner.scans_chunks", "\u0421\u043a\u0430\u043d\u0438\u0440\u0443\u0435\u0442 \u0447\u0430\u043d\u043a\u0438 \u0432 \u043f\u043e\u0438\u0441\u043a\u0430\u0445");
                this.add("tooltip.hbm_m.depth_ores_scanner.deep_clusters", "\u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0445 \u043a\u043b\u0430\u0441\u0442\u0435\u0440\u043e\u0432 \u043f\u043e\u0434 \u0438\u0433\u0440\u043e\u043a\u043e\u043c");
                this.add("tooltip.hbm_m.depth_ores_scanner.depth_warning", "\u0420\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u043d\u0430 \u0433\u043b\u0443\u0431\u0438\u043d\u0435 -30 \u0438 \u043d\u0438\u0436\u0435!");
                this.add("message.hbm_m.depth_ores_scanner.invalid_height", "\u0421\u043a\u0430\u043d\u0435\u0440 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0432\u044b\u0441\u043e\u0442\u0435 -30 \u0438\u043b\u0438 \u043d\u0438\u0436\u0435!");
                this.add("message.hbm_m.depth_ores_scanner.directly_below", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0442\u0435\u0440 \u043f\u0440\u044f\u043c\u043e \u043f\u043e\u0434 \u043d\u0430\u043c\u0438!");
                this.add("message.hbm_m.depth_ores_scanner.in_chunk", "\u0412 \u043d\u0430\u0448\u0435\u043c \u0447\u0430\u043d\u043a\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0442\u0435\u0440!");
                this.add("message.hbm_m.depth_ores_scanner.adjacent_chunk", "\u0412 \u0441\u043e\u0441\u0435\u0434\u043d\u0435\u043c \u0447\u0430\u043d\u043a\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0442\u0435\u0440!");
                this.add("message.hbm_m.depth_ores_scanner.none_found", "\u041d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0445 \u043a\u043b\u0430\u0441\u0442\u0435\u0440\u043e\u0432 \u043f\u043e\u0431\u043b\u0438\u0437\u043e\u0441\u0442\u0438");
                this.add("tooltip.hbm_m.multi_detonator.active_point", "\u27a4 %s:");
                this.add("tooltip.hbm_m.multi_detonator.point_set", "\u2705 %s:");
                this.add("tooltip.hbm_m.multi_detonator.coordinates", "   %d, %d, %d");
                this.add("tooltip.hbm_m.multi_detonator.point_empty", "\u25cb \u0422\u043e\u0447\u043a\u0430 %d:");
                this.add("tooltip.hbm_m.multi_detonator.not_set", "   \u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                this.add("tooltip.hbm_m.multi_detonator.key_r", "R - \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043c\u0435\u043d\u044e");
                this.add("tooltip.hbm_m.multi_detonator.shift_rmb", "Shift+\u041f\u041a\u041c - \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u0443\u044e \u0442\u043e\u0447\u043a\u0443");
                this.add("tooltip.hbm_m.multi_detonator.rmb_activate", "\u041f\u041a\u041c - \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u0443\u044e \u0442\u043e\u0447\u043a\u0443");
                this.add("message.hbm_m.multi_detonator.position_saved", "\u041f\u043e\u0437\u0438\u0446\u0438\u044f '%s' \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430: %d, %d, %d");
                this.add("message.hbm_m.multi_detonator.no_coordinates", "\u041d\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442!");
                this.add("message.hbm_m.multi_detonator.point_not_set", "\u0422\u043e\u0447\u043a\u0430 %d \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430!");
                this.add("message.hbm_m.multi_detonator.chunk_not_loaded", "\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
                this.add("message.hbm_m.multi_detonator.activated", "%s \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
                this.add("message.hbm_m.multi_detonator.activation_error", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
                this.add("message.hbm_m.multi_detonator.incompatible_block", "\u0411\u043b\u043e\u043a \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c!");
                this.add("tooltip.hbm_m.oil_detector.scans_chunks", "\u0421\u043a\u0430\u043d\u0438\u0440\u0443\u0435\u0442 \u0447\u0430\u043d\u043a\u0438 \u0432 \u043f\u043e\u0438\u0441\u043a\u0430\u0445");
                this.add("tooltip.hbm_m.oil_detector.oil_deposits", "\u043d\u0435\u0444\u0442\u044f\u043d\u044b\u0445 \u0437\u0430\u043b\u0435\u0436 \u043f\u043e\u0434 \u0438\u0433\u0440\u043e\u043a\u043e\u043c");
                this.add("message.hbm_m.oil_detector.directly_below", "\u0417\u0430\u043b\u0435\u0436\u0438 \u043d\u0435\u0444\u0442\u0438 \u043f\u0440\u044f\u043c\u043e \u043f\u043e\u0434 \u043d\u0430\u043c\u0438!");
                this.add("message.hbm_m.oil_detector.in_chunk", "\u0412 \u043d\u0430\u0448\u0435\u043c \u0447\u0430\u043d\u043a\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043d\u0435\u0444\u0442\u044c!");
                this.add("message.hbm_m.oil_detector.adjacent_chunk", "\u0412 \u0441\u043e\u0441\u0435\u0434\u043d\u0435\u043c \u0447\u0430\u043d\u043a\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0437\u0430\u043b\u0435\u0436\u0438 \u043d\u0435\u0444\u0442\u0438!");
                this.add("message.hbm_m.oil_detector.none_found", "\u041d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0437\u0430\u043b\u0435\u0436\u044c \u043d\u0435\u0444\u0442\u0438 \u043f\u043e\u0431\u043b\u0438\u0437\u043e\u0441\u0442\u0438");
                this.add("tooltip.hbm_m.range_detonator.desc", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0435\u0442 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
                this.add("tooltip.hbm_m.range_detonator.hint", "\u043f\u043e \u043b\u0443\u0447\u0443 \u0434\u043e 256 \u0431\u043b\u043e\u043a\u043e\u0432.");
                this.add("message.hbm_m.range_detonator.pos_not_loaded", "\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0438\u043b\u0438 \u043d\u0435 \u043f\u0440\u043e\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
                this.add("message.hbm_m.range_detonator.activated", "\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
                this.add("tooltip.hbm_m.grenade_nuc.line1", "\u042f\u0434\u0435\u0440\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435!");
                this.add("tooltip.hbm_m.grenade_nuc.line2", "\u0417\u043e\u043d\u0430 \u043f\u043e\u0440\u0430\u0436\u0435\u043d\u0438\u044f: 25 \u043c\u0435\u0442\u0440\u043e\u0432");
                this.add("tooltip.hbm_m.grenade_nuc.line3", "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430: 6\u0441");
                this.add("tooltip.hbm_m.grenade.common.line1", "\u0420\u0443\u0447\u043d\u0430\u044f \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add("tooltip.hbm_m.grenade.smart.line2", "\u0414\u0435\u0442\u043e\u043d\u0438\u0440\u0443\u0435\u0442 \u043f\u0440\u0438 \u043f\u0440\u044f\u043c\u043e\u043c \u043f\u043e\u043f\u0430\u0434\u0430\u043d\u0438\u0438 \u0432 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c");
                this.add("tooltip.hbm_m.grenade.fire.line2", "\u041e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043e\u0433\u043e\u043d\u044c \u043f\u043e\u0441\u043b\u0435 \u0434\u0435\u0442\u043e\u043d\u0430\u0446\u0438\u0438");
                this.add("tooltip.hbm_m.grenade.slime.line2", "\u0421\u0438\u043b\u044c\u043d\u043e \u043e\u0442\u0441\u043a\u0430\u043a\u0438\u0432\u0430\u0435\u0442 \u043e\u0442 \u043f\u043e\u0432\u0435\u0440\u0445\u043d\u043e\u0441\u0442\u0435\u0439");
                this.add("tooltip.hbm_m.grenade.standard.line2", "\u0421\u043b\u0430\u0431\u044b\u0439 \u043e\u0441\u043a\u043e\u043b\u043e\u0447\u043d\u044b\u0439 \u0432\u0437\u0440\u044b\u0432");
                this.add("tooltip.hbm_m.grenade.he.line2", "\u0423\u0441\u0438\u043b\u0435\u043d\u043d\u044b\u0439 \u0444\u0443\u0433\u0430\u0441\u043d\u044b\u0439 \u0432\u0437\u0440\u044b\u0432");
                this.add("tooltip.hbm_m.grenade.default.line2", "\u041a\u0438\u0434\u0430\u0439\u0442\u0435 \u0438 \u0432\u0437\u0440\u044b\u0432\u0430\u0439\u0442\u0435!");
                this.add("tooltip.hbm_m.grenade_if.common.line1", "IF-\u0413\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add("tooltip.hbm_m.grenade_if.he.line2", "\u041c\u043e\u0449\u043d\u044b\u0439 \u0444\u0443\u0433\u0430\u0441\u043d\u044b\u0439 \u0432\u0437\u0440\u044b\u0432");
                this.add("tooltip.hbm_m.grenade_if.slime.line2", "\u0421\u0438\u043b\u044c\u043d\u043e \u043e\u0442\u0441\u043a\u0430\u043a\u0438\u0432\u0430\u0435\u0442 \u043e\u0442 \u043f\u043e\u0432\u0435\u0440\u0445\u043d\u043e\u0441\u0442\u0435\u0439");
                this.add("tooltip.hbm_m.grenade_if.fire.line2", "\u041e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043e\u0433\u043e\u043d\u044c \u043f\u043e\u0441\u043b\u0435 \u0434\u0435\u0442\u043e\u043d\u0430\u0446\u0438\u0438");
                this.add("tooltip.hbm_m.grenade_if.standard.line2", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0432\u0437\u0440\u044b\u0432 \u0441 \u0442\u0430\u0439\u043c\u0435\u0440\u043e\u043c");
                this.add("tooltip.hbm_m.grenade_if.default.line2", "\u0410\u043b\u043b\u0430\u0445 \u043e\u0434\u043e\u0431\u0440\u044f\u0435\u0442!");
                this.add((Block)ModBlocks.BARREL_IRON.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u0431\u043e\u0447\u043a\u0430");
                this.add((Block)ModBlocks.BARREL_STEEL.get(), "\u0421\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u0431\u043e\u0447\u043a\u0430");
                this.add((Block)ModBlocks.BARREL_TCALLOY.get(), "\u0411\u043e\u0447\u043a\u0430 \u0438\u0437 \u0442\u0435\u0445\u043d\u0435\u0446\u0438\u0435\u0432\u043e\u0439 \u0441\u0442\u0430\u043b\u0438");
                this.add((Item)ModItems.ZIRCONIUM_SHARP.get(), "\u041e\u0441\u043a\u043e\u043b\u043e\u043a \u0446\u0438\u0440\u043a\u043e\u043d\u0438\u044f");
                this.add((Block)ModBlocks.CRATE_CONSERVE.get(), "\u042f\u0449\u0438\u043a \u0441 \u043a\u043e\u043d\u0441\u0435\u0440\u0432\u0430\u043c\u0438");
                this.add((Block)ModBlocks.CAGE_LAMP.get(), "\u041b\u0430\u043c\u043f\u0430 \u0432 \u043a\u043b\u0435\u0442\u043a\u0435");
                this.add((Block)ModBlocks.FLOOD_LAMP.get(), "\u041f\u0440\u043e\u0436\u0435\u043a\u0442\u043e\u0440");
                this.add((Block)ModBlocks.B29.get(), "B-29");
                this.add((Block)ModBlocks.DORNIER.get(), "Dornier");
                this.add((Block)ModBlocks.FILE_CABINET.get(), "\u0428\u043a\u0430\u0444\u0447\u0438\u043a");
                this.add((Block)ModBlocks.TAPE_RECORDER.get(), "\u041c\u0430\u0433\u043d\u0438\u0442\u043e\u0444\u043e\u043d");
                this.add((Block)ModBlocks.CRT_BROKEN.get(), "\u0421\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043d\u0438\u0442\u043e\u0440");
                this.add((Block)ModBlocks.CRT_BSOD.get(), "BSOD \u041c\u043e\u043d\u0438\u0442\u043e\u0440 ");
                this.add((Block)ModBlocks.CRT_CLEAN.get(), "\u041c\u043e\u043d\u0438\u0442\u043e\u0440");
                this.add((Block)ModBlocks.TOASTER.get(), "\u0422\u043e\u0441\u0442\u0435\u0440");
                this.add((Block)ModBlocks.BARREL_CORRODED.get(), "\u041f\u0440\u043e\u0440\u0436\u0430\u0432\u0435\u0432\u0448\u0430\u044f \u0431\u043e\u0447\u043a\u0430");
                this.add((Block)ModBlocks.BARREL_LOX.get(), "\u0411\u043e\u0447\u043a\u0430 \u0441 \u0436\u0438\u0434\u043a\u0438\u043c \u043a\u0438\u0441\u043b\u043e\u0440\u043e\u0434\u043e\u043c");
                this.add((Block)ModBlocks.BARREL_PINK.get(), "\u0411\u043e\u0447\u043a\u0430 \u0441 \u043a\u0435\u0440\u043e\u0441\u0438\u043d\u043e\u043c");
                this.add((Block)ModBlocks.BARREL_YELLOW.get(), "\u0411\u043e\u0447\u043a\u0430 \u0441 \u044f\u0434\u0435\u0440\u043d\u044b\u043c\u0438 \u043e\u0442\u0445\u043e\u0434\u0430\u043c\u0438");
                this.add((Block)ModBlocks.BARREL_VITRIFIED.get(), "\u0411\u043e\u0447\u043a\u0430 \u0441 \u043e\u0441\u0442\u0435\u043a\u043b\u043e\u0432\u0430\u043d\u043d\u044b\u043c\u0438 \u044f\u0434\u0435\u0440\u043d\u044b\u043c\u0438 \u043e\u0442\u0445\u043e\u0434\u0430\u043c\u0438");
                this.add((Block)ModBlocks.BARREL_TAINT.get(), "\u0411\u043e\u0447\u043a\u0430 \u0441 \u0433\u043e\u0432\u043d\u043e\u043c");
                this.add((Block)ModBlocks.FIRE_DOOR.get(), "\u041f\u043e\u0436\u0430\u0440\u043d\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add((Block)ModBlocks.SLIDING_SEAL_DOOR.get(), "\u0421\u043a\u043e\u043b\u044c\u0437\u044f\u0449\u0430\u044f \u0433\u0435\u0440\u043c\u0435\u0442\u0438\u0447\u043d\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add((Block)ModBlocks.SECURE_ACCESS_DOOR.get(), "\u0423\u0441\u0438\u043b\u0435\u043d\u043d\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add((Block)ModBlocks.QE_CONTAINMENT.get(), "QE \u0434\u0432\u0435\u0440\u044c \u0431\u0438\u043e\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0441\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u043d\u0438\u044f");
                this.add((Block)ModBlocks.QE_SLIDING.get(), "QE \u0440\u0430\u0437\u0434\u0432\u0438\u0436\u043d\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add((Block)ModBlocks.WATER_DOOR.get(), "\u041f\u043e\u0434\u0432\u043e\u0434\u043d\u044b\u0439 \u043b\u044e\u043a");
                this.add((Block)ModBlocks.SILO_HATCH.get(), "\u041c\u0430\u043b\u044b\u0439 \u043b\u044e\u043a");
                this.add((Block)ModBlocks.SILO_HATCH_LARGE.get(), "\u041b\u044e\u043a \u0440\u0430\u043a\u0435\u0442\u043d\u043e\u0439 \u0448\u0430\u0445\u0442\u044b");
                this.add((Block)ModBlocks.DUD_SALTED.get(), "\u041d\u0435\u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0432\u0448\u0430\u044f\u0441\u044f \u0441\u043e\u043b\u0451\u043d\u0430\u044f \u0431\u043e\u043c\u0431\u0430");
                this.add((Block)ModBlocks.DUD_NUKE.get(), "\u041d\u0435\u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0432\u0448\u0430\u044f\u0441\u044f \u044f\u0434\u0435\u0440\u043d\u0430\u044f \u0431\u043e\u043c\u0431\u0430");
                this.add((Block)ModBlocks.DUD_FUGAS_TONG.get(), "\u041d\u0435\u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0432\u0448\u0430\u044f\u0441\u044f \u0444\u0443\u0433\u0430\u0441\u043d\u0430\u044f \u0431\u043e\u043c\u0431\u0430");
                this.add((Block)ModBlocks.MINE_FAT.get(), "\u041c\u0438\u043d\u0430 '\u0422\u043e\u043b\u0441\u0442\u044f\u043a'");
                this.add((Block)ModBlocks.MINE_AP.get(), "\u041f\u0440\u043e\u0442\u0438\u0432\u043e\u043f\u0435\u0445\u043e\u0442\u043d\u0430\u044f \u043c\u0438\u043d\u0430");
                this.add((Item)ModItems.GRENADE_NUC.get(), "\u042f\u0434\u0435\u0440\u043d\u0430\u044f \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add((Item)ModItems.GRENADE_IF_HE.get(), "IF-\u0413\u0440\u0430\u043d\u0430\u0442\u0430: \u0444\u0443\u0433\u0430\u0441\u043d\u0430\u044f");
                this.add((Item)ModItems.GRENADE_IF_FIRE.get(), "IF-\u0413\u0440\u0430\u043d\u0430\u0442\u0430: \u0437\u0430\u0436\u0438\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f");
                this.add((Item)ModItems.GRENADE_IF_SLIME.get(), "IF-\u0413\u0440\u0430\u043d\u0430\u0442\u0430: \u043f\u0440\u044b\u0433\u0443\u0447\u0430\u044f");
                this.add((Item)ModItems.MULTI_DETONATOR.get(), "\u041c\u0443\u043b\u044c\u0442\u0438-\u0434\u0435\u0442\u043e\u043d\u0430\u0442\u043e\u0440");
                this.add((Item)ModItems.RANGE_DETONATOR.get(), "\u0414\u0435\u0442\u043e\u043d\u0430\u0442\u043e\u0440 \u0434\u0430\u043b\u044c\u043d\u0435\u0433\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
                this.add((Item)ModItems.DETONATOR.get(), "\u0414\u0435\u0442\u043e\u043d\u0430\u0442\u043e\u0440");
                this.add((Block)ModBlocks.BARBED_WIRE_POISON.get(), "\u041a\u043e\u043b\u044e\u0447\u0430\u044f \u043f\u0440\u043e\u0432\u043e\u043b\u043e\u043a\u0430 (\u044f\u0434)");
                this.add((Block)ModBlocks.BARBED_WIRE_FIRE.get(), "\u041a\u043e\u043b\u044e\u0447\u0430\u044f \u043f\u0440\u043e\u0432\u043e\u043b\u043e\u043a\u0430 (\u043e\u0433\u043e\u043d\u044c)");
                this.add((Block)ModBlocks.BARBED_WIRE_RAD.get(), "\u041a\u043e\u043b\u044e\u0447\u0430\u044f \u043f\u0440\u043e\u0432\u043e\u043b\u043e\u043a\u0430 (\u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f)");
                this.add((Block)ModBlocks.BARBED_WIRE.get(), "\u041a\u043e\u043b\u044e\u0447\u0430\u044f \u043f\u0440\u043e\u0432\u043e\u043b\u043e\u043a\u0430");
                this.add((Block)ModBlocks.BARBED_WIRE_WITHER.get(), "\u041a\u043e\u043b\u044e\u0447\u0430\u044f \u043f\u0440\u043e\u0432\u043e\u043b\u043e\u043a\u0430 (\u0438\u0441\u0441\u0443\u0448\u0435\u043d\u0438\u0435)");
                this.add((Block)ModBlocks.WASTE_CHARGE.get(), "\u041e\u0442\u0445\u043e\u0434\u043d\u044b\u0439 \u0437\u0430\u0440\u044f\u0434");
                this.add((Block)ModBlocks.GIGA_DET.get(), "\u0427\u0451\u0440\u0442\u043e\u0432 \u0437\u0430\u0440\u044f\u0434 \u0433\u043e\u0440\u043d\u044f\u043a\u0430");
                this.add((Block)ModBlocks.NUCLEAR_CHARGE.get(), "\u042f\u0434\u0435\u0440\u043d\u044b\u0439 \u0437\u0430\u0440\u044f\u0434");
                this.add((Block)ModBlocks.C4.get(), "\u0417\u0430\u0440\u044f\u0434 C4");
                this.add((Item)ModItems.DEFUSER.get(), "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u0434\u043b\u044f \u0440\u0430\u0437\u043c\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                this.add((Item)ModItems.CROWBAR.get(), "\u041b\u043e\u043c");
                this.add((Item)ModItems.DEPTH_ORES_SCANNER.get(), "\u0421\u043a\u0430\u043d\u0435\u0440 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0445 \u043a\u043b\u0430\u0441\u0442\u0435\u0440\u043e\u0432");
                this.add((Item)ModItems.OIL_DETECTOR.get(), "\u0414\u0435\u0442\u0435\u043a\u0442\u043e\u0440 \u043d\u0435\u0444\u0442\u0438");
                this.add((Item)ModItems.GHIORSIUM_CLADDING.get(), "\u041f\u0440\u043e\u043a\u043b\u0430\u0434\u043a\u0430 \u0438\u0437 \u0433\u0438\u043e\u0440\u0441\u0438\u044f");
                this.add((Item)ModItems.DESH_CLADDING.get(), "\u041e\u0431\u0448\u0438\u0432\u043a\u0430 \u0438\u0437 \u0434\u0435\u0448");
                this.add((Item)ModItems.RUBBER_CLADDING.get(), "\u0420\u0435\u0437\u0438\u043d\u043e\u0432\u0430\u044f \u043e\u0431\u0448\u0438\u0432\u043a\u0430");
                this.add((Item)ModItems.LEAD_CLADDING.get(), "\u0421\u0432\u0438\u043d\u0446\u043e\u0432\u0430\u044f \u043e\u0431\u0448\u0438\u0432\u043a\u0430");
                this.add((Item)ModItems.PAINT_CLADDING.get(), "\u0421\u0432\u0438\u043d\u0446\u043e\u0432\u0430\u044f \u043a\u0440\u0430\u0441\u043a\u0430");
                this.add((Item)ModItems.CRT_DISPLAY.get(), "\u042d\u043b\u0435\u043a\u0442\u0440\u043e-\u043b\u0443\u0447\u0435\u0432\u0430\u044f \u0442\u0440\u0443\u0431\u043a\u0430");
                this.add((Item)ModItems.MAN_CORE.get(), "\u041f\u043b\u0443\u0442\u043e\u043d\u0438\u0435\u0432\u043e\u0435 \u044f\u0434\u0440\u043e");
                this.add((Item)ModItems.GRENADESMART.get(), "\u0423\u041c\u043d\u0430\u044f \u043e\u0442\u0441\u043a\u043e\u043a \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add((Item)ModItems.GRENADESLIME.get(), "\u041e\u0442\u0441\u043a\u043e\u043a-\u043e\u0442\u0441\u043a\u043e\u043a \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add((Item)ModItems.GRENADE.get(), "\u041e\u0442\u0441\u043a\u043e\u043a \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add((Item)ModItems.GRENADEHE.get(), "\u041c\u043e\u0449\u043d\u0430\u044f \u043e\u0442\u0441\u043a\u043e\u043a \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add((Item)ModItems.GRENADEFIRE.get(), "\u0417\u0430\u0436\u0438\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043e\u0442\u0441\u043a\u043e\u043a \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add((Item)ModItems.GRENADE_IF.get(), "IF \u0433\u0440\u0430\u043d\u0430\u0442\u0430");
                this.add("item.hbm_m.radaway", "\u0410\u043d\u0442\u0438\u0440\u0430\u0434\u0438\u043d");
                this.add("item.hbm_m.wood_ash_powder", "\u0414\u0440\u0435\u0432\u0435\u0441\u043d\u044b\u0439 \u043f\u0435\u043f\u0435\u043b");
                this.add("effect.hbm_m.radaway", "\u041e\u0447\u0438\u0449\u0435\u043d\u0438\u0435 \u043e\u0442 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438");
                this.add((Block)ModBlocks.CONVERTER_BLOCK.get(), "\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0435\u0440 \u044d\u043d\u0435\u0440\u0433\u0438\u0438");
                this.add((Block)ModBlocks.MACHINE_BATTERY_DINEUTRONIUM.get(), "\u0414\u0438\u043d\u0435\u0439\u0442\u0440\u043e\u043d\u0438\u0435\u0432\u043e\u0435 \u044d\u043d\u0435\u0440\u0433\u043e\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
                this.add((Block)ModBlocks.MACHINE_BATTERY_SCHRABIDIUM.get(), "\u0428\u0440\u0430\u0431\u0438\u0434\u0438\u0435\u0432\u043e\u0435 \u044d\u043d\u0435\u0440\u0433\u043e\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
                this.add((Block)ModBlocks.MACHINE_BATTERY_LITHIUM.get(), "\u041b\u0438\u0442\u0438\u0435\u0432\u043e\u0435 \u044d\u043d\u0435\u0440\u0433\u043e\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
                this.add((Block)ModBlocks.ASPHALT.get(), "\u0410\u0441\u0444\u0430\u043b\u044c\u0442");
                this.add((Block)ModBlocks.BARRICADE.get(), "\u041c\u0435\u0448\u043a\u0438 \u0441 \u043f\u0435\u0441\u043a\u043e\u043c");
                this.add((Block)ModBlocks.CONCRETE_PILLAR.get(), "\u041a\u043e\u043b\u043e\u043d\u043d\u0430 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.BASALT_BRICK.get(), "\u0411\u0430\u0437\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.BASALT_POLISHED.get(), "\u041e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0431\u0430\u0437\u0430\u043b\u044c\u0442");
                this.add((Block)ModBlocks.BRICK_BASE.get(), "\u041e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.BRICK_DUCRETE.get(), "\u0414\u044e\u043a\u0440\u0438\u0442\u043e\u0432\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.BRICK_FIRE.get(), "\u041e\u0433\u043d\u0435\u0443\u043f\u043e\u0440\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.BRICK_LIGHT.get(), "\u041b\u0435\u0433\u043a\u0438\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.BRICK_OBSIDIAN.get(), "\u041e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u043e\u0432\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.CONCRETE_ASBESTOS.get(), "\u0410\u0441\u0431\u0435\u0441\u0442\u043e\u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_BLACK.get(), "\u0427\u0451\u0440\u043d\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_BLUE.get(), "\u0421\u0438\u043d\u0438\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_BROWN.get(), "\u041a\u043e\u0440\u0438\u0447\u043d\u0435\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_COLORED_BRONZE.get(), "\u0411\u0440\u043e\u043d\u0437\u043e\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_COLORED_INDIGO.get(), "\u0418\u043d\u0434\u0438\u0433\u043e \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE.get(), "\u0411\u0435\u0442\u043e\u043d '\u0412\u044b\u0431\u043e\u0440 \u041f\u043b\u043e\u043c\u0431\u0438\u0440\u0430'");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE_STRIPE.get(), "\u041f\u043e\u043b\u043e\u0441\u0430\u0442\u044b\u0439 \u0431\u0435\u0442\u043e\u043d '\u0412\u044b\u0431\u043e\u0440 \u041f\u043b\u043e\u043c\u0431\u0438\u0440\u0430'");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PINK.get(), "\u0420\u043e\u0437\u043e\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PURPLE.get(), "\u0424\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_COLORED_SAND.get(), "\u0411\u0435\u0442\u043e\u043d '\u0422\u0435\u0445\u0430\u0441'");
                this.add((Block)ModBlocks.CONCRETE_CYAN.get(), "\u0411\u0438\u0440\u044e\u0437\u043e\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_GRAY.get(), "\u0421\u0435\u0440\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_GREEN.get(), "\u0417\u0435\u043b\u0451\u043d\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_LIGHT_BLUE.get(), "\u0413\u043e\u043b\u0443\u0431\u043e\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_LIME.get(), "\u041b\u0430\u0439\u043c\u043e\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_MAGENTA.get(), "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_ORANGE.get(), "\u041e\u0440\u0430\u043d\u0436\u0435\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_PINK.get(), "\u0420\u043e\u0437\u043e\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_PURPLE.get(), "\u0424\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_REBAR.get(), "\u0413\u0440\u0443\u0431\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_REBAR_ALT.get(), "\u0411\u0435\u0442\u043e\u043d \u0441 \u0430\u0440\u043c\u0430\u0442\u0443\u0440\u043e\u0439");
                this.add((Block)ModBlocks.CONCRETE_RED.get(), "\u041a\u0440\u0430\u0441\u043d\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_SILVER.get(), "\u0421\u0435\u0440\u0435\u0431\u0440\u0438\u0441\u0442\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_SUPER.get(), "\u0421\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_SUPER_BROKEN.get(), "\u0420\u0430\u0437\u0431\u0438\u0442\u044b\u0439 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M0.get(), "\u0421\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d M0");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M1.get(), "\u0421\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d M1");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M2.get(), "\u0421\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d M2");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M3.get(), "\u0421\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d M3");
                this.add((Block)ModBlocks.CONCRETE_TILE.get(), "\u0411\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u043a\u0430");
                this.add((Block)ModBlocks.CONCRETE_TILE_TREFOIL.get(), "\u041f\u043e\u043c\u0435\u0447\u0435\u043d\u043d\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u043a\u0430");
                this.add((Block)ModBlocks.CONCRETE_WHITE.get(), "\u0411\u0435\u043b\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_YELLOW.get(), "\u0416\u0451\u043b\u0442\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.CONCRETE_FLAT.get(), "\u041f\u043b\u043e\u0441\u043a\u0438\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add((Block)ModBlocks.DEPTH_BRICK.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.DEPTH_NETHER_BRICK.get(), "\u0410\u0434\u0441\u043a\u0438\u0435 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.DEPTH_NETHER_TILES.get(), "\u0410\u0434\u0441\u043a\u0430\u044f \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u043a\u0430");
                this.add((Block)ModBlocks.DEPTH_STONE_NETHER.get(), "\u0410\u0434\u0441\u043a\u0438\u0439 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u043a\u0430\u043c\u0435\u043d\u044c");
                this.add((Block)ModBlocks.DEPTH_TILES.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u043a\u0430");
                this.add((Block)ModBlocks.GNEISS_BRICK.get(), "\u041a\u0438\u0440\u043f\u0438\u0447\u0438 \u0438\u0437 \u0433\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430");
                this.add((Block)ModBlocks.GNEISS_CHISELED.get(), "\u0420\u0435\u0437\u043d\u043e\u0439 \u0433\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u044b\u0439 \u0441\u043b\u0430\u043d\u0435\u0446");
                this.add((Block)ModBlocks.GNEISS_STONE.get(), "\u0413\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u044b\u0439 \u0441\u043b\u0430\u043d\u0435\u0446");
                this.add((Block)ModBlocks.GNEISS_TILE.get(), "\u041f\u043b\u0438\u0442\u043a\u0430 \u0438\u0437 \u0433\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430");
                this.add((Block)ModBlocks.METEOR.get(), "\u0411\u043b\u043e\u043a \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u0430");
                this.add((Block)ModBlocks.METEOR_BRICK.get(), "\u041c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.METEOR_BRICK_CHISELED.get(), "\u0420\u0435\u0437\u043d\u044b\u0435 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.METEOR_BRICK_CRACKED.get(), "\u0422\u0440\u0435\u0441\u043d\u0443\u0442\u044b\u0435 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.METEOR_BRICK_MOSSY.get(), "\u0417\u0430\u043c\u0448\u0435\u043b\u044b\u0435 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add((Block)ModBlocks.METEOR_COBBLE.get(), "\u041c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0439 \u0431\u0443\u043b\u044b\u0436\u043d\u0438\u043a");
                this.add((Block)ModBlocks.METEOR_CRUSHED.get(), "\u0414\u0440\u043e\u0431\u043b\u0451\u043d\u044b\u0439 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442");
                this.add((Block)ModBlocks.METEOR_PILLAR.get(), "\u041c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u0430\u044f \u043a\u043e\u043b\u043e\u043d\u043d\u0430");
                this.add((Block)ModBlocks.METEOR_POLISHED.get(), "\u041e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442");
                this.add((Block)ModBlocks.METEOR_TREASURE.get(), "\u0411\u043b\u043e\u043a \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0445 \u0441\u043e\u043a\u0440\u043e\u0432\u0438\u0449");
                this.add((Block)ModBlocks.VINYL_TILE.get(), "\u0412\u0438\u043d\u0438\u043b\u043e\u0432\u0430\u044f \u043f\u043b\u0438\u0442\u043a\u0430");
                this.add((Block)ModBlocks.VINYL_TILE_SMALL.get(), "\u041c\u0435\u043b\u043a\u0430\u044f \u0432\u0438\u043d\u0438\u043b\u043e\u0432\u0430\u044f \u043f\u043b\u0438\u0442\u043a\u0430");
                this.add((Block)ModBlocks.CONCRETE_ASBESTOS_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0430\u0441\u0431\u0435\u0441\u0442\u043e\u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_BLACK_SLAB.get(), "\u0427\u0451\u0440\u043d\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_BLUE_SLAB.get(), "\u0421\u0438\u043d\u044f\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_BROWN_SLAB.get(), "\u041a\u043e\u0440\u0438\u0447\u043d\u0435\u0432\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_BRONZE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0431\u0440\u043e\u043d\u0437\u043e\u0432\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_INDIGO_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0438\u043d\u0434\u0438\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u0430 '\u0412\u044b\u0431\u043e\u0440 \u041f\u043b\u043e\u043c\u0431\u0438\u0440\u0430'");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PINK_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0440\u043e\u0437\u043e\u0432\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PURPLE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0444\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_SAND_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u0430 '\u0422\u0435\u0445\u0430\u0441'");
                this.add((Block)ModBlocks.CONCRETE_CYAN_SLAB.get(), "\u0411\u0438\u0440\u044e\u0437\u043e\u0432\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_GRAY_SLAB.get(), "\u0421\u0435\u0440\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_GREEN_SLAB.get(), "\u0417\u0435\u043b\u0451\u043d\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_LIGHT_BLUE_SLAB.get(), "\u0413\u043e\u043b\u0443\u0431\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_LIME_SLAB.get(), "\u041b\u0430\u0439\u043c\u043e\u0432\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_MAGENTA_SLAB.get(), "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_ORANGE_SLAB.get(), "\u041e\u0440\u0430\u043d\u0436\u0435\u0432\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_PINK_SLAB.get(), "\u0420\u043e\u0437\u043e\u0432\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_PURPLE_SLAB.get(), "\u0424\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_RED_SLAB.get(), "\u041a\u0440\u0430\u0441\u043d\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_SILVER_SLAB.get(), "\u0421\u0435\u0440\u0435\u0431\u0440\u0438\u0441\u0442\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_WHITE_SLAB.get(), "\u0411\u0435\u043b\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_YELLOW_SLAB.get(), "\u0416\u0451\u043b\u0442\u0430\u044f \u0431\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_SUPER_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M0_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M0");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M1_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M1");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M2_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M2");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M3_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M3");
                this.add((Block)ModBlocks.CONCRETE_SUPER_BROKEN_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0440\u0430\u0437\u0431\u0438\u0442\u043e\u0433\u043e \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_REBAR_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0433\u0440\u0443\u0431\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_FLAT_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043f\u043b\u043e\u0441\u043a\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_TILE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u043d\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.DEPTH_BRICK_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.DEPTH_TILES_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.DEPTH_NETHER_BRICK_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0430\u0434\u0441\u043a\u0438\u0445 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.DEPTH_NETHER_TILES_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0430\u0434\u0441\u043a\u043e\u0439 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.GNEISS_TILE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043f\u043b\u0438\u0442\u043a\u0438 \u0433\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430");
                this.add((Block)ModBlocks.GNEISS_BRICK_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439 \u0433\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430");
                this.add((Block)ModBlocks.BRICK_BASE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.BRICK_LIGHT_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043b\u0435\u0433\u043a\u0438\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.BRICK_FIRE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043e\u0433\u043d\u0435\u0443\u043f\u043e\u0440\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.BRICK_OBSIDIAN_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u043e\u0432\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.VINYL_TILE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0432\u0438\u043d\u0438\u043b\u043e\u0432\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.VINYL_TILE_SMALL_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043c\u0435\u043b\u043a\u043e\u0439 \u0432\u0438\u043d\u0438\u043b\u043e\u0432\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.BRICK_DUCRETE_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0434\u044e\u043a\u0440\u0438\u0442\u043e\u0432\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.ASPHALT_SLAB.get(), "\u0410\u0441\u0444\u0430\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add((Block)ModBlocks.BASALT_POLISHED_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0431\u0430\u0437\u0430\u043b\u044c\u0442\u0430");
                this.add((Block)ModBlocks.BASALT_BRICK_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0431\u0430\u0437\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_POLISHED_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u0430");
                this.add((Block)ModBlocks.METEOR_BRICK_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_BRICK_CRACKED_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0442\u0440\u0435\u0441\u043d\u0443\u0442\u044b\u0445 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_BRICK_MOSSY_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0437\u0430\u043c\u0448\u0435\u043b\u044b\u0445 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_CRUSHED_SLAB.get(), "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0434\u0440\u043e\u0431\u043b\u0451\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u0430");
                this.add((Block)ModBlocks.CONCRETE_ASBESTOS_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0430\u0441\u0431\u0435\u0441\u0442\u043e\u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_BLACK_STAIRS.get(), "\u0427\u0451\u0440\u043d\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_BLUE_STAIRS.get(), "\u0421\u0438\u043d\u0438\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_BROWN_STAIRS.get(), "\u041a\u043e\u0440\u0438\u0447\u043d\u0435\u0432\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_COLORED_BRONZE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0431\u0440\u043e\u043d\u0437\u043e\u0432\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_INDIGO_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0438\u043d\u0434\u0438\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u0430 '\u0412\u044b\u0431\u043e\u0440 \u041f\u043b\u043e\u043c\u0431\u0438\u0440\u0430'");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PINK_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0440\u043e\u0437\u043e\u0432\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PURPLE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0444\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_COLORED_SAND_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u0430 '\u0422\u0435\u0445\u0430\u0441'");
                this.add((Block)ModBlocks.CONCRETE_CYAN_STAIRS.get(), "\u0411\u0438\u0440\u044e\u0437\u043e\u0432\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_GRAY_STAIRS.get(), "\u0421\u0435\u0440\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_GREEN_STAIRS.get(), "\u0417\u0435\u043b\u0451\u043d\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_LIGHT_BLUE_STAIRS.get(), "\u0413\u043e\u043b\u0443\u0431\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_LIME_STAIRS.get(), "\u041b\u0430\u0439\u043c\u043e\u0432\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_MAGENTA_STAIRS.get(), "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_ORANGE_STAIRS.get(), "\u041e\u0440\u0430\u043d\u0436\u0435\u0432\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_PINK_STAIRS.get(), "\u0420\u043e\u0437\u043e\u0432\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_PURPLE_STAIRS.get(), "\u0424\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_RED_STAIRS.get(), "\u041a\u0440\u0430\u0441\u043d\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_SILVER_STAIRS.get(), "\u0421\u0435\u0440\u0435\u0431\u0440\u0438\u0441\u0442\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_WHITE_STAIRS.get(), "\u0411\u0435\u043b\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_YELLOW_STAIRS.get(), "\u0416\u0451\u043b\u0442\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.CONCRETE_SUPER_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M0_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M0");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M1_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M1");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M2_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M2");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M3_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430 M3");
                this.add((Block)ModBlocks.CONCRETE_SUPER_BROKEN_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0440\u0430\u0437\u0431\u0438\u0442\u043e\u0433\u043e \u0441\u0443\u043f\u0435\u0440 \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_REBAR_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0433\u0440\u0443\u0431\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_FLAT_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043f\u043b\u043e\u0441\u043a\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add((Block)ModBlocks.CONCRETE_TILE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u043d\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.DEPTH_BRICK_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.DEPTH_TILES_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.DEPTH_NETHER_BRICK_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0430\u0434\u0441\u043a\u0438\u0445 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.DEPTH_NETHER_TILES_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0430\u0434\u0441\u043a\u043e\u0439 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.GNEISS_TILE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043f\u043b\u0438\u0442\u043a\u0438 \u0433\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430");
                this.add((Block)ModBlocks.GNEISS_BRICK_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439 \u0433\u0440\u0430\u0444\u0438\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430");
                this.add((Block)ModBlocks.BRICK_BASE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.BRICK_LIGHT_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043b\u0435\u0433\u043a\u0438\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.BRICK_FIRE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043e\u0433\u043d\u0435\u0443\u043f\u043e\u0440\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.BRICK_OBSIDIAN_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u043e\u0432\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.VINYL_TILE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0432\u0438\u043d\u0438\u043b\u043e\u0432\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.VINYL_TILE_SMALL_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043c\u0435\u043b\u043a\u043e\u0439 \u0432\u0438\u043d\u0438\u043b\u043e\u0432\u043e\u0439 \u043f\u043b\u0438\u0442\u043a\u0438");
                this.add((Block)ModBlocks.BRICK_DUCRETE_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0434\u044e\u043a\u0440\u0438\u0442\u043e\u0432\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.ASPHALT_STAIRS.get(), "\u0410\u0441\u0444\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u0438");
                this.add((Block)ModBlocks.BASALT_POLISHED_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0431\u0430\u0437\u0430\u043b\u044c\u0442\u0430");
                this.add((Block)ModBlocks.BASALT_BRICK_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0431\u0430\u0437\u0430\u043b\u044c\u0442\u043e\u0432\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_POLISHED_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043e\u0442\u043f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u0430");
                this.add((Block)ModBlocks.METEOR_BRICK_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_BRICK_CRACKED_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0442\u0440\u0435\u0441\u043d\u0443\u0442\u044b\u0445 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_BRICK_MOSSY_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0437\u0430\u043c\u0448\u0435\u043b\u044b\u0445 \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add((Block)ModBlocks.METEOR_CRUSHED_STAIRS.get(), "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0434\u0440\u043e\u0431\u043b\u0451\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u0435\u043e\u0440\u0438\u0442\u0430");
                this.add((Block)ModBlocks.DEPTH_STONE.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u043a\u0430\u043c\u0435\u043d\u044c");
                this.add((Block)ModBlocks.DEPTH_CINNABAR.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u043a\u0438\u043d\u043e\u0432\u0430\u0440\u043d\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add((Block)ModBlocks.DEPTH_IRON.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0436\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add((Block)ModBlocks.DEPTH_ZIRCONIUM.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0446\u0438\u0440\u043a\u043e\u043d\u0438\u0435\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add((Block)ModBlocks.DEPTH_BORAX.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0431\u0443\u0440\u0430");
                this.add((Block)ModBlocks.DEPTH_TUNGSTEN.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0432\u043e\u043b\u044c\u0444\u0440\u0430\u043c\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add((Block)ModBlocks.DEPTH_TITANIUM.get(), "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0442\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add((Block)ModBlocks.BEDROCK_OIL.get(), "\u0411\u0435\u0434\u0440\u043e\u043a\u043e\u0432\u0430\u044f \u043d\u0435\u0444\u0442\u044c");
                this.add((Block)ModBlocks.BURNED_GRASS.get(), "\u0412\u044b\u0436\u0436\u0435\u043d\u043d\u0430\u044f \u0442\u0440\u0430\u0432\u0430");
                this.add((Block)ModBlocks.WASTE_PLANKS.get(), "\u0412\u044b\u0436\u0436\u0435\u043d\u043d\u044b\u0435 \u0434\u043e\u0441\u043a\u0438");
                this.add((Block)ModBlocks.WASTE_LOG.get(), "\u0412\u044b\u0436\u0436\u0435\u043d\u043d\u043e\u0435 \u0431\u0440\u0435\u0432\u043d\u043e");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED.get(), "\u041f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0439 \u0441\u0435\u043b\u043b\u0430\u0444\u0438\u0442");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED1.get(), "\u041f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0439 \u0441\u0435\u043b\u043b\u0430\u0444\u0438\u0442 I");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED2.get(), "\u041f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0439 \u0441\u0435\u043b\u043b\u0430\u0444\u0438\u0442 II");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED3.get(), "\u041f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0439 \u0441\u0435\u043b\u043b\u0430\u0444\u0438\u0442 III");
                this.add((Item)ModItems.COIL_MAGNETIZED_TUNGSTEN_TORUS.get(), "\u041a\u043e\u043b\u044c\u0446\u0435\u0432\u0430\u044f \u043a\u0430\u0442\u0443\u0448\u043a\u0430 \u0438\u0437 \u043d\u0430\u043c\u0430\u0433\u043d\u0438\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u043e\u043b\u044c\u0444\u0440\u0430\u043c\u0430");
                this.add((Item)ModItems.COIL_MAGNETIZED_TUNGSTEN.get(), "\u041a\u0430\u0442\u0443\u0448\u043a\u0430 \u0438\u0437 \u043d\u0430\u043c\u0430\u0433\u043d\u0438\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u043e\u043b\u044c\u0444\u0440\u0430\u043c\u0430");
                this.add((Item)ModItems.COIL_ADVANCED_ALLOY_TORUS.get(), "\u041a\u043e\u043b\u044c\u0446\u0435\u0432\u0430\u044f \u043a\u0430\u0442\u0443\u0448\u043a\u0430 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add((Item)ModItems.COIL_ADVANCED_ALLOY.get(), "\u041a\u0430\u0442\u0443\u0448\u043a\u0430 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add((Item)ModItems.COIL_COPPER_TORUS.get(), "\u041a\u043e\u043b\u044c\u0446\u0435\u0432\u0430\u044f \u043c\u0435\u0434\u043d\u0430\u044f \u043a\u0430\u0442\u0443\u0448\u043a\u0430");
                this.add((Item)ModItems.COIL_GOLD_TORUS.get(), "\u041a\u043e\u043b\u044c\u0446\u0435\u0432\u0430\u044f \u0437\u043e\u043b\u043e\u0442\u0430\u044f \u043a\u0430\u0442\u0443\u0448\u043a\u0430");
                this.add((Item)ModItems.COIL_COPPER.get(), "\u041c\u0435\u0434\u043d\u0430\u044f \u043a\u0430\u0442\u0443\u0448\u043a\u0430");
                this.add((Item)ModItems.COIL_GOLD.get(), "\u041c\u0435\u0434\u043d\u0430\u044f \u043a\u0430\u0442\u0443\u0448\u043a\u0430");
                this.add((Item)ModItems.DUST.get(), "\u041a\u0443\u0447\u043a\u0430 \u043f\u044b\u043b\u0438");
                this.add((Item)ModItems.DUST_TINY.get(), "\u041c\u0430\u043b\u0435\u043d\u044c\u043a\u0430\u044f \u043a\u0443\u0447\u043a\u0430 \u043f\u044b\u043b\u0438");
                this.add((Item)ModItems.SCRAP.get(), "\u041c\u0443\u0441\u043e\u0440");
                this.add((Item)ModItems.POWDER_COAL.get(), "\u0423\u0433\u043e\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0440\u043e\u0448\u043e\u043a");
                this.add((Item)ModItems.POWDER_COAL_SMALL.get(), "\u041c\u0430\u043b\u0435\u043d\u044c\u043a\u0430\u044f \u043a\u0443\u0447\u043a\u0430 \u0443\u0433\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u043e\u0448\u043e\u043a\u0430");
                this.add((Item)ModItems.BILLET_PLUTONIUM.get(), "\u0417\u0430\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043f\u043b\u0443\u0442\u043e\u043d\u0438\u044f");
                this.add("tooltip.hbm_m.depthstone.line1", "\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0437\u0440\u044b\u0432\u043e\u043c!");
                this.add("tooltip.hbm_m.depthstone.line4", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0428\u0430\u0445\u0442\u0451\u0440\u0441\u043a\u0438\u0439 \u0437\u0430\u0440\u044f\u0434 \u0434\u043b\u044f \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0439 \u0434\u043e\u0431\u044b\u0447\u0438");
                this.add((Item)ModItems.MOTOR_BISMUTH.get(), "\u0412\u0438\u0441\u043c\u0443\u0442\u043e\u0432\u044b\u0439 \u043c\u043e\u0442\u043e\u0440");
                this.add((Item)ModItems.MOTOR_DESH.get(), "\u0414\u0435\u0448 \u043c\u043e\u0442\u043e\u0440");
                this.add((Item)ModItems.MOTOR.get(), "\u041c\u043e\u0442\u043e\u0440");
                this.add((Item)ModItems.BLADE_TEST.get(), "\u0414\u0435\u0448 \u043b\u0435\u0437\u0432\u0438\u044f");
                this.add((Item)ModItems.BLADE_STEEL.get(), "\u0421\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u043b\u0435\u0437\u0432\u0438\u044f");
                this.add((Item)ModItems.BLADE_TITANIUM.get(), "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u044b\u0435 \u043b\u0435\u0437\u0432\u0438\u044f");
                this.add((Item)ModItems.BLADE_ALLOY.get(), "\u041b\u0435\u0437\u0432\u0438\u044f \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add((Item)ModItems.BORAX.get(), "\u0411\u0443\u0440\u0430");
                this.add((Item)ModItems.BALL_TNT.get(), "\u0412\u0437\u0440\u044b\u0432\u0447\u0430\u0442\u043a\u0430");
                this.add((Item)ModItems.BOLT_STEEL.get(), "\u0411\u043e\u043b\u0442");
                this.add((Item)ModItems.CANNED_ASBESTOS.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0430\u0441\u0431\u0435\u0441\u0442");
                this.add((Item)ModItems.CANNED_ASS.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0437\u0430\u0434\u043d\u0438\u0446\u0430");
                this.add((Item)ModItems.CANNED_BARK.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043a\u043e\u0440\u0430");
                this.add((Item)ModItems.CANNED_BEEF.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0433\u043e\u0432\u044f\u0434\u0438\u043d\u0430");
                this.add((Item)ModItems.CANNED_BHOLE.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0447\u0435\u0440\u043d\u0430\u044f \u0434\u044b\u0440\u0430");
                this.add((Item)ModItems.CANNED_CHEESE.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u044b\u0440");
                this.add((Item)ModItems.CANNED_CHINESE.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u043a\u0438\u0442\u0430\u0439\u0441\u043a\u043e\u0435 \u0431\u043b\u044e\u0434\u043e");
                this.add((Item)ModItems.CANNED_DIESEL.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u0438\u0437\u0435\u043b\u044c");
                this.add((Item)ModItems.CANNED_FIST.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043a\u0443\u043b\u0430\u043a");
                this.add((Item)ModItems.CANNED_FRIED.get(), "\u0416\u0430\u0440\u0435\u043d\u0430\u044f \u043a\u043e\u043d\u0441\u0435\u0440\u0432\u0430");
                this.add((Item)ModItems.CANNED_HOTDOGS.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0445\u043e\u0442-\u0434\u043e\u0433\u0438");
                this.add((Item)ModItems.CANNED_JIZZ.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0436\u0435\u0440\u0435\u0431\u0446\u043e\u0432\u043e\u0435 \u043c\u043e\u043b\u043e\u0447\u043a\u043e");
                this.add((Item)ModItems.CANNED_KEROSENE.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043a\u0435\u0440\u043e\u0441\u0438\u043d");
                this.add((Item)ModItems.CANNED_LEFTOVERS.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043e\u0441\u0442\u0430\u0442\u043a\u0438");
                this.add((Item)ModItems.CANNED_MILK.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u043c\u043e\u043b\u043e\u043a\u043e");
                this.add((Item)ModItems.CANNED_MYSTERY.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0437\u0430\u0433\u0430\u0434\u043a\u0430");
                this.add((Item)ModItems.CANNED_NAPALM.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043d\u0430\u043f\u0430\u043b\u043c");
                this.add((Item)ModItems.CANNED_OIL.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043d\u0435\u0444\u0442\u044c");
                this.add((Item)ModItems.CANNED_PASHTET.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u0448\u0442\u0435\u0442");
                this.add((Item)ModItems.CANNED_PIZZA.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043f\u0438\u0446\u0446\u0430");
                this.add((Item)ModItems.CANNED_RECURSION.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0440\u0435\u043a\u0443\u0440\u0441\u0438\u044f");
                this.add((Item)ModItems.CANNED_SPAM.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u043f\u0430\u043c");
                this.add((Item)ModItems.CANNED_STEW.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0440\u0430\u0433\u0443");
                this.add((Item)ModItems.CANNED_TOMATO.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0442\u043e\u043c\u0430\u0442");
                this.add((Item)ModItems.CANNED_TUNA.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0442\u0443\u043d\u0435\u0446");
                this.add((Item)ModItems.CANNED_TUBE.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0442\u0440\u0443\u0431\u043a\u0430");
                this.add((Item)ModItems.CANNED_YOGURT.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0439\u043e\u0433\u0443\u0440\u0442");
                this.add((Item)ModItems.CAN_BEPIS.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a \u0411\u0435\u043f\u0438\u0441");
                this.add((Item)ModItems.CAN_BREEN.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a Breen");
                this.add((Item)ModItems.CAN_CREATURE.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a Creature");
                this.add((Item)ModItems.CAN_EMPTY.get(), "\u041f\u0443\u0441\u0442\u0430\u044f \u0431\u0430\u043d\u043a\u0430");
                this.add((Item)ModItems.CAN_KEY.get(), "\u041a\u043e\u043d\u0441\u0435\u0440\u0432\u043d\u044b\u0439 \u043d\u043e\u0436");
                this.add((Item)ModItems.CAN_LUNA.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a Luna");
                this.add((Item)ModItems.CAN_MRSUGAR.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a Mrsugar");
                this.add((Item)ModItems.CAN_MUG.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a Mug");
                this.add((Item)ModItems.CAN_OVERCHARGE.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a Overcharge");
                this.add((Item)ModItems.CAN_REDBOMB.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a RedBomb");
                this.add((Item)ModItems.CAN_SMART.get(), "\u041d\u0430\u043f\u0438\u0442\u043e\u043a Smart");
                this.add((Item)ModItems.QUANTUM_CHIP.get(), "\u041a\u0432\u0430\u043d\u0442\u043e\u0432\u044b\u0439 \u0447\u0438\u043f");
                this.add((Item)ModItems.QUANTUM_CIRCUIT.get(), "\u041a\u0432\u0430\u043d\u0442\u043e\u0432\u0430\u044f \u043c\u0438\u043a\u0440\u043e\u0441\u0445\u0435\u043c\u0430");
                this.add((Item)ModItems.QUANTUM_COMPUTER.get(), "\u041a\u0432\u0430\u043d\u0442\u043e\u0432\u044b\u0439 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440");
                this.add((Item)ModItems.SILICON_CIRCUIT.get(), "\u041e\u043f\u0435\u0447\u0430\u0442\u0430\u043d\u043d\u0430\u044f \u043a\u0440\u0435\u043c\u043d\u0438\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.BISMOID_CHIP.get(), "\u041f\u0435\u0440\u0435\u0434\u043e\u0432\u043e\u0439 \u043c\u0438\u043a\u0440\u043e\u0447\u0438\u043f");
                this.add((Item)ModItems.BISMOID_CIRCUIT.get(), "\u041f\u0435\u0440\u0435\u0434\u043e\u0432\u0430\u044f \u043c\u0438\u043a\u0440\u043e\u0441\u0445\u0435\u043c\u0430");
                this.add((Item)ModItems.CONTROLLER_CHASSIS.get(), "\u041a\u043e\u0440\u043f\u0443\u0441 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430");
                this.add((Item)ModItems.CONTROLLER.get(), "\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440");
                this.add((Item)ModItems.CONTROLLER_ADVANCED.get(), "\u041f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u044b\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440");
                this.add((Item)ModItems.CAPACITOR_BOARD.get(), "\u041a\u043e\u043d\u0434\u0435\u043d\u0441\u0430\u0442\u043e\u0440\u043d\u0430\u044f \u043f\u043b\u0430\u0442\u0430");
                this.add((Item)ModItems.CAPACITOR_TANTALUM.get(), "\u0422\u0430\u043d\u0442\u0430\u043b\u043e\u0432\u044b\u0439 \u043a\u043e\u043d\u0434\u0435\u043d\u0441\u0430\u0442\u043e\u0440");
                this.add((Item)ModItems.ANALOG_CIRCUIT.get(), "\u0410\u043d\u0430\u043b\u043e\u0433\u043e\u0432\u0430\u044f \u043f\u043b\u0430\u0442\u0430");
                this.add((Item)ModItems.INTEGRATED_CIRCUIT.get(), "\u0418\u043d\u0442\u0435\u0433\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0445\u0435\u043c\u0430");
                this.add((Item)ModItems.ADVANCED_CIRCUIT.get(), "\u0412\u043e\u0435\u043d\u043d\u0430\u044f \u043c\u0438\u043a\u0440\u043e\u0441\u0445\u0435\u043c\u0430");
                this.add((Item)ModItems.MICROCHIP.get(), "\u041c\u0438\u043a\u0440\u043e\u0447\u0438\u043f");
                this.add((Item)ModItems.ATOMIC_CLOCK.get(), "\u0410\u0442\u043e\u043c\u043d\u044b\u0435 \u0447\u0430\u0441\u044b");
                this.add((Item)ModItems.VACUUM_TUBE.get(), "\u0412\u0430\u043a\u0443\u0443\u043c\u043d\u0430\u044f \u0442\u0440\u0443\u0431\u043a\u0430");
                this.add((Item)ModItems.CAPACITOR.get(), "\u041a\u043e\u043d\u0434\u0435\u043d\u0441\u0430\u0442\u043e\u0440");
                this.add((Item)ModItems.PCB.get(), "\u041f\u0435\u0447\u0430\u0442\u043d\u0430\u044f \u043f\u043b\u0430\u0442\u0430");
                this.add((Item)ModItems.INSULATOR.get(), "\u0418\u0437\u043e\u043b\u044f\u0442\u043e\u0440");
                this.add((Item)ModItems.NUGGET_SILICON.get(), "\u0421\u0430\u043c\u043e\u0440\u043e\u0434\u043e\u043a \u043a\u0440\u0435\u043c\u043d\u0438\u044f");
                this.add((Item)ModItems.BILLET_SILICON.get(), "\u0417\u0430\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a\u0440\u0435\u043c\u043d\u0438\u044f");
                this.add((Item)ModItems.BATTLE_GEARS.get(), "\u0411\u043e\u0435\u0432\u044b\u0435 \u0434\u0435\u0442\u0430\u043b\u0438");
                this.add((Item)ModItems.BATTLE_CASING.get(), "\u0411\u043e\u0435\u0432\u043e\u0439 \u043a\u043e\u0440\u043f\u0443\u0441");
                this.add((Item)ModItems.BATTLE_COUNTER.get(), "\u0411\u043e\u0435\u0432\u043e\u0439 \u0431\u043b\u043e\u043a \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
                this.add((Item)ModItems.BATTLE_SENSOR.get(), "\u0411\u043e\u0435\u0432\u043e\u0439 \u0441\u0435\u043d\u0441\u043e\u0440");
                this.add((Item)ModItems.BATTLE_MODULE.get(), "\u0411\u043e\u0435\u0432\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
                this.add((Item)ModItems.METAL_ROD.get(), "\u041c\u0435\u0442\u0430\u043b\u043b\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u0442\u0435\u0440\u0436\u0435\u043d\u044c");
                this.add((Item)ModItems.STRAWBERRY.get(), "\u041a\u043b\u0443\u0431\u043d\u0438\u043a\u0430");
                this.add((Item)ModItems.PLATE_GOLD.get(), "\u0417\u043e\u043b\u043e\u0442\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_GUNMETAL.get(), "\u041f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 \u043f\u0443\u0448\u0435\u0447\u043d\u043e\u0439 \u0431\u0440\u043e\u043d\u0437\u044b");
                this.add((Item)ModItems.PLATE_TITANIUM.get(), "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_GUNSTEEL.get(), "\u041f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 \u043e\u0440\u0443\u0436\u0435\u0439\u043d\u043e\u0439 \u0441\u0442\u0430\u043b\u0438");
                this.add((Item)ModItems.PLATE_IRON.get(), "\u0416\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_KEVLAR.get(), "\u041a\u0435\u0432\u043b\u0430\u0440\u043e\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_LEAD.get(), "\u0421\u0432\u0438\u043d\u0446\u043e\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_MIXED.get(), "\u041a\u043e\u043c\u043f\u043e\u0437\u0438\u0442\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_PAA.get(), "\u041f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 \u0441\u043f\u043b\u0430\u0432\u0430 \u0420\u0430\u0410");
                this.add((Item)ModItems.PLATE_SATURNITE.get(), "\u0421\u0430\u0442\u0443\u0440\u043d\u0438\u0442\u043e\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_SCHRABIDIUM.get(), "\u0428\u0440\u0430\u0431\u0438\u0434\u0438\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_STEEL.get(), "\u0421\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_ADVANCED_ALLOY.get(), "\u041f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 \u0438\u0437 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u043e\u0433\u043e \u0441\u043f\u043b\u0430\u0432\u0430");
                this.add((Item)ModItems.PLATE_ALUMINUM.get(), "\u0410\u043b\u044e\u043c\u0438\u043d\u0438\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_COPPER.get(), "\u041c\u0435\u0434\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_BISMUTH.get(), "\u0412\u0438\u0441\u043c\u0443\u0442\u043e\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_ARMOR_AJR.get(), "\u0411\u0440\u043e\u043d\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 AJR");
                this.add((Item)ModItems.PLATE_ARMOR_DNT.get(), "\u0411\u0440\u043e\u043d\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 DNT");
                this.add((Item)ModItems.PLATE_ARMOR_DNT_RUSTED.get(), "\u0420\u0436\u0430\u0432\u0430\u044f \u0431\u0440\u043e\u043d\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 DNT");
                this.add((Item)ModItems.PLATE_ARMOR_FAU.get(), "\u0411\u0440\u043e\u043d\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 FAU");
                this.add((Item)ModItems.PLATE_ARMOR_HEV.get(), "\u0411\u0440\u043e\u043d\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 HEV");
                this.add((Item)ModItems.PLATE_ARMOR_LUNAR.get(), "\u041b\u0443\u043d\u043d\u0430\u044f \u0431\u0440\u043e\u043d\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_ARMOR_TITANIUM.get(), "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u0431\u0440\u043e\u043d\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_CAST.get(), "\u041b\u0438\u0442\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_CAST_ALT.get(), "\u0410\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u0430\u044f \u043b\u0438\u0442\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_CAST_BISMUTH.get(), "\u0412\u0438\u0441\u043c\u0443\u0442\u043e\u0432\u0430\u044f \u043b\u0438\u0442\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_CAST_DARK.get(), "\u0422\u0451\u043c\u043d\u0430\u044f \u043b\u0438\u0442\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_COMBINE_STEEL.get(), "\u041f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 \u0438\u0437 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0439 \u0441\u0442\u0430\u043b\u0438");
                this.add((Item)ModItems.PLATE_DURA_STEEL.get(), "\u041f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 \u0438\u0437 \u043f\u0440\u043e\u0447\u043d\u043e\u0439 \u0441\u0442\u0430\u043b\u0438");
                this.add((Item)ModItems.PLATE_DALEKANIUM.get(), "\u0414\u0430\u043b\u0435\u043a\u0430\u043d\u0438\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_DESH.get(), "\u0414\u0435\u0448\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_DINEUTRONIUM.get(), "\u0414\u0438\u043d\u0435\u0439\u0442\u0440\u043e\u043d\u0438\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_EUPHEMIUM.get(), "\u042d\u0443\u0444\u0435\u043c\u0438\u0435\u0432\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add((Item)ModItems.PLATE_FUEL_MOX.get(), "\u0422\u043e\u043f\u043b\u0438\u0432\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 MOX");
                this.add((Item)ModItems.PLATE_FUEL_PU238BE.get(), "\u0422\u043e\u043f\u043b\u0438\u0432\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 Pu-238/Be");
                this.add((Item)ModItems.PLATE_FUEL_PU239.get(), "\u0422\u043e\u043f\u043b\u0438\u0432\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 Pu-239");
                this.add((Item)ModItems.PLATE_FUEL_RA226BE.get(), "\u0422\u043e\u043f\u043b\u0438\u0432\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 Ra-226/Be");
                this.add((Item)ModItems.PLATE_FUEL_SA326.get(), "\u0422\u043e\u043f\u043b\u0438\u0432\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 SA-326");
                this.add((Item)ModItems.PLATE_FUEL_U233.get(), "\u0422\u043e\u043f\u043b\u0438\u0432\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 U-233");
                this.add((Item)ModItems.PLATE_FUEL_U235.get(), "\u0422\u043e\u043f\u043b\u0438\u0432\u043d\u0430\u044f \u043f\u043b\u0430\u0441\u0442\u0438\u043d\u0430 U-235");
                this.add("item.hbm_m.firebrick", "\u0428\u0430\u043c\u043e\u0442\u043d\u044b\u0439 \u043a\u0438\u0440\u043f\u0438\u0447");
                this.add("item.hbm_m.uranium_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u0443\u0440\u0430\u043d");
                this.add("item.hbm_m.tungsten_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u0432\u043e\u043b\u044c\u0444\u0440\u0430\u043c");
                this.add("item.hbm_m.titanium_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u0442\u0438\u0442\u0430\u043d");
                this.add("item.hbm_m.thorium_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u0442\u043e\u0440\u0438\u0439");
                this.add("item.hbm_m.lead_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u0441\u0432\u0438\u043d\u0435\u0446");
                this.add("item.hbm_m.cobalt_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u043a\u043e\u0431\u0430\u043b\u044c\u0442");
                this.add("item.hbm_m.beryllium_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u0431\u0435\u0440\u0438\u043b\u043b\u0438\u0439");
                this.add("item.hbm_m.aluminum_raw", "\u0420\u0443\u0434\u043d\u044b\u0439 \u0430\u043b\u044e\u043c\u0438\u043d\u0438\u0439");
                this.add("item.hbm_m.cinnabar", "\u041a\u0438\u043d\u043e\u0432\u0430\u0440\u044c");
                this.add("item.hbm_m.sulfur", "\u0421\u0435\u0440\u0430");
                this.add("item.hbm_m.rareground_ore_chunk", "\u041a\u0443\u0441\u043e\u043a \u0440\u0435\u0434\u043a\u043e\u0437\u0435\u043c\u0435\u043b\u044c\u043d\u043e\u0439 \u0440\u0443\u0434\u044b");
                this.add("item.hbm_m.lignite", "\u0411\u0443\u0440\u044b\u0439 \u0443\u0433\u043e\u043b\u044c");
                this.add("item.hbm_m.fluorite", "\u0424\u043b\u044e\u043e\u0440\u0438\u0442");
                this.add("item.hbm_m.fireclay_ball", "\u041a\u043e\u043c\u043e\u043a \u043e\u0433\u043d\u0435\u0443\u043f\u043e\u0440\u043d\u043e\u0439 \u0433\u043b\u0438\u043d\u044b");
                this.add("item.hbm_m.blueprint_folder", "\u041f\u0430\u043f\u043a\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432");
                this.add("item.hbm_m.blueprint_folder.named", "\u041f\u0430\u043f\u043a\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u043c\u0430\u0448\u0438\u043d");
                this.add("item.hbm_m.blueprint_folder.empty", "\u041f\u0443\u0441\u0442\u0430\u044f \u043f\u0430\u043f\u043a\u0430");
                this.add("item.hbm_m.blueprint_folder.obsolete", "\u0423\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0439 \u0448\u0430\u0431\u043b\u043e\u043d (\u0433\u0440\u0443\u043f\u043f\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430)");
                this.add("item.hbm_m.blueprint_folder.desc", "\u0412\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0432 \u0421\u0431\u043e\u0440\u043e\u0447\u043d\u0443\u044e \u043c\u0430\u0448\u0438\u043d\u0443 \u0434\u043b\u044f \u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0440\u0435\u0446\u0435\u043f\u0442\u043e\u0432");
                this.add("item.hbm_m.blueprint_folder.recipes", "\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0440\u0435\u0446\u0435\u043f\u0442\u044b:");
                this.add("gui.hbm_m.recipe_from_group", "\u0418\u0437 \u0433\u0440\u0443\u043f\u043f\u044b:");
                this.add("sounds.hbm_m.radaway_use", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u043d\u0442\u0438\u0440\u0430\u0434\u0438\u043d\u0430");
                this.add("tooltip.hbm_m.mods", "\u041c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438:");
                this.add("tooltip.hbm_m.heart_piece.effect", "+5 \u0417\u0434\u043e\u0440\u043e\u0432\u044c\u044f");
                this.add("tooltip.hbm_m.applies_to", "\u041f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u043a:");
                this.add("tooltip.hbm_m.helmet", "\u0428\u043b\u0435\u043c\u0443");
                this.add("tooltip.hbm_m.chestplate", "\u041d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a\u0443");
                this.add("tooltip.hbm_m.leggings", "\u041f\u043e\u043d\u043e\u0436\u0430\u043c");
                this.add("tooltip.hbm_m.boots", "\u0411\u043e\u0442\u0438\u043d\u043a\u0430\u043c");
                this.add("tooltip.hbm_m.armor.all", "\u041b\u044e\u0431\u043e\u0439 \u0431\u0440\u043e\u043d\u0435");
                this.add("tooltip.hbm_m.rad_protection.value_short", "%s \u0441\u043e\u043f\u0440. \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438.");
                this.add("gui.hbm_m.blast_furnace.accepts", "\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b: %s");
                this.add("direction.hbm_m.down", "\u0412\u043d\u0438\u0437");
                this.add("direction.hbm_m.up", "\u0412\u0432\u0435\u0440\u0445");
                this.add("direction.hbm_m.north", "\u0421\u0435\u0432\u0435\u0440");
                this.add("direction.hbm_m.south", "\u042e\u0433");
                this.add("direction.hbm_m.west", "\u0417\u0430\u043f\u0430\u0434");
                this.add("direction.hbm_m.east", "\u0412\u043e\u0441\u0442\u043e\u043a");
                this.add("gui.hbm_m.anvil.inputs", "\u0412\u0445\u043e\u0434\u044b:");
                this.add("gui.hbm_m.anvil.outputs", "\u0412\u044b\u0445\u043e\u0434\u044b:");
                this.add("gui.hbm_m.anvil.search", "\u041f\u043e\u0438\u0441\u043a");
                this.add("gui.hbm_m.anvil.search_hint", "\u041f\u043e\u0438\u0441\u043a...");
                this.add("gui.hbm_m.anvil.tier", "\u0422\u0440\u0435\u0431\u0443\u0435\u043c\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c: %s");
                this.add("tier.hbm_m.anvil.iron", "\u0416\u0435\u043b\u0435\u0437\u043e");
                this.add("tier.hbm_m.anvil.steel", "\u0421\u0442\u0430\u043b\u044c");
                this.add("tier.hbm_m.anvil.oil", "\u041d\u0435\u0444\u0442\u044f\u043d\u043e\u0439");
                this.add("tier.hbm_m.anvil.nuclear", "\u042f\u0434\u0435\u0440\u043d\u044b\u0439");
                this.add("tier.hbm_m.anvil.rbmk", "\u0420\u0411\u041c\u041a");
                this.add("tier.hbm_m.anvil.fusion", "\u0422\u0435\u0440\u043c\u043e\u044f\u0434\u0435\u0440\u043d\u044b\u0439");
                this.add("tier.hbm_m.anvil.particle", "\u0427\u0430\u0441\u0442\u0438\u0447\u043d\u044b\u0439 \u0443\u0441\u043a\u043e\u0440\u0438\u0442\u0435\u043b\u044c");
                this.add("tier.hbm_m.anvil.gerald", "\u0414\u0436\u0435\u0440\u0430\u043b\u044c\u0434");
                this.add("tier.hbm_m.anvil.murky", "\u041c\u0440\u0430\u0447\u043d\u044b\u0439");
                this.add((Block)ModBlocks.RESOURCE_ASBESTOS.get(), "\u0410\u0441\u0431\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u043a\u043b\u0430\u0441\u0442\u0435\u0440");
                this.add((Block)ModBlocks.RESOURCE_BAUXITE.get(), "\u0411\u043e\u043a\u0441\u0438\u0442");
                this.add((Block)ModBlocks.RESOURCE_HEMATITE.get(), "\u0413\u0435\u043c\u0430\u0442\u0438\u0442");
                this.add((Block)ModBlocks.RESOURCE_LIMESTONE.get(), "\u0418\u0437\u0432\u0435\u0441\u0442\u043d\u044f\u043a");
                this.add((Block)ModBlocks.RESOURCE_MALACHITE.get(), "\u041c\u0430\u043b\u0430\u0445\u0438\u0442");
                this.add((Block)ModBlocks.RESOURCE_SULFUR.get(), "\u0421\u0435\u0440\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0442\u0435\u0440");
                this.add("block.hbm_m.anvil_block", "\u0418\u043d\u0434\u0443\u0441\u0442\u0440\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.anvil_iron", "\u0416\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.anvil_lead", "\u0421\u0432\u0438\u043d\u0446\u043e\u0432\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.anvil_steel", "\u0421\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.anvil_desh", "\u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f \u0438\u0437 \u0434\u0435\u0448\u0430");
                this.add("block.hbm_m.anvil_ferrouranium", "\u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f \u0438\u0437 \u0444\u0435\u0440\u0440\u043e\u0443\u0440\u0430\u043d\u0438\u044f");
                this.add("block.hbm_m.anvil_saturnite", "\u0421\u0430\u0442\u0443\u0440\u043d\u0438\u0442\u043e\u0432\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.anvil_bismuth_bronze", "\u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f \u0438\u0437 \u0432\u0438\u0441\u043c\u0443\u0442\u043e\u0432\u043e\u0439 \u0431\u0440\u043e\u043d\u0437\u044b");
                this.add("block.hbm_m.anvil_arsenic_bronze", "\u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f \u0438\u0437 \u043c\u044b\u0448\u044c\u044f\u043a\u043e\u0432\u043e\u0439 \u0431\u0440\u043e\u043d\u0437\u044b");
                this.add("block.hbm_m.anvil_schrabidate", "\u0428\u0440\u0430\u0431\u0438\u0434\u0430\u0442\u043e\u0432\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.anvil_dnt", "\u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f DNT");
                this.add("block.hbm_m.anvil_osmiridium", "\u041e\u0441\u043c\u0438\u0440\u0438\u0434\u0438\u0435\u0432\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.anvil_murky", "\u041c\u0440\u0430\u0447\u043d\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("block.hbm_m.door_office", "\u041e\u0444\u0438\u0441\u043d\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add("block.hbm_m.door_bunker", "\u0411\u0443\u043d\u043a\u0435\u0440\u043d\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add("block.hbm_m.metal_door", "\u041c\u0435\u0442\u0430\u043b\u043b\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add("block.hbm_m.demon_lamp", "\u041c\u0438\u043b\u0430\u044f \u043b\u0430\u043c\u043f\u0430 (WIP)");
                this.add("block.hbm_m.explosive_charge", "\u0417\u0430\u0440\u044f\u0434 \u0432\u0437\u0440\u044b\u0432\u0447\u0430\u0442\u043a\u0438");
                this.add("block.hbm_m.det_miner", "\u0428\u0430\u0445\u0442\u0451\u0440\u0441\u043a\u0438\u0439 \u0437\u0430\u0440\u044f\u0434");
                this.add("block.hbm_m.concrete_vent", "\u0412\u0435\u043d\u0442\u0438\u043b\u044f\u0446\u0438\u044f \u0432 \u0431\u0435\u0442\u043e\u043d\u0435");
                this.add("block.hbm_m.concrete_fan", "\u0412\u0435\u043d\u0442\u0438\u043b\u044f\u0442\u043e\u0440 \u0432 \u0431\u0435\u0442\u043e\u043d\u0435");
                this.add("block.hbm_m.concrete_marked", "\u041f\u043e\u043c\u0435\u0447\u0435\u043d\u043d\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add("block.hbm_m.concrete_cracked", "\u041f\u043e\u0442\u0440\u0435\u0441\u043a\u0430\u0432\u0448\u0438\u0439\u0441\u044f \u0431\u0435\u0442\u043e\u043d");
                this.add("block.hbm_m.concrete_mossy", "\u0417\u0430\u043c\u0448\u0435\u043b\u044b\u0439 \u0431\u0435\u0442\u043e\u043d");
                this.add("block.hbm_m.concrete", "\u0411\u0435\u0442\u043e\u043d");
                this.add("block.hbm_m.reinforced_glass", "\u0423\u0441\u0438\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u0442\u0435\u043a\u043b\u043e");
                this.add("block.hbm_m.crate", "\u042f\u0449\u0438\u043a");
                this.add("block.hbm_m.crate_lead", "\u0421\u0432\u0438\u043d\u0446\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a");
                this.add("block.hbm_m.crate_metal", "\u041c\u0435\u0442\u0430\u043b\u043b\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u044f\u0449\u0438\u043a");
                this.add("block.hbm_m.crate_weapon", "\u042f\u0449\u0438\u043a \u0441 \u043e\u0440\u0443\u0436\u0438\u0435\u043c");
                this.add("block.hbm_m.uranium_block", "\u0423\u0440\u0430\u043d\u043e\u0432\u044b\u0439 \u0431\u043b\u043e\u043a");
                this.add("block.hbm_m.plutonium_block", "\u041f\u043b\u0443\u0442\u043e\u043d\u0438\u0435\u0432\u044b\u0439 \u0431\u043b\u043e\u043a");
                this.add("block.hbm_m.plutonium_fuel_block", "\u0411\u043b\u043e\u043a \u043f\u043b\u0443\u0442\u043e\u043d\u0438\u0435\u0432\u043e\u0433\u043e \u0442\u043e\u043f\u043b\u0438\u0432\u0430");
                this.add("block.hbm_m.polonium210_block", "\u0411\u043b\u043e\u043a \u043f\u043e\u043b\u043e\u043d\u0438\u044f-210");
                this.add("block.hbm_m.armor_table", "\u0421\u0442\u043e\u043b \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0431\u0440\u043e\u043d\u0438");
                this.add("block.hbm_m.machine_assembler", "\u0421\u0431\u043e\u0440\u043e\u0447\u043d\u0430\u044f \u043c\u0430\u0448\u0438\u043d\u0430 (\u0421\u0442\u0430\u0440\u0430\u044f)");
                this.add("block.hbm_m.advanced_assembly_machine", "\u0421\u0431\u043e\u0440\u043e\u0447\u043d\u0430\u044f \u043c\u0430\u0448\u0438\u043d\u0430");
                this.add("block.hbm_m.machine_battery", "\u042d\u043d\u0435\u0440\u0433\u043e\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
                this.add("block.hbm_m.wire_coated", "\u041f\u0440\u043e\u0432\u043e\u0434 \u0438\u0437 \u043a\u0440\u0430\u0441\u043d\u043e\u0439 \u043c\u0435\u0434\u0438");
                this.add("block.hbm_m.wood_burner", "\u0414\u0440\u043e\u0432\u044f\u043d\u043e\u0439 \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440");
                this.add("block.hbm_m.shredder", "\u0418\u0437\u043c\u0435\u043b\u044c\u0447\u0438\u0442\u0435\u043b\u044c");
                this.add("block.hbm_m.blast_furnace", "\u0414\u043e\u043c\u0435\u043d\u043d\u0430\u044f \u043f\u0435\u0447\u044c");
                this.add("block.hbm_m.blast_furnace_extension", "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0439 \u043f\u0435\u0447\u0438");
                this.add("block.hbm_m.press", "\u041f\u0440\u0435\u0441\u0441");
                this.add("block.hbm_m.geiger_counter_block", "\u0421\u0442\u0430\u0446\u0438\u043e\u043d\u0430\u0440\u043d\u044b\u0439 \u0441\u0447\u0435\u0442\u0447\u0438\u043a \u0413\u0435\u0439\u0433\u0435\u0440\u0430");
                this.add("block.hbm_m.freaky_alien_block", "\u0411\u043b\u043e\u043a \u0435\u0431\u0430\u043d\u0443\u0442\u043e\u0433\u043e \u0438\u043d\u043e\u043f\u043b\u0430\u043d\u0435\u0442\u044f\u043d\u0438\u043d\u0430");
                this.add("block.hbm_m.reinforced_stone", "\u0423\u043f\u043b\u043e\u0442\u043d\u0451\u043d\u043d\u044b\u0439 \u043a\u0430\u043c\u0435\u043d\u044c");
                this.add("block.hbm_m.reinforced_stone_slab", "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0443\u043f\u043b\u043e\u0442\u043d\u0451\u043d\u043d\u043e\u0433\u043e \u043a\u0430\u043c\u043d\u044f");
                this.add("block.hbm_m.reinforced_stone_stairs", "\u0421\u0442\u0443\u043f\u0435\u043d\u044c\u043a\u0438 \u0438\u0437 \u0443\u043f\u043b\u043e\u0442\u043d\u0451\u043d\u043d\u043e\u0433\u043e \u043a\u0430\u043c\u043d\u044f");
                this.add("block.hbm_m.concrete_hazard", "\u0411\u0435\u0442\u043e\u043d ''\u0412\u044b\u0431\u043e\u0440 \u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044f'' - \u041f\u043e\u043b\u043e\u0441\u0430 \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438");
                this.add("block.hbm_m.concrete_hazard_slab", "\u0411\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430 ''\u0412\u044b\u0431\u043e\u0440 \u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044f'' - \u041f\u043e\u043b\u043e\u0441\u0430 \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438");
                this.add("block.hbm_m.concrete_hazard_stairs", "\u0411\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u044c\u043a\u0438 ''\u0412\u044b\u0431\u043e\u0440 \u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044f'' - \u041f\u043e\u043b\u043e\u0441\u0430 \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438");
                this.add("block.hbm_m.concrete_stairs", "\u0411\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u0441\u0442\u0443\u043f\u0435\u043d\u044c\u043a\u0438");
                this.add("block.hbm_m.concrete_slab", "\u0411\u0435\u0442\u043e\u043d\u043d\u0430\u044f \u043f\u043b\u0438\u0442\u0430");
                this.add("block.hbm_m.concrete_cracked_slab", "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0442\u0440\u0435\u0441\u043d\u0443\u0442\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add("block.hbm_m.concrete_cracked_stairs", "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0442\u0440\u0435\u0441\u043d\u0443\u0442\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add("block.hbm_m.concrete_mossy_slab", "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0437\u0430\u043c\u0448\u0435\u043b\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add("block.hbm_m.concrete_mossy_stairs", "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0437\u0430\u043c\u0448\u0435\u043b\u043e\u0433\u043e \u0431\u0435\u0442\u043e\u043d\u0430");
                this.add("block.hbm_m.switch", "\u0420\u0443\u0431\u0438\u043b\u044c\u043d\u0438\u043a");
                this.add("block.hbm_m.large_vehicle_door", "\u0414\u0432\u0435\u0440\u044c \u0434\u043b\u044f \u043a\u0440\u0443\u043f\u043d\u043e\u0433\u0430\u0431\u0430\u0440\u0438\u0442\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430");
                this.add("block.hbm_m.round_airlock_door", "\u041a\u0440\u0443\u0433\u043b\u0430\u044f \u0432\u043e\u0437\u0434\u0443\u0448\u043d\u0430\u044f \u0434\u0432\u0435\u0440\u044c");
                this.add("block.hbm_m.strawberry_bush", "\u041a\u0443\u0441\u0442 \u043a\u043b\u0443\u0431\u043d\u0438\u043a\u0438");
                this.add("block.hbm_m.strawberry", "\u041a\u043b\u0443\u0431\u043d\u0438\u043a\u0430");
                this.add("block.hbm_m.brick_concrete", "\u0411\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add("block.hbm_m.brick_concrete_slab", "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_stairs", "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_broken", "\u0421\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add("block.hbm_m.brick_concrete_broken_slab", "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0441\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u0445 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_broken_stairs", "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0441\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u0445 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_cracked", "\u0422\u0440\u0435\u0441\u043d\u0443\u0442\u044b\u0435 \u0411\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add("block.hbm_m.brick_concrete_cracked_slab", "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0442\u0440\u0435\u0441\u043d\u0443\u0442\u044b\u0445 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_cracked_stairs", "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0442\u0440\u0435\u0441\u043d\u0443\u0442\u044b\u0445 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_mossy", "\u0417\u0430\u043c\u0448\u0435\u043b\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add("block.hbm_m.brick_concrete_mossy_slab", "\u041f\u043b\u0438\u0442\u0430 \u0438\u0437 \u0437\u0430\u043c\u0448\u0435\u043b\u044b\u0445 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_mossy_stairs", "\u0421\u0442\u0443\u043f\u0435\u043d\u0438 \u0438\u0437 \u0437\u0430\u043c\u0448\u0435\u043b\u044b\u0445 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0445 \u043a\u0438\u0440\u043f\u0438\u0447\u0435\u0439");
                this.add("block.hbm_m.brick_concrete_marked", "\u041f\u043e\u043c\u0435\u0447\u0435\u043d\u043d\u044b\u0435 \u0431\u0435\u0442\u043e\u043d\u043d\u044b\u0435 \u043a\u0438\u0440\u043f\u0438\u0447\u0438");
                this.add("block.hbm_m.uranium_ore", "\u0423\u0440\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.aluminum_ore", "\u0410\u043b\u044e\u043c\u0438\u043d\u0438\u0435\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.aluminum_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0430\u043b\u044e\u043c\u0438\u043d\u0438\u0435\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.cinnabar_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u043a\u0438\u043d\u043e\u0432\u0430\u0440\u043d\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.cobalt_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u043a\u043e\u0431\u0430\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.titanium_ore", "\u0422\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.titanium_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0442\u0438\u0442\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.tungsten_ore", "\u0412\u043e\u043b\u044c\u0444\u0440\u0430\u043c\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.asbestos_ore", "\u0410\u0441\u0431\u0435\u0441\u0442\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.sulfur_ore", "\u0421\u0435\u0440\u043d\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.cobalt_ore", "\u041a\u043e\u0431\u0430\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.lignite_ore", "\u0420\u0443\u0434\u0430 \u0431\u0443\u0440\u043e\u0433\u043e \u0443\u0433\u043b\u044f");
                this.add("block.hbm_m.uranium_ore_h", "\u041e\u0431\u043e\u0433\u0430\u0449\u0451\u043d\u043d\u0430\u044f \u0443\u0440\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.uranium_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0443\u0440\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.thorium_ore", "\u0422\u043e\u0440\u0438\u0435\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.thorium_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0442\u043e\u0440\u0438\u0435\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.rareground_ore", "\u0420\u0443\u0434\u0430 \u0440\u0435\u0434\u043a\u043e\u0437\u0435\u043c\u0435\u043b\u044c\u043d\u044b\u0445 \u043c\u0435\u0442\u0430\u043b\u043b\u043e\u0432");
                this.add("block.hbm_m.rareground_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0440\u0443\u0434\u0430 \u0440\u0435\u0434\u043a\u043e\u0437\u0435\u043c\u0435\u043b\u044c\u043d\u044b\u0445 \u043c\u0435\u0442\u0430\u043b\u043b\u043e\u0432");
                this.add("block.hbm_m.beryllium_ore", "\u0411\u0435\u0440\u0438\u043b\u043b\u0438\u0435\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.beryllium_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0431\u0435\u0440\u0438\u043b\u043b\u0438\u0435\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.fluorite_ore", "\u0424\u043b\u044e\u043e\u0440\u0438\u0442\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.lead_ore", "\u0421\u0432\u0438\u043d\u0446\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.lead_ore_deepslate", "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u0430\u044f \u0441\u0432\u0438\u043d\u0446\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.cinnabar_ore", "\u041a\u0438\u043d\u043e\u0432\u0430\u0440\u043d\u0430\u044f \u0440\u0443\u0434\u0430");
                this.add("block.hbm_m.crate_iron", "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u044f\u0449\u0438\u043a");
                this.add("block.hbm_m.crate_steel", "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u044f\u0449\u0438\u043a");
                this.add("block.hbm_m.crate_desh", "\u0414\u0435\u0448 \u044f\u0449\u0438\u043a");
                this.add("block.hbm_m.waste_grass", "\u041c\u0451\u0440\u0442\u0432\u0430\u044f \u0442\u0440\u0430\u0432\u0430");
                this.add("block.hbm_m.waste_leaves", "\u041c\u0451\u0440\u0442\u0432\u0430\u044f \u043b\u0438\u0441\u0442\u0432\u0430");
                this.add("tooltip.hbm_m.armor_table.main_slot", "\u0412\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0431\u0440\u043e\u043d\u044e, \u0447\u0442\u043e\u0431\u044b \u0435\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c...");
                this.add("tooltip.hbm_m.slot", "\u0421\u043b\u043e\u0442");
                this.add("tooltip.hbm_m.armor_table.helmet_slot", "\u0428\u043b\u0435\u043c");
                this.add("tooltip.hbm_m.armor_table.chestplate_slot", "\u041d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a");
                this.add("tooltip.hbm_m.armor_table.leggings_slot", "\u041f\u043e\u043d\u043e\u0436\u0438");
                this.add("tooltip.hbm_m.armor_table.boots_slot", "\u0411\u043e\u0442\u0438\u043d\u043a\u0438");
                this.add("tooltip.hbm_m.armor_table.battery_slot", "\u0410\u043a\u043a\u0443\u043c\u0443\u043b\u044f\u0442\u043e\u0440");
                this.add("tooltip.hbm_m.armor_table.special_slot", "\u041e\u0441\u043e\u0431\u043e\u0435");
                this.add("tooltip.hbm_m.armor_table.plating_slot", "\u041f\u043b\u0430\u0441\u0442\u0438\u043d\u0430");
                this.add("tooltip.hbm_m.armor_table.casing_slot", "\u041e\u0431\u0448\u0438\u0432\u043a\u0430");
                this.add("tooltip.hbm_m.armor_table.servos_slot", "\u0421\u0435\u0440\u0432\u043e\u043f\u0440\u0438\u0432\u043e\u0434\u044b");
                this.add("tooltip.hbm_m.rad_protection.value", "\u0421\u043e\u043f\u0440\u043e\u0442\u0438\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438: %s");
                this.add("container.inventory", "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c");
                this.add("container.hbm_m.armor_table", "\u0421\u0442\u043e\u043b \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0431\u0440\u043e\u043d\u0438");
                this.add("container.hbm_m.machine_assembler", "\u0421\u0431\u043e\u0440\u043e\u0447\u043d\u0430\u044f \u043c\u0430\u0448\u0438\u043d\u0430");
                this.add("container.hbm_m.advanced_assembly_machine", "\u0421\u0431\u043e\u0440\u043e\u0447\u043d\u0430\u044f \u043c\u0430\u0448\u0438\u043d\u0430");
                this.add("container.hbm_m.wood_burner", "\u0414\u0440\u043e\u0432\u044f\u043d\u043e\u0439 \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440");
                this.add("container.hbm_m.machine_battery", "\u042d\u043d\u0435\u0440\u0433\u043e\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
                this.add("container.hbm_m.press", "\u041f\u0440\u0435\u0441\u0441");
                this.add("container.hbm_m.anvil_block", "\u0418\u043d\u0434\u0443\u0441\u0442\u0440\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u043d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f");
                this.add("container.hbm_m.anvil", "\u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f %s");
                this.add("container.hbm_m.crate_iron", "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u044f\u0449\u0438\u043a");
                this.add("container.hbm_m.crate_steel", "\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u044f\u0449\u0438\u043a");
                this.add("container.hbm_m.crate_desh", "\u0414\u0443\u0448 \u044f\u0449\u0438\u043a");
                this.add("gui.hbm_m.battery.priority.0", "\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: \u041d\u0438\u0437\u043a\u0438\u0439");
                this.add("gui.hbm_m.battery.priority.0.desc", "\u041d\u0438\u0437\u0448\u0438\u0439 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442. \u041e\u043f\u0443\u0441\u0442\u043e\u0448\u0430\u0435\u0442\u0441\u044f \u0432 \u043f\u0435\u0440\u0432\u0443\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c, \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0432 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044e\u044e");
                this.add("gui.hbm_m.battery.priority.1", "\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: \u041d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439");
                this.add("gui.hbm_m.battery.priority.1.desc", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u044d\u043d\u0435\u0440\u0433\u0438\u0438.");
                this.add("gui.hbm_m.battery.priority.2", "\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: \u0412\u044b\u0441\u043e\u043a\u0438\u0439");
                this.add("gui.hbm_m.battery.priority.2.desc", "\u0412\u044b\u0441\u0448\u0438\u0439 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442. \u0417\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0432\u044b\u043c, \u043e\u043f\u0443\u0441\u0442\u043e\u0448\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u043c.");
                this.add("gui.hbm_m.battery.priority.recommended", "(\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f)");
                this.add("gui.hbm_m.battery.condition.no_signal", "\u041a\u043e\u0433\u0434\u0430 \u041d\u0415\u0422 \u0440\u0435\u0434\u0441\u0442\u043e\u0443\u043d-\u0441\u0438\u0433\u043d\u0430\u043b\u0430:");
                this.add("gui.hbm_m.battery.condition.with_signal", "\u041a\u043e\u0433\u0434\u0430 \u0415\u0421\u0422\u042c \u0440\u0435\u0434\u0441\u0442\u043e\u0443\u043d-\u0441\u0438\u0433\u043d\u0430\u043b:");
                this.add("gui.hbm_m.battery.mode.both", "\u0420\u0435\u0436\u0438\u043c: \u041f\u0440\u0438\u0451\u043c \u0438 \u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430");
                this.add("gui.hbm_m.battery.mode.both.desc", "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b \u0432\u0441\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439.");
                this.add("gui.hbm_m.battery.mode.input", "\u0420\u0435\u0436\u0438\u043c: \u0422\u043e\u043b\u044c\u043a\u043e \u041f\u0440\u0438\u0451\u043c");
                this.add("gui.hbm_m.battery.mode.input.desc", "\u0420\u0430\u0437\u0440\u0435\u0448\u0451\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438\u0451\u043c \u044d\u043d\u0435\u0440\u0433\u0438\u0438.");
                this.add("gui.hbm_m.battery.mode.output", "\u0420\u0435\u0436\u0438\u043c: \u0422\u043e\u043b\u044c\u043a\u043e \u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430");
                this.add("gui.hbm_m.battery.mode.output.desc", "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442\u0434\u0430\u0447\u0430 \u044d\u043d\u0435\u0440\u0433\u0438\u0438.");
                this.add("gui.hbm_m.battery.mode.locked", "\u0420\u0435\u0436\u0438\u043c: \u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
                this.add("gui.hbm_m.battery.mode.locked.desc", "\u0412\u0441\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u044b.");
                this.add("gui.recipe.setRecipe", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0440\u0435\u0446\u0435\u043f\u0442");
                this.add("tooltip.hbm_m.battery.stored", "\u0425\u0440\u0430\u043d\u0438\u0442\u0441\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u0438:");
                this.add("tooltip.hbm_m.battery.transfer_rate", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0437\u0430\u0440\u044f\u0434\u043a\u0438: %1$s HE/t");
                this.add("tooltip.hbm_m.battery.discharge_rate", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0437\u0440\u044f\u0434\u043a\u0438: %1$s HE/t");
                this.add("tooltip.hbm_m.machine_battery.capacity", "\u0401\u043c\u043a\u043e\u0441\u0442\u044c: %1$s HE");
                this.add("tooltip.hbm_m.machine_battery.charge_speed", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0437\u0430\u0440\u044f\u0434\u043a\u0438: %1$s HE/\u0442");
                this.add("tooltip.hbm_m.machine_battery.discharge_speed", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0437\u0440\u044f\u0434\u043a\u0438: %1$s HE/\u0442");
                this.add("tooltip.hbm_m.machine_battery.stored", "\u0417\u0430\u0440\u044f\u0436\u0435\u043d\u043e: %1$s / %2$s HE");
                this.add("tooltip.hbm_m.requires", "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                this.add("hazard.hbm_m.radiation", "[\u0420\u0430\u0434\u0438\u043e\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439]");
                this.add("hazard.hbm_m.radiation.format", "%s \u0420\u0410\u0414/\u0441");
                this.add("hazard.hbm_m.hydro_reactive", "[\u0413\u0438\u0434\u0440\u043e\u0440\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439]");
                this.add("hazard.hbm_m.explosive_on_fire", "[\u0412\u043e\u0441\u043f\u043b\u0430\u043c\u0435\u043d\u044f\u044e\u0449\u0438\u0439\u0441\u044f / \u0412\u0437\u0440\u044b\u0432\u043e\u043e\u043f\u0430\u0441\u043d\u044b\u0439]");
                this.add("hazard.hbm_m.pyrophoric", "[\u041f\u0438\u0440\u043e\u0444\u043e\u0440\u043d\u044b\u0439 / \u0413\u043e\u0440\u044f\u0447\u0438\u0439]");
                this.add("hazard.hbm_m.explosion_strength.format", " \u0421\u0438\u043b\u0430 \u0432\u0437\u0440\u044b\u0432\u0430 - %s");
                this.add("hazard.hbm_m.stack", "\u0421\u0442\u0430\u043a: %s");
                this.add("item.hbm_m.meter.geiger_counter.name", "\u0421\u0427\u0401\u0422\u0427\u0418\u041a \u0413\u0415\u0419\u0413\u0415\u0420\u0410");
                this.add("item.hbm_m.meter.dosimeter.name", "\u0414\u041e\u0417\u0418\u041c\u0415\u0422\u0420");
                this.add("item.hbm_m.meter.title_format", "%s");
                this.add("hbm_m.render.shader_detected", "\u00a7e[HBM] \u00a77\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u0448\u0435\u0439\u0434\u0435\u0440. \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u0440\u0435\u043d\u0434\u0435\u0440...");
                this.add("hbm_m.render.shader_disabled", "\u00a7a[HBM] \u00a77\u0428\u0435\u0439\u0434\u0435\u0440 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d. \u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u043a \u043e\u043f\u0442\u0438\u043c\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u043c\u0443 VBO \u0440\u0435\u043d\u0434\u0435\u0440\u0443.");
                this.add("hbm_m.render.path_changed", "\u00a7e[HBM] \u00a77\u041f\u0443\u0442\u044c \u0440\u0435\u043d\u0434\u0435\u0440\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d: %s");
                this.add("hbm_m.render.status", "\u00a7e[HBM] \u00a77\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0443\u0442\u044c \u0440\u0435\u043d\u0434\u0435\u0440\u0430: \u00a7f%s\n\u00a77\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0448\u0435\u0439\u0434\u0435\u0440 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d: \u00a7f%s");
                this.add("tooltip.hbm_m.abilities", "\u0421\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u0438:");
                this.add("tooltip.hbm_m.vein_miner", "\u0416\u0438\u043b\u043a\u043e\u0432\u044b\u0439 \u043c\u0430\u0439\u043d\u0435\u0440 (%s)");
                this.add("tooltip.hbm_m.aoe", "\u0417\u043e\u043d\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f %s");
                this.add("tooltip.hbm_m.silk_touch", "\u0428\u0451\u043b\u043a\u043e\u0432\u043e\u0435 \u043a\u0430\u0441\u0430\u043d\u0438\u0435");
                this.add("tooltip.hbm_m.fortune", "\u0423\u0434\u0430\u0447\u0430 (%s)");
                this.add("tooltip.hbm_m.right_click", "\u041f\u041a\u041c - \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u044c");
                this.add("tooltip.hbm_m.shift_right_click", "Shift + \u041f\u041a\u041c - \u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u0441\u0451");
                this.add("message.hbm_m.vein_miner.enabled", "\u0416\u0438\u043b\u043a\u043e\u0432\u044b\u0439 \u043c\u0430\u0439\u043d\u0435\u0440 %s \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
                this.add("message.hbm_m.vein_miner.disabled", "\u0416\u0438\u043b\u043a\u043e\u0432\u044b\u0439 \u043c\u0430\u0439\u043d\u0435\u0440 %s \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
                this.add("message.hbm_m.aoe.enabled", "\u0417\u043e\u043d\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f %1$s x %1$s x %1$s \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
                this.add("message.hbm_m.aoe.disabled", "\u0417\u043e\u043d\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f %s x %s x %s \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
                this.add("message.hbm_m.silk_touch.enabled", "\u0428\u0451\u043b\u043a\u043e\u0432\u043e\u0435 \u043a\u0430\u0441\u0430\u043d\u0438\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e!");
                this.add("message.hbm_m.silk_touch.disabled", "\u0428\u0451\u043b\u043a\u043e\u0432\u043e\u0435 \u043a\u0430\u0441\u0430\u043d\u0438\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e!");
                this.add("message.hbm_m.fortune.enabled", "\u0423\u0434\u0430\u0447\u0430 %s \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
                this.add("message.hbm_m.fortune.disabled", "\u0423\u0434\u0430\u0447\u0430 %s \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
                this.add("message.hbm_m.disabled", "\u0412\u0441\u0435 \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u044b!");
                this.add("item.hbm_m.meter.chunk_rads", "\u00a7e\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0435: %s\n");
                this.add("item.hbm_m.meter.env_rads", "\u00a7e\u041e\u0431\u0449\u0435\u0435 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0435 \u0437\u0430\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441\u0440\u0435\u0434\u044b: %s");
                this.add("item.hbm_m.meter.player_rads", "\u00a7e\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0440\u0430\u0434\u0438\u043e\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0437\u0430\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0438\u0433\u0440\u043e\u043a\u0430: %s\n");
                this.add("item.hbm_m.meter.protection", "\u00a7e\u0417\u0430\u0449\u0438\u0449\u0451\u043d\u043d\u043e\u0441\u0442\u044c \u0438\u0433\u0440\u043e\u043a\u0430: %s (%s)");
                this.add("item.hbm_m.meter.rads_over_limit", ">%s RAD/s");
                this.add("tooltip.hbm_m.hold_shift_for_details", "<\u0417\u0430\u0436\u043c\u0438\u0442\u0435 SHIFT \u0434\u043b\u044f \u0434\u0435\u0442\u0430\u043b\u0435\u0439>");
                this.add("sounds.hbm_m.geiger_counter", "\u0429\u0435\u043b\u0447\u043a\u0438 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 \u0413\u0435\u0439\u0433\u0435\u0440\u0430");
                this.add("sounds.hbm_m.tool.techboop", "\u041f\u0438\u043a \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 \u0413\u0435\u0439\u0433\u0435\u0440\u0430");
                this.add("commands.hbm_m.rad.cleared", "\u0420\u0430\u0434\u0438\u0430\u0446\u0438\u044f \u043e\u0447\u0438\u0449\u0435\u043d\u0430 \u0443 %s \u0438\u0433\u0440\u043e\u043a\u043e\u0432.");
                this.add("commands.hbm_m.rad.cleared.self", "\u0412\u0430\u0448\u0430 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f \u043e\u0447\u0438\u0449\u0435\u043d\u0430.");
                this.add("commands.hbm_m.rad.added", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e %s \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 %s \u0438\u0433\u0440\u043e\u043a\u0430\u043c.");
                this.add("commands.hbm_m.rad.added.self", "\u0412\u0430\u043c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e %s \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438.");
                this.add("commands.hbm_m.rad.removed", "\u0423\u0431\u0440\u0430\u043d\u043e %s \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0443 %s \u0438\u0433\u0440\u043e\u043a\u043e\u0432.");
                this.add("commands.hbm_m.rad.removed.self", "\u0423 \u0432\u0430\u0441 \u0443\u0431\u0440\u0430\u043d\u043e %s \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438.");
                this.add("death.attack.radiation", "\u0418\u0433\u0440\u043e\u043a %s \u0443\u043c\u0435\u0440 \u043e\u0442 \u043b\u0443\u0447\u0435\u0432\u043e\u0439 \u0431\u043e\u043b\u0435\u0437\u043d\u0438");
                this.add("advancements.hbm_m.radiation_200.title", "\u0423\u0440\u0430, \u0420\u0430\u0434\u0438\u0430\u0446\u0438\u044f!");
                this.add("advancements.hbm_m.radiation_200.description", "\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442\u044c \u0443\u0440\u043e\u0432\u043d\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 200 \u0420\u0410\u0414");
                this.add("advancements.hbm_m.radiation_1000.title", "\u0410\u0439, \u0420\u0430\u0434\u0438\u0430\u0446\u0438\u044f!");
                this.add("advancements.hbm_m.radiation_1000.description", "\u0423\u043c\u0435\u0440\u0435\u0442\u044c \u043e\u0442 \u043b\u0443\u0447\u0435\u0432\u043e\u0439 \u0431\u043e\u043b\u0435\u0437\u043d\u0438");
                this.add("chat.hbm_m.structure.obstructed", "\u0414\u0440\u0443\u0433\u0438\u0435 \u0431\u043b\u043e\u043a\u0438 \u043c\u0435\u0448\u0430\u044e\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b!!");
                this.add("text.autoconfig.hbm_m.title", "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 (HBM Modernized)");
                this.add("text.autoconfig.hbm_m.category.general", "\u041e\u0431\u0449\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438");
                this.add("text.autoconfig.hbm_m.option.enableRadiation", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044e");
                this.add("text.autoconfig.hbm_m.option.enableChunkRads", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044e \u0432 \u0447\u0430\u043d\u043a\u0430\u0445");
                this.add("text.autoconfig.hbm_m.option.usePrismSystem", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u0443 PRISM (\u0438\u043d\u0430\u0447\u0435 Simple, WIP)");
                this.add("text.autoconfig.hbm_m.category.world_effects", "\u042d\u0444\u0444\u0435\u043a\u0442\u044b \u043c\u0438\u0440\u0430");
                this.add("text.autoconfig.hbm_m.option.worldRadEffects", "\u042d\u0444\u0444\u0435\u043a\u0442\u044b \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u043d\u0430 \u043c\u0438\u0440 (\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u043a\u043e\u0432)");
                this.add("text.autoconfig.hbm_m.option.worldRadEffects.@Tooltip", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u044d\u0444\u0444\u0435\u043a\u0442\u044b \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u043c\u0438\u0440\u0430 \u043e\u0442 \u0432\u044b\u0441\u043e\u043a\u043e\u0439 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 (\u0437\u0430\u043c\u0435\u043d\u0430 \u0431\u043b\u043e\u043a\u043e\u0432, \u0433\u0438\u0431\u0435\u043b\u044c \u0440\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0438 \u0442.\u0434.).");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsThreshold", "\u041f\u043e\u0440\u043e\u0433 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsThreshold.@Tooltip", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0444\u043e\u043d\u043e\u0432\u043e\u0439 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0435, \u043f\u0440\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043d\u0430\u0447\u0438\u043d\u0430\u044e\u0442\u0441\u044f \u044d\u0444\u0444\u0435\u043a\u0442\u044b \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f.");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsBlockChecks", "\u041f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0431\u043b\u043e\u043a\u043e\u0432 \u0432 \u0442\u0438\u043a");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsBlockChecks.@Tooltip", "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0445 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0431\u043b\u043e\u043a\u043e\u0432 \u0432 \u0437\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u043e\u043c \u0447\u0430\u043d\u043a\u0435 \u0437\u0430 \u043e\u0434\u0438\u043d \u0442\u0438\u043a. \u0412\u043b\u0438\u044f\u0435\u0442 \u043d\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f. \u0411\u043e\u043b\u044c\u0448\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043c\u043e\u0433\u0443\u0442 \u043f\u043e\u0432\u043b\u0438\u044f\u0442\u044c \u043d\u0430 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c.");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxScaling", "\u041c\u0430\u043a\u0441. \u043c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxScaling.@Tooltip", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u0441\u043a\u043e\u0440\u0435\u043d\u0438\u0435 \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u043c\u0438\u0440\u0430 \u043f\u0440\u0438 \u043f\u0438\u043a\u043e\u0432\u043e\u0439 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438. 1 = \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f, 4 = \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0434\u043e 4 \u0440\u0430\u0437 \u0432\u044b\u0448\u0435. \u041c\u0430\u043a\u0441 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - 10\u0445");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxDepth", "\u0413\u043b\u0443\u0431\u0438\u043d\u0430 \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxDepth.@Tooltip", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0433\u043b\u0443\u0431\u0438\u043d\u0430 (\u0432 \u0431\u043b\u043e\u043a\u0430\u0445) \u043e\u0442 \u043f\u043e\u0432\u0435\u0440\u0445\u043d\u043e\u0441\u0442\u0438, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u044f\u0442\u044c\u0441\u044f \u044d\u0444\u0444\u0435\u043a\u0442\u044b \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u043c\u0438\u0440\u0430.");
                this.add("text.autoconfig.hbm_m.option.enableRadFogEffect", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u044d\u0444\u0444\u0435\u043a\u0442 \u0440\u0430\u0434\u0438\u043e\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0442\u0443\u043c\u0430\u043d\u0430");
                this.add("text.autoconfig.hbm_m.option.enableRadFogEffect.@Tooltip", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0434\u0438\u043e\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0442\u0443\u043c\u0430\u043d\u0430 \u0432 \u0447\u0430\u043d\u043a\u0430\u0445 \u0441 \u0432\u044b\u0441\u043e\u043a\u0438\u043c \u0443\u0440\u043e\u0432\u043d\u0435\u043c \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438.");
                this.add("text.autoconfig.hbm_m.option.radFogThreshold", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u043c\u0430\u043d\u0430");
                this.add("text.autoconfig.hbm_m.option.radFogThreshold.@Tooltip", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0444\u043e\u043d\u043e\u0432\u043e\u0439 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0435, \u043f\u0440\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u044f\u0432\u0438\u0442\u044c\u0441\u044f \u0442\u0443\u043c\u0430\u043d.");
                this.add("text.autoconfig.hbm_m.option.radFogChance", "\u0428\u0430\u043d\u0441 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u043c\u0430\u043d\u0430");
                this.add("text.autoconfig.hbm_m.option.radFogChance.@Tooltip", "\u0428\u0430\u043d\u0441 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0447\u0430\u0441\u0442\u0438\u0446 \u0442\u0443\u043c\u0430\u043d\u0430 \u0432 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u043c \u0447\u0430\u043d\u043a\u0435 \u0437\u0430 \u0441\u0435\u043a\u0443\u043d\u0434\u0443. \u0420\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043a\u0430\u043a 1 \u043a X. \u0427\u0435\u043c \u043c\u0435\u043d\u044c\u0448\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u0442\u0435\u043c \u0447\u0430\u0449\u0435 \u043f\u043e\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0443\u043c\u0430\u043d.");
                this.add("text.autoconfig.hbm_m.category.player", "\u0418\u0433\u0440\u043e\u043a");
                this.add("text.autoconfig.hbm_m.option.maxPlayerRad", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0443 \u0438\u0433\u0440\u043e\u043a\u0430");
                this.add("text.autoconfig.hbm_m.option.radDecay", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0441\u043f\u0430\u0434\u0430 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0443 \u0438\u0433\u0440\u043e\u043a\u0430");
                this.add("text.autoconfig.hbm_m.option.radDamage", "\u0423\u0440\u043e\u043d \u043e\u0442 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438");
                this.add("text.autoconfig.hbm_m.option.radDamageThreshold", "\u041f\u043e\u0440\u043e\u0433 \u0443\u0440\u043e\u043d\u0430 \u043e\u0442 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438");
                this.add("text.autoconfig.hbm_m.option.radSickness", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u0442\u043e\u0448\u043d\u043e\u0442\u044b");
                this.add("text.autoconfig.hbm_m.option.radWater", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u043d\u0435\u0433\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u044d\u0444\u0444\u0435\u043a\u0442\u0430 \u0432\u043e\u0434\u044b, WIP");
                this.add("text.autoconfig.hbm_m.option.radConfusion", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u0437\u0430\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430, WIP");
                this.add("text.autoconfig.hbm_m.option.radBlindness", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u0441\u043b\u0435\u043f\u043e\u0442\u044b");
                this.add("text.autoconfig.hbm_m.category.overlay", "\u042d\u043a\u0440\u0430\u043d\u043d\u044b\u0435 \u043d\u0430\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
                this.add("text.autoconfig.hbm_m.option.enableRadiationPixelEffect", "\u042d\u043a\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u0444\u0444\u0435\u043a\u0442 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u043f\u043e\u043c\u0435\u0445");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectThreshold", "\u041f\u043e\u0440\u043e\u0433 \u0441\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u043d\u0438\u044f \u044d\u0444\u0444\u0435\u043a\u0442\u0430");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxIntensityRad", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0442\u0435\u043d\u0441\u0438\u0432\u043d\u043e\u0441\u0442\u044c \u044d\u0444\u0444\u0435\u043a\u0442\u0430");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectMaxDots", "\u041c\u0430\u043a\u0441. \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectGreenChance", "\u0428\u0430\u043d\u0441 \u0437\u0435\u043b\u0435\u043d\u043e\u0433\u043e \u043f\u0438\u043a\u0441\u0435\u043b\u044f");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMinLifetime", "\u041c\u0438\u043d. \u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043f\u0438\u043a\u0441\u0435\u043b\u044f");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxLifetime", "\u041c\u0430\u043a\u0441. \u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043f\u0438\u043a\u0441\u0435\u043b\u044f");
                this.add("text.autoconfig.hbm_m.option.enableObstructionHighlight", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0443 \u043f\u0440\u0435\u043f\u044f\u0442\u0441\u0442\u0432\u0438\u0439");
                this.add("text.autoconfig.hbm_m.option.enableObstructionHighlight.@Tooltip", "\u0415\u0441\u043b\u0438 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e, \u0431\u043b\u043e\u043a\u0438, \u043c\u0435\u0448\u0430\u044e\u0449\u0438\u0435 \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u044e \u043c\u0443\u043b\u044c\u0442\u0438\u0431\u043b\u043e\u043a\u0430, \n\u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u0434\u0441\u0432\u0435\u0447\u0438\u0432\u0430\u0442\u044c\u0441\u044f \u043a\u0440\u0430\u0441\u043d\u043e\u0439 \u0440\u0430\u043c\u043a\u043e\u0439.");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightDuration", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0438 (\u0441\u0435\u043a)");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightDuration.@Tooltip", "\u0412\u0440\u0435\u043c\u044f \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445, \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0431\u0443\u0434\u0435\u0442 \u0432\u0438\u0434\u043d\u0430 \u043f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0430 \u043f\u0440\u0435\u043f\u044f\u0442\u0441\u0442\u0432\u0438\u0439.");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightAlpha", "\u041d\u0435\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0438 \u043f\u0440\u0435\u043f\u044f\u0442\u0441\u0442\u0432\u0438\u0439");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightAlpha.@Tooltip", "\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u043d\u0435\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u043b\u0438\u0432\u043a\u0438 \u043f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0438.\n0% = \u041d\u0435\u0432\u0438\u0434\u0438\u043c\u0430\u044f, 100% = \u041d\u0435\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u0430\u044f.");
                this.add("text.autoconfig.hbm_m.category.chunk", "\u0427\u0430\u043d\u043a");
                this.add("text.autoconfig.hbm_m.option.maxRad", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f \u0432 \u0447\u0430\u043d\u043a\u0435");
                this.add("text.autoconfig.hbm_m.option.fogRad", "\u041f\u043e\u0440\u043e\u0433 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u043c\u0430\u043d\u0430");
                this.add("text.autoconfig.hbm_m.option.fogCh", "\u0428\u0430\u043d\u0441 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u043c\u0430\u043d\u0430 (1 \u0438\u0437 fogCh), WIP");
                this.add("text.autoconfig.hbm_m.option.radChunkDecay", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0441\u043f\u0430\u0434\u0430 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0435");
                this.add("text.autoconfig.hbm_m.option.radChunkSpreadFactor", "\u0424\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u043c\u0435\u0436\u0434\u0443 \u0447\u0430\u043d\u043a\u0430\u043c\u0438");
                this.add("text.autoconfig.hbm_m.option.radSpreadThreshold", "\u041f\u043e\u0440\u043e\u0433 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438");
                this.add("text.autoconfig.hbm_m.option.minRadDecayAmount", "\u041c\u0438\u043d. \u0440\u0430\u0441\u043f\u0430\u0434 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0437\u0430 \u0442\u0438\u043a");
                this.add("text.autoconfig.hbm_m.option.radSourceInfluenceFactor", "\u0412\u043b\u0438\u044f\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0430\u043d\u043a");
                this.add("text.autoconfig.hbm_m.option.radRandomizationFactor", "\u0424\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u043d\u0434\u043e\u043c\u0438\u0437\u0430\u0446\u0438\u0438 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0435");
                this.add("text.autoconfig.hbm_m.category.rendering", "\u0420\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433");
                this.add("text.autoconfig.hbm_m.option.modelUpdateDistance", "\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0434\u043b\u044f \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0447\u0430\u0441\u0442\u0435\u0439 .obj \u043c\u043e\u0434\u0435\u043b\u0435\u0439");
                this.add("text.autoconfig.hbm_m.option.enableOcclusionCulling", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043a\u0443\u043b\u043b\u0438\u043d\u0433 \u043c\u043e\u0434\u0435\u043b\u0435\u0439");
                this.add("text.autoconfig.hbm_m.category.debug", "\u041e\u0442\u043b\u0430\u0434\u043a\u0430");
                this.add("text.autoconfig.hbm_m.option.enableDebugRender", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0439 \u0440\u0435\u043d\u0434\u0435\u0440 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438");
                this.add("text.autoconfig.hbm_m.option.debugRenderTextSize", "\u0420\u0430\u0437\u043c\u0435\u0440 \u0442\u0435\u043a\u0441\u0442\u0430 \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u043e\u0433\u043e \u0440\u0435\u043d\u0434\u0435\u0440\u0430");
                this.add("text.autoconfig.hbm_m.option.debugRenderDistance", "\u0414\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u043e\u0433\u043e \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 (\u0447\u0430\u043d\u043a\u0438)");
                this.add("text.autoconfig.hbm_m.option.debugRenderInSurvival", "\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0439 \u0440\u0435\u043d\u0434\u0435\u0440 \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f");
                this.add("text.autoconfig.hbm_m.option.enableDebugLogging", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0435 \u043b\u043e\u0433\u0438");
                this.add("text.autoconfig.hbm_m.option.enableRadiation.@Tooltip", "\u0415\u0441\u043b\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e, \u0432\u0441\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0430\u0435\u0442\u0441\u044f (\u0447\u0430\u043d\u043a\u0438, \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b)");
                this.add("text.autoconfig.hbm_m.option.enableChunkRads.@Tooltip", "\u0415\u0441\u043b\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e, \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f \u0432 \u0447\u0430\u043d\u043a\u0430\u0445 \u0432\u0441\u0435\u0433\u0434\u0430 0");
                this.add("text.autoconfig.hbm_m.option.usePrismSystem.@Tooltip", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u0443 PRISM \u0434\u043b\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0430\u0445 (WIP)");
                this.add("text.autoconfig.hbm_m.option.maxPlayerRad.@Tooltip", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f, \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u043c\u043e\u0436\u0435\u0442 \u043d\u0430\u043a\u043e\u043f\u0438\u0442\u044c \u0438\u0433\u0440\u043e\u043a");
                this.add("text.autoconfig.hbm_m.option.radDecay.@Tooltip", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0441\u043f\u0430\u0434\u0430 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0443 \u0438\u0433\u0440\u043e\u043a\u0430 \u0437\u0430 \u0442\u0438\u043a");
                this.add("text.autoconfig.hbm_m.option.radDamage.@Tooltip", "\u0423\u0440\u043e\u043d \u0437\u0430 \u0442\u0438\u043a \u043f\u0440\u0438 \u043f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0438 \u043f\u043e\u0440\u043e\u0433\u0430");
                this.add("text.autoconfig.hbm_m.option.radDamageThreshold.@Tooltip", "\u0418\u0433\u0440\u043e\u043a \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u0443\u0440\u043e\u043d \u0432\u044b\u0448\u0435 \u044d\u0442\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                this.add("text.autoconfig.hbm_m.option.radSickness.@Tooltip", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u044d\u0444\u0444\u0435\u043a\u0442\u0430 \u0442\u043e\u0448\u043d\u043e\u0442\u044b");
                this.add("text.autoconfig.hbm_m.option.radWater.@Tooltip", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u043d\u0435\u0433\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u044d\u0444\u0444\u0435\u043a\u0442\u0430 \u0432\u043e\u0434\u044b (WIP)");
                this.add("text.autoconfig.hbm_m.option.radConfusion.@Tooltip", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u044d\u0444\u0444\u0435\u043a\u0442\u0430 \u0437\u0430\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 (WIP)");
                this.add("text.autoconfig.hbm_m.option.radBlindness.@Tooltip", "\u041f\u043e\u0440\u043e\u0433 \u0434\u043b\u044f \u044d\u0444\u0444\u0435\u043a\u0442\u0430 \u0441\u043b\u0435\u043f\u043e\u0442\u044b");
                this.add("text.autoconfig.hbm_m.option.enableRadiationPixelEffect.@Tooltip", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u044d\u0444\u0444\u0435\u043a\u0442 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0445 \u043c\u0435\u0440\u0446\u0430\u044e\u0449\u0438\u0445 \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439 \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435, \u043a\u043e\u0433\u0434\u0430 \u0438\u0433\u0440\u043e\u043a \u043f\u043e\u0434\u0432\u0435\u0440\u0433\u0430\u0435\u0442\u0441\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u043c\u0443 \u043e\u0431\u043b\u0443\u0447\u0435\u043d\u0438\u044e.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectThreshold.@Tooltip", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0439 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 (\u0432 RAD/\u0441), \u043f\u0440\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442 \u043f\u043e\u044f\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u044d\u0444\u0444\u0435\u043a\u0442 \u0432\u0438\u0437\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u043c\u0435\u0445.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxIntensityRad.@Tooltip", "\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0439 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 (\u0432 RAD/\u0441), \u043f\u0440\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u044d\u0444\u0444\u0435\u043a\u0442 \u043f\u043e\u043c\u0435\u0445 \u0434\u043e\u0441\u0442\u0438\u0433\u0430\u0435\u0442 \u0441\u0432\u043e\u0435\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0438\u043b\u044b (\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439).");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectMaxDots.@Tooltip", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043c\u043e\u0436\u0435\u0442 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435 \u043f\u0440\u0438 \u043f\u0438\u043a\u043e\u0432\u043e\u0439 \u0438\u043d\u0442\u0435\u043d\u0441\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0430. \u0412\u043b\u0438\u044f\u0435\u0442 \u043d\u0430 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043d\u0430 \u0441\u043b\u0430\u0431\u044b\u0445 \u0441\u0438\u0441\u0442\u0435\u043c\u0430\u0445.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectGreenChance.@Tooltip", "\u0412\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c (\u043e\u0442 0.0 \u0434\u043e 1.0), \u0447\u0442\u043e \u043d\u043e\u0432\u044b\u0439 \u043f\u043e\u044f\u0432\u0438\u0432\u0448\u0438\u0439\u0441\u044f \u043f\u0438\u043a\u0441\u0435\u043b\u044c \u0431\u0443\u0434\u0435\u0442 \u0437\u0435\u043b\u0435\u043d\u044b\u043c, \u0430 \u043d\u0435 \u0431\u0435\u043b\u044b\u043c. \u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 0.1 = 10% \u0448\u0430\u043d\u0441.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMinLifetime.@Tooltip", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f (\u0432 \u0442\u0438\u043a\u0430\u0445), \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043e\u0434\u0438\u043d \u043f\u0438\u043a\u0441\u0435\u043b\u044c \u0431\u0443\u0434\u0435\u0442 \u043e\u0441\u0442\u0430\u0432\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435. 20 \u0442\u0438\u043a\u043e\u0432 = 1 \u0441\u0435\u043a\u0443\u043d\u0434\u0430.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxLifetime.@Tooltip", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f (\u0432 \u0442\u0438\u043a\u0430\u0445), \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043e\u0434\u0438\u043d \u043f\u0438\u043a\u0441\u0435\u043b\u044c \u0431\u0443\u0434\u0435\u0442 \u043e\u0441\u0442\u0430\u0432\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435. \u0414\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u043f\u0438\u043a\u0441\u0435\u043b\u044f \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442\u0441\u044f \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u043c \u0438 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u0436\u0438\u0437\u043d\u0438.");
                this.add("text.autoconfig.hbm_m.option.maxRad.@Tooltip", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f \u0432 \u0447\u0430\u043d\u043a\u0435");
                this.add("text.autoconfig.hbm_m.option.fogRad.@Tooltip", "\u041f\u043e\u0440\u043e\u0433 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u043c\u0430\u043d\u0430 (WIP)");
                this.add("text.autoconfig.hbm_m.option.fogCh.@Tooltip", "\u0428\u0430\u043d\u0441 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u043c\u0430\u043d\u0430 (WIP)");
                this.add("text.autoconfig.hbm_m.option.radChunkDecay.@Tooltip", "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0441\u043f\u0430\u0434\u0430 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0435");
                this.add("text.autoconfig.hbm_m.option.radChunkSpreadFactor.@Tooltip", "\u0421\u043a\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f \u043d\u0430 \u0441\u043e\u0441\u0435\u0434\u043d\u0438\u0435 \u0447\u0430\u043d\u043a\u0438");
                this.add("text.autoconfig.hbm_m.option.radSpreadThreshold.@Tooltip", "\u041d\u0438\u0436\u0435 \u044d\u0442\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u044f \u043d\u0435 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f");
                this.add("text.autoconfig.hbm_m.option.minRadDecayAmount.@Tooltip", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0441\u043f\u0430\u0434 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0437\u0430 \u0442\u0438\u043a \u0432 \u0447\u0430\u043d\u043a\u0435");
                this.add("text.autoconfig.hbm_m.option.radSourceInfluenceFactor.@Tooltip", "\u0412\u043b\u0438\u044f\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0430\u043d\u043a.");
                this.add("text.autoconfig.hbm_m.option.radRandomizationFactor.@Tooltip", "\u0424\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u043d\u0434\u043e\u043c\u0438\u0437\u0430\u0446\u0438\u0438 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0435");
                this.add("text.autoconfig.hbm_m.option.modelUpdateDistance.@Tooltip", "\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0434\u043b\u044f \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0447\u0430\u0441\u0442\u0435\u0439 .obj \u043c\u043e\u0434\u0435\u043b\u0435\u0439 (\u0432 \u0447\u0430\u043d\u043a\u0430\u0445)");
                this.add("text.autoconfig.hbm_m.option.enableOcclusionCulling.@Tooltip", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043a\u0443\u043b\u043b\u0438\u043d\u0433 \u043c\u043e\u0434\u0435\u043b\u0435\u0439 (\u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u0435, \u0435\u0441\u043b\u0438 \u0432\u0430\u0448\u0438 \u043c\u043e\u0434\u0435\u043b\u0438 \u0440\u0435\u043d\u0434\u0435\u0440\u044f\u0442\u0441\u044f \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e)");
                this.add("text.autoconfig.hbm_m.option.enableDebugRender.@Tooltip", "\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0439 \u043e\u0432\u0435\u0440\u043b\u0435\u0439 \u0440\u0430\u0434\u0438\u0430\u0446\u0438\u0438 \u0432 \u0447\u0430\u043d\u043a\u0430\u0445 (F3)");
                this.add("text.autoconfig.hbm_m.option.debugRenderTextSize.@Tooltip", "\u0420\u0430\u0437\u043c\u0435\u0440 \u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u043e\u0433\u043e \u043e\u0432\u0435\u0440\u043b\u0435\u044f");
                this.add("text.autoconfig.hbm_m.option.debugRenderDistance.@Tooltip", "\u0414\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u043e\u0433\u043e \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 (\u0447\u0430\u043d\u043a\u0438)");
                this.add("text.autoconfig.hbm_m.option.debugRenderInSurvival.@Tooltip", "\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0439 \u0440\u0435\u043d\u0434\u0435\u0440 \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f");
                this.add("text.autoconfig.hbm_m.option.enableDebugLogging.@Tooltip", "\u0415\u0441\u043b\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e, \u0431\u0443\u0434\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e \u0433\u043b\u0443\u0431\u043e\u043a\u043e\u0435 \u043b\u043e\u0433\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u0433\u0440\u043e\u0432\u044b\u0445 \u0441\u043e\u0431\u044b\u0442\u0438\u0439. \u041d\u0435 \u0441\u0442\u043e\u0438\u0442 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c, \u0435\u0441\u043b\u0438 \u043d\u0435 \u0438\u0441\u043f\u044b\u0442\u044b\u0432\u0430\u0435\u0442\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c");
                break;
            }
            case "en_us": {
                this.add("itemGroup.hbm_m.ntm_resources_tab", "NTM Ingots and Resources");
                this.add("itemGroup.hbm_m.ntm_fuel_tab", "NTM Fuel and Machine Components");
                this.add("itemGroup.hbm_m.ntm_templates_tab", "NTM Templates");
                this.add("itemGroup.hbm_m.ntm_ores_tab", "NTM Ores and Blocks");
                this.add("itemGroup.hbm_m.ntm_machines_tab", "NTM Machines");
                this.add("itemGroup.hbm_m.ntm_bombs_tab", "NTM Bombs");
                this.add("itemGroup.hbm_m.ntm_missiles_tab", "NTM Missiles and Satellites");
                this.add("itemGroup.hbm_m.ntm_weapons_tab", "NTM Weapons and Turrets");
                this.add("itemGroup.hbm_m.ntm_consumables_tab", "NTM Consumables and Equipment");
                this.add("itemGroup.hbm_m.ntm_spareparts_tab", "NTM Spare Parts");
                this.add("itemGroup.hbm_m.ntm_instruments_tab", "NTM Instruments");
                this.add("itemGroup.hbm_m.ntm_building_tab", "NTM Building Blocks");
                this.add("item.hbm_m.alloy_sword", "Alloy Sword");
                this.add("item.hbm_m.alloy_pickaxe", "Alloy Pickaxe");
                this.add("item.hbm_m.alloy_axe", "Alloy Axe");
                this.add("item.hbm_m.alloy_hoe", "Alloy Hoe");
                this.add("item.hbm_m.alloy_shovel", "Alloy Shovel");
                this.add("item.hbm_m.steel_sword", "Steel Sword");
                this.add("item.hbm_m.steel_pickaxe", "Steel Pickaxe");
                this.add("item.hbm_m.steel_axe", "Steel Axe");
                this.add("item.hbm_m.steel_hoe", "Steel Hoe");
                this.add("item.hbm_m.steel_shovel", "Steel Shovel");
                this.add("gui.hbm_m.energy", "Energy: %s/%s HE");
                this.add("gui.hbm_m.shredder.blade_warning.title", "Blades missing!");
                this.add("gui.hbm_m.shredder.blade_warning.desc", "Install or repair the shredder blades.");
                this.add("item.hbm_m.titanium_sword", "Titanium Sword");
                this.add("item.hbm_m.titanium_pickaxe", "Titanium Pickaxe");
                this.add("item.hbm_m.titanium_axe", "Titanium Axe");
                this.add("item.hbm_m.titanium_hoe", "Titanium Hoe");
                this.add("item.hbm_m.titanium_shovel", "Titanium Shovel");
                this.add("item.hbm_m.starmetal_sword", "Starmetal Sword");
                this.add("item.hbm_m.starmetal_pickaxe", "Starmetal Pickaxe");
                this.add("item.hbm_m.starmetal_axe", "Starmetal Axe");
                this.add("item.hbm_m.starmetal_hoe", "Starmetal Hoe");
                this.add("item.hbm_m.starmetal_shovel", "Starmetal Shovel");
                this.add("item.hbm_m.alloy_helmet", "Alloy Helmet");
                this.add("item.hbm_m.alloy_chestplate", "Alloy Chestplate");
                this.add("item.hbm_m.alloy_leggings", "Alloy Leggings");
                this.add("item.hbm_m.alloy_boots", "Alloy Boots");
                this.add("item.hbm_m.cobalt_helmet", "Cobalt Helmet");
                this.add("item.hbm_m.cobalt_chestplate", "Cobalt Chestplate");
                this.add("item.hbm_m.cobalt_leggings", "Cobalt Leggings");
                this.add("item.hbm_m.cobalt_boots", "Cobalt Boots");
                this.add("item.hbm_m.titanium_helmet", "Titanium Helmet");
                this.add("item.hbm_m.titanium_chestplate", "Titanium Chestplate");
                this.add("item.hbm_m.titanium_leggings", "Titanium Leggings");
                this.add("item.hbm_m.titanium_boots", "Titanium Boots");
                this.add("item.hbm_m.security_helmet", "Security Helmet");
                this.add("item.hbm_m.security_chestplate", "Security Chestplate");
                this.add("item.hbm_m.security_leggings", "Security Leggings");
                this.add("item.hbm_m.security_boots", "Security Boots");
                this.add("item.hbm_m.ajr_helmet", "Steel Ranger Helmet");
                this.add("item.hbm_m.ajr_chestplate", "Steel Ranger Chestplate");
                this.add("item.hbm_m.ajr_leggings", "Steel Ranger Leggings");
                this.add("item.hbm_m.ajr_boots", "Steel Ranger Boots");
                this.add("item.hbm_m.steel_helmet", "Steel Helmet");
                this.add("item.hbm_m.steel_chestplate", "Steel Chestplate");
                this.add("item.hbm_m.steel_leggings", "Steel Leggings");
                this.add("item.hbm_m.steel_boots", "Steel Boots");
                this.add("item.hbm_m.asbestos_helmet", "Fire Proximity Helmet");
                this.add("item.hbm_m.asbestos_chestplate", "Fire Proximity Chestplate");
                this.add("item.hbm_m.asbestos_leggings", "Fire Proximity Leggings");
                this.add("item.hbm_m.asbestos_boots", "Fire Proximity Boots");
                this.add("item.hbm_m.hazmat_helmet", "Hazmat Helmet");
                this.add("item.hbm_m.hazmat_chestplate", "Hazmat Chestplate");
                this.add("item.hbm_m.hazmat_leggings", "Hazmat Leggings");
                this.add("item.hbm_m.hazmat_boots", "Hazmat Boots");
                this.add("item.hbm_m.liquidator_helmet", "Liquidator Suit Helmet");
                this.add("item.hbm_m.liquidator_chestplate", "Liquidator Suit Chestplate");
                this.add("item.hbm_m.liquidator_leggings", "Liquidator Suit Leggings");
                this.add("item.hbm_m.liquidator_boots", "Liquidator Suit Boots");
                this.add("item.hbm_m.paa_helmet", "PaA Battle Hazmat Suit Helmet");
                this.add("item.hbm_m.paa_chestplate", "PaA Chest Protection Plate");
                this.add("item.hbm_m.paa_leggings", "PaA Leg Reinforcements");
                this.add("item.hbm_m.paa_boots", "PaA ''good ol` shoes''");
                this.add("item.hbm_m.starmetal_helmet", "Starmetal Helmet");
                this.add("item.hbm_m.starmetal_chestplate", "Starmetal Chestplate");
                this.add("item.hbm_m.starmetal_leggings", "Starmetal Leggings");
                this.add("item.hbm_m.starmetal_boots", "Starmetal Boots");
                this.add((Item)ModItems.CANNED_ASBESTOS.get(), "Canned Asbestos");
                this.add((Item)ModItems.CANNED_ASS.get(), "Canned Ass Meat");
                this.add((Item)ModItems.CANNED_BARK.get(), "Canned Bark");
                this.add((Item)ModItems.CANNED_BEEF.get(), "Canned Beef");
                this.add((Item)ModItems.CANNED_BHOLE.get(), "Canned Black Hole");
                this.add((Item)ModItems.CANNED_CHEESE.get(), "Canned Cheese");
                this.add((Item)ModItems.CANNED_CHINESE.get(), "Canned Chinese");
                this.add((Item)ModItems.CANNED_DIESEL.get(), "Canned Diesel");
                this.add((Item)ModItems.CANNED_FIST.get(), "Canned Fist");
                this.add((Item)ModItems.CANNED_FRIED.get(), "Canned Fried");
                this.add((Item)ModItems.CANNED_HOTDOGS.get(), "Canned Hotdogs");
                this.add((Item)ModItems.CANNED_JIZZ.get(), "Mystery Canned Item");
                this.add((Item)ModItems.CANNED_KEROSENE.get(), "Canned Kerosene");
                this.add((Item)ModItems.CANNED_LEFTOVERS.get(), "Canned Leftovers");
                this.add((Item)ModItems.CANNED_MILK.get(), "Canned Milk");
                this.add((Item)ModItems.CANNED_MYSTERY.get(), "Canned Mystery");
                this.add((Item)ModItems.CANNED_NAPALM.get(), "Canned Napalm");
                this.add((Item)ModItems.CANNED_OIL.get(), "Canned Oil");
                this.add((Item)ModItems.CANNED_PASHTET.get(), "Canned Pate");
                this.add((Item)ModItems.CANNED_PIZZA.get(), "Canned Pizza");
                this.add((Item)ModItems.CANNED_RECURSION.get(), "Canned Recursion");
                this.add((Item)ModItems.CANNED_SPAM.get(), "Canned Spam");
                this.add((Item)ModItems.CANNED_STEW.get(), "Canned Stew");
                this.add((Item)ModItems.CANNED_TOMATO.get(), "Canned Tomato");
                this.add((Item)ModItems.CANNED_TUNA.get(), "Canned Tuna");
                this.add((Item)ModItems.CANNED_TUBE.get(), "Canned Tube");
                this.add((Item)ModItems.CANNED_YOGURT.get(), "Canned Yogurt");
                this.add((Item)ModItems.CAN_BEPIS.get(), "Can of Bepis");
                this.add((Item)ModItems.CAN_BREEN.get(), "Can of Breen");
                this.add((Item)ModItems.CAN_CREATURE.get(), "Can of Creature");
                this.add((Item)ModItems.CAN_EMPTY.get(), "Empty Can");
                this.add((Item)ModItems.CAN_KEY.get(), "Can Key");
                this.add((Item)ModItems.CAN_LUNA.get(), "Can of Luna");
                this.add((Item)ModItems.CAN_MRSUGAR.get(), "Can of Mrsugar");
                this.add((Item)ModItems.CAN_MUG.get(), "Can of Mug");
                this.add((Item)ModItems.CAN_OVERCHARGE.get(), "Can of Overcharge");
                this.add((Item)ModItems.CAN_REDBOMB.get(), "Can of Redbomb");
                this.add((Item)ModItems.CAN_SMART.get(), "Can of Smart");
                this.add((Item)ModItems.BATTERY_POTATO.get(), "Potato Battery");
                this.add((Item)ModItems.BATTERY.get(), "Battery");
                this.add((Item)ModItems.BATTERY_RED_CELL.get(), "Red Energy Cell");
                this.add((Item)ModItems.BATTERY_RED_CELL_6.get(), "Red Energy Cell x6");
                this.add((Item)ModItems.BATTERY_RED_CELL_24.get(), "Red Energy Cell x24");
                this.add((Item)ModItems.BATTERY_ADVANCED.get(), "Advanced Battery");
                this.add((Item)ModItems.BATTERY_ADVANCED_CELL.get(), "Advanced Energy Cell");
                this.add((Item)ModItems.BATTERY_ADVANCED_CELL_4.get(), "Advanced Energy Cell x4");
                this.add((Item)ModItems.BATTERY_ADVANCED_CELL_12.get(), "Advanced Energy Cell x12");
                this.add((Item)ModItems.BATTERY_LITHIUM.get(), "Lithium Battery");
                this.add((Item)ModItems.BATTERY_LITHIUM_CELL.get(), "Lithium Energy Cell");
                this.add((Item)ModItems.BATTERY_LITHIUM_CELL_3.get(), "Lithium Energy Cell x3");
                this.add((Item)ModItems.BATTERY_LITHIUM_CELL_6.get(), "Lithium Energy Cell x6");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM.get(), "Schrabidium Battery");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM_CELL.get(), "Schrabidium Energy Cell");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM_CELL_2.get(), "Schrabidium Energy Cell x2");
                this.add((Item)ModItems.BATTERY_SCHRABIDIUM_CELL_4.get(), "Schrabidium Energy Cell x4");
                this.add((Item)ModItems.BATTERY_SPARK.get(), "Spark Battery");
                this.add((Item)ModItems.BATTERY_TRIXITE.get(), "Trixite Battery");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_6.get(), "Spark Energy Cell x6");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_25.get(), "Spark Energy Cell x25");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_100.get(), "Spark Energy Cell x100");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_1000.get(), "Spark Energy Cell x1000");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_2500.get(), "Spark Energy Cell x2500");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_10000.get(), "Spark Energy Cell x10000");
                this.add((Item)ModItems.BATTERY_SPARK_CELL_POWER.get(), "Spark Power Cell");
                this.add((Item)ModItems.WIRE_RED_COPPER.get(), "Red Copper Wire");
                this.add((Item)ModItems.WIRE_COPPER.get(), "Copper Wire");
                this.add((Item)ModItems.WIRE_ALUMINIUM.get(), "Aluminium Wire");
                this.add((Item)ModItems.WIRE_GOLD.get(), "Golden Wire");
                this.add((Item)ModItems.WIRE_TUNGSTEN.get(), "Tungsten Wire");
                this.add((Item)ModItems.WIRE_MAGNETIZED_TUNGSTEN.get(), "Magnetized Tungsten Wire");
                this.add((Item)ModItems.WIRE_FINE.get(), "Fine Wire");
                this.add((Item)ModItems.WIRE_CARBON.get(), "Lead Wire");
                this.add((Item)ModItems.WIRE_SCHRABIDIUM.get(), "Shrabidium Wire");
                this.add((Item)ModItems.WIRE_ADVANCED_ALLOY.get(), "Advanced Alloy Wire");
                this.add((Item)ModItems.STAMP_STONE_FLAT.get(), "Stone Flat Stamp");
                this.add((Item)ModItems.STAMP_STONE_PLATE.get(), "Stone Plate Stamp");
                this.add((Item)ModItems.STAMP_STONE_WIRE.get(), "Stone Wire Stamp");
                this.add((Item)ModItems.STAMP_STONE_CIRCUIT.get(), "Stone Circuit Stamp");
                this.add((Item)ModItems.STAMP_IRON_FLAT.get(), "Iron Flat Stamp");
                this.add((Item)ModItems.STAMP_IRON_PLATE.get(), "Iron Plate Stamp");
                this.add((Item)ModItems.STAMP_IRON_WIRE.get(), "Iron Wire Stamp");
                this.add((Item)ModItems.STAMP_IRON_CIRCUIT.get(), "Iron Circuit Stamp");
                this.add((Item)ModItems.STAMP_STEEL_FLAT.get(), "Steel Flat Stamp");
                this.add((Item)ModItems.STAMP_STEEL_PLATE.get(), "Steel Plate Stamp");
                this.add((Item)ModItems.STAMP_STEEL_WIRE.get(), "Steel Wire Stamp");
                this.add((Item)ModItems.STAMP_STEEL_CIRCUIT.get(), "Steel Circuit Stamp");
                this.add((Item)ModItems.STAMP_TITANIUM_FLAT.get(), "Titanium Flat Stamp");
                this.add((Item)ModItems.STAMP_TITANIUM_PLATE.get(), "Titanium Plate Stamp");
                this.add((Item)ModItems.STAMP_TITANIUM_WIRE.get(), "Titanium Wire Stamp");
                this.add((Item)ModItems.STAMP_TITANIUM_CIRCUIT.get(), "Titanium Circuit Stamp");
                this.add((Item)ModItems.STAMP_OBSIDIAN_FLAT.get(), "Obsidian Flat Stamp");
                this.add((Item)ModItems.STAMP_OBSIDIAN_PLATE.get(), "Obsidian Plate Stamp");
                this.add((Item)ModItems.STAMP_OBSIDIAN_WIRE.get(), "Obsidian Wire Stamp");
                this.add((Item)ModItems.STAMP_OBSIDIAN_CIRCUIT.get(), "Obsidian Circuit Stamp");
                this.add((Item)ModItems.STAMP_DESH_FLAT.get(), "Desh Flat Stamp");
                this.add((Item)ModItems.STAMP_DESH_PLATE.get(), "Desh Plate Stamp");
                this.add((Item)ModItems.STAMP_DESH_WIRE.get(), "Desh Wire Stamp");
                this.add((Item)ModItems.STAMP_DESH_CIRCUIT.get(), "Desh Circuit Stamp");
                this.add((Item)ModItems.STAMP_DESH_9.get(), "Desh 9mm Stamp");
                this.add((Item)ModItems.STAMP_DESH_44.get(), "Desh .44 Magnum Stamp");
                this.add((Item)ModItems.STAMP_DESH_50.get(), "Desh .50 BMG Stamp");
                this.add((Item)ModItems.STAMP_DESH_357.get(), "Desh .357 Magnum Stamp");
                this.add((Item)ModItems.STAMP_IRON_357.get(), "Iron .357 Magnum Stamp");
                this.add((Item)ModItems.STAMP_IRON_44.get(), "Iron .44 Magnum Stamp");
                this.add((Item)ModItems.STAMP_IRON_50.get(), "Iron .50 BMG Stamp");
                this.add((Item)ModItems.STAMP_IRON_9.get(), "Iron 9mm Stamp");
                this.add((Item)ModItems.QUANTUM_CHIP.get(), "Quantum Chip");
                this.add((Item)ModItems.QUANTUM_CIRCUIT.get(), "Quantum Circuit");
                this.add((Item)ModItems.QUANTUM_COMPUTER.get(), "Quantum Computer");
                this.add((Item)ModItems.SILICON_CIRCUIT.get(), "Silicone Circuit");
                this.add((Item)ModItems.BISMOID_CHIP.get(), "Bismoid Chip");
                this.add((Item)ModItems.BISMOID_CIRCUIT.get(), "Bismoid Circuit");
                this.add((Item)ModItems.CONTROLLER_CHASSIS.get(), "Controller Chassis");
                this.add((Item)ModItems.CONTROLLER.get(), "Controller");
                this.add((Item)ModItems.CONTROLLER_ADVANCED.get(), "Controller Advanced");
                this.add((Item)ModItems.CAPACITOR_BOARD.get(), "Capacitor Board");
                this.add((Item)ModItems.CAPACITOR_TANTALUM.get(), "Tantalum Capacitor");
                this.add((Item)ModItems.ANALOG_CIRCUIT.get(), "Analog Circuit");
                this.add((Item)ModItems.INTEGRATED_CIRCUIT.get(), "Integrated Circuit");
                this.add((Item)ModItems.ADVANCED_CIRCUIT.get(), "Advancer Circuit");
                this.add((Item)ModItems.MICROCHIP.get(), "Microchip");
                this.add((Item)ModItems.ATOMIC_CLOCK.get(), "Atomic Clock");
                this.add((Item)ModItems.VACUUM_TUBE.get(), "Vacuum Tube");
                this.add((Item)ModItems.CAPACITOR.get(), "Capacitor");
                this.add((Item)ModItems.PCB.get(), "PCB");
                this.add((Item)ModItems.STRAWBERRY.get(), "Strawberry");
                this.add((Item)ModItems.BATTLE_GEARS.get(), "Battle Gears");
                this.add((Item)ModItems.BATTLE_CASING.get(), "Battle Casing");
                this.add((Item)ModItems.BATTLE_COUNTER.get(), "Battle Counter");
                this.add((Item)ModItems.BATTLE_SENSOR.get(), "Battle Sensor");
                this.add((Item)ModItems.BATTLE_MODULE.get(), "Battle Module");
                this.add((Item)ModItems.METAL_ROD.get(), "Metal Rod");
                this.add((Item)ModItems.GRENADE.get(), "Bouncing Grenade");
                this.add((Item)ModItems.GRENADEHE.get(), "Powerful Bouncing Grenade");
                this.add((Item)ModItems.GRENADEFIRE.get(), "Fire Bouncing Grenade");
                this.add((Item)ModItems.GRENADESLIME.get(), "Bouncy Bouncing Grenade");
                this.add((Item)ModItems.GRENADESMART.get(), "Smart Bouncing Grenade");
                this.add((Item)ModItems.GRENADE_IF.get(), "IF Grenade");
                this.add("item.hbm_m.geiger_counter", "Geiger Counter");
                this.add("item.hbm_m.dosimeter", "Dosimeter");
                this.add("item.hbm_m.battery_creative", "Creative Battery");
                this.add("tooltip.hbm_m.creative_battery_desc", "Provides an infinite amount of power");
                this.add("tooltip.hbm_m.creative_battery_flavor", "To infinity... and beyond!!");
                this.add("item.hbm_m.blueprint_folder", "Template Folder");
                this.add("item.hbm_m.blueprint_folder.named", "Machine Template Folder");
                this.add("item.hbm_m.blueprint_folder.empty", "Empty folder");
                this.add("item.hbm_m.blueprint_folder.obsolete", "Folder is Deprecated (Group was removed)");
                this.add("item.hbm_m.blueprint_folder.desc", "Insert into Assembly Machine to unlock recipes");
                this.add("item.hbm_m.blueprint_folder.recipes", "Contains recipes:");
                this.add("gui.hbm_m.recipe_from_group", "From Group:");
                this.add("item.hbm_m.heart_piece", "Heart Piece");
                this.add((Item)ModItems.HEART_CONTAINER.get(), "Heart Container");
                this.add((Item)ModItems.HEART_BOOSTER.get(), "Heart Booster");
                this.add((Item)ModItems.HEART_FAB.get(), "Heart of Darkness");
                this.add((Item)ModItems.BLACK_DIAMOND.get(), "Black Diamond");
                this.add((Item)ModItems.GHIORSIUM_CLADDING.get(), "Ghiorsium Cladding");
                this.add((Item)ModItems.DESH_CLADDING.get(), "Desh Cladding");
                this.add((Item)ModItems.RUBBER_CLADDING.get(), "Rubber Cladding");
                this.add((Item)ModItems.LEAD_CLADDING.get(), "Lead Cladding");
                this.add((Item)ModItems.PAINT_CLADDING.get(), "Lead Paint");
                this.add("item.hbm_m.radaway", "Radaway");
                this.add("effect.hbm_m.radaway", "Radiation cleansing");
                this.add("sounds.hbm_m.radaway_use", "Use of radaway");
                this.add((Item)ModItems.TEMPLATE_FOLDER.get(), "Template Folder");
                this.add((Item)ModItems.ASSEMBLY_TEMPLATE.get(), "Assembly Template: %s");
                this.add("tooltip.hbm_m.template_broken", "Broken template");
                this.add("tooltip.hbm_m.created_with_template_folder", "Created via Template Folder");
                this.add("tooltip.hbm_m.output", "Output: ");
                this.add("tooltip.hbm_m.input", "Input: ");
                this.add("tooltip.hbm_m.production_time", "Production time:");
                this.add("tooltip.hbm_m.seconds", "seconds");
                this.add("tooltip.hbm_m.energy_consumption", "Energy Consumption:");
                this.add("tooltip.hbm_m.tags", "\u0422ags (OreDict):");
                this.add("item.hbm_m.template_folder.desc", "Machine Templates: Paper + Dye$Fluid IDs: Iron Plate + Dye$Press Stamps: Flat Stamp$Siren Tracks: Insulator + Steel Plate");
                this.add("desc.gui.template", "Insert Assembly Template");
                this.add("desc.gui.assembler.warning", "No valid template!");
                this.add("tooltip.hbm_m.crowbar.line1", "Tool for prying open containers.");
                this.add("tooltip.hbm_m.crowbar.line2", "Opens crates on right-click");
                this.add("tooltip.hbm_m.defuser.line1", "Device for disarming mines and bombs");
                this.add("tooltip.hbm_m.defuser.line2", "RMB on a compatible device to disarm");
                this.add("tooltip.hbm_m.mine.line1", "Can be defused");
                this.add("tooltip.hbm_m.gigadet.line1", "Was made for fun");
                this.add("tooltip.hbm_m.nuclear_charge.line1", "High-yield nuclear weapon!");
                this.add("tooltip.hbm_m.nuclear_charge.line2", "At the moment, this is the");
                this.add("tooltip.hbm_m.nuclear_charge.line3", "most destructive block in our mod.");
                this.add("tooltip.hbm_m.nuclear_charge.line4", "If the crater loaded incorrectly");
                this.add("tooltip.hbm_m.nuclear_charge.line5", "or without biomes, restart the world.");
                this.add("tooltip.hbm_m.mine_nuke.line1", "Nuclear weapon!");
                this.add("tooltip.hbm_m.mine_nuke.line2", "Blast radius: 35 meters");
                this.add("tooltip.hbm_m.mine_nuke.line3", "Can be defused");
                this.add("tooltip.hbm_m.dudnuke.line1", "High-yield nuclear weapon!");
                this.add("tooltip.hbm_m.dudnuke.line4", "If the crater loaded incorrectly");
                this.add("tooltip.hbm_m.dudnuke.line5", "or without biomes, restart the world");
                this.add("tooltip.hbm_m.dudnuke.line6", "Can be defused");
                this.add("tooltip.hbm_m.dudsalted.line1", "High-yield nuclear weapon!");
                this.add("tooltip.hbm_m.dudsalted.line4", "If the crater loaded incorrectly");
                this.add("tooltip.hbm_m.dudsalted.line5", "or without biomes, restart the world");
                this.add("tooltip.hbm_m.dudsalted.line6", "Can be defused");
                this.add("tooltip.hbm_m.dudfugas.line1", "High-yield explosion!");
                this.add("tooltip.hbm_m.dudfugas.line6", "Can be defused");
                this.add("tooltip.hbm_m.detonator.target", "Target: ");
                this.add("tooltip.hbm_m.detonator.no_target", "No target");
                this.add("tooltip.hbm_m.detonator.right_click", "RMB - Activate");
                this.add("tooltip.hbm_m.detonator.shift_right_click", "Shift+RMB - Set target");
                this.add("tooltip.hbm_m.depth_ores_scanner.scans_chunks", "Scans chunks for");
                this.add("tooltip.hbm_m.depth_ores_scanner.deep_clusters", "depth clusters beneath the player");
                this.add("tooltip.hbm_m.depth_ores_scanner.depth_warning", "works at depth -30 and below!");
                this.add("message.hbm_m.depth_ores_scanner.invalid_height", "Scanner works only at height -30 or below!");
                this.add("message.hbm_m.depth_ores_scanner.directly_below", "Depth cluster directly below us!");
                this.add("message.hbm_m.depth_ores_scanner.in_chunk", "Depth cluster found in our chunk!");
                this.add("message.hbm_m.depth_ores_scanner.adjacent_chunk", "Depth cluster found in adjacent chunk!");
                this.add("message.hbm_m.depth_ores_scanner.none_found", "No depth clusters found nearby");
                this.add("tooltip.hbm_m.oil_detector.scans_chunks", "Scans chunks for");
                this.add("tooltip.hbm_m.oil_detector.oil_deposits", "oil deposits beneath the player");
                this.add("message.hbm_m.oil_detector.directly_below", "Oil deposits directly below us!");
                this.add("message.hbm_m.oil_detector.in_chunk", "Oil found in our chunk!");
                this.add("message.hbm_m.oil_detector.adjacent_chunk", "Oil deposits found in adjacent chunk!");
                this.add("message.hbm_m.oil_detector.none_found", "No oil deposits found nearby");
                this.add("tooltip.hbm_m.multi_detonator.active_point", "\u27a4 %s:");
                this.add("tooltip.hbm_m.multi_detonator.point_set", "\u2705 %s:");
                this.add("tooltip.hbm_m.multi_detonator.coordinates", "   %d, %d, %d");
                this.add("tooltip.hbm_m.multi_detonator.point_empty", "\u25cb Point %d:");
                this.add("tooltip.hbm_m.multi_detonator.not_set", "   Not set");
                this.add("tooltip.hbm_m.multi_detonator.key_r", "R - open menu");
                this.add("tooltip.hbm_m.multi_detonator.shift_rmb", "Shift+RMB - save to active point");
                this.add("tooltip.hbm_m.multi_detonator.rmb_activate", "RMB - activate active point");
                this.add("message.hbm_m.multi_detonator.position_saved", "Position '%s' saved: %d, %d, %d");
                this.add("message.hbm_m.multi_detonator.no_coordinates", "No coordinates set!");
                this.add("message.hbm_m.multi_detonator.point_not_set", "Point %d not set!");
                this.add("message.hbm_m.multi_detonator.chunk_not_loaded", "Position not loaded!");
                this.add("message.hbm_m.multi_detonator.activated", "%s activated!");
                this.add("message.hbm_m.multi_detonator.activation_error", "Activation error!");
                this.add("message.hbm_m.multi_detonator.incompatible_block", "Block incompatible!");
                this.add("tooltip.hbm_m.range_detonator.desc", "Activates compatible blocks");
                this.add("tooltip.hbm_m.range_detonator.hint", "along a ray up to 256 blocks.");
                this.add("message.hbm_m.range_detonator.pos_not_loaded", "Position incompatible or not loaded");
                this.add("message.hbm_m.range_detonator.activated", "Successfully activated");
                this.add("tooltip.hbm_m.grenade_nuc.line1", "Nuclear weapon!");
                this.add("tooltip.hbm_m.grenade_nuc.line2", "Blast radius: 25 meters");
                this.add("tooltip.hbm_m.grenade_nuc.line3", "Fuse time: 6s");
                this.add("tooltip.hbm_m.detminer.line1", "Does not damage entities or players");
                this.add("tooltip.hbm_m.detminer.line4", "Allows mining depth ores and stone");
                this.add("tooltip.hbm_m.grenade.common.line1", "Hand grenade");
                this.add("tooltip.hbm_m.grenade.smart.line2", "Detonates on direct hit with an entity");
                this.add("tooltip.hbm_m.grenade.fire.line2", "Leaves fire after detonation");
                this.add("tooltip.hbm_m.grenade.slime.line2", "Bounces strongly off surfaces");
                this.add("tooltip.hbm_m.grenade.standard.line2", "Weak fragmentation blast");
                this.add("tooltip.hbm_m.grenade.he.line2", "Enhanced high-explosive blast");
                this.add("tooltip.hbm_m.grenade.default.line2", "Throw it and watch it boom!");
                this.add("tooltip.hbm_m.grenade_if.common.line1", "IF-Grenade");
                this.add("tooltip.hbm_m.grenade_if.he.line2", "Powerful high-explosive blast");
                this.add("tooltip.hbm_m.grenade_if.slime.line2", "Bounces strongly off surfaces");
                this.add("tooltip.hbm_m.grenade_if.fire.line2", "Leaves fire after detonation");
                this.add("tooltip.hbm_m.grenade_if.standard.line2", "Standard timed explosion");
                this.add("tooltip.hbm_m.grenade_if.default.line2", "Throw it and wait for the boom");
                this.add("tooltip.hbm_m.depthstone.line1", "Can be mined or destroyed only by explosion!");
                this.add("tooltip.hbm_m.depthstone.line4", "Use Det Miner to safe-mine depth ores");
                this.add((Item)ModItems.MAN_CORE.get(), "Plutonium Core");
                this.add((Item)ModItems.CRT_DISPLAY.get(), "CRT");
                this.add((Block)ModBlocks.DEPTH_STONE.get(), "Depth Stone");
                this.add((Block)ModBlocks.DEPTH_CINNABAR.get(), "Deep Cinnabar Ore");
                this.add((Block)ModBlocks.DEPTH_IRON.get(), "Deep Iron Ore");
                this.add((Block)ModBlocks.DEPTH_ZIRCONIUM.get(), "Deep Zirconium Ore");
                this.add((Block)ModBlocks.DEPTH_BORAX.get(), "Deep Borax Ore");
                this.add((Block)ModBlocks.DEPTH_TUNGSTEN.get(), "Deep Tungsten Ore");
                this.add((Block)ModBlocks.DEPTH_TITANIUM.get(), "Deep Titanium Ore");
                this.add((Block)ModBlocks.BEDROCK_OIL.get(), "Bedrock Oil");
                this.add((Block)ModBlocks.BURNED_GRASS.get(), "Burned Grass");
                this.add((Block)ModBlocks.WASTE_PLANKS.get(), "Burned Planks");
                this.add((Block)ModBlocks.WASTE_LOG.get(), "Burned Log");
                this.add((Block)ModBlocks.CONCRETE_PILLAR.get(), "Concrete Pillar");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED.get(), "Slaked Sellafield");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED1.get(), "Slaked Sellafield I");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED2.get(), "Slaked Sellafield II");
                this.add((Block)ModBlocks.SELLAFIELD_SLAKED3.get(), "Slaked Sellafield III");
                this.add((Item)ModItems.MOTOR_BISMUTH.get(), "Bismuth Motor");
                this.add((Item)ModItems.MOTOR_DESH.get(), "Desh Motor");
                this.add((Item)ModItems.MOTOR.get(), "Motor");
                this.add((Block)ModBlocks.ASPHALT.get(), "Asphalt");
                this.add((Block)ModBlocks.BARRICADE.get(), "Sand Barricade");
                this.add((Block)ModBlocks.BASALT_BRICK.get(), "Basalt Bricks");
                this.add((Block)ModBlocks.BASALT_POLISHED.get(), "Polished Basalt");
                this.add((Block)ModBlocks.BRICK_BASE.get(), "Polished Bricks");
                this.add((Block)ModBlocks.BRICK_DUCRETE.get(), "Ducrete Bricks");
                this.add((Block)ModBlocks.BRICK_FIRE.get(), "Fire Bricks");
                this.add((Block)ModBlocks.BRICK_LIGHT.get(), "Light Bricks");
                this.add((Block)ModBlocks.BRICK_OBSIDIAN.get(), "Obsidian Bricks");
                this.add((Block)ModBlocks.CONCRETE_ASBESTOS.get(), "Asbestos Concrete");
                this.add((Block)ModBlocks.CONCRETE_BLACK.get(), "Black Concrete");
                this.add((Block)ModBlocks.CONCRETE_BLUE.get(), "Blue Concrete");
                this.add((Block)ModBlocks.CONCRETE_BROWN.get(), "Brown Concrete");
                this.add((Block)ModBlocks.CONCRETE_COLORED_BRONZE.get(), "Bronze Concrete");
                this.add((Block)ModBlocks.CONCRETE_COLORED_INDIGO.get(), "Indigo Concrete");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE.get(), "Concrete 'Machine'");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE_STRIPE.get(), "Striped Concrete 'Machine'");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PINK.get(), "Pink Concrete");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PURPLE.get(), "Purple Concrete");
                this.add((Block)ModBlocks.CONCRETE_COLORED_SAND.get(), "Concrete 'Texas'");
                this.add((Block)ModBlocks.CONCRETE_CYAN.get(), "Cyan Concrete");
                this.add((Block)ModBlocks.CONCRETE_GRAY.get(), "Gray Concrete");
                this.add((Block)ModBlocks.CONCRETE_GREEN.get(), "Green Concrete");
                this.add((Block)ModBlocks.CONCRETE_LIGHT_BLUE.get(), "Light Blue Concrete");
                this.add((Block)ModBlocks.CONCRETE_LIME.get(), "Lime Concrete");
                this.add((Block)ModBlocks.CONCRETE_MAGENTA.get(), "Magenta Concrete");
                this.add((Block)ModBlocks.CONCRETE_ORANGE.get(), "Orange Concrete");
                this.add((Block)ModBlocks.CONCRETE_PINK.get(), "Pink Concrete");
                this.add((Block)ModBlocks.CONCRETE_PURPLE.get(), "Purple Concrete");
                this.add((Block)ModBlocks.CONCRETE_REBAR.get(), "Rough Concrete");
                this.add((Block)ModBlocks.CONCRETE_REBAR_ALT.get(), "Rebar Concrete");
                this.add((Block)ModBlocks.CONCRETE_RED.get(), "Red Concrete");
                this.add((Block)ModBlocks.CONCRETE_SILVER.get(), "Silver Concrete");
                this.add((Block)ModBlocks.CONCRETE_SUPER.get(), "Super Concrete");
                this.add((Block)ModBlocks.CONCRETE_SUPER_BROKEN.get(), "Broken Super Concrete");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M0.get(), "Super Concrete MO");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M1.get(), "Super Concrete M1");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M2.get(), "Super Concrete M2");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M3.get(), "Super Concrete M3");
                this.add((Block)ModBlocks.CONCRETE_TILE.get(), "Concrete Tile");
                this.add((Block)ModBlocks.CONCRETE_TILE_TREFOIL.get(), "Marked Concrete Tile");
                this.add((Block)ModBlocks.CONCRETE_WHITE.get(), "White Concrete");
                this.add((Block)ModBlocks.CONCRETE_YELLOW.get(), "Yellow Concrete");
                this.add((Block)ModBlocks.CONCRETE_FLAT.get(), "Flat Concrete");
                this.add((Block)ModBlocks.DEPTH_BRICK.get(), "Depth Bricks");
                this.add((Block)ModBlocks.DEPTH_NETHER_BRICK.get(), "Depth Nether Bricks");
                this.add((Block)ModBlocks.DEPTH_NETHER_TILES.get(), "Depth Nether Tiles");
                this.add((Block)ModBlocks.DEPTH_STONE_NETHER.get(), "Depth Nether Stone");
                this.add((Block)ModBlocks.DEPTH_TILES.get(), "Depth Tiles");
                this.add((Block)ModBlocks.GNEISS_BRICK.get(), "Gneiss Brick");
                this.add((Block)ModBlocks.GNEISS_CHISELED.get(), "Chiseled Gneiss");
                this.add((Block)ModBlocks.GNEISS_STONE.get(), "Graphite Slate");
                this.add((Block)ModBlocks.GNEISS_TILE.get(), "Graphite Slate Tile");
                this.add((Block)ModBlocks.METEOR.get(), "Meteor Block");
                this.add((Block)ModBlocks.METEOR_BRICK.get(), "Meteor Bricks");
                this.add((Block)ModBlocks.METEOR_BRICK_CHISELED.get(), "Chiseled Meteor Bricks");
                this.add((Block)ModBlocks.METEOR_BRICK_CRACKED.get(), "Cracked Meteor Bricks");
                this.add((Block)ModBlocks.METEOR_BRICK_MOSSY.get(), "Mossy Meteor Bricks");
                this.add((Block)ModBlocks.METEOR_COBBLE.get(), "Meteor Cobble");
                this.add((Block)ModBlocks.METEOR_CRUSHED.get(), "Crushed Meteor");
                this.add((Block)ModBlocks.METEOR_PILLAR.get(), "Meteor Pillar");
                this.add((Block)ModBlocks.METEOR_POLISHED.get(), "Polished Meteor");
                this.add((Block)ModBlocks.METEOR_TREASURE.get(), "Meteor Treasure");
                this.add((Block)ModBlocks.VINYL_TILE.get(), "Vinyl Tiles");
                this.add((Block)ModBlocks.VINYL_TILE_SMALL.get(), "Small Vinyl Tiles");
                this.add((Block)ModBlocks.CONCRETE_ASBESTOS_SLAB.get(), "Asbestos Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_BLACK_SLAB.get(), "Black Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_BLUE_SLAB.get(), "Blue Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_BROWN_SLAB.get(), "Brown Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_COLORED_BRONZE_SLAB.get(), "Bronze Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_COLORED_INDIGO_SLAB.get(), "Indigo Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE_SLAB.get(), "Concrete 'Machine' Slab");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PINK_SLAB.get(), "Pink Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PURPLE_SLAB.get(), "Purple Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_COLORED_SAND_SLAB.get(), "Concrete 'Texas' Slab");
                this.add((Block)ModBlocks.CONCRETE_CYAN_SLAB.get(), "Cyan Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_GRAY_SLAB.get(), "Gray Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_GREEN_SLAB.get(), "Green Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_LIGHT_BLUE_SLAB.get(), "Light Blue Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_LIME_SLAB.get(), "Lime Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_MAGENTA_SLAB.get(), "Magenta Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_ORANGE_SLAB.get(), "Orange Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_PINK_SLAB.get(), "Pink Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_PURPLE_SLAB.get(), "Purple Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_RED_SLAB.get(), "Red Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_SILVER_SLAB.get(), "Silver Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_WHITE_SLAB.get(), "White Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_YELLOW_SLAB.get(), "Yellow Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_SUPER_SLAB.get(), "Super Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M0_SLAB.get(), "Super Concrete M0 Slab");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M1_SLAB.get(), "Super Concrete M1 Slab");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M2_SLAB.get(), "Super Concrete M2 Slab");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M3_SLAB.get(), "Super Concrete M3 Slab");
                this.add((Block)ModBlocks.CONCRETE_SUPER_BROKEN_SLAB.get(), "Broken Super Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_REBAR_SLAB.get(), "Rough Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_FLAT_SLAB.get(), "Flat Concrete Slab");
                this.add((Block)ModBlocks.CONCRETE_TILE_SLAB.get(), "Concrete Tile Slab");
                this.add((Block)ModBlocks.DEPTH_BRICK_SLAB.get(), "Depth Bricks Slab");
                this.add((Block)ModBlocks.DEPTH_TILES_SLAB.get(), "Depth Tiles Slab");
                this.add((Block)ModBlocks.DEPTH_NETHER_BRICK_SLAB.get(), "Depth Nether Bricks Slab");
                this.add((Block)ModBlocks.DEPTH_NETHER_TILES_SLAB.get(), "Depth Nether Tiles Slab");
                this.add((Block)ModBlocks.GNEISS_TILE_SLAB.get(), "Graphite Slate Tile Slab");
                this.add((Block)ModBlocks.GNEISS_BRICK_SLAB.get(), "Gneiss Brick Slab");
                this.add((Block)ModBlocks.BRICK_BASE_SLAB.get(), "Polished Bricks Slab");
                this.add((Block)ModBlocks.BRICK_LIGHT_SLAB.get(), "Light Bricks Slab");
                this.add((Block)ModBlocks.BRICK_FIRE_SLAB.get(), "Fire Bricks Slab");
                this.add((Block)ModBlocks.BRICK_OBSIDIAN_SLAB.get(), "Obsidian Bricks Slab");
                this.add((Block)ModBlocks.VINYL_TILE_SLAB.get(), "Vinyl Tiles Slab");
                this.add((Block)ModBlocks.VINYL_TILE_SMALL_SLAB.get(), "Small Vinyl Tiles Slab");
                this.add((Block)ModBlocks.BRICK_DUCRETE_SLAB.get(), "Ducrete Bricks Slab");
                this.add((Block)ModBlocks.ASPHALT_SLAB.get(), "Asphalt Slab");
                this.add((Block)ModBlocks.BASALT_POLISHED_SLAB.get(), "Polished Basalt Slab");
                this.add((Block)ModBlocks.BASALT_BRICK_SLAB.get(), "Basalt Bricks Slab");
                this.add((Block)ModBlocks.METEOR_POLISHED_SLAB.get(), "Polished Meteor Slab");
                this.add((Block)ModBlocks.METEOR_BRICK_SLAB.get(), "Meteor Bricks Slab");
                this.add((Block)ModBlocks.METEOR_BRICK_CRACKED_SLAB.get(), "Cracked Meteor Bricks Slab");
                this.add((Block)ModBlocks.METEOR_BRICK_MOSSY_SLAB.get(), "Mossy Meteor Bricks Slab");
                this.add((Block)ModBlocks.METEOR_CRUSHED_SLAB.get(), "Crushed Meteor Slab");
                this.add((Block)ModBlocks.CONCRETE_ASBESTOS_STAIRS.get(), "Asbestos Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_BLACK_STAIRS.get(), "Black Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_BLUE_STAIRS.get(), "Blue Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_BROWN_STAIRS.get(), "Brown Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_COLORED_BRONZE_STAIRS.get(), "Bronze Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_COLORED_INDIGO_STAIRS.get(), "Indigo Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_COLORED_MACHINE_STAIRS.get(), "Concrete 'Machine' Stairs");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PINK_STAIRS.get(), "Pink Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_COLORED_PURPLE_STAIRS.get(), "Purple Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_COLORED_SAND_STAIRS.get(), "Concrete 'Texas' Stairs");
                this.add((Block)ModBlocks.CONCRETE_CYAN_STAIRS.get(), "Cyan Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_GRAY_STAIRS.get(), "Gray Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_GREEN_STAIRS.get(), "Green Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_LIGHT_BLUE_STAIRS.get(), "Light Blue Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_LIME_STAIRS.get(), "Lime Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_MAGENTA_STAIRS.get(), "Magenta Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_ORANGE_STAIRS.get(), "Orange Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_PINK_STAIRS.get(), "Pink Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_PURPLE_STAIRS.get(), "Purple Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_RED_STAIRS.get(), "Red Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_SILVER_STAIRS.get(), "Silver Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_WHITE_STAIRS.get(), "White Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_YELLOW_STAIRS.get(), "Yellow Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_SUPER_STAIRS.get(), "Super Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M0_STAIRS.get(), "Super Concrete M0 Stairs");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M1_STAIRS.get(), "Super Concrete M1 Stairs");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M2_STAIRS.get(), "Super Concrete M2 Stairs");
                this.add((Block)ModBlocks.CONCRETE_SUPER_M3_STAIRS.get(), "Super Concrete M3 Stairs");
                this.add((Block)ModBlocks.CONCRETE_SUPER_BROKEN_STAIRS.get(), "Broken Super Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_REBAR_STAIRS.get(), "Rough Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_FLAT_STAIRS.get(), "Flat Concrete Stairs");
                this.add((Block)ModBlocks.CONCRETE_TILE_STAIRS.get(), "Concrete Tile Stairs");
                this.add((Block)ModBlocks.DEPTH_BRICK_STAIRS.get(), "Depth Bricks Stairs");
                this.add((Block)ModBlocks.DEPTH_TILES_STAIRS.get(), "Depth Tiles Stairs");
                this.add((Block)ModBlocks.DEPTH_NETHER_BRICK_STAIRS.get(), "Depth Nether Bricks Stairs");
                this.add((Block)ModBlocks.DEPTH_NETHER_TILES_STAIRS.get(), "Depth Nether Tiles Stairs");
                this.add((Block)ModBlocks.GNEISS_TILE_STAIRS.get(), "Graphite Slate Tile Stairs");
                this.add((Block)ModBlocks.GNEISS_BRICK_STAIRS.get(), "Gneiss Brick Stairs");
                this.add((Block)ModBlocks.BRICK_BASE_STAIRS.get(), "Polished Bricks Stairs");
                this.add((Block)ModBlocks.BRICK_LIGHT_STAIRS.get(), "Light Bricks Stairs");
                this.add((Block)ModBlocks.BRICK_FIRE_STAIRS.get(), "Fire Bricks Stairs");
                this.add((Block)ModBlocks.BRICK_OBSIDIAN_STAIRS.get(), "Obsidian Bricks Stairs");
                this.add((Block)ModBlocks.VINYL_TILE_STAIRS.get(), "Vinyl Tiles Stairs");
                this.add((Block)ModBlocks.VINYL_TILE_SMALL_STAIRS.get(), "Small Vinyl Tiles Stairs");
                this.add((Block)ModBlocks.BRICK_DUCRETE_STAIRS.get(), "Ducrete Bricks Stairs");
                this.add((Block)ModBlocks.ASPHALT_STAIRS.get(), "Asphalt Stairs");
                this.add((Block)ModBlocks.BASALT_POLISHED_STAIRS.get(), "Polished Basalt Stairs");
                this.add((Block)ModBlocks.BASALT_BRICK_STAIRS.get(), "Basalt Bricks Stairs");
                this.add((Block)ModBlocks.METEOR_POLISHED_STAIRS.get(), "Polished Meteor Stairs");
                this.add((Block)ModBlocks.METEOR_BRICK_STAIRS.get(), "Meteor Bricks Stairs");
                this.add((Block)ModBlocks.METEOR_BRICK_CRACKED_STAIRS.get(), "Cracked Meteor Bricks Stairs");
                this.add((Block)ModBlocks.METEOR_BRICK_MOSSY_STAIRS.get(), "Mossy Meteor Bricks Stairs");
                this.add((Block)ModBlocks.METEOR_CRUSHED_STAIRS.get(), "Crushed Meteor Stairs");
                this.add((Item)ModItems.COIL_TUNGSTEN.get(), "Heating Element");
                this.add((Block)ModBlocks.CONVERTER_BLOCK.get(), "Energy Converter");
                this.add((Block)ModBlocks.MACHINE_BATTERY_DINEUTRONIUM.get(), "Spark Battery");
                this.add((Block)ModBlocks.MACHINE_BATTERY_SCHRABIDIUM.get(), "Shrabidium Battery");
                this.add((Block)ModBlocks.MACHINE_BATTERY_LITHIUM.get(), "Lithium Battery");
                this.add((Item)ModItems.COIL_MAGNETIZED_TUNGSTEN_TORUS.get(), "Magnetized Tungsten Torus Coil");
                this.add((Item)ModItems.COIL_MAGNETIZED_TUNGSTEN.get(), "Magnetized Tungsten Coil");
                this.add((Item)ModItems.COIL_ADVANCED_ALLOY_TORUS.get(), "Advanced Alloy Torus Coil");
                this.add((Item)ModItems.COIL_ADVANCED_ALLOY.get(), "Advanced Alloy Coil");
                this.add((Item)ModItems.COIL_COPPER_TORUS.get(), "Copper Torus Coil");
                this.add((Item)ModItems.COIL_COPPER.get(), "Copper Coil");
                this.add((Item)ModItems.COIL_GOLD_TORUS.get(), "Golden Torus Coil");
                this.add((Item)ModItems.COIL_GOLD.get(), "Golden Coil");
                this.add((Item)ModItems.DUST.get(), "Dust");
                this.add((Item)ModItems.DUST_TINY.get(), "Tiny Dust");
                this.add((Item)ModItems.SCRAP.get(), "Scrap");
                this.add((Item)ModItems.POWDER_COAL.get(), "Coal Powder");
                this.add((Item)ModItems.POWDER_COAL_SMALL.get(), "Tiny Coal Powder");
                this.add((Item)ModItems.BILLET_PLUTONIUM.get(), "Plutonium Billet");
                this.add((Item)ModItems.BLADE_TEST.get(), "Desh Blades");
                this.add((Item)ModItems.BLADE_STEEL.get(), "Steel Blades");
                this.add((Item)ModItems.BLADE_TITANIUM.get(), "Titanium Blades");
                this.add((Item)ModItems.BLADE_ALLOY.get(), "Advanced Alloy Blades");
                this.add((Item)ModItems.BORAX.get(), "Borax");
                this.add((Item)ModItems.BALL_TNT.get(), "TNT Ball");
                this.add((Item)ModItems.BOLT_STEEL.get(), "Steel Bolt");
                this.add((Item)ModItems.ZIRCONIUM_SHARP.get(), "Zirconium Sharp");
                this.add((Block)ModBlocks.CRATE_CONSERVE.get(), "Canned Goods Crate");
                this.add((Block)ModBlocks.CAGE_LAMP.get(), "Cage Lamp");
                this.add((Block)ModBlocks.FLOOD_LAMP.get(), "Flood Lamp");
                this.add((Block)ModBlocks.B29.get(), "B-29");
                this.add((Block)ModBlocks.DORNIER.get(), "Dornier");
                this.add((Block)ModBlocks.FILE_CABINET.get(), "File Cabinet");
                this.add((Block)ModBlocks.TAPE_RECORDER.get(), "Tape Recorder");
                this.add((Block)ModBlocks.CRT_BROKEN.get(), "Broken CRT");
                this.add((Block)ModBlocks.CRT_BSOD.get(), "BSOD CRT");
                this.add((Block)ModBlocks.CRT_CLEAN.get(), "Clean CRT");
                this.add((Block)ModBlocks.TOASTER.get(), "Toaster");
                this.add((Block)ModBlocks.BARREL_CORRODED.get(), "Corroded Barrel");
                this.add((Block)ModBlocks.BARREL_LOX.get(), "LOX Barrel");
                this.add((Block)ModBlocks.BARREL_PINK.get(), "Pink Barrel");
                this.add((Block)ModBlocks.BARREL_YELLOW.get(), "Yellow Barrel");
                this.add((Block)ModBlocks.BARREL_VITRIFIED.get(), "Vitrified Barrel");
                this.add((Block)ModBlocks.BARREL_TAINT.get(), "Tainted Barrel");
                this.add((Block)ModBlocks.BARREL_IRON.get(), "Iron Barrel");
                this.add((Block)ModBlocks.BARREL_STEEL.get(), "Steel Barrel");
                this.add((Block)ModBlocks.BARREL_TCALLOY.get(), "Iron Barrel");
                this.add((Block)ModBlocks.FIRE_DOOR.get(), "Fire Door");
                this.add((Block)ModBlocks.SLIDING_SEAL_DOOR.get(), "Sliding Seal Door");
                this.add((Block)ModBlocks.SECURE_ACCESS_DOOR.get(), "Secure Access Door");
                this.add((Block)ModBlocks.QE_CONTAINMENT.get(), "QE Containment Door");
                this.add((Block)ModBlocks.QE_SLIDING.get(), "QE Sliding Door");
                this.add((Block)ModBlocks.WATER_DOOR.get(), "Waterproof Hatch");
                this.add((Block)ModBlocks.SILO_HATCH.get(), "Silo Hatch");
                this.add((Block)ModBlocks.SILO_HATCH_LARGE.get(), "Large Silo Hatch");
                this.add((Block)ModBlocks.DUD_SALTED.get(), "Unexploded Salted Bomb");
                this.add((Block)ModBlocks.DUD_NUKE.get(), "Unexploded Nuclear Bomb");
                this.add((Block)ModBlocks.DUD_FUGAS_TONG.get(), "Unexploded High-Explosive Bomb");
                this.add((Block)ModBlocks.MINE_FAT.get(), "FatMan Mine");
                this.add((Block)ModBlocks.MINE_AP.get(), "Anti-Personnel Mine");
                this.add((Item)ModItems.GRENADE_NUC.get(), "Nuclear Grenade");
                this.add((Item)ModItems.GRENADE_IF_HE.get(), "IF Grenade: HE");
                this.add((Item)ModItems.GRENADE_IF_FIRE.get(), "IF Grenade: Incendiary");
                this.add((Item)ModItems.GRENADE_IF_SLIME.get(), "IF Grenade: Bouncy");
                this.add((Item)ModItems.MULTI_DETONATOR.get(), "Multi Detonator");
                this.add((Item)ModItems.RANGE_DETONATOR.get(), "Range Detonator");
                this.add((Item)ModItems.DETONATOR.get(), "Detonator");
                this.add((Block)ModBlocks.BARBED_WIRE_POISON.get(), "Poison Barbed Wire");
                this.add((Block)ModBlocks.BARBED_WIRE_FIRE.get(), "Fire Barbed Wire");
                this.add((Block)ModBlocks.BARBED_WIRE_RAD.get(), "Radiation Barbed Wire");
                this.add((Block)ModBlocks.BARBED_WIRE.get(), "Barbed Wire");
                this.add((Block)ModBlocks.BARBED_WIRE_WITHER.get(), "Wither Barbed Wire");
                this.add((Block)ModBlocks.WASTE_CHARGE.get(), "Waste Charge");
                this.add((Block)ModBlocks.GIGA_DET.get(), "Giga Det");
                this.add((Block)ModBlocks.NUCLEAR_CHARGE.get(), "Nuclear Charge");
                this.add((Block)ModBlocks.C4.get(), "C4 Charge");
                this.add((Item)ModItems.DEFUSER.get(), "Defuser");
                this.add((Item)ModItems.CROWBAR.get(), "Crowbar");
                this.add((Item)ModItems.DEPTH_ORES_SCANNER.get(), "Depth Ore Scanner");
                this.add((Item)ModItems.OIL_DETECTOR.get(), "Oil Detector");
                this.add((Block)ModBlocks.SMOKE_BOMB.get(), "Semtex");
                this.add((Item)ModItems.NUGGET_SILICON.get(), "Silicon Nugget");
                this.add((Item)ModItems.BILLET_SILICON.get(), "Silicon Billet");
                this.add((Item)ModItems.PLATE_GOLD.get(), "Golden Plate");
                this.add((Item)ModItems.PLATE_GUNMETAL.get(), "Gunmetal Plate");
                this.add((Item)ModItems.PLATE_GUNSTEEL.get(), "Gunsteel Plate");
                this.add((Item)ModItems.PLATE_TITANIUM.get(), "Titanium Plate");
                this.add((Item)ModItems.PLATE_IRON.get(), "Iron Plate");
                this.add((Item)ModItems.PLATE_KEVLAR.get(), "Kevlar Plate");
                this.add((Item)ModItems.PLATE_LEAD.get(), "Lead Plate");
                this.add((Item)ModItems.PLATE_MIXED.get(), "Mixed Plate");
                this.add((Item)ModItems.PLATE_PAA.get(), "PAA Plate");
                this.add((Item)ModItems.INSULATOR.get(), "Insulator");
                this.add((Item)ModItems.PLATE_SATURNITE.get(), "Saturnite Plate");
                this.add((Item)ModItems.PLATE_SCHRABIDIUM.get(), "Schrabidium Plate");
                this.add((Item)ModItems.PLATE_STEEL.get(), "Steel Plate");
                this.add((Item)ModItems.PLATE_ADVANCED_ALLOY.get(), "Advanced Alloy Plate");
                this.add((Item)ModItems.PLATE_ALUMINUM.get(), "Aluminum Plate");
                this.add((Item)ModItems.PLATE_COPPER.get(), "Copper Plate");
                this.add((Item)ModItems.PLATE_BISMUTH.get(), "Bismuth Plate");
                this.add((Item)ModItems.PLATE_ARMOR_AJR.get(), "AJR Armor Plate");
                this.add((Item)ModItems.PLATE_ARMOR_DNT.get(), "DNT Armor Plate");
                this.add((Item)ModItems.PLATE_ARMOR_DNT_RUSTED.get(), "Rusted DNT Armor Plate");
                this.add((Item)ModItems.PLATE_ARMOR_FAU.get(), "FAU Armor Plate");
                this.add((Item)ModItems.PLATE_ARMOR_HEV.get(), "HEV Armor Plate");
                this.add((Item)ModItems.PLATE_ARMOR_LUNAR.get(), "Lunar Armor Plate");
                this.add((Item)ModItems.PLATE_ARMOR_TITANIUM.get(), "Titanium Armor Plate");
                this.add((Item)ModItems.PLATE_CAST.get(), "Casting Mold");
                this.add((Item)ModItems.PLATE_CAST_ALT.get(), "Alternative Casting Mold");
                this.add((Item)ModItems.PLATE_CAST_BISMUTH.get(), "Bismuth Casting Mold");
                this.add((Item)ModItems.PLATE_CAST_DARK.get(), "Dark Casting Mold");
                this.add((Item)ModItems.PLATE_COMBINE_STEEL.get(), "Combine Steel Plate");
                this.add((Item)ModItems.PLATE_DURA_STEEL.get(), "Dura Steel Plate");
                this.add((Item)ModItems.PLATE_DALEKANIUM.get(), "Dalekanium Plate");
                this.add((Item)ModItems.PLATE_DESH.get(), "Desh Plate");
                this.add((Item)ModItems.PLATE_DINEUTRONIUM.get(), "Dineutronium Plate");
                this.add((Item)ModItems.PLATE_EUPHEMIUM.get(), "Euphemium Plate");
                this.add((Item)ModItems.PLATE_FUEL_MOX.get(), "MOX Fuel Plate");
                this.add((Item)ModItems.PLATE_FUEL_PU238BE.get(), "Pu-238/Be Fuel Plate");
                this.add((Item)ModItems.PLATE_FUEL_PU239.get(), "Pu-239 Fuel Plate");
                this.add((Item)ModItems.PLATE_FUEL_RA226BE.get(), "Ra-226/Be Fuel Plate");
                this.add((Item)ModItems.PLATE_FUEL_SA326.get(), "SA-326 Fuel Plate");
                this.add((Item)ModItems.PLATE_FUEL_U233.get(), "U-233 Fuel Plate");
                this.add((Item)ModItems.PLATE_FUEL_U235.get(), "U-235 Fuel Plate");
                this.add("item.hbm_m.firebrick", "Firebrick");
                this.add("item.hbm_m.uranium_raw", "Raw Uranium");
                this.add("item.hbm_m.tungsten_raw", "Raw Tungsten");
                this.add("item.hbm_m.titanium_raw", "Raw Titanium");
                this.add("item.hbm_m.thorium_raw", "Raw Thorium");
                this.add("item.hbm_m.lead_raw", "Raw Lead");
                this.add("item.hbm_m.cobalt_raw", "Raw Cobalt");
                this.add("item.hbm_m.beryllium_raw", "Raw Beryllium");
                this.add("item.hbm_m.aluminum_raw", "Raw Aluminum");
                this.add("item.hbm_m.cinnabar", "Cinnabar");
                this.add("item.hbm_m.sulfur", "Sulfur");
                this.add("item.hbm_m.rareground_ore_chunk", "Rareground Ore Chunk");
                this.add("item.hbm_m.lignite", "Lignite");
                this.add("item.hbm_m.fluorite", "Fluorite");
                this.add("item.hbm_m.fireclay_ball", "Fireclay Ball");
                this.add("item.hbm_m.wood_ash_powder", "Wood Ash Powder");
                this.add("tooltip.hbm_m.mods", "Modifications:");
                this.add("tooltip.hbm_m.heart_piece.effect", "+5 Max Health");
                this.add("tooltip.hbm_m.applies_to", "Applies to:");
                this.add("tooltip.hbm_m.helmet", "Helmet");
                this.add("tooltip.hbm_m.chestplate", "Chestplate");
                this.add("tooltip.hbm_m.leggings", "Leggings");
                this.add("tooltip.hbm_m.boots", "Boots");
                this.add("tooltip.hbm_m.armor.all", "Any Armor");
                this.add("tooltip.hbm_m.armor_table.main_slot", "Insert armor to be modified...");
                this.add("tooltip.hbm_m.slot", "Slot");
                this.add("tooltip.hbm_m.armor_table.helmet_slot", "Helmet");
                this.add("tooltip.hbm_m.armor_table.chestplate_slot", "Chestplate");
                this.add("tooltip.hbm_m.armor_table.leggings_slot", "Leggings");
                this.add("tooltip.hbm_m.armor_table.boots_slot", "Boots");
                this.add("tooltip.hbm_m.armor_table.battery_slot", "Battery");
                this.add("tooltip.hbm_m.armor_table.special_slot", "Special");
                this.add("tooltip.hbm_m.armor_table.plating_slot", "Plating");
                this.add("tooltip.hbm_m.armor_table.casing_slot", "Casing");
                this.add("tooltip.hbm_m.armor_table.servos_slot", "Servos");
                this.add("gui.hbm_m.blast_furnace.accepts", "Accepts items from: %s");
                this.add("direction.hbm_m.down", "Down");
                this.add("direction.hbm_m.up", "Up");
                this.add("direction.hbm_m.north", "North");
                this.add("direction.hbm_m.south", "South");
                this.add("direction.hbm_m.west", "West");
                this.add("direction.hbm_m.east", "East");
                this.add("gui.hbm_m.anvil.inputs", "Inputs:");
                this.add("gui.hbm_m.anvil.outputs", "Outputs:");
                this.add("gui.hbm_m.anvil.search", "Search");
                this.add("gui.hbm_m.anvil.search_hint", "Search...");
                this.add("gui.hbm_m.anvil.tier", "Required Tier: %s");
                this.add("tier.hbm_m.anvil.iron", "Iron");
                this.add("tier.hbm_m.anvil.steel", "Steel");
                this.add("tier.hbm_m.anvil.oil", "Oil");
                this.add("tier.hbm_m.anvil.nuclear", "Nuclear");
                this.add("tier.hbm_m.anvil.rbmk", "RBMK");
                this.add("tier.hbm_m.anvil.fusion", "Fusion");
                this.add("tier.hbm_m.anvil.particle", "Particle");
                this.add("tier.hbm_m.anvil.gerald", "Gerald");
                this.add("tier.hbm_m.anvil.murky", "Murky");
                this.add("block.hbm_m.anvil_block", "Industrial Anvil");
                this.add("block.hbm_m.anvil_iron", "Iron Anvil");
                this.add("block.hbm_m.anvil_lead", "Lead Anvil");
                this.add("block.hbm_m.anvil_steel", "Steel Anvil");
                this.add("block.hbm_m.anvil_desh", "Desh Anvil");
                this.add("block.hbm_m.anvil_ferrouranium", "Ferrouranium Anvil");
                this.add("block.hbm_m.anvil_saturnite", "Saturnite Anvil");
                this.add("block.hbm_m.anvil_bismuth_bronze", "Bismuth Bronze Anvil");
                this.add("block.hbm_m.anvil_arsenic_bronze", "Arsenic Bronze Anvil");
                this.add("block.hbm_m.anvil_schrabidate", "Schrabidate Anvil");
                this.add("block.hbm_m.anvil_dnt", "DNT Anvil");
                this.add("block.hbm_m.anvil_osmiridium", "Osmiridium Anvil");
                this.add("block.hbm_m.anvil_murky", "Murky Anvil");
                this.add("block.hbm_m.door_office", "Office Door");
                this.add("block.hbm_m.door_bunker", "Bunker Door");
                this.add("block.hbm_m.metal_door", "Metal Door");
                this.add("block.hbm_m.demon_lamp", "Demon Lamp (WIP)");
                this.add("block.hbm_m.explosive_charge", "Explosive Charge");
                this.add("block.hbm_m.reinforced_glass", "Reinforced Glass");
                this.add("block.hbm_m.crate", "Crate");
                this.add("block.hbm_m.crate_lead", "Lead Crate");
                this.add("block.hbm_m.crate_metal", "Metal Crate");
                this.add("block.hbm_m.crate_weapon", "Weapon Crate");
                this.add("block.hbm_m.uranium_block", "Uranium Block");
                this.add("block.hbm_m.plutonium_block", "Plutonium Block");
                this.add("block.hbm_m.plutonium_fuel_block", "Plutonium Fuel Block");
                this.add("block.hbm_m.polonium210_block", "Polonium-210 Block");
                this.add("block.hbm_m.armor_table", "Armor Modification Table");
                this.add("block.hbm_m.machine_assembler", "Assembly Machine (Legacy)");
                this.add("block.hbm_m.advanced_assembly_machine", "Assembly Machine");
                this.add("block.hbm_m.machine_battery", "Machine Battery");
                this.add("block.hbm_m.shredder", "Shredder");
                this.add("block.hbm_m.wood_burner", "Wood Burner Generator");
                this.add("block.hbm_m.blast_furnace", "Blast Furnace");
                this.add("block.hbm_m.blast_furnace_extension", "Blast Furnace Extension");
                this.add("block.hbm_m.press", "Press");
                this.add("block.hbm_m.crate_iron", "Iron Crate");
                this.add("block.hbm_m.crate_steel", "Steel Crate");
                this.add("block.hbm_m.crate_desh", "Desh Crate");
                this.add("block.hbm_m.det_miner", "Det Miner");
                this.add("block.hbm_m.concrete_vent", "Concrete Vent");
                this.add("block.hbm_m.concrete_fan", "Concrete Fan");
                this.add("block.hbm_m.concrete_marked", "Marked Concrete");
                this.add("block.hbm_m.concrete_cracked", "Cracked Concrete");
                this.add("block.hbm_m.concrete_mossy", "Mossy Concrete");
                this.add("block.hbm_m.concrete", "Concrete");
                this.add("block.hbm_m.concrete_cracked_stairs", "Concrete Cracked Stairs");
                this.add("block.hbm_m.concrete_cracked_slab", "Concrete Cracked Slab");
                this.add("block.hbm_m.concrete_mossy_stairs", "Concrete Mossy Stairs");
                this.add("block.hbm_m.concrete_mossy_slab", "Concrete Mossy Slab");
                this.add("block.hbm_m.brick_concrete", "Concrete Bricks");
                this.add("block.hbm_m.brick_concrete_slab", "Concrete Bricks Slab");
                this.add("block.hbm_m.brick_concrete_stairs", "Concrete Bricks Stairs");
                this.add("block.hbm_m.brick_concrete_broken", "Broken Concrete Bricks");
                this.add("block.hbm_m.brick_concrete_broken_slab", "Broken Concrete Bricks Slab");
                this.add("block.hbm_m.brick_concrete_broken_stairs", "Broken Concrete Bricks Stairs");
                this.add("block.hbm_m.brick_concrete_cracked", "Cracked Concrete Bricks");
                this.add("block.hbm_m.brick_concrete_cracked_slab", "Cracked Concrete Bricks Slab");
                this.add("block.hbm_m.brick_concrete_cracked_stairs", "Cracked Concrete Bricks Stairs");
                this.add("block.hbm_m.brick_concrete_mossy", "Mossy Concrete Bricks");
                this.add("block.hbm_m.brick_concrete_mossy_slab", "Mossy Concrete Bricks Slab");
                this.add("block.hbm_m.brick_concrete_mossy_stairs", "Mossy Concrete Bricks Stairs");
                this.add("block.hbm_m.brick_concrete_marked", "Marked Concrete Bricks");
                this.add("block.hbm_m.concrete_hazard", "Concrete Block with Hazard line");
                this.add("block.hbm_m.concrete_hazard_slab", "Concrete Slab with Hazard line");
                this.add("block.hbm_m.concrete_hazard_stairs", "Concrete Stairs with Hazard line");
                this.add("block.hbm_m.concrete_stairs", "Concrete Stairs");
                this.add("block.hbm_m.concrete_slab", "Concrete Slab");
                this.add("block.hbm_m.large_vehicle_door", "Large Vehicle Door");
                this.add("block.hbm_m.round_airlock_door", "Round Airlock Door");
                this.add("block.hbm_m.strawberry_bush", "Strawberry Bush");
                this.add("block.hbm_m.geiger_counter_block", "Geiger Counter Block");
                this.add("block.hbm_m.wire_coated", "Red Copper Wire");
                this.add((Block)ModBlocks.RESOURCE_ASBESTOS.get(), "Asbestos Cluster");
                this.add((Block)ModBlocks.RESOURCE_BAUXITE.get(), "Bauxite");
                this.add((Block)ModBlocks.RESOURCE_HEMATITE.get(), "Hematite");
                this.add((Block)ModBlocks.RESOURCE_LIMESTONE.get(), "Limestone");
                this.add((Block)ModBlocks.RESOURCE_MALACHITE.get(), "Malachite");
                this.add((Block)ModBlocks.RESOURCE_SULFUR.get(), "Sulfur Cluster");
                this.add("block.hbm_m.cinnabar_ore_deepslate", "Deepslate Cinnabar Ore");
                this.add("block.hbm_m.cobalt_ore_deepslate", "Deepslate Cobalt Ore");
                this.add("block.hbm_m.uranium_ore", "Uranium Ore");
                this.add("block.hbm_m.aluminum_ore", "Aluminum Ore");
                this.add("block.hbm_m.aluminum_ore_deepslate", "Deepslate Aluminum Ore");
                this.add("block.hbm_m.titanium_ore", "Titanium Ore");
                this.add("block.hbm_m.titanium_ore_deepslate", "Deepslate Titanium Ore");
                this.add("block.hbm_m.tungsten_ore", "Tungsten Ore");
                this.add("block.hbm_m.asbestos_ore", "Asbestos Ore");
                this.add("block.hbm_m.sulfur_ore", "Sulfur Ore");
                this.add("block.hbm_m.cobalt_ore", "Cobalt Ore");
                this.add("block.hbm_m.uranium_ore_h", "High-Yield Uranium Ore");
                this.add("block.hbm_m.uranium_ore_deepslate", "Deepslate Uranium Ore");
                this.add("block.hbm_m.thorium_ore", "Thorium Ore");
                this.add("block.hbm_m.thorium_ore_deepslate", "Deepslate Thorium Ore");
                this.add("block.hbm_m.rareground_ore", "Rare Earth Ore");
                this.add("block.hbm_m.rareground_ore_deepslate", "Deepslate Rare Earth Ore");
                this.add("block.hbm_m.lignite_ore", "Lignite Ore");
                this.add("block.hbm_m.beryllium_ore", "Beryllium Ore");
                this.add("block.hbm_m.beryllium_ore_deepslate", "Deepslate Beryllium Ore");
                this.add("block.hbm_m.fluorite_ore", "Fluorite Ore");
                this.add("block.hbm_m.lead_ore", "Lead Ore");
                this.add("block.hbm_m.lead_ore_deepslate", "Deepslate Lead Ore");
                this.add("block.hbm_m.cinnabar_ore", "Cinnabar Ore");
                this.add("block.hbm_m.waste_grass", "Waste Grass");
                this.add("block.hbm_m.waste_leaves", "Waste Leaves");
                this.add("block.hbm_m.freaky_alien_block", "Freaky Allien Block");
                this.add("block.hbm_m.reinforced_stone", "Reinforced Stone");
                this.add("block.hbm_m.reinforced_stone_slab", "Reinforced Stone Slab");
                this.add("block.hbm_m.reinforced_stone_stairs", "Reinforced Stone Stairs");
                this.add("block.hbm_m.switch", "Switch");
                this.add("tooltip.hbm_m.rad_protection.value", "Radiation Resistance: %s");
                this.add("tooltip.hbm_m.rad_protection.value_short", "%s rad-resistance");
                this.add("container.inventory", "Inventory");
                this.add("container.hbm_m.armor_table", "Armor Modification Table");
                this.add("container.hbm_m.machine_assembler", "Assembly Machine");
                this.add("container.hbm_m.wood_burner", "Wood Burner Generator");
                this.add("container.hbm_m.advanced_assembly_machine", "Assembly Machine");
                this.add("container.hbm_m.machine_battery", "Machine Battery");
                this.add("container.hbm_m.press", "Press");
                this.add("container.hbm_m.anvil_block", "Industrial Anvil");
                this.add("container.hbm_m.anvil", "%s Anvil");
                this.add("container.hbm_m.crate_iron", "Iron Crate");
                this.add("container.hbm_m.crate_steel", "Steel Crate");
                this.add("container.hbm_m.crate_desh", "Desh Crate");
                this.add("gui.hbm_m.battery.priority.0", "Priority: Low");
                this.add("gui.hbm_m.battery.priority.0.desc", "Lowest priority. Will be drained first and filled last.");
                this.add("gui.hbm_m.battery.priority.1", "Priority: Normal");
                this.add("gui.hbm_m.battery.priority.1.desc", "Standard priority for energy transfer.");
                this.add("gui.hbm_m.battery.priority.2", "Priority: High");
                this.add("gui.hbm_m.battery.priority.2.desc", "Highest priority. Will be filled first and drained last.");
                this.add("gui.hbm_m.battery.priority.recommended", "(Recommended)");
                this.add("gui.hbm_m.battery.condition.no_signal", "When there is NO redstone signal:");
                this.add("gui.hbm_m.battery.condition.with_signal", "When there IS a redstone signal:");
                this.add("gui.hbm_m.battery.mode.both", "Mode: Input & Output");
                this.add("gui.hbm_m.battery.mode.both.desc", "All energy operations are allowed.");
                this.add("gui.hbm_m.battery.mode.input", "Mode: Input Only");
                this.add("gui.hbm_m.battery.mode.input.desc", "Only receiving energy is allowed.");
                this.add("gui.hbm_m.battery.mode.output", "Mode: Output Only");
                this.add("gui.hbm_m.battery.mode.output.desc", "Only sending energy is allowed.");
                this.add("gui.hbm_m.battery.mode.locked", "Mode: Locked");
                this.add("gui.hbm_m.battery.mode.locked.desc", "All energy operations are disabled.");
                this.add("gui.recipe.setRecipe", "Set Recipe");
                this.add("tooltip.hbm_m.machine_battery.capacity", "Capacity: %1$s HE");
                this.add("tooltip.hbm_m.machine_battery.charge_speed", "Charge Speed: %1$s HE/t");
                this.add("tooltip.hbm_m.machine_battery.discharge_speed", "Discharge Speed: %1$s HE/t");
                this.add("tooltip.hbm_m.machine_battery.stored", "Stored: %1$s / %2$s HE");
                this.add("hazard.hbm_m.radiation", "[Radioactive]");
                this.add("hazard.hbm_m.radiation.format", "%s RAD/s");
                this.add("hazard.hbm_m.hydro_reactive", "[Hydro-reactive]");
                this.add("hazard.hbm_m.explosive_on_fire", "[Flammable / Explosive]");
                this.add("hazard.hbm_m.pyrophoric", "[Pyrophoric / Hot]");
                this.add("hazard.hbm_m.explosion_strength.format", " Explosion Strength - %s");
                this.add("hazard.hbm_m.stack", "Stack: %s");
                this.add("tooltip.hbm_m.abilities", "Abilities:");
                this.add("tooltip.hbm_m.vein_miner", "Vein Miner (%s)");
                this.add("tooltip.hbm_m.aoe", "AOE (%s x %s x %s)");
                this.add("tooltip.hbm_m.silk_touch", "Silk Touch");
                this.add("tooltip.hbm_m.fortune", "Fortune (%s)");
                this.add("tooltip.hbm_m.right_click", "Right click - toggle ability");
                this.add("tooltip.hbm_m.shift_right_click", "Shift + Right click - disable all");
                this.add("message.hbm_m.vein_miner.enabled", "Vein Miner %s enabled!");
                this.add("message.hbm_m.vein_miner.disabled", "Vein Miner %s disabled!");
                this.add("message.hbm_m.aoe.enabled", "AOE %s x %s x %s enabled!");
                this.add("message.hbm_m.aoe.disabled", "AOE %s x %s x %s disabled!");
                this.add("message.hbm_m.silk_touch.enabled", "Silk Touch enabled!");
                this.add("message.hbm_m.silk_touch.disabled", "Silk Touch disabled!");
                this.add("message.hbm_m.fortune.enabled", "Fortune %s enabled!");
                this.add("message.hbm_m.fortune.disabled", "Fortune %s disabled!");
                this.add("message.hbm_m.disabled", "All abilities disabled!");
                this.add("item.hbm_m.meter.geiger_counter.name", "GEIGER COUNTER");
                this.add("item.hbm_m.meter.dosimeter.name", "DOSIMETER");
                this.add("item.hbm_m.meter.title_format", "%s");
                this.add("hbm_m.render.shader_detected", "\u00a7e[HBM] \u00a77External shader detected. Switching to compatible renderer...");
                this.add("hbm_m.render.shader_disabled", "\u00a7a[HBM] \u00a77Shader disabled. Returning to optimized VBO renderer.");
                this.add("hbm_m.render.path_changed", "\u00a7e[HBM] \u00a77Render path set to: %s");
                this.add("hbm_m.render.status", "\u00a7e[HBM] \u00a77Current render path: \u00a7f%s\n\u00a77External shader detected: \u00a7f%s");
                this.add("item.hbm_m.meter.chunk_rads", "\u00a7eCurrent chunk radiation: %s\n");
                this.add("item.hbm_m.meter.env_rads", "\u00a7eTotal environment contamination: %s");
                this.add("item.hbm_m.meter.player_rads", "\u00a7ePlayer contamination: %s\n");
                this.add("item.hbm_m.meter.protection", "\u00a7ePlayer protection: %s (%s)");
                this.add("item.hbm_m.meter.rads_over_limit", ">%s RAD/s");
                this.add("gui.hbm_m.battery.energy.info", "%s / %s HE");
                this.add("gui.hbm_m.battery.energy.delta", "%s HE/t");
                this.add("tooltip.hbm_m.hold_shift_for_details", "<Hold SHIFT to display more info>");
                this.add("sounds.hbm_m.geiger_counter", "Geiger Counter clicking");
                this.add("sounds.hbm_m.tool.techboop", "Geiger counter beep");
                this.add("commands.hbm_m.rad.cleared", "Radiation cleared for %s players.");
                this.add("commands.hbm_m.rad.cleared.self", "Your radiation has been cleared.");
                this.add("commands.hbm_m.rad.added", "Added %s radiation to %s players.");
                this.add("commands.hbm_m.rad.added.self", "You have been given %s radiation.");
                this.add("commands.hbm_m.rad.removed", "Removed %s radiation from %s players.");
                this.add("commands.hbm_m.rad.removed.self", "%s radiation has been removed from you.");
                this.add("death.attack.radiation", "Player %s died from radiation sickness");
                this.add("advancements.hbm_m.radiation_200.title", "Hooray, Radiation!");
                this.add("advancements.hbm_m.radiation_200.description", "Reach a radiation level of 200 RAD");
                this.add("advancements.hbm_m.radiation_1000.title", "Ouch, Radiation!");
                this.add("advancements.hbm_m.radiation_1000.description", "Die from radiation sickness");
                this.add("chat.hbm_m.structure.obstructed", "Placement obstructed by other blocks!");
                this.add("text.autoconfig.hbm_m.title", "Radiation Settings (HBM Modernized)");
                this.add("text.autoconfig.hbm_m.category.general", "General Settings");
                this.add("text.autoconfig.hbm_m.option.enableRadiation", "Enable radiation");
                this.add("text.autoconfig.hbm_m.option.enableChunkRads", "Enable chunk radiation");
                this.add("text.autoconfig.hbm_m.option.usePrismSystem", "Use PRISM system (otherwise Simple), WIP");
                this.add("text.autoconfig.hbm_m.category.world_effects", "World Effects");
                this.add("text.autoconfig.hbm_m.option.worldRadEffects", "World Radiation Effects");
                this.add("text.autoconfig.hbm_m.option.worldRadEffects.@Tooltip", "Enables/disables world destruction effects from high radiation (block replacement, vegetation decay, etc.).");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsThreshold", "World Destruction Threshold");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsThreshold.@Tooltip", "The minimum ambient radiation level in a chunk at which world destruction effects begin.");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsBlockChecks", "Block Checks per Tick");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsBlockChecks.@Tooltip", "The number of random block checks in an affected chunk per tick. Affects the speed of destruction. Higher values may impact performance.");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxScaling", "Max Destruction Scaler");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxScaling.@Tooltip", "The maximum speed multiplier for world destruction at peak radiation. 1 = no scaling, 4 = can be up to 4 times faster. Max value - 10x");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxDepth", "Destruction Depth");
                this.add("text.autoconfig.hbm_m.option.worldRadEffectsMaxDepth.@Tooltip", "The maximum depth (in blocks) from the surface that world destruction effects can reach.");
                this.add("text.autoconfig.hbm_m.option.enableRadFogEffect", "Enable Radiation Fog Effect");
                this.add("text.autoconfig.hbm_m.option.radFogThreshold", "Fog Threshold");
                this.add("text.autoconfig.hbm_m.option.radFogChance", "Fog Chance");
                this.add("text.autoconfig.hbm_m.category.player", "Player");
                this.add("text.autoconfig.hbm_m.option.maxPlayerRad", "Max player radiation level");
                this.add("text.autoconfig.hbm_m.option.radDecay", "Player radiation decay rate");
                this.add("text.autoconfig.hbm_m.option.radDamage", "Radiation damage");
                this.add("text.autoconfig.hbm_m.option.radDamageThreshold", "Radiation damage threshold");
                this.add("text.autoconfig.hbm_m.option.radSickness", "Nausea threshold");
                this.add("text.autoconfig.hbm_m.option.radWater", "Water negative effect threshold, WIP");
                this.add("text.autoconfig.hbm_m.option.radConfusion", "Confusion threshold, WIP");
                this.add("text.autoconfig.hbm_m.option.radBlindness", "Blindness threshold");
                this.add("text.autoconfig.hbm_m.category.overlay", "Screen Overlays");
                this.add("text.autoconfig.hbm_m.option.enableRadiationPixelEffect", "Enable Radiation Screen Pixel Effect");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectThreshold", "Pixel Effect Threshold");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxIntensityRad", "Pixel Effect Max Intensity");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectMaxDots", "Max Pixel Count");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectGreenChance", "Green Pixel Chance");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMinLifetime", "Min Pixel Lifetime");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxLifetime", "Max Pixel Lifetime");
                this.add("text.autoconfig.hbm_m.option.enableObstructionHighlight", "Enable Obstruction Highlight");
                this.add("text.autoconfig.hbm_m.option.enableObstructionHighlight.@Tooltip", "If enabled, blocks obstructing multiblock placement\nwill be highlighted with a red box.");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightAlpha", "Obstruction Highlight Opacity");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightAlpha.@Tooltip", "Sets the opacity of the highlight box's fill.\n0% = Invisible, 100% = Solid.");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightDuration", "Highlight Duration (sec)");
                this.add("text.autoconfig.hbm_m.option.obstructionHighlightDuration.@Tooltip", "The duration in seconds for how long the obstruction highlight will be visible.");
                this.add("text.autoconfig.hbm_m.category.chunk", "Chunk");
                this.add("text.autoconfig.hbm_m.option.maxRad", "Max chunk radiation");
                this.add("text.autoconfig.hbm_m.option.fogRad", "Fog radiation threshold");
                this.add("text.autoconfig.hbm_m.option.fogCh", "Fog chance (1 in fogCh), WIP");
                this.add("text.autoconfig.hbm_m.option.radChunkDecay", "Chunk radiation decay rate");
                this.add("text.autoconfig.hbm_m.option.radChunkSpreadFactor", "Chunk radiation spread factor");
                this.add("text.autoconfig.hbm_m.option.radSpreadThreshold", "Radiation spread threshold");
                this.add("text.autoconfig.hbm_m.option.minRadDecayAmount", "Min decay per tick");
                this.add("text.autoconfig.hbm_m.option.radSourceInfluenceFactor", "Source influence factor");
                this.add("text.autoconfig.hbm_m.option.radRandomizationFactor", "Chunk radiation randomization factor");
                this.add("text.autoconfig.hbm_m.category.rendering", "Rendering");
                this.add("text.autoconfig.hbm_m.option.modelUpdateDistance", "Distance for .obj model dynamic parts rendering");
                this.add("text.autoconfig.hbm_m.option.enableOcclusionCulling", "Enable model occlusion culling");
                this.add("text.autoconfig.hbm_m.category.debug", "Debug");
                this.add("text.autoconfig.hbm_m.option.enableDebugRender", "Enable radiation debug render");
                this.add("text.autoconfig.hbm_m.option.debugRenderTextSize", "Debug render text size");
                this.add("text.autoconfig.hbm_m.option.debugRenderDistance", "Debug render distance (chunks)");
                this.add("text.autoconfig.hbm_m.option.debugRenderInSurvival", "Show debug render in survival mode");
                this.add("text.autoconfig.hbm_m.option.enableDebugLogging", "Enable debug logging");
                this.add("key.hbm_m.open_config", "Open configuration menu");
                this.add("key.categories.hbm_m", "HBM Modernized");
                this.add("text.autoconfig.hbm_m.option.enableRadiation.@Tooltip", "If disabled, all radiation is turned off (chunks, items)");
                this.add("text.autoconfig.hbm_m.option.enableChunkRads.@Tooltip", "If disabled, chunk radiation is always 0");
                this.add("text.autoconfig.hbm_m.option.usePrismSystem.@Tooltip", "Use PRISM system for chunk radiation (WIP)");
                this.add("text.autoconfig.hbm_m.option.enableRadFogEffect.@Tooltip", "Enables/disables the radioactive fog particle effect in chunks with high radiation levels.");
                this.add("text.autoconfig.hbm_m.option.radFogThreshold.@Tooltip", "The minimum ambient radiation level in a chunk for the fog effect to appear.");
                this.add("text.autoconfig.hbm_m.option.radFogChance.@Tooltip", "The chance for fog particles to spawn in a suitable chunk per second. Calculated as 1 in X. A lower value means more frequent fog.");
                this.add("text.autoconfig.hbm_m.option.maxPlayerRad.@Tooltip", "Maximum radiation the player can accumulate");
                this.add("text.autoconfig.hbm_m.option.radDecay.@Tooltip", "How fast player radiation decays per tick");
                this.add("text.autoconfig.hbm_m.option.radDamage.@Tooltip", "Damage per tick when above threshold (Will be reworked)");
                this.add("text.autoconfig.hbm_m.option.radDamageThreshold.@Tooltip", "Player starts taking damage above this value");
                this.add("text.autoconfig.hbm_m.option.radSickness.@Tooltip", "Threshold for nausea effect");
                this.add("text.autoconfig.hbm_m.option.radWater.@Tooltip", "Threshold for water negative effect (WIP)");
                this.add("text.autoconfig.hbm_m.option.radConfusion.@Tooltip", "Threshold for confusion effect (WIP)");
                this.add("text.autoconfig.hbm_m.option.radBlindness.@Tooltip", "Threshold for blindness effect");
                this.add("text.autoconfig.hbm_m.option.enableRadiationPixelEffect.@Tooltip", "Shows random, flickering pixels on the screen when the player is exposed to incoming radiation.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectThreshold.@Tooltip", "The minimum incoming radiation (RAD/s) required for the visual interference effect to appear.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxIntensityRad.@Tooltip", "The level of incoming radiation (RAD/s) at which the pixel effect reaches its maximum strength (maximum number of pixels).");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectMaxDots.@Tooltip", "The maximum number of pixels that can be on the screen at once when the effect is at its peak intensity. Affects performance on weak systems.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelEffectGreenChance.@Tooltip", "The probability (from 0.0 to 1.0) that a newly appeared pixel will be green instead of white. E.g., 0.1 = 10% chance.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMinLifetime.@Tooltip", "The minimum time (in ticks) a single pixel will stay on the screen. 20 ticks = 1 second.");
                this.add("text.autoconfig.hbm_m.option.radiationPixelMaxLifetime.@Tooltip", "The maximum time (in ticks) a single pixel will stay on the screen. A random value between min and max lifetime is chosen for each pixel.");
                this.add("text.autoconfig.hbm_m.option.maxRad.@Tooltip", "Maximum chunk radiation");
                this.add("text.autoconfig.hbm_m.option.fogRad.@Tooltip", "Chunk radiation for fog to appear (WIP)");
                this.add("text.autoconfig.hbm_m.option.fogCh.@Tooltip", "Chance for fog to appear (WIP)");
                this.add("text.autoconfig.hbm_m.option.radChunkDecay.@Tooltip", "How fast chunk radiation decays");
                this.add("text.autoconfig.hbm_m.option.radChunkSpreadFactor.@Tooltip", "How much radiation spreads to neighboring chunks");
                this.add("text.autoconfig.hbm_m.option.radSpreadThreshold.@Tooltip", "Below this, radiation doesn't spread");
                this.add("text.autoconfig.hbm_m.option.minRadDecayAmount.@Tooltip", "Minimum decay per tick in chunk");
                this.add("text.autoconfig.hbm_m.option.radSourceInfluenceFactor.@Tooltip", "Influence of radioactive blocks in chunk");
                this.add("text.autoconfig.hbm_m.option.radRandomizationFactor.@Tooltip", "Randomization factor for chunk radiation");
                this.add("text.autoconfig.hbm_m.option.modelUpdateDistance.@Tooltip", "Distance for .obj model dynamic parts rendering (in chunks)");
                this.add("text.autoconfig.hbm_m.option.enableOcclusionCulling.@Tooltip", "Enable model occlusion culling (disable if your models are not rendering correctly)");
                this.add("text.autoconfig.hbm_m.option.enableDebugRender.@Tooltip", "Whether radiation debug render is enabled (F3)");
                this.add("text.autoconfig.hbm_m.option.debugRenderTextSize.@Tooltip", "Debug render text size");
                this.add("text.autoconfig.hbm_m.option.debugRenderDistance.@Tooltip", "Debug render distance (in chunks)");
                this.add("text.autoconfig.hbm_m.option.debugRenderInSurvival.@Tooltip", "Show debug renderer in survival mode");
                this.add("text.autoconfig.hbm_m.option.enableDebugLogging.@Tooltip", "If disabled, deep logging of game events will be active. Do not enable unless you experience problems");
            }
        }
    }

    private /* synthetic */ void lambda$addTranslations$3(ModIngots ingot, RegistryObject tiny) {
        if (tiny != null && tiny.isPresent()) {
            this.add((Item)tiny.get(), this.buildPowderName(ingot, true));
        }
    }
}

