/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.item.ModIngots;
import com.hbm_m.item.ModItems;
import com.hbm_m.item.ModPowders;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModVanillaRecipeProvider
extends RecipeProvider {
    public ModVanillaRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> writer) {
        this.registerAll(writer);
    }

    public void registerVanillaRecipes(@NotNull Consumer<FinishedRecipe> writer) {
        this.registerAll(writer);
    }

    private void registerAll(@NotNull Consumer<FinishedRecipe> writer) {
        this.registerToolAndArmorSets(writer);
        this.registerCrates(writer);
        this.registerCoil(writer);
        this.registerCoilTorus(writer);
        this.registerStamps(writer);
        this.registerGrenades(writer);
        this.registerUtilityRecipes(writer);
        this.registerPowderCooking(writer);
        this.registerOreAndRawCooking(writer);
    }

    private boolean isItemSafe(RegistryObject<?> itemObj) {
        return itemObj != null && itemObj.get() != null;
    }

    private ItemLike safeIngot(ModIngots ingot) {
        RegistryObject<Item> obj = ModItems.getIngot(ingot);
        return this.isItemSafe(obj) ? (ItemLike)obj.get() : Items.f_41852_;
    }

    private Item safePowder(ModPowders powder) {
        RegistryObject<Item> obj = ModItems.getPowders(powder);
        return this.isItemSafe(obj) ? (Item)obj.get() : null;
    }

    private void registerUtilityRecipes(Consumer<FinishedRecipe> writer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.DOOR_BUNKER.get())).m_126130_("$$$").m_126130_("###").m_126130_("$$$").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_LEAD.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_LEAD.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get()))).m_126140_(writer, this.recipeId("crafting/door_bunker"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.METAL_DOOR.get())).m_126130_("$$$").m_126130_("###").m_126130_("$$$").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_IRON.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get()))).m_126140_(writer, this.recipeId("crafting/metal_door"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.DOOR_OFFICE.get())).m_126130_("$$$").m_126130_("###").m_126130_("$$$").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_IRON.get()).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_41888_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get()))).m_126140_(writer, this.recipeId("crafting/door_office"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MOTOR.get()), (int)2).m_126130_(" $ ").m_126130_("%#%").m_126130_("%@%").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.PLATE_IRON.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.WIRE_RED_COPPER.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.COIL_COPPER.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.COIL_COPPER_TORUS.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.COIL_COPPER_TORUS.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.COIL_COPPER_TORUS.get()))).m_126140_(writer, this.recipeId("crafting/motor"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MOTOR_DESH.get()), (int)2).m_126130_("@$@").m_126130_("%#%").m_126130_("@$@").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.getIngot(ModIngots.DESH).get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.COIL_GOLD_TORUS.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.MOTOR.get()).m_126124_(Character.valueOf('@'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.getIngot(ModIngots.BAKELITE).get(), (ItemLike)ModItems.getIngot(ModIngots.POLYMER).get()})).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_DESH.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_DESH.get()))).m_126140_(writer, this.recipeId("crafting/motor_desh"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INSULATOR.get()), (int)4).m_126130_("$  ").m_126130_("$  ").m_126130_("   ").m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42460_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)Items.f_42460_), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Items.f_42460_)).m_126140_(writer, this.recipeId("crafting/insulator2"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INSULATOR.get()), (int)4).m_126130_("$#$").m_126130_("   ").m_126130_("   ").m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_41870_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)Items.f_41870_), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Items.f_41870_)).m_126140_(writer, this.recipeId("crafting/insulator"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INSULATOR.get()), (int)16).m_126130_("## ").m_126130_("   ").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.getIngot(ModIngots.ASBESTOS).get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.ASBESTOS).get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.ASBESTOS).get()))).m_126140_(writer, this.recipeId("crafting/insulator3"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SWITCH.get())).m_126130_("#  ").m_126130_("@  ").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)ModBlocks.WIRE_COATED.get()).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_41966_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModBlocks.WIRE_COATED.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModBlocks.WIRE_COATED.get()))).m_126140_(writer, this.recipeId("crafting/switch"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GEIGER_COUNTER_BLOCK.get())).m_126130_("#  ").m_126130_("   ").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.GEIGER_COUNTER.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.GEIGER_COUNTER.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.GEIGER_COUNTER.get()))).m_126140_(writer, this.recipeId("crafting/geiger1"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GEIGER_COUNTER.get())).m_126130_("#  ").m_126130_("   ").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)ModBlocks.GEIGER_COUNTER_BLOCK.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModBlocks.GEIGER_COUNTER_BLOCK.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModBlocks.GEIGER_COUNTER_BLOCK.get()))).m_126140_(writer, this.recipeId("crafting/geiger2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GEIGER_COUNTER.get())).m_126130_("###").m_126130_("%$@").m_126130_("%&&").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.WIRE_GOLD.get()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.INTEGRATED_CIRCUIT.get()).m_126127_(Character.valueOf('&'), (ItemLike)ModItems.getIngot(ModIngots.BERYLLIUM).get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.ANALOG_CIRCUIT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.ANALOG_CIRCUIT.get()))).m_126140_(writer, this.recipeId("crafting/geiger3"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.DEFUSER.get())).m_126130_(" # ").m_126130_("$ $").m_126130_("$ $").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.BOLT_STEEL.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get()))).m_126140_(writer, this.recipeId("crafting/defuser"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CRT_DISPLAY.get()), (int)4).m_126130_(" # ").m_126130_("$@$").m_126130_(" % ").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.getPowder(ModIngots.ALUMINUM).get()).m_126127_(Character.valueOf('%'), (ItemLike)ModItems.VACUUM_TUBE.get()).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42027_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.VACUUM_TUBE.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.VACUUM_TUBE.get()))).m_126140_(writer, this.recipeId("crafting/crt_ds"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MICROCHIP.get())).m_126130_("#  ").m_126130_("@  ").m_126130_("%  ").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.INSULATOR.get()).m_126124_(Character.valueOf('%'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WIRE_COPPER.get(), (ItemLike)ModItems.WIRE_GOLD.get()})).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.SILICON_CIRCUIT.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.SILICON_CIRCUIT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.SILICON_CIRCUIT.get()))).m_126140_(writer, this.recipeId("crafting/microchip"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.PCB.get()), (int)4).m_126130_("#  ").m_126130_("@  ").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.INSULATOR.get()).m_126124_(Character.valueOf('@'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PLATE_COPPER.get(), (ItemLike)ModItems.PLATE_GOLD.get()})).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.INSULATOR.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.INSULATOR.get()))).m_126140_(writer, this.recipeId("crafting/pcb"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.DOSIMETER.get())).m_126130_("$%$").m_126130_("$@$").m_126130_("$#$").m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42647_).m_126127_(Character.valueOf('%'), (ItemLike)Items.f_42027_).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.getIngot(ModIngots.BERYLLIUM).get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.VACUUM_TUBE.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.VACUUM_TUBE.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.VACUUM_TUBE.get()))).m_126140_(writer, this.recipeId("crafting/dosimeter"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CROWBAR.get())).m_126130_("$$ ").m_126130_(" $ ").m_126130_(" $ ").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.getIngot(ModIngots.STEEL).get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.STEEL).get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.STEEL).get()))).m_126140_(writer, this.recipeId("crafting/crowbar"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.OIL_DETECTOR.get())).m_126130_("# @").m_126130_("#$@").m_126130_("&&&").m_126127_(Character.valueOf('&'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_151052_).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.ANALOG_CIRCUIT.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.WIRE_GOLD.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.ANALOG_CIRCUIT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.ANALOG_CIRCUIT.get()))).m_126140_(writer, this.recipeId("crafting/oil_detector"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.DEPTH_ORES_SCANNER.get())).m_126130_("###").m_126130_("@%@").m_126130_("$$$").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.VACUUM_TUBE.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.CAPACITOR.get()).m_126127_(Character.valueOf('%'), (ItemLike)ModItems.CONTROLLER_CHASSIS.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_GOLD.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.CONTROLLER_CHASSIS.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.CONTROLLER_CHASSIS.get()))).m_126140_(writer, this.recipeId("crafting/depth_ores_scanner"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CONVERTER_BLOCK.get())).m_126130_("###").m_126130_("@@@").m_126130_("$$$").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.CAPACITOR.get()).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.getIngot(ModIngots.STEEL).get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.STEEL).get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.STEEL).get()))).m_126140_(writer, this.recipeId("crafting/converter_block"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BOLT_STEEL.get()), (int)16).m_126130_("$  ").m_126130_("$  ").m_126130_("   ").m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42416_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_126140_(writer, this.recipeId("crafting/bolt_steel"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GRENADE_IF.get())).m_126130_(" $ ").m_126130_("#@#").m_126130_(" # ").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.COIL_TUNGSTEN.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.BALL_TNT.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get()))).m_126140_(writer, this.recipeId("crafting/grenade_if"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VACUUM_TUBE.get())).m_126130_("$  ").m_126130_("#  ").m_126130_("@  ").m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42027_).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.WIRE_TUNGSTEN.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.INSULATOR.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.WIRE_TUNGSTEN.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.WIRE_TUNGSTEN.get()))).m_126140_(writer, this.recipeId("crafting/vacuum_tube"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CAPACITOR.get()), (int)2).m_126130_("$#$").m_126130_("% %").m_126130_("   ").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.INSULATOR.get()).m_126124_(Character.valueOf('%'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WIRE_COPPER.get(), (ItemLike)ModItems.WIRE_ALUMINIUM.get()})).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.getPowder(ModIngots.ALUMINUM).get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.getPowder(ModIngots.ALUMINUM).get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.getPowder(ModIngots.ALUMINUM).get()))).m_126140_(writer, this.recipeId("crafting/capacitor"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CAGE_LAMP.get()), (int)4).m_126130_(" % ").m_126130_(" @ ").m_126130_(" ! ").m_126127_(Character.valueOf('%'), (ItemLike)Items.f_42027_).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.WIRE_TUNGSTEN.get()).m_126127_(Character.valueOf('!'), (ItemLike)Items.f_42416_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_126140_(writer, this.recipeId("crafting/cage_lamp"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.BARBED_WIRE.get()), (int)16).m_126130_("$@$").m_126130_("@ @").m_126130_("$@$").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.WIRE_FINE.get()).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42416_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.WIRE_FINE.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.WIRE_FINE.get()))).m_126140_(writer, this.recipeId("crafting/barbed_wire"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.WIRE_COATED.get()), (int)16).m_126130_(" $ ").m_126130_("@@@").m_126130_(" $ ").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.INSULATOR.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.WIRE_RED_COPPER.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.WIRE_RED_COPPER.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.WIRE_RED_COPPER.get()))).m_126140_(writer, this.recipeId("crafting/wire_coated"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.WOOD_BURNER.get())).m_126130_("$$$").m_126130_("@&@").m_126130_("% %").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.COIL_COPPER.get()).m_126127_(Character.valueOf('&'), (ItemLike)Items.f_41962_).m_126127_(Character.valueOf('%'), (ItemLike)Items.f_42416_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get()))).m_126140_(writer, this.recipeId("crafting/wood_burner"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ARMOR_TABLE.get())).m_126130_("$$$").m_126130_("%&%").m_126130_("%#%").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('%'), (ItemLike)ModItems.getIngot(ModIngots.TUNGSTEN).get()).m_126127_(Character.valueOf('&'), (ItemLike)Items.f_41960_).m_126127_(Character.valueOf('#'), (ItemLike)ModBlocks.getIngotBlock(ModIngots.STEEL).get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get()))).m_126140_(writer, this.recipeId("crafting/armor_table"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.DETONATOR.get())).m_126130_("#  ").m_126130_("@  ").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.INTEGRATED_CIRCUIT.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.INTEGRATED_CIRCUIT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.INTEGRATED_CIRCUIT.get()))).m_126140_(writer, this.recipeId("crafting/detonator"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MULTI_DETONATOR.get())).m_126130_("@# ").m_126130_("   ").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.ADVANCED_CIRCUIT.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.DETONATOR.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.ADVANCED_CIRCUIT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.ADVANCED_CIRCUIT.get()))).m_126140_(writer, this.recipeId("crafting/multi_detonator"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.MINE_AP.get())).m_126130_("@  ").m_126130_("#  ").m_126130_("$  ").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.BALL_TNT.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.getIngot(ModIngots.STEEL).get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.INSULATOR.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.BALL_TNT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.BALL_TNT.get()))).m_126140_(writer, this.recipeId("crafting/mine_ap"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.MINE_FAT.get())).m_126130_("@  ").m_126130_("#  ").m_126130_("$  ").m_126127_(Character.valueOf('#'), (ItemLike)ModBlocks.MINE_AP.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.getIngot(ModIngots.TUNGSTEN).get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.BILLET_PLUTONIUM.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.BILLET_PLUTONIUM.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.BILLET_PLUTONIUM.get()))).m_126140_(writer, this.recipeId("crafting/mine_fat"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RANGE_DETONATOR.get())).m_126130_("##$").m_126130_("\u2116&%").m_126130_("  @").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('\u2116'), (ItemLike)Items.f_42153_).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('%'), (ItemLike)ModItems.ADVANCED_CIRCUIT.get()).m_126127_(Character.valueOf('&'), (ItemLike)ModItems.CAPACITOR_BOARD.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.BOLT_STEEL.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.ADVANCED_CIRCUIT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.ADVANCED_CIRCUIT.get()))).m_126140_(writer, this.recipeId("crafting/range_detonator"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BALL_TNT.get()), (int)4).m_126130_("#$ ").m_126130_("@% ").m_126130_("   ").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.POWDER_COAL.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.SULFUR.get()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42403_).m_126127_(Character.valueOf('%'), (ItemLike)Items.f_42501_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.SULFUR.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.SULFUR.get()))).m_126140_(writer, this.recipeId("crafting/ball_tnt"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.REINFORCED_STONE.get()), (int)4).m_126130_("#$#").m_126130_("$#$").m_126130_("#$#").m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50652_).m_126127_(Character.valueOf('$'), (ItemLike)Blocks.f_50069_).m_126132_("has_stone", (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Blocks.f_50069_)).m_126140_(writer, this.recipeId("crafting/reinforced_stone"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.DET_MINER.get()), (int)4).m_126130_("$$$").m_126130_("%#%").m_126130_("%#%").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.PLATE_IRON.get()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_41996_).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42484_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get()))).m_126140_(writer, this.recipeId("crafting/det_miner"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.PRESS.get())).m_126130_("%$%").m_126130_("%#%").m_126130_("%@%").m_126127_(Character.valueOf('%'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_41913_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_41962_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)Items.f_41869_), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Items.f_41869_)).m_126140_(writer, this.recipeId("crafting/press"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.BLAST_FURNACE_EXTENSION.get())).m_126130_(" $ ").m_126130_("%#%").m_126130_("%#%").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('%'), (ItemLike)ModItems.FIREBRICK.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_COPPER.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)Items.f_41869_), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Items.f_41869_)).m_126140_(writer, this.recipeId("crafting/blast_furnace_extension"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.EXPLOSIVE_CHARGE.get())).m_126130_("$% ").m_126130_("%$ ").m_126130_("   ").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.BALL_TNT.get()).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_41830_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.BALL_TNT.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.BALL_TNT.get()))).m_126140_(writer, this.recipeId("crafting/explosive_charge"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ANVIL_IRON.get())).m_126130_("###").m_126130_(" @ ").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_41913_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_126140_(writer, this.recipeId("crafting/anvil_iron"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ANVIL_LEAD.get())).m_126130_("###").m_126130_(" @ ").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.getIngot(ModIngots.LEAD).get()).m_126127_(Character.valueOf('@'), (ItemLike)ModBlocks.getIngotBlock(ModIngots.LEAD).get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.LEAD).get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.getIngot(ModIngots.LEAD).get()))).m_126140_(writer, this.recipeId("crafting/anvil_lead"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.NUCLEAR_CHARGE.get())).m_126130_("$$$").m_126130_("%@%").m_126130_("%#%").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.MAN_CORE.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.CONTROLLER.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.INSULATOR.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.MAN_CORE.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.MAN_CORE.get()))).m_126140_(writer, this.recipeId("crafting/nuclear_charge"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CONTROLLER_CHASSIS.get())).m_126130_("$$$").m_126130_("%##").m_126130_("$$$").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_ALUMINUM.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PCB.get()).m_126127_(Character.valueOf('%'), (ItemLike)ModItems.CRT_DISPLAY.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.CRT_DISPLAY.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.CRT_DISPLAY.get()))).m_126140_(writer, this.recipeId("crafting/controller_chassis"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FIRECLAY_BALL.get()), (int)4).m_126130_("AB").m_126130_("BB").m_126127_(Character.valueOf('A'), (ItemLike)ModItems.ALUMINUM_RAW.get()).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42461_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.ALUMINUM_RAW.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.ALUMINUM_RAW.get()))).m_126140_(writer, this.recipeId("crafting/alclay_fireclay"));
        this.registerSmelting(writer, (ItemLike)ModItems.FIRECLAY_BALL.get(), (ItemLike)ModItems.FIREBRICK.get(), 0.1f, 100, "firebrick_smelting");
    }

    private void registerPowderCooking(Consumer<FinishedRecipe> writer) {
        Item ironPowder = this.safePowder(ModPowders.IRON);
        Item goldPowder = this.safePowder(ModPowders.GOLD);
        Item coalPowder = this.safePowder(ModPowders.COAL);
        if (ironPowder != null) {
            this.registerSmelting(writer, (ItemLike)ironPowder, (ItemLike)Items.f_42416_, 0.0f, 200, "powder_iron_smelting");
            this.registerBlasting(writer, (ItemLike)ironPowder, (ItemLike)Items.f_42416_, 0.0f, 100, "powder_iron_blasting");
        }
        if (goldPowder != null) {
            this.registerSmelting(writer, (ItemLike)goldPowder, (ItemLike)Items.f_42417_, 0.0f, 200, "powder_gold_smelting");
            this.registerBlasting(writer, (ItemLike)goldPowder, (ItemLike)Items.f_42417_, 0.0f, 100, "powder_gold_blasting");
        }
        if (coalPowder != null) {
            this.registerSmelting(writer, (ItemLike)coalPowder, (ItemLike)Items.f_42413_, 0.0f, 200, "powder_coal_smelting");
            this.registerBlasting(writer, (ItemLike)coalPowder, (ItemLike)Items.f_42413_, 0.0f, 100, "powder_coal_blasting");
        }
    }

    private void registerOreAndRawCooking(Consumer<FinishedRecipe> writer) {
        ItemLike uraniumIngot = (ItemLike)ModItems.getIngot(ModIngots.URANIUM).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.URANIUM_RAW.get(), uraniumIngot, 2.1f, 3.0f, "uranium_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.URANIUM_ORE.get(), uraniumIngot, 2.1f, 3.0f, "uranium_ore");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.URANIUM_ORE_DEEPSLATE.get(), uraniumIngot, 2.1f, 3.0f, "uranium_ore_deepslate");
        ItemLike thoriumIngot = (ItemLike)ModItems.getIngot(ModIngots.THORIUM232).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.THORIUM_RAW.get(), thoriumIngot, 2.1f, 3.0f, "thorium_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.THORIUM_ORE.get(), thoriumIngot, 2.1f, 3.0f, "thorium_ore");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.THORIUM_ORE_DEEPSLATE.get(), thoriumIngot, 2.1f, 3.0f, "thorium_ore_deepslate");
        ItemLike titaniumIngot = (ItemLike)ModItems.getIngot(ModIngots.TITANIUM).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.TITANIUM_RAW.get(), titaniumIngot, 0.7f, 1.0f, "titanium_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.TITANIUM_ORE.get(), titaniumIngot, 0.7f, 1.0f, "titanium_ore");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.TITANIUM_ORE_DEEPSLATE.get(), titaniumIngot, 0.7f, 1.0f, "titanium_ore_deepslate");
        ItemLike tungstenIngot = (ItemLike)ModItems.getIngot(ModIngots.TUNGSTEN).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.TUNGSTEN_RAW.get(), tungstenIngot, 0.7f, 1.0f, "tungsten_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.TUNGSTEN_ORE.get(), tungstenIngot, 0.7f, 1.0f, "tungsten_ore");
        ItemLike leadIngot = (ItemLike)ModItems.getIngot(ModIngots.LEAD).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.LEAD_RAW.get(), leadIngot, 0.7f, 1.0f, "lead_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.LEAD_ORE.get(), leadIngot, 0.7f, 1.0f, "lead_ore");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.LEAD_ORE_DEEPSLATE.get(), leadIngot, 0.7f, 1.0f, "lead_ore_deepslate");
        ItemLike cobaltIngot = (ItemLike)ModItems.getIngot(ModIngots.COBALT).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.COBALT_RAW.get(), cobaltIngot, 0.7f, 1.0f, "cobalt_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.COBALT_ORE.get(), cobaltIngot, 0.7f, 1.0f, "cobalt_ore");
        ItemLike berylliumIngot = (ItemLike)ModItems.getIngot(ModIngots.BERYLLIUM).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.BERYLLIUM_RAW.get(), berylliumIngot, 0.7f, 1.0f, "beryllium_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.BERYLLIUM_ORE.get(), berylliumIngot, 0.7f, 1.0f, "beryllium_ore");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.BERYLLIUM_ORE_DEEPSLATE.get(), berylliumIngot, 0.7f, 1.0f, "beryllium_ore_deepslate");
        ItemLike aluminumIngot = (ItemLike)ModItems.getIngot(ModIngots.ALUMINUM).get();
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModItems.ALUMINUM_RAW.get(), aluminumIngot, 0.7f, 1.0f, "aluminum_raw");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.ALUMINUM_ORE.get(), aluminumIngot, 0.7f, 1.0f, "aluminum_ore");
        this.registerSmeltingAndBlasting(writer, (ItemLike)ModBlocks.ALUMINUM_ORE_DEEPSLATE.get(), aluminumIngot, 0.7f, 1.0f, "aluminum_ore_deepslate");
    }

    private void buildBlades(Consumer<FinishedRecipe> writer, Item result, ItemLike material, ItemLike material2, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_(" $ ").m_126130_("$#$").m_126130_(" $ ").m_126127_(Character.valueOf('$'), material2).m_126127_(Character.valueOf('#'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void registerCrates(Consumer<FinishedRecipe> writer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CRATE_IRON.get())).m_126130_("AAA").m_126130_("B B").m_126130_("BBB").m_126127_(Character.valueOf('A'), (ItemLike)ModItems.PLATE_IRON.get()).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42416_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_IRON.get()))).m_126140_(writer, this.recipeId("crafting/crate_iron"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CRATE_STEEL.get())).m_126130_("AAA").m_126130_("B B").m_126130_("BBB").m_126127_(Character.valueOf('A'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.getIngot(ModIngots.STEEL).get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get()))).m_126140_(writer, this.recipeId("crafting/crate_steel"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CRATE_DESH.get())).m_126130_("AAA").m_126130_("ABA").m_126130_("AAA").m_126127_(Character.valueOf('A'), (ItemLike)ModItems.PLATE_DESH.get()).m_126127_(Character.valueOf('B'), (ItemLike)ModBlocks.CRATE_STEEL.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_DESH.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_DESH.get()))).m_126140_(writer, this.recipeId("crafting/crate_desh"));
    }

    private void registerStamps(Consumer<FinishedRecipe> writer) {
        this.buildStamp(writer, (Item)ModItems.STAMP_STONE_FLAT.get(), (ItemLike)Items.f_41905_, "stamp_stone_flat");
        this.buildStamp(writer, (Item)ModItems.STAMP_IRON_FLAT.get(), (ItemLike)Items.f_42416_, "stamp_iron_flat");
        this.buildStamp(writer, (Item)ModItems.STAMP_STEEL_FLAT.get(), (ItemLike)ModItems.getIngot(ModIngots.STEEL).get(), "stamp_steel_flat");
        this.buildStamp(writer, (Item)ModItems.STAMP_TITANIUM_FLAT.get(), (ItemLike)ModItems.getIngot(ModIngots.TITANIUM).get(), "stamp_titanium_flat");
        this.buildStamp(writer, (Item)ModItems.STAMP_OBSIDIAN_FLAT.get(), (ItemLike)Blocks.f_50080_.m_5456_(), "stamp_obsidian_flat");
        this.buildStamp(writer, (Item)ModItems.STAMP_DESH_FLAT.get(), (ItemLike)ModItems.getIngot(ModIngots.DESH).get(), "stamp_desh_flat");
    }

    private void registerGrenades(Consumer<FinishedRecipe> writer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GRENADE.get())).m_126130_("%@ ").m_126130_("#$#").m_126130_(" # ").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.WIRE_RED_COPPER.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_IRON.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.BALL_TNT.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLATE_STEEL.get()))).m_126140_(writer, this.recipeId("crafting/grenade"));
        this.buildGrenadeUpgrade(writer, (Item)ModItems.GRENADEHE.get(), (ItemLike)ModItems.BALL_TNT.get(), "grenadehe");
        this.buildGrenadeUpgrade(writer, (Item)ModItems.GRENADESLIME.get(), (ItemLike)Items.f_42518_, "grenadeslime");
        this.buildGrenadeUpgrade(writer, (Item)ModItems.GRENADEFIRE.get(), (ItemLike)ModItems.getIngot(ModIngots.PHOSPHORUS).get(), "grenadefire");
        this.buildGrenadeIfUpgrade(writer, (Item)ModItems.GRENADE_IF_HE.get(), (ItemLike)ModItems.BALL_TNT.get(), "grenade_if_he");
        this.buildGrenadeIfUpgrade(writer, (Item)ModItems.GRENADE_IF_SLIME.get(), (ItemLike)Items.f_42518_, "grenade_if_slime");
        this.buildGrenadeIfUpgrade(writer, (Item)ModItems.GRENADE_IF_FIRE.get(), (ItemLike)ModItems.getIngot(ModIngots.PHOSPHORUS).get(), "grenade_if_fire");
        this.buildBlades(writer, (Item)ModItems.BLADE_STEEL.get(), (ItemLike)ModItems.getIngot(ModIngots.STEEL).get(), (ItemLike)ModItems.PLATE_STEEL.get(), "blades_steel");
        this.buildBlades(writer, (Item)ModItems.BLADE_TITANIUM.get(), (ItemLike)ModItems.getIngot(ModIngots.TITANIUM).get(), (ItemLike)ModItems.PLATE_TITANIUM.get(), "blades_titanium");
        this.buildBlades(writer, (Item)ModItems.BLADE_ALLOY.get(), (ItemLike)ModItems.getIngot(ModIngots.ADVANCED_ALLOY).get(), (ItemLike)ModItems.PLATE_ADVANCED_ALLOY.get(), "blades_advanced_alloy");
        this.buildBarbedWireUpgrade(writer, Item.m_41439_((Block)((Block)ModBlocks.BARBED_WIRE_FIRE.get())), (ItemLike)Items.f_42593_, "barbed_wire_fire");
        this.buildBarbedWireUpgrade(writer, Item.m_41439_((Block)((Block)ModBlocks.BARBED_WIRE_POISON.get())), (ItemLike)Items.f_42591_, "barbed_wire_poison");
        this.buildBarbedWireUpgrade(writer, Item.m_41439_((Block)((Block)ModBlocks.BARBED_WIRE_WITHER.get())), (ItemLike)Items.f_42679_, "barbed_wire_wither");
        this.buildBarbedWireUpgrade(writer, Item.m_41439_((Block)((Block)ModBlocks.BARBED_WIRE_RAD.get())), (ItemLike)ModItems.BILLET_PLUTONIUM.get(), "barbed_wire_rad");
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GRENADESMART.get()), (int)4).m_126130_(" @ ").m_126130_("&%$").m_126130_(" # ").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.GRENADE.get()).m_126127_(Character.valueOf('&'), (ItemLike)ModItems.getIngot(ModIngots.PHOSPHORUS).get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('@'), (ItemLike)ModItems.MICROCHIP.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.BALL_TNT.get()).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.GRENADE.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.GRENADE.get()))).m_126140_(writer, this.recipeId("crafting/grenadesmart"));
    }

    private void registerToolAndArmorSets(Consumer<FinishedRecipe> writer) {
        ItemLike titaniumIngot = (ItemLike)ModItems.getIngot(ModIngots.TITANIUM).get();
        this.buildToolSet(writer, "titanium", titaniumIngot, (Item)ModItems.TITANIUM_SWORD.get(), (Item)ModItems.TITANIUM_SHOVEL.get(), (Item)ModItems.TITANIUM_PICKAXE.get(), (Item)ModItems.TITANIUM_HOE.get(), (Item)ModItems.TITANIUM_AXE.get());
        this.buildArmorSet(writer, "titanium", titaniumIngot, (Item)ModItems.TITANIUM_HELMET.get(), (Item)ModItems.TITANIUM_CHESTPLATE.get(), (Item)ModItems.TITANIUM_LEGGINGS.get(), (Item)ModItems.TITANIUM_BOOTS.get());
        ItemLike steelIngot = (ItemLike)ModItems.getIngot(ModIngots.STEEL).get();
        this.buildToolSet(writer, "steel", steelIngot, (Item)ModItems.STEEL_SWORD.get(), (Item)ModItems.STEEL_SHOVEL.get(), (Item)ModItems.STEEL_PICKAXE.get(), (Item)ModItems.STEEL_HOE.get(), (Item)ModItems.STEEL_AXE.get());
        this.buildArmorSet(writer, "steel", steelIngot, (Item)ModItems.STEEL_HELMET.get(), (Item)ModItems.STEEL_CHESTPLATE.get(), (Item)ModItems.STEEL_LEGGINGS.get(), (Item)ModItems.STEEL_BOOTS.get());
        ItemLike starmetalIngot = (ItemLike)ModItems.getIngot(ModIngots.STARMETAL).get();
        this.buildToolSet(writer, "starmetal", starmetalIngot, (Item)ModItems.STARMETAL_SWORD.get(), (Item)ModItems.STARMETAL_SHOVEL.get(), (Item)ModItems.STARMETAL_PICKAXE.get(), (Item)ModItems.STARMETAL_HOE.get(), (Item)ModItems.STARMETAL_AXE.get());
        this.buildArmorSet(writer, "starmetal", starmetalIngot, (Item)ModItems.STARMETAL_HELMET.get(), (Item)ModItems.STARMETAL_CHESTPLATE.get(), (Item)ModItems.STARMETAL_LEGGINGS.get(), (Item)ModItems.STARMETAL_BOOTS.get());
        ItemLike alloyIngot = (ItemLike)ModItems.getIngot(ModIngots.ADVANCED_ALLOY).get();
        this.buildToolSet(writer, "alloy", alloyIngot, (Item)ModItems.ALLOY_SWORD.get(), (Item)ModItems.ALLOY_SHOVEL.get(), (Item)ModItems.ALLOY_PICKAXE.get(), (Item)ModItems.ALLOY_HOE.get(), (Item)ModItems.ALLOY_AXE.get());
        this.buildArmorSet(writer, "alloy", alloyIngot, (Item)ModItems.ALLOY_HELMET.get(), (Item)ModItems.ALLOY_CHESTPLATE.get(), (Item)ModItems.ALLOY_LEGGINGS.get(), (Item)ModItems.ALLOY_BOOTS.get());
        ItemLike cobaltIngot = (ItemLike)ModItems.getIngot(ModIngots.COBALT).get();
        this.buildArmorSet(writer, "cobalt", cobaltIngot, (Item)ModItems.COBALT_HELMET.get(), (Item)ModItems.COBALT_CHESTPLATE.get(), (Item)ModItems.COBALT_LEGGINGS.get(), (Item)ModItems.COBALT_BOOTS.get());
        ItemLike asbestosSheet = (ItemLike)ModItems.getIngot(ModIngots.ASBESTOS).get();
        this.buildArmorSet(writer, "asbestos", asbestosSheet, (Item)ModItems.ASBESTOS_HELMET.get(), (Item)ModItems.ASBESTOS_CHESTPLATE.get(), (Item)ModItems.ASBESTOS_LEGGINGS.get(), (Item)ModItems.ASBESTOS_BOOTS.get());
    }

    private void registerCoil(Consumer<FinishedRecipe> writer) {
        this.buildCoil(writer, (Item)ModItems.COIL_ADVANCED_ALLOY.get(), (ItemLike)ModItems.WIRE_ADVANCED_ALLOY.get(), "coil_advanced_alloy");
        this.buildCoil(writer, (Item)ModItems.COIL_COPPER.get(), (ItemLike)ModItems.WIRE_RED_COPPER.get(), "coil_copper");
        this.buildCoil(writer, (Item)ModItems.COIL_GOLD.get(), (ItemLike)ModItems.WIRE_GOLD.get(), "coil_gold");
        this.buildCoil(writer, (Item)ModItems.COIL_MAGNETIZED_TUNGSTEN.get(), (ItemLike)ModItems.WIRE_MAGNETIZED_TUNGSTEN.get(), "coil_magnetized_tungsten");
        this.buildCoil(writer, (Item)ModItems.COIL_TUNGSTEN.get(), (ItemLike)ModItems.WIRE_TUNGSTEN.get(), "coil_tungsten");
    }

    private void registerCoilTorus(Consumer<FinishedRecipe> writer) {
        this.buildCoilTorus(writer, (Item)ModItems.COIL_ADVANCED_ALLOY_TORUS.get(), (ItemLike)ModItems.COIL_ADVANCED_ALLOY.get(), "coil_advanced_alloy_torus");
        this.buildCoilTorus(writer, (Item)ModItems.COIL_COPPER_TORUS.get(), (ItemLike)ModItems.COIL_COPPER.get(), "coil_copper_torus");
        this.buildCoilTorus(writer, (Item)ModItems.COIL_GOLD_TORUS.get(), (ItemLike)ModItems.COIL_GOLD.get(), "coil_gold_torus");
        this.buildCoilTorus(writer, (Item)ModItems.COIL_MAGNETIZED_TUNGSTEN_TORUS.get(), (ItemLike)ModItems.COIL_MAGNETIZED_TUNGSTEN.get(), "coil_magnetized_tungsten_torus");
    }

    private void buildCoil(Consumer<FinishedRecipe> writer, Item result, ItemLike material, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("###").m_126130_("#$#").m_126130_("###").m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('#'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildCoilTorus(Consumer<FinishedRecipe> writer, Item result, ItemLike material, String name) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)2).m_126130_(" # ").m_126130_("#$#").m_126130_(" # ").m_126127_(Character.valueOf('$'), (ItemLike)ModItems.PLATE_IRON.get()).m_126127_(Character.valueOf('#'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildGrenadeUpgrade(Consumer<FinishedRecipe> writer, Item result, ItemLike core, String name) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result, (int)4).m_126130_(" # ").m_126130_("$%$").m_126130_(" # ").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.GRENADE.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('$'), core).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.GRENADE.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.GRENADE.get()))).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildGrenadeIfUpgrade(Consumer<FinishedRecipe> writer, Item result, ItemLike core, String name) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result, (int)2).m_126130_(" # ").m_126130_("$%$").m_126130_(" # ").m_126127_(Character.valueOf('%'), (ItemLike)ModItems.GRENADE_IF.get()).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.PLATE_STEEL.get()).m_126127_(Character.valueOf('$'), core).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.GRENADE_IF.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.GRENADE_IF.get()))).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildBarbedWireUpgrade(Consumer<FinishedRecipe> writer, Item result, ItemLike core, String name) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result, (int)8).m_126130_("###").m_126130_("#@#").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)ModBlocks.BARBED_WIRE.get()).m_126127_(Character.valueOf('@'), core).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)((ItemLike)ModBlocks.BARBED_WIRE.get())), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)((ItemLike)ModBlocks.BARBED_WIRE.get()))).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildStamp(Consumer<FinishedRecipe> writer, Item result, ItemLike material, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("###").m_126130_("$$$").m_126130_("   ").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42460_).m_126127_(Character.valueOf('$'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildSword(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_(" # ").m_126130_(" # ").m_126130_(" $ ").m_126127_(Character.valueOf('#'), material).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42398_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildShovel(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_(" # ").m_126130_(" $ ").m_126130_(" $ ").m_126127_(Character.valueOf('#'), material).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42398_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildPickaxe(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("###").m_126130_(" $ ").m_126130_(" $ ").m_126127_(Character.valueOf('#'), material).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42398_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildHoe(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("## ").m_126130_(" $ ").m_126130_(" $ ").m_126127_(Character.valueOf('#'), material).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42398_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildAxe(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("## ").m_126130_("#$ ").m_126130_(" $ ").m_126127_(Character.valueOf('#'), material).m_126127_(Character.valueOf('$'), (ItemLike)Items.f_42398_).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildHelmet(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("###").m_126130_("# #").m_126127_(Character.valueOf('#'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildChestplate(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("# #").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildLeggings(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("###").m_126130_("# #").m_126130_("# #").m_126127_(Character.valueOf('#'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildBoots(Consumer<FinishedRecipe> writer, ItemLike material, Item result, String name) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("# #").m_126130_("# #").m_126127_(Character.valueOf('#'), material).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)material)).m_126140_(writer, this.recipeId("crafting/" + name));
    }

    private void buildToolSet(Consumer<FinishedRecipe> writer, String name, ItemLike material, Item sword, Item shovel, Item pickaxe, Item hoe, Item axe) {
        this.buildSword(writer, material, sword, name + "_sword");
        this.buildShovel(writer, material, shovel, name + "_shovel");
        this.buildPickaxe(writer, material, pickaxe, name + "_pickaxe");
        this.buildHoe(writer, material, hoe, name + "_hoe");
        this.buildAxe(writer, material, axe, name + "_axe");
    }

    private void buildArmorSet(Consumer<FinishedRecipe> writer, String name, ItemLike material, Item helmet, Item chestplate, Item leggings, Item boots) {
        this.buildHelmet(writer, material, helmet, name + "_helmet");
        this.buildChestplate(writer, material, chestplate, name + "_chestplate");
        this.buildLeggings(writer, material, leggings, name + "_leggings");
        this.buildBoots(writer, material, boots, name + "_boots");
    }

    private void registerSmeltingAndBlasting(Consumer<FinishedRecipe> writer, ItemLike input, ItemLike output, float smeltXp, float blastXp, String baseName) {
        this.registerSmelting(writer, input, output, smeltXp, 200, baseName + "_smelting");
        this.registerBlasting(writer, input, output, blastXp, 100, baseName + "_blasting");
    }

    private void registerSmelting(Consumer<FinishedRecipe> writer, ItemLike input, ItemLike result, float xp, int time, String name) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)time).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)input)).m_126140_(writer, this.recipeId(name));
    }

    private void registerBlasting(Consumer<FinishedRecipe> writer, ItemLike input, ItemLike result, float xp, int time, String name) {
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)time).m_126132_(ModVanillaRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)ModVanillaRecipeProvider.m_125977_((ItemLike)input)).m_126140_(writer, this.recipeId(name));
    }

    private ResourceLocation recipeId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)path);
    }
}

