/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm_m.recipe.PressRecipe;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PressRecipeBuilder
implements RecipeBuilder {
    private final ItemStack output;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private JsonObject stampJson;
    private JsonObject materialJson;

    private PressRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static PressRecipeBuilder pressRecipe(ItemStack output) {
        return new PressRecipeBuilder(output);
    }

    public PressRecipeBuilder stamp(Ingredient ingredient) {
        this.stampJson = ingredient.m_43942_().getAsJsonObject();
        return this;
    }

    public PressRecipeBuilder stamp(TagKey<Item> tag) {
        this.stampJson = PressRecipeBuilder.tagJson(tag);
        return this;
    }

    public PressRecipeBuilder stamp(ItemLike item) {
        this.stampJson = PressRecipeBuilder.itemJson(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()), "Item is not registered"));
        return this;
    }

    public PressRecipeBuilder stamp(ResourceLocation itemId) {
        this.stampJson = PressRecipeBuilder.itemJson(itemId);
        return this;
    }

    public PressRecipeBuilder material(Ingredient ingredient) {
        this.materialJson = ingredient.m_43942_().getAsJsonObject();
        return this;
    }

    public PressRecipeBuilder material(TagKey<Item> tag) {
        this.materialJson = PressRecipeBuilder.tagJson(tag);
        return this;
    }

    public PressRecipeBuilder material(ItemLike item) {
        this.materialJson = PressRecipeBuilder.itemJson(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()), "Item is not registered"));
        return this;
    }

    public PressRecipeBuilder material(ResourceLocation itemId) {
        this.materialJson = PressRecipeBuilder.itemJson(itemId);
        return this;
    }

    private static JsonObject tagJson(TagKey<Item> tag) {
        JsonObject json = new JsonObject();
        json.addProperty("tag", tag.f_203868_().toString());
        return json;
    }

    private static JsonObject itemJson(ResourceLocation id) {
        JsonObject json = new JsonObject();
        json.addProperty("item", id.toString());
        return json;
    }

    public RecipeBuilder m_126132_(@Nonnull String pCriterionName, @Nonnull CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.output.m_41720_();
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> pFinishedRecipeConsumer, @Nonnull ResourceLocation pRecipeId) {
        if (this.stampJson == null) {
            throw new IllegalStateException("Stamp ingredient is not defined for press recipe " + String.valueOf(pRecipeId));
        }
        if (this.materialJson == null) {
            throw new IllegalStateException("Material ingredient is not defined for press recipe " + String.valueOf(pRecipeId));
        }
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final PressRecipeBuilder builder;

        private Result(ResourceLocation id, PressRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void m_7917_(@Nonnull JsonObject pJson) {
            JsonArray jsonIngredients = new JsonArray();
            jsonIngredients.add((JsonElement)this.builder.stampJson.deepCopy());
            jsonIngredients.add((JsonElement)this.builder.materialJson.deepCopy());
            pJson.add("ingredients", (JsonElement)jsonIngredients);
            JsonObject jsonOutput = new JsonObject();
            jsonOutput.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.builder.output.m_41720_()), "Output item is not registered").toString());
            if (this.builder.output.m_41613_() > 1) {
                jsonOutput.addProperty("count", (Number)this.builder.output.m_41613_());
            }
            pJson.add("output", (JsonElement)jsonOutput);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return PressRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

