/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm_m.recipe.ShredderRecipe;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ShredderRecipeBuilder
implements RecipeBuilder {
    private final Ingredient input;
    private final ItemStack output;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    private ShredderRecipeBuilder(Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static ShredderRecipeBuilder shredderRecipe(Ingredient input, ItemStack output) {
        return new ShredderRecipeBuilder(input, output);
    }

    public static ShredderRecipeBuilder shredderRecipe(Item input, ItemStack output) {
        return new ShredderRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), output);
    }

    public static ShredderRecipeBuilder shredderRecipe(Item input, Item output, int count) {
        return new ShredderRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), new ItemStack((ItemLike)output, count));
    }

    public RecipeBuilder m_126132_(@Nonnull String pCriterionName, @Nonnull CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.output.m_41720_();
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> pFinishedRecipeConsumer, @Nonnull ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ShredderRecipeBuilder builder;

        public Result(ResourceLocation id, ShredderRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void m_7917_(@Nonnull JsonObject pJson) {
            pJson.add("ingredient", this.builder.input.m_43942_());
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.builder.output.m_41720_()).toString());
            if (this.builder.output.m_41613_() > 1) {
                resultJson.addProperty("count", (Number)this.builder.output.m_41613_());
            }
            pJson.add("result", (JsonElement)resultJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ShredderRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

