/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.datagen.ShredderRecipeBuilder;
import com.hbm_m.item.ModIngots;
import com.hbm_m.item.ModItems;
import com.hbm_m.item.ModPowders;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public final class ShredderRecipeGenerator {
    private static final Set<String> ENABLED_POWDERS = Set.of("uranium", "u233", "u235", "u238", "th232", "plutonium", "pu238", "pu239", "pu240", "pu241", "actinium", "steel", "advanced_alloy", "aluminum", "schrabidium", "saturnite", "lead", "gunmetal", "gunsteel", "red_copper", "asbestos", "titanium", "cobalt", "tungsten", "starmetal", "beryllium", "bismuth", "polymer", "bakelite", "rubber", "desh", "graphite", "phosphorus", "les", "magnetized_tungsten", "combine_steel", "dura_steel", "pc", "euphemium", "dineutronium", "electronium", "australium", "solinium", "tantalium", "chainsteel", "meteorite", "lanthanium", "neodymium", "niobium", "cerium", "cadmium", "caesium", "strontium", "bromide", "tennessine", "zirconium", "arsenic", "iodine", "astatine", "americium", "neptunium", "polonium", "technetium", "boron", "schrabidate", "schraranium", "au198", "pb209", "ra226", "thorium", "osmiridium", "selenium", "co60", "sr90", "am241", "am242", "steel_dusted", "calcium", "graphene", "mox_fuel", "smore", "schrabidium_fuel", "uranium_fuel", "thorium_fuel", "plutonium_fuel", "neptunium_fuel", "americium_fuel", "bismuth_bronze", "arsenic_bronze", "crystalline", "mud", "silicon", "fiberglass", "ceramic", "pu_mix", "am_mix", "pet", "ferrouranium", "pvc", "biorubber", "cdalloy", "bscco");

    private ShredderRecipeGenerator() {
    }

    public static void generate(Consumer<FinishedRecipe> writer, Function<ItemLike, InventoryChangeTrigger.TriggerInstance> hasItem) {
        ShredderRecipeGenerator.registerBasicConversions(writer);
        ShredderRecipeGenerator.registerMetalPowders(writer);
        ShredderRecipeGenerator.generatePowderProcessing(writer, hasItem);
    }

    private static void registerBasicConversions(Consumer<FinishedRecipe> writer) {
        ShredderRecipeBuilder.shredderRecipe(Items.f_41905_, new ItemStack((ItemLike)Items.f_41832_, 1)).m_176500_(writer, "stone_to_gravel");
        ShredderRecipeBuilder.shredderRecipe(Items.f_42413_, new ItemStack((ItemLike)ModItems.POWDER_COAL.get(), 1)).m_176500_(writer, "coal_to_powder");
        ShredderRecipeBuilder.shredderRecipe(Items.f_42594_, new ItemStack((ItemLike)Items.f_41832_, 1)).m_176500_(writer, "cobblestone_to_gravel");
        ShredderRecipeBuilder.shredderRecipe(Items.f_42018_, new ItemStack((ItemLike)Items.f_41832_, 1)).m_176500_(writer, "stone_bricks_to_gravel");
        ShredderRecipeBuilder.shredderRecipe(Items.f_41832_, new ItemStack((ItemLike)Items.f_41830_, 1)).m_176500_(writer, "gravel_to_sand");
        ShredderRecipeBuilder.shredderRecipe(Items.f_42054_, new ItemStack((ItemLike)Items.f_42525_, 4)).m_176500_(writer, "glowstone_to_dust");
        ShredderRecipeBuilder.shredderRecipe(Items.f_41995_, new ItemStack((ItemLike)Items.f_42461_, 4)).m_176500_(writer, "bricks_to_clay");
        ShredderRecipeBuilder.shredderRecipe(Items.f_42460_, new ItemStack((ItemLike)Items.f_42461_, 1)).m_176500_(writer, "brick_to_clay");
    }

    private static void registerMetalPowders(Consumer<FinishedRecipe> writer) {
        if (ModItems.getPowders(ModPowders.IRON) != null) {
            ShredderRecipeBuilder.shredderRecipe(Items.f_42416_, new ItemStack((ItemLike)ModItems.getPowders(ModPowders.IRON).get(), 1)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"shredder/iron_ingot_to_powder"));
        }
        if (ModItems.getPowders(ModPowders.GOLD) != null) {
            ShredderRecipeBuilder.shredderRecipe(Items.f_42417_, new ItemStack((ItemLike)ModItems.getPowders(ModPowders.GOLD).get(), 1)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"shredder/gold_ingot_to_powder"));
        }
        if (ModItems.getPowders(ModPowders.COAL) != null) {
            if (ModItems.POWDER_COAL_SMALL != null) {
                ShredderRecipeBuilder.shredderRecipe((Item)ModItems.getPowders(ModPowders.COAL).get(), new ItemStack((ItemLike)ModItems.POWDER_COAL_SMALL.get(), 9)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"shredder/coal_to_small_powder"));
            }
            ShredderRecipeBuilder.shredderRecipe(Items.f_42413_, new ItemStack((ItemLike)ModItems.getPowders(ModPowders.COAL).get(), 1)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"shredder/coal_to_powder"));
        }
    }

    private static void generatePowderProcessing(Consumer<FinishedRecipe> writer, Function<ItemLike, InventoryChangeTrigger.TriggerInstance> hasItem) {
        ShredderRecipeBuilder.shredderRecipe((Item)ModItems.SCRAP.get(), new ItemStack((ItemLike)ModItems.DUST.get(), 1)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"shredder/scrap_to_dust"));
        for (String powderName : ENABLED_POWDERS) {
            ModIngots ingot = ModIngots.byName(powderName).orElse(null);
            if (ingot == null) continue;
            RegistryObject<Item> ingotRegistry = ModItems.getIngot(ingot);
            RegistryObject<Item> powderRegistry = ModItems.getPowder(ingot);
            if (ingotRegistry == null || powderRegistry == null) continue;
            Item ingotItem = (Item)ingotRegistry.get();
            Item powderItem = (Item)powderRegistry.get();
            String ingotName = ingot.getName();
            RegistryObject<Block> blockRegistry = null;
            if (ModBlocks.hasIngotBlock(ingot)) {
                blockRegistry = ModBlocks.getIngotBlock(ingot);
            }
            ShredderRecipeBuilder.shredderRecipe(ingotItem, new ItemStack((ItemLike)powderItem, 1)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)("shredder/" + ingotName + "_powder")));
            if (blockRegistry != null) {
                ShredderRecipeBuilder.shredderRecipe(((Block)blockRegistry.get()).m_5456_(), new ItemStack((ItemLike)powderItem, 9)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)("shredder/" + ingotName + "_block_powder")));
            }
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{powderItem}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)ingotItem, (float)0.35f, (int)200).m_126132_("has_" + ingotName + "_powder", (CriterionTriggerInstance)hasItem.apply((ItemLike)powderItem)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)(ingotName + "_powder_smelting")));
            SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{powderItem}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)ingotItem, (float)0.35f, (int)100).m_126132_("has_" + ingotName + "_powder", (CriterionTriggerInstance)hasItem.apply((ItemLike)powderItem)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)(ingotName + "_powder_blasting")));
            ModItems.getTinyPowder(ingot).ifPresent(tinyRegistry -> {
                Item tinyItem = (Item)tinyRegistry.get();
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)powderItem).m_126130_("TTT").m_126130_("TTT").m_126130_("TTT").m_126127_(Character.valueOf('T'), (ItemLike)tinyItem).m_126132_("has_" + ingotName + "_powder_tiny", (CriterionTriggerInstance)hasItem.apply((ItemLike)tinyItem)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)(ingotName + "_powder_from_tiny")));
                ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)tinyItem, (int)9).m_126209_((ItemLike)powderItem).m_126132_("has_" + ingotName + "_powder", (CriterionTriggerInstance)hasItem.apply((ItemLike)powderItem)).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)(ingotName + "_tiny_from_powder")));
            });
        }
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.DUST.get())).m_126130_("TTT").m_126130_("TTT").m_126130_("TTT").m_126127_(Character.valueOf('T'), (ItemLike)ModItems.DUST_TINY.get()).m_126132_("has_dust_tiny", (CriterionTriggerInstance)hasItem.apply((ItemLike)ModItems.DUST_TINY.get())).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"dust_from_tiny"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.DUST_TINY.get()), (int)9).m_126209_((ItemLike)ModItems.DUST.get()).m_126132_("has_dust", (CriterionTriggerInstance)hasItem.apply((ItemLike)ModItems.DUST.get())).m_126140_(writer, ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"dust_tiny_from_dust"));
    }
}

