/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.entity.grenades;

import com.hbm_m.entity.ModEntities;
import com.hbm_m.entity.grenades.GrenadeIfType;
import com.hbm_m.item.ModItems;
import com.hbm_m.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GrenadeIfProjectileEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> TIMER_ACTIVATED = SynchedEntityData.m_135353_(GrenadeIfProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DETONATION_TIME = SynchedEntityData.m_135353_(GrenadeIfProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int FUSE_SECONDS = 4;
    private static final float MIN_BOUNCE_SPEED = 0.15f;
    private GrenadeIfType grenadeType;
    private static final Random RANDOM = new Random();

    public GrenadeIfProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public GrenadeIfProjectileEntity(Level level, LivingEntity thrower, GrenadeIfType type) {
        super((EntityType)ModEntities.GRENADE_IF_PROJECTILE.get(), thrower, level);
        this.grenadeType = type;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIMER_ACTIVATED, (Object)false);
        this.f_19804_.m_135372_(DETONATION_TIME, (Object)0);
    }

    protected Item m_7881_() {
        return this.grenadeType != null ? this.grenadeType.getItem() : (Item)ModItems.GRENADE_IF.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && ((Boolean)this.f_19804_.m_135370_(TIMER_ACTIVATED)).booleanValue() && this.f_19797_ >= (Integer)this.f_19804_.m_135370_(DETONATION_TIME)) {
            this.explode(this.m_20183_());
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            if (!((Boolean)this.f_19804_.m_135370_(TIMER_ACTIVATED)).booleanValue()) {
                this.f_19804_.m_135381_(TIMER_ACTIVATED, (Object)true);
                this.f_19804_.m_135381_(DETONATION_TIME, (Object)(this.f_19797_ + 80));
            }
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                this.handleBounce((BlockHitResult)result);
            }
        }
    }

    private void handleBounce(BlockHitResult result) {
        Vec3 velocity = this.m_20184_();
        float speed = (float)velocity.m_82553_();
        if (speed < 0.15f) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20242_(true);
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.BOUNCE_RANDOM.get(), SoundSource.NEUTRAL, 0.5f, 0.8f);
            return;
        }
        BlockPos blockPos = result.m_82425_();
        this.m_9236_().m_5594_(null, blockPos, (SoundEvent)ModSounds.BOUNCE_RANDOM.get(), SoundSource.NEUTRAL, 2.1f, 1.0f);
        Vec3 currentVelocity = this.m_20184_();
        Vec3 hitNormal = Vec3.m_82528_((Vec3i)result.m_82434_().m_122436_());
        Vec3 reflectedVelocity = currentVelocity.m_82546_(hitNormal.m_82490_(2.0 * currentVelocity.m_82526_(hitNormal)));
        this.m_20256_(reflectedVelocity.m_82490_((double)this.grenadeType.getBounceMultiplier()));
    }

    private void explode(BlockPos pos) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.m_9236_().m_254877_((Entity)this, null, null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, this.grenadeType.getExplosionPower(), this.grenadeType.causesFire(), Level.ExplosionInteraction.BLOCK);
            this.playDetonationSound(this.m_9236_(), pos);
            float damageRadius = this.grenadeType.getExplosionPower() * 2.0f;
            List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)damageRadius));
            for (LivingEntity entity : entities) {
                double distSqr = entity.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                if (!(distSqr < (double)(damageRadius * damageRadius))) continue;
                double dist = Math.sqrt(distSqr);
                float damage = this.grenadeType.getCustomDamage() * (float)(1.0 - dist / (double)damageRadius);
                if (!(damage > 0.0f)) continue;
                entity.f_19802_ = 0;
                entity.m_6469_(this.m_269291_().m_269036_((Entity)this, null), damage);
            }
            this.m_146870_();
        }
    }

    private void playDetonationSound(Level level, BlockPos pos) {
        SoundEvent[] sounds = new SoundEvent[]{(SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR1.orElse(null), (SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR2.orElse(null), (SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR3.orElse(null)};
        List<SoundEvent> availableSounds = Arrays.stream(sounds).filter(Objects::nonNull).toList();
        if (!availableSounds.isEmpty()) {
            SoundEvent soundToPlay = availableSounds.get(RANDOM.nextInt(availableSounds.size()));
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundToPlay, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("TimerActivated", ((Boolean)this.f_19804_.m_135370_(TIMER_ACTIVATED)).booleanValue());
        tag.m_128405_("DetonationTime", ((Integer)this.f_19804_.m_135370_(DETONATION_TIME)).intValue());
        if (this.grenadeType != null) {
            tag.m_128359_("GrenadeType", this.grenadeType.name());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TIMER_ACTIVATED, (Object)tag.m_128471_("TimerActivated"));
        this.f_19804_.m_135381_(DETONATION_TIME, (Object)tag.m_128451_("DetonationTime"));
        if (tag.m_128441_("GrenadeType")) {
            this.grenadeType = GrenadeIfType.valueOf(tag.m_128461_("GrenadeType"));
        }
    }
}

