/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.entity.grenades;

import com.hbm_m.block.IDetonatable;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.entity.ModEntities;
import com.hbm_m.item.ModItems;
import com.hbm_m.particle.ModExplosionParticles;
import com.hbm_m.sound.ModSounds;
import com.hbm_m.util.ShockwaveGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GrenadeNucProjectileEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> TIMER_ACTIVATED = SynchedEntityData.m_135353_(GrenadeNucProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DETONATION_TIME = SynchedEntityData.m_135353_(GrenadeNucProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int FUSE_SECONDS = 6;
    private static final float EXPLOSION_POWER = 10.0f;
    private static final float RADIATION_RADIUS = 25.0f;
    private static final float MIN_BOUNCE_SPEED = 0.1f;
    private static final float BOUNCE_MULTIPLIER = 0.4f;
    private static final float DAMAGE_RADIUS = 25.0f;
    private static final float DAMAGE_AMOUNT = 200.0f;
    private static final float MAX_DAMAGE_DISTANCE = 25.0f;
    private static final Random RANDOM = new Random();

    public GrenadeNucProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public GrenadeNucProjectileEntity(Level level, LivingEntity thrower) {
        super((EntityType)ModEntities.GRENADE_NUC_PROJECTILE.get(), thrower, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIMER_ACTIVATED, (Object)false);
        this.f_19804_.m_135372_(DETONATION_TIME, (Object)0);
    }

    protected Item m_7881_() {
        return (Item)ModItems.GRENADE_NUC.get();
    }

    public void m_8119_() {
        int detonationTime;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && ((Boolean)this.f_19804_.m_135370_(TIMER_ACTIVATED)).booleanValue() && this.f_19797_ >= (detonationTime = ((Integer)this.f_19804_.m_135370_(DETONATION_TIME)).intValue())) {
            this.explode(this.m_20183_());
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            if (!((Boolean)this.f_19804_.m_135370_(TIMER_ACTIVATED)).booleanValue()) {
                this.f_19804_.m_135381_(TIMER_ACTIVATED, (Object)true);
                this.f_19804_.m_135381_(DETONATION_TIME, (Object)(this.f_19797_ + 120));
            }
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                this.handleBounce((BlockHitResult)result);
            }
        }
    }

    private void handleBounce(BlockHitResult result) {
        Vec3 velocity = this.m_20184_();
        float speed = (float)velocity.m_82553_();
        if (speed < 0.1f) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20242_(true);
            return;
        }
        BlockPos blockPos = result.m_82425_();
        this.m_9236_().m_5594_(null, blockPos, (SoundEvent)ModSounds.BOUNCE_RANDOM.get(), SoundSource.NEUTRAL, 2.5f, 0.6f);
        Vec3 currentVelocity = this.m_20184_();
        Vec3 hitNormal = Vec3.m_82528_((Vec3i)result.m_82434_().m_122436_());
        Vec3 reflectedVelocity = currentVelocity.m_82546_(hitNormal.m_82490_(2.0 * currentVelocity.m_82526_(hitNormal)));
        this.m_20256_(reflectedVelocity.m_82490_((double)0.4f));
    }

    private void explode(BlockPos pos) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            this.m_146870_();
            serverLevel.m_255391_((Entity)this, x, y, z, 9.0f, true, Level.ExplosionInteraction.NONE);
            this.triggerNearbyDetonations(serverLevel, pos, null);
            this.dealExplosionDamage(serverLevel, x, y, z);
            this.scheduleExplosionEffects(serverLevel, x, y, z);
            this.playRandomDetonationSound(this.m_9236_(), pos);
            if (serverLevel.m_7654_() != null) {
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(30, () -> {
                    serverLevel.m_254849_(null, x, y, z, 9.0f, Level.ExplosionInteraction.NONE);
                    ShockwaveGenerator.generateCrater(serverLevel, pos, 25, 10, (Block)ModBlocks.WASTE_LOG.get(), (Block)ModBlocks.WASTE_PLANKS.get(), (Block)ModBlocks.BURNED_GRASS.get());
                }));
            }
        }
    }

    private void dealExplosionDamage(ServerLevel serverLevel, double x, double y, double z) {
        List entitiesNearby = serverLevel.m_45976_(LivingEntity.class, new AABB(x - 25.0, y - 25.0, z - 25.0, x + 25.0, y + 25.0, z + 25.0));
        for (LivingEntity entity : entitiesNearby) {
            double distanceToEntity = Math.sqrt(Math.pow(entity.m_20185_() - x, 2.0) + Math.pow(entity.m_20186_() - y, 2.0) + Math.pow(entity.m_20189_() - z, 2.0));
            if (!(distanceToEntity <= 25.0)) continue;
            float damage = 200.0f;
            if (distanceToEntity > 25.0) {
                float remainingDistance = 0.0f;
                float damageDistance = (float)distanceToEntity - 25.0f;
                damage = 200.0f * (1.0f - damageDistance / remainingDistance) * 0.5f;
            }
            entity.m_6469_(entity.m_269291_().m_269093_(null), damage);
        }
    }

    private void playRandomDetonationSound(Level level, BlockPos pos) {
        List<SoundEvent> sounds = Arrays.asList((SoundEvent)ModSounds.MUKE_EXPLOSION.orElse(null), (SoundEvent)ModSounds.MUKE_EXPLOSION.orElse(null), (SoundEvent)ModSounds.MUKE_EXPLOSION.orElse(null));
        sounds.removeIf(Objects::isNull);
        if (!sounds.isEmpty()) {
            SoundEvent sound = sounds.get(RANDOM.nextInt(sounds.size()));
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound, SoundSource.BLOCKS, 4.0f, 1.0f);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("TimerActivated", ((Boolean)this.f_19804_.m_135370_(TIMER_ACTIVATED)).booleanValue());
        tag.m_128405_("DetonationTime", ((Integer)this.f_19804_.m_135370_(DETONATION_TIME)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TIMER_ACTIVATED, (Object)tag.m_128471_("TimerActivated"));
        this.f_19804_.m_135381_(DETONATION_TIME, (Object)tag.m_128451_("DetonationTime"));
    }

    private void scheduleExplosionEffects(ServerLevel level, double x, double y, double z) {
        this.spawnFlash(level, x, y, z);
        this.spawnSparks(level, x, y, z);
        level.m_7654_().m_6937_((Runnable)new TickTask(5, () -> this.spawnShockwave(level, x, y, z)));
        level.m_7654_().m_6937_((Runnable)new TickTask(10, () -> this.spawnMushroomCloud(level, x, y, z)));
    }

    private void spawnFlash(ServerLevel level, double x, double y, double z) {
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.FLASH.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnSparks(ServerLevel level, double x, double y, double z) {
        for (int i = 0; i < 300; ++i) {
            double xSpeed = (level.f_46441_.m_188500_() - 0.5) * 5.0;
            double ySpeed = level.f_46441_.m_188500_() * 4.0;
            double zSpeed = (level.f_46441_.m_188500_() - 0.5) * 5.0;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.EXPLOSION_SPARK.get()), x, y, z, 1, xSpeed, ySpeed, zSpeed, 1.2);
        }
    }

    private void spawnShockwave(ServerLevel level, double x, double y, double z) {
        for (int ring = 0; ring < 4; ++ring) {
            double ringY = y + (double)ring * 0.4;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.SHOCKWAVE.get()), x, ringY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnMushroomCloud(ServerLevel level, double x, double y, double z) {
        int i;
        for (i = 0; i < 120; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 5.0;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 5.0;
            double ySpeed = 0.6 + level.f_46441_.m_188500_() * 0.4;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, y, z + offsetZ, 1, offsetX * 0.06, ySpeed, offsetZ * 0.06, 1.2);
        }
        for (i = 0; i < 200; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double radius = 6.0 + level.f_46441_.m_188500_() * 10.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double capY = y + 18.0 + level.f_46441_.m_188500_() * 8.0;
            double xSpeed = Math.cos(angle) * 0.4;
            double ySpeed = -0.05 + level.f_46441_.m_188500_() * 0.15;
            double zSpeed = Math.sin(angle) * 0.4;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, capY, z + offsetZ, 1, xSpeed, ySpeed, zSpeed, 1.2);
        }
    }

    private void triggerNearbyDetonations(ServerLevel serverLevel, BlockPos pos, Player player) {
        int DETONATION_RADIUS = 8;
        for (int x = -DETONATION_RADIUS; x <= DETONATION_RADIUS; ++x) {
            for (int y = -DETONATION_RADIUS; y <= DETONATION_RADIUS; ++y) {
                for (int z = -DETONATION_RADIUS; z <= DETONATION_RADIUS; ++z) {
                    BlockPos checkPos;
                    BlockState checkState;
                    Block block;
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= (double)DETONATION_RADIUS) || !(dist > 0.0) || !((block = (checkState = serverLevel.m_8055_(checkPos = pos.m_7918_(x, y, z))).m_60734_()) instanceof IDetonatable)) continue;
                    IDetonatable detonatable = (IDetonatable)block;
                    int delay = (int)(dist * 1.5);
                    serverLevel.m_7654_().m_6937_((Runnable)new TickTask(delay, () -> detonatable.onDetonate((Level)serverLevel, checkPos, checkState, player)));
                }
            }
        }
    }
}

