/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.entity.grenades;

import com.hbm_m.entity.grenades.GrenadeType;
import com.hbm_m.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class GrenadeProjectileEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<String> GRENADE_TYPE_ID = SynchedEntityData.m_135353_(GrenadeProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int bounceCount = 0;
    private GrenadeType grenadeType;
    private static final Random RANDOM = new Random();

    public GrenadeProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public GrenadeProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level, LivingEntity livingEntity, GrenadeType type) {
        super(entityType, livingEntity, level);
        this.grenadeType = type;
        this.f_19804_.m_135381_(GRENADE_TYPE_ID, (Object)type.name());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GRENADE_TYPE_ID, (Object)GrenadeType.STANDARD.name());
    }

    protected Item m_7881_() {
        if (this.grenadeType == null) {
            try {
                this.grenadeType = GrenadeType.valueOf((String)this.f_19804_.m_135370_(GRENADE_TYPE_ID));
            }
            catch (Exception e) {
                this.grenadeType = GrenadeType.STANDARD;
            }
        }
        return this.grenadeType != null ? this.grenadeType.getItem() : Items.f_42452_;
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.m_9236_().f_46443_) {
            if (this.grenadeType == null) {
                this.grenadeType = GrenadeType.valueOf((String)this.f_19804_.m_135370_(GRENADE_TYPE_ID));
            }
            BlockPos blockPos = result.m_82425_();
            this.m_9236_().m_5594_(null, blockPos, (SoundEvent)ModSounds.BOUNCE_RANDOM.get(), SoundSource.NEUTRAL, 2.1f, 1.0f);
            ++this.bounceCount;
            if (this.bounceCount < this.grenadeType.getMaxBounces()) {
                Vec3 currentVelocity = this.m_20184_();
                Vec3 hitNormal = Vec3.m_82528_((Vec3i)result.m_82434_().m_122436_());
                Vec3 reflectedVelocity = currentVelocity.m_82546_(hitNormal.m_82490_(2.0 * currentVelocity.m_82526_(hitNormal)));
                this.m_20256_(reflectedVelocity.m_82490_((double)this.grenadeType.getBounceMultiplier()));
            } else {
                this.explode(blockPos);
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        if (!this.m_9236_().f_46443_) {
            if (this.grenadeType == null) {
                this.grenadeType = GrenadeType.valueOf((String)this.f_19804_.m_135370_(GRENADE_TYPE_ID));
            }
            if (this.grenadeType.explodesOnEntity()) {
                this.explode(result.m_82443_().m_20183_());
            }
        }
    }

    private void explode(BlockPos pos) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            float explosionPower = this.grenadeType.getExplosionPower() * 1.5f;
            this.m_9236_().m_254877_((Entity)this, null, null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, explosionPower, this.grenadeType.causesFire(), Level.ExplosionInteraction.TNT);
            this.playDetonationSound(this.m_9236_(), pos);
            float damageRadius = explosionPower * 2.0f;
            List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)damageRadius));
            for (LivingEntity entity : entities) {
                double distSqr = entity.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                if (!(distSqr < (double)(damageRadius * damageRadius))) continue;
                double dist = Math.sqrt(distSqr);
                float damage = this.grenadeType.getCustomDamage() * (float)(1.0 - dist / (double)damageRadius);
                if (!(damage > 0.0f)) continue;
                entity.f_19802_ = 0;
                entity.m_6469_(this.m_269291_().m_269036_((Entity)this, null), damage);
            }
            this.m_146870_();
        }
    }

    private void playDetonationSound(Level level, BlockPos pos) {
        SoundEvent[] sounds = new SoundEvent[]{(SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR1.orElse(null), (SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR2.orElse(null), (SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR3.orElse(null)};
        List<SoundEvent> availableSounds = Arrays.stream(sounds).filter(Objects::nonNull).toList();
        if (!availableSounds.isEmpty()) {
            SoundEvent soundToPlay = availableSounds.get(RANDOM.nextInt(availableSounds.size()));
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundToPlay, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("BounceCount", this.bounceCount);
        tag.m_128359_("GrenadeType", (String)this.f_19804_.m_135370_(GRENADE_TYPE_ID));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.bounceCount = tag.m_128451_("BounceCount");
        if (tag.m_128441_("GrenadeType")) {
            this.f_19804_.m_135381_(GRENADE_TYPE_ID, (Object)tag.m_128461_("GrenadeType"));
            this.grenadeType = GrenadeType.valueOf(tag.m_128461_("GrenadeType"));
        }
    }
}

