/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.event;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.item.ModItems;
import com.hbm_m.sound.ModSounds;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="hbm_m", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BombDefuser {
    private static final Random RANDOM = new Random();
    private static final List<RegistryObject<Block>> BOMBS = List.of(ModBlocks.MINE_AP, ModBlocks.MINE_FAT, ModBlocks.DUD_FUGAS_TONG, ModBlocks.DUD_SALTED, ModBlocks.DUD_NUKE);
    private static final List<RegistryObject<?>> DEFUSE_SOUNDS = List.of(ModSounds.CLICK);
    private static final Map<RegistryObject<Block>, List<DropAmount>> BOMB_DROPS = Map.of(ModBlocks.MINE_FAT, List.of(new DropAmount(ModItems.BILLET_PLUTONIUM, 1), new DropAmount(ModItems.PLATE_STEEL, 3), new DropAmount(ModItems.BALL_TNT, 1)), ModBlocks.MINE_AP, List.of(new DropAmount(ModItems.PLATE_STEEL, 3), new DropAmount(ModItems.BALL_TNT, 2)), ModBlocks.DUD_FUGAS_TONG, List.of(new DropAmount(ModItems.PLATE_STEEL, 8), new DropAmount(ModItems.BALL_TNT, 16)), ModBlocks.DUD_SALTED, List.of(new DropAmount(ModItems.BILLET_PLUTONIUM, 2), new DropAmount(ModItems.BALL_TNT, 8), new DropAmount(ModItems.COBALT_RAW, 8)), ModBlocks.DUD_NUKE, List.of(new DropAmount(ModItems.BALL_TNT, 8), new DropAmount(ModItems.BILLET_PLUTONIUM, 4)));

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        List<DropAmount> drops;
        Object soundEvent;
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        Player entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = entity;
        ItemStack held = player.m_21120_(event.getHand());
        if (!held.m_150930_((Item)ModItems.DEFUSER.get())) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = level.m_8055_(pos).m_60734_();
        RegistryObject<Block> matchedCrate = null;
        for (RegistryObject<Block> crate : BOMBS) {
            Block b = (Block)crate.orElse(null);
            if (b == null || b != block) continue;
            matchedCrate = crate;
            break;
        }
        if (matchedCrate == null) {
            return;
        }
        event.setCanceled(true);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_21011_(event.getHand(), true);
        }
        level.m_46961_(pos, false);
        RegistryObject<?> soundObj = DEFUSE_SOUNDS.get(RANDOM.nextInt(DEFUSE_SOUNDS.size()));
        if (soundObj != null && (soundEvent = soundObj.get()) instanceof SoundEvent) {
            SoundEvent se = (SoundEvent)soundEvent;
            level.m_5594_(null, pos, se, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if ((drops = BOMB_DROPS.get(matchedCrate)) == null) {
            return;
        }
        for (DropAmount drop : drops) {
            BombDefuser.dropItem(drop, level, pos);
        }
    }

    private static void dropItem(DropAmount drop, Level level, BlockPos pos) {
        Object obj = drop.item.get();
        Item itemToDrop = null;
        if (obj instanceof Item) {
            Item item;
            itemToDrop = item = (Item)obj;
        } else if (obj instanceof Block) {
            Block block = (Block)obj;
            itemToDrop = Item.m_41439_((Block)block);
        }
        if (itemToDrop != null && itemToDrop != Items.f_41852_) {
            ItemStack dropStack = new ItemStack((ItemLike)itemToDrop, drop.amount);
            ItemEntity dropEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, dropStack);
            dropEntity.m_20334_((RANDOM.nextDouble() - 0.5) * 0.5, RANDOM.nextDouble() * 0.3 + 0.1, (RANDOM.nextDouble() - 0.5) * 0.5);
            level.m_7967_((Entity)dropEntity);
        }
    }

    private record DropAmount(RegistryObject<?> item, int amount) {
    }
}

