/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.event;

import com.hbm_m.client.render.DoorRenderer;
import com.hbm_m.client.render.GlobalMeshCache;
import com.hbm_m.client.render.MachineAdvancedAssemblerRenderer;
import com.hbm_m.client.render.MachinePressRenderer;
import com.hbm_m.client.render.OcclusionCullingHelper;
import com.hbm_m.client.render.shader.ImmediateFallbackRenderer;
import com.hbm_m.client.render.shader.RenderPathManager;
import com.hbm_m.event.HazardTooltipHandler;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.multiblock.DoorPartAABBRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hbm_m", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientModEvents {
    private static int memoryCleanupCounter = 0;
    private static final int MEMORY_CLEANUP_INTERVAL = 1200;

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_() || stack.m_41720_() instanceof ArmorItem) {
            return;
        }
        HazardTooltipHandler.appendHazardTooltips(event.getItemStack(), event.getToolTip());
        boolean hasTags = event.getItemStack().m_204131_().findAny().isPresent();
        if (hasTags) {
            if (Screen.m_96638_()) {
                event.getToolTip().add(Component.m_237119_());
                event.getToolTip().add(Component.m_237115_((String)"tooltip.hbm_m.tags").m_130940_(ChatFormatting.GRAY));
                event.getItemStack().m_204131_().map(TagKey::f_203868_).sorted(ResourceLocation::compareTo).forEach(location -> event.getToolTip().add(Component.m_237113_((String)("  - " + location.toString())).m_130940_(ChatFormatting.DARK_GRAY)));
            } else {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.hbm_m.hold_shift_for_details").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            MachineAdvancedAssemblerRenderer.flushInstancedBatches();
            DoorRenderer.flushInstancedBatches();
            MachinePressRenderer.flushInstancedBatches();
            ImmediateFallbackRenderer.endBatch();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            OcclusionCullingHelper.onFrameStart();
        } else if (event.phase == TickEvent.Phase.END) {
            RenderPathManager.checkAndUpdate();
            if (++memoryCleanupCounter >= 1200) {
                memoryCleanupCounter = 0;
                DoorRenderer.clearAllCaches();
                GlobalMeshCache.clearAll();
                DoorPartAABBRegistry.clear();
                ImmediateFallbackRenderer.forceReset();
                Runtime runtime = Runtime.getRuntime();
                long usedMemory = runtime.totalMemory() - runtime.freeMemory();
                long maxMemory = runtime.maxMemory();
                if ((double)usedMemory > (double)maxMemory * 0.8) {
                    MainRegistry.LOGGER.debug("Memory usage high ({}%), triggering GC", (Object)(usedMemory * 100L / maxMemory));
                    System.gc();
                }
            }
        }
    }
}

